/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import jwrapper.LPUninstallerListener;
import jwrapper.ui.JWLanguage;
import utils.ostools.OS;
import utils.swing.IconLoader;
import utils.swing.components.SwipeImagePanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.layout.GbPanel;
import utils.swing.nolaf.NoLafButton;
import utils.swing.nolaf.NoLafProgressBarUI;

public class SwipeLoadPanel
implements WindowListener {
    JFrame frame;
    private static final Color BORDER_COLOR = new Color(200, 200, 200);
    private static final String BUTTON_PANEL = "BUTTONS";
    private static final String PROGRESS_PANEL = "PROGRESS";
    SwipeImagePanel big;
    SwipeImagePanel small = new SwipeImagePanel();
    JProgressBar finiteProgressBar = new JProgressBar();
    JProgressBar infiniteProgressBar = new JProgressBar();
    public static String Undo = "UndoSmall.png";
    public static String Uninstall = "UninstallSmall.png";
    JPanel mainPanel;
    JPanel centerPanel;
    JPanel southPanel;
    GbPanel buttonPanel = new GbPanel();
    JPanel progressPanel;
    JPanel messagePanel;
    NoLafButton uninstall;
    NoLafButton cancel;
    LPUninstallerListener listener;
    private JLabel messageLabel1;
    private JLabel messageLabel2;
    private CardLayout southCardLayout;
    private CardLayout messageCardLayout;

    public void makeUninstaller(String title, Object logo, LPUninstallerListener listener) {
        this.makeFrame(title, logo);
        this.frame.addWindowListener(this);
        this.listener = listener;
        this.buttonPanel.setBackground(Color.white);
        IconLoader.CUSTOM_ICON_PATH = "/";
        this.uninstall = new NoLafButton(IconLoader.load(Uninstall), (Icon)IconLoader.loadDisabled(Uninstall));
        this.cancel = new NoLafButton(IconLoader.load(Undo), (Icon)IconLoader.loadDisabled(Undo));
        this.uninstall.setText(JWLanguage.getString("UNINSTALL"));
        this.cancel.setText(JWLanguage.getString("CANCEL"));
        this.uninstall.setPreferredSize(new Dimension(this.uninstall.getPreferredSize().width, 52));
        this.cancel.setPreferredSize(new Dimension(this.uninstall.getPreferredSize().width, 52));
        int buffer = 7;
        this.buttonPanel.add(this.uninstall, 0, 0, 1, 1, 10, 10, 10, 2, new Insets(0, buffer * 2, buffer * 2, buffer));
        this.buttonPanel.add(this.cancel, 1, 0, 1, 1, 10, 10, 10, 2, new Insets(0, buffer, buffer * 2, buffer * 2));
        if (listener != null) {
            this.cancel.addActionListener(new UninstallListener());
            this.uninstall.addActionListener(new UninstallListener());
        }
        this.hideProgress();
        this.showButtons();
    }

    public void disableButtons() {
        this.buttonPanel.setVisible(false);
        this.cancel.setEnabled(false);
        this.uninstall.setEnabled(false);
        this.mainPanel.repaint();
    }

    public void makeFrame(String title, Object logo) {
        System.out.println("[SwipeLoadPanel] Asked to make frame (current=" + this.frame + ")");
        if (this.frame != null) {
            return;
        }
        this.frame = new JFrame();
        this.frame.setTitle(title);
        if (logo != null) {
            this.frame.setIconImage((Image)logo);
        }
        this.frame.setBounds(0, 0, 400, 320);
        this.frame.setLocationRelativeTo(null);
        this.frame.setResizable(false);
        this.frame.setUndecorated(true);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("Center", this.centerPanel);
        this.mainPanel.add("South", this.southPanel);
        if (!OS.isMacOS()) {
            this.mainPanel.setBorder(SHBorderFactory.createLineBorder(BORDER_COLOR));
        }
        this.frame.getContentPane().add(this.mainPanel);
    }

    public void showFrame() {
        System.out.println("[SwipeLoadPanel] Showing frame (" + this.frame + ")");
        if (this.frame != null) {
            this.frame.setVisible(true);
        }
    }

    public void hideFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("[SwipeLoadPanel] Hiding frame");
                if (SwipeLoadPanel.this.frame != null) {
                    SwipeLoadPanel.this.frame.setVisible(false);
                }
            }
        });
    }

    public int[] getPosition() {
        Rectangle r = this.frame.getBounds();
        int[] tmp = new int[]{r.x, r.y, r.width, r.height};
        return tmp;
    }

    public void setPosition(int[] tmp) {
        Rectangle r = new Rectangle(tmp[0], tmp[1], tmp[2], tmp[3]);
        this.frame.setBounds(r);
    }

    public void setBigTo(Image img) {
        this.big.setImage(img);
    }

    public void setSmallTo(Image img) {
        this.small.setImage(img);
    }

    public void swipeAllTo(Image big, Image small) {
        new OffsetSwipe(big, small).start();
    }

    public void swipeBigTo(Image img) {
        this.big.swipeTo(img);
    }

    public void swipeSmallTo(Image img) {
        this.small.swipeTo(img);
    }

    public void setProgress(double outOfOne) {
        this.finiteProgressBar.setValue((int)(outOfOne * 100000.0));
        this.finiteProgressBar.repaint();
    }

    public void waitForAllSwipes() {
        this.big.waitForAllSwipes();
        this.small.waitForAllSwipes();
    }

    public SwipeLoadPanel() {
        this.centerPanel = new JPanel(new BorderLayout());
        this.southCardLayout = new CardLayout();
        this.southPanel = new JPanel(this.southCardLayout);
        this.big = new SwipeImagePanel();
        this.small = new SwipeImagePanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 70;
                return d;
            }
        };
        this.initMessagePanel();
        this.initProgressPanels();
        this.progressPanel = new JPanel(new BorderLayout());
        this.progressPanel.add((Component)this.small, "North");
        this.progressPanel.add((Component)this.messagePanel, "South");
        this.progressPanel.setBackground(Color.white);
        this.centerPanel.add((Component)this.big, "Center");
        this.southPanel.add((Component)this.progressPanel, PROGRESS_PANEL);
        this.southPanel.add((Component)this.buttonPanel, BUTTON_PANEL);
    }

    private void initProgressPanels() {
        this.finiteProgressBar.setMaximum(100000);
        this.finiteProgressBar.putClientProperty("COLOR", NoLafProgressBarUI.COLOR_LIGHBLUE);
        this.finiteProgressBar.putClientProperty("IMAGE", "progress_piece" + NoLafProgressBarUI.COLOR_LIGHBLUE + ".png");
        this.finiteProgressBar.setUI(new NoLafProgressBarUI());
        this.finiteProgressBar.setPreferredSize(new Dimension(500, 22));
        this.infiniteProgressBar.putClientProperty("COLOR", NoLafProgressBarUI.COLOR_LIGHBLUE);
        this.infiniteProgressBar.putClientProperty("IMAGE", "progress_piece" + NoLafProgressBarUI.COLOR_LIGHBLUE + ".png");
        this.infiniteProgressBar.setIndeterminate(true);
        this.infiniteProgressBar.setUI(new NoLafProgressBarUI());
        this.infiniteProgressBar.setPreferredSize(new Dimension(500, 22));
    }

    private void initMessagePanel() {
        this.messageLabel1 = new JLabel(" ");
        this.messageLabel1.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.messageLabel1.setHorizontalAlignment(0);
        this.messageLabel1.setForeground(new Color(100, 100, 100));
        this.messageLabel1.setBackground(Color.WHITE);
        this.messageLabel2 = new JLabel();
        this.messageLabel2.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.messageLabel2.setHorizontalAlignment(0);
        this.messageLabel2.setForeground(new Color(100, 100, 100));
        this.messageLabel2.setBackground(Color.WHITE);
        this.messageLabel2.setVisible(false);
        JPanel messageLabelPanel = new JPanel(new BorderLayout());
        messageLabelPanel.setBackground(Color.WHITE);
        messageLabelPanel.add((Component)this.messageLabel1, "North");
        messageLabelPanel.add((Component)this.messageLabel2, "South");
        this.messageLabel1.setVisible(false);
        this.messageLabel2.setVisible(false);
        this.messageCardLayout = new CardLayout();
        this.messagePanel = new JPanel(this.messageCardLayout);
        this.messagePanel.setBackground(Color.WHITE);
        this.messagePanel.add((Component)messageLabelPanel, "LABEL");
        this.messagePanel.add((Component)this.infiniteProgressBar, "INFINITE");
        this.messagePanel.add((Component)this.finiteProgressBar, "FINITE");
        this.messageCardLayout.show(this.messagePanel, "FINITE");
    }

    private void showButtons() {
        this.southCardLayout.show(this.southPanel, BUTTON_PANEL);
    }

    public void hideProgress() {
        this.messageCardLayout.show(this.messagePanel, "LABEL");
        this.messagePanel.repaint();
    }

    public void showInfiniteProgress() {
        this.messageCardLayout.show(this.messagePanel, "INFINITE");
        this.messagePanel.repaint();
    }

    public void showFiniteProgress() {
        this.messageCardLayout.show(this.messagePanel, "FINITE");
        this.messagePanel.repaint();
    }

    public void setMessage(String string) {
        this.setMessage(string, null);
    }

    public void setMessage(String message1, String message2) {
        this.hideProgress();
        this.messageLabel1.setText(message1);
        this.messageLabel1.setVisible(message1 != null);
        this.messageLabel2.setText(message2);
        this.messageLabel2.setVisible(message2 != null);
        this.messageLabel1.getParent().repaint();
    }

    public void preventWindowClose() {
        this.frame.setDefaultCloseOperation(0);
    }

    public static void main(String[] args) throws Exception {
        SwipeLoadPanel swp = new SwipeLoadPanel();
        BufferedImage image = ImageIO.read(new File("/Users/gchristelis/Desktop/avatar.png"));
        swp.makeFrame("WOOT", image);
        swp.setBigTo(image);
        swp.swipeBigTo(image);
        swp.frame.setVisible(true);
        for (int i = 0; i <= 100; i += 5) {
            double d = i;
            swp.setProgress(d /= 100.0);
            Thread.sleep(200L);
        }
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    class OffsetSwipe
    extends Thread {
        Image big;
        Image small;

        OffsetSwipe(Image big, Image small) {
            this.big = big;
            this.small = small;
        }

        public void run() {
            SwipeLoadPanel.this.swipeBigTo(this.big);
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwipeLoadPanel.this.swipeSmallTo(this.small);
        }
    }

    class UninstallListener
    implements ActionListener {
        UninstallListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == SwipeLoadPanel.this.uninstall) {
                SwipeLoadPanel.this.listener.doUninstall();
            } else if (o == SwipeLoadPanel.this.cancel) {
                SwipeLoadPanel.this.listener.doExit();
            }
        }
    }
}

