/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import jwrapper.HeadlessOsxUtil;
import jwrapper.HeadlessSwipeLoadUtil;
import jwrapper.jwutils.JWGenericOS;
import utils.files.AtomicSafeDeleter;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.progtools.CheapTimingPrintStream;
import utils.stream.MappedFile;
import utils.vm.VMFork;

public class SelfDelete {
    public static void deleteSelf(File mydir, File[] extras, HeadlessSwipeLoadUtil swu, String app, byte[] splashPNG, byte[] logoPNG) throws IOException {
        block19: {
            if (app == null) {
                app = "";
            }
            if (splashPNG == null) {
                splashPNG = new byte[]{};
            }
            if (logoPNG == null) {
                logoPNG = new byte[]{};
            }
            mydir = mydir.getCanonicalFile().getAbsoluteFile();
            File tempdir = new File(System.getProperty("java.io.tmpdir"));
            File jvmdir = new File(System.getProperty("java.home"));
            File ddir = new File(tempdir, "selfdelete-" + System.currentTimeMillis());
            ddir.mkdirs();
            boolean copyJVM = false;
            System.out.println("JVM Dir:  " + jvmdir.getAbsolutePath());
            System.out.println("Deleting: " + ddir.getAbsolutePath());
            if (jvmdir.getAbsolutePath().startsWith(mydir.getAbsolutePath())) {
                System.out.println("Have to copy JVM");
                copyJVM = true;
            }
            if (copyJVM) {
                System.out.println("Copying JVM from " + jvmdir + " to " + ddir);
                FileUtil.copyFileOrDir(jvmdir, ddir);
                if (!OS.isWindows()) {
                    System.out.println("Making executable");
                    JWGenericOS.setWritableForAllUsersAndWait(ddir, true);
                }
            }
            String csep = System.getProperty("path.separator");
            String[] jars = System.getProperty("java.class.path").split(csep);
            String[] njars = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                File jar = new File(jars[i]);
                File target = new File(ddir, "selfdeletejar" + i + ".jar");
                if (jar.isDirectory()) {
                    target = new File(ddir, "selfdeletejar" + i);
                }
                System.out.println("Copying " + jar + " to " + target);
                if (jar.getName().equals("jwstandalonelaunch.jar")) {
                    jar = new File(jar.getCanonicalFile().getParentFile(), "jwstandalone.jar");
                    System.out.println("Switching to copy " + jar + " to " + target);
                }
                FileUtil.copyFileOrDir(jar, target);
                njars[i] = target.getAbsolutePath();
            }
            File title = new File(ddir, "title");
            FileUtil.writeFileAsString(title.getAbsolutePath(), app);
            File png = new File(ddir, "splash");
            FileUtil.writeFile(png, splashPNG);
            File logo = new File(ddir, "logo");
            FileUtil.writeFile(logo, logoPNG);
            VMFork fork = new VMFork(SelfDelete.class.getName());
            fork.setWorkingDir(ddir);
            fork.setBaseClasspath(njars);
            if (copyJVM) {
                if (OS.isWindows()) {
                    fork.setJavaExe(new File(new File(ddir, "bin"), "javaw.exe").getAbsolutePath());
                } else {
                    fork.setJavaExe(new File(new File(ddir, "bin"), "java").getAbsolutePath());
                }
            }
            String[] args = new String[extras.length + 1];
            args[0] = mydir.getAbsolutePath();
            for (int i = 0; i < extras.length; ++i) {
                args[1 + i] = extras[i].getAbsolutePath();
            }
            fork.setClassArgs(args);
            System.out.println(fork);
            Process p = fork.fork();
            try {
                System.out.println("Connecting to new JVM");
                MappedFile mfw = new MappedFile(new File(ddir, "setupPosition"), 50000, true, 300000L);
                MappedFile mfr = new MappedFile(new File(ddir, "exitNotify"), 50000, false, 300000L);
                mfr.readBlock();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                if (swu != null) {
                    int[] pos = swu.getPosition();
                    System.out.println("Frame pos:");
                    for (int i = 0; i < pos.length; ++i) {
                        System.out.println(pos[i]);
                        dout.writeInt(pos[i]);
                    }
                    dout.flush();
                }
                mfw.writeBlock(bout.toByteArray());
                mfr.readBlock();
                if (swu == null) break block19;
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                swu.hideFrame();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        Object logo;
        Object splash;
        try {
            CheapTimingPrintStream out = new CheapTimingPrintStream(new FileOutputStream("DELETE.log"));
            System.setErr(out);
            System.setOut(out);
            System.out.println("STDOUT test");
            System.err.println("STDERR test");
        }
        catch (Throwable out) {
            // empty catch block
        }
        MappedFile mfr = new MappedFile(new File("setupPosition"), 50000, false, 300000L);
        MappedFile mfw = new MappedFile(new File("exitNotify"), 50000, true, 300000L);
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Deleting [" + args[i] + "]");
        }
        HeadlessSwipeLoadUtil swu = new HeadlessSwipeLoadUtil(true);
        String title = FileUtil.readFileAsString("title");
        try {
            splash = swu.loadImage(new File("splash"));
        }
        catch (Exception x) {
            splash = null;
        }
        try {
            logo = swu.loadImage(new File("logo"));
        }
        catch (Exception x) {
            logo = null;
        }
        if (OS.isMacOS()) {
            try {
                HeadlessOsxUtil.setOSXAppName(title);
            }
            catch (Exception x) {
                // empty catch block
            }
            try {
                HeadlessOsxUtil.setOSXAppDockImage(logo);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        swu.setBigTo(splash);
        swu.setSmallTo("SmallUninstall");
        swu.makeUninstaller(title, logo, null);
        swu.disableButtons();
        swu.showInfiniteProgress();
        mfw.writeBlock(new byte[1]);
        byte[] dat = mfr.readBlock();
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(dat));
        if (title.length() > 0) {
            if (dat.length > 0) {
                int[] tmp = new int[4];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = din.readInt();
                }
                swu.setPosition(tmp);
            }
            swu.ensureShowing();
            swu.preventWindowClose();
        }
        mfw.writeBlock(new byte[1]);
        for (int i = 0; i < args.length; ++i) {
            File todelete = new File(args[i]);
            System.out.println("Trying to delete " + todelete + " now...");
            long showError = System.currentTimeMillis() + 120000L;
            while (!AtomicSafeDeleter.deleteIfNotInUse(todelete)) {
                System.out.println("Unable to delete, will try again...");
                Thread.sleep(2500L);
                if (System.currentTimeMillis() <= showError) continue;
                System.out.println("ERROR: Unable to delete " + todelete);
                System.exit(1);
            }
            System.out.println("Deleted OK");
        }
        System.out.println("Uninstallation complete");
        System.out.flush();
        System.exit(0);
    }
}

