/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.JOptionPane;
import jwrapper.JWConstants;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWOSXEventListener;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.updater.JWApp;
import utils.ostools.OS;

public class SampleApp {
    public static void main(String[] args) throws Exception {
        System.out.println("Application Arguments Are: " + Arrays.toString(args));
        if (OS.isMacOS()) {
            String appBundle = JWSystem.getAppBundleName();
            String bundleID = JWConstants.buildOsxDomainFromBundle(appBundle);
            JWMacOS.registerAppAsURLHandler("jwsample", bundleID);
            JWMacOS.setOSXEventListener(new JWOSXEventListener(){

                public void openURL(final String url) {
                    new Thread(){

                        public void run() {
                            System.out.println("[SampleApp] Showing URL dialog for " + url);
                            JOptionPane.showMessageDialog(null, "Asked to handle URL '" + url + "'");
                        }
                    }.start();
                }
            });
            String string = JWMacOS.getRequestedURL();
            if (string != null && string.length() > 0) {
                JOptionPane.showConfirmDialog(null, "Sample App launched to process URL: '" + string + "'");
            }
        } else if (OS.isWindows()) {
            String vappName = JWApp.getMyVirtualApp().getUserVisibleName();
            JWWindowsOS.registerURLSchemeForVirtualApp("jwsample", vappName);
            String url = JWWindowsOS.getRequestedURL();
            if (url != null && url.length() > 0) {
                JOptionPane.showConfirmDialog(null, "Sample App launched to process URL: '" + (String)url + "'");
            }
        }
        Properties props = System.getProperties();
        System.out.println("Number of system properties is " + props.size());
        for (Object e : props.keySet()) {
            System.out.println(e + " - " + props.getProperty((String)e));
        }
        String message = JWSystem.getAppLaunchProperty("message");
        if (message.length() == 0) {
            message = "Hello World";
        }
        try {
            String string = JWSystem.getAppBundleVersion();
        }
        catch (Exception x) {
            String string = "(not running inside JWrapper)";
        }
        JOptionPane.showMessageDialog(null, "Example Minimal App (" + message + ") " + JWSystem.getAppBundleVersion());
        System.exit(0);
    }

    public static void saveShortcut() throws Exception {
        File desktop = new File(System.getProperty("user.home"), "Desktop");
        Properties props = new Properties();
        props.setProperty("message", "Goodbye!");
        JWSystem.saveLauncherShortcutForVirtualApp(desktop, "SampleAppGoodbye", "SampleApp", props, false);
    }
}

