/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import bcutil.BCUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jwrapper.AppFile;
import jwrapper.CompilerArchives;
import jwrapper.DMGHelper;
import jwrapper.HeadlessOsxUtil;
import jwrapper.IcoPng;
import jwrapper.JWConstants;
import jwrapper.JWParameteriser;
import jwrapper.JWrapper;
import jwrapper.JWrapperJreCheckShim;
import jwrapper.LevelGzipOutputStream;
import jwrapper.LicenseZFilter;
import jwrapper.archive.Archive;
import jwrapper.archive.FileStripper;
import jwrapper.archive.LaunchableArchive;
import jwrapper.autotest.AutoTest;
import jwrapper.crypt.CryptBuilder;
import jwrapper.crypt.JarProtector;
import jwrapper.filestrippers.CVSStripper;
import jwrapper.filestrippers.JREStripper;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.service.ManageService;
import jwrapper.launch.JWCompiler;
import jwrapper.lic.JWLicense;
import jwrapper.lic.JWSplash;
import jwrapper.osxwrapper.OSXWrapper;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWApp;
import jwrapper.updater.LaunchFile;
import jwrapper.updater.VersionUtil;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.buildtools.common.signing.KeyStoreDetails;
import utils.buildtools.osx.dsstore.DSConfig;
import utils.buildtools.osx.signer.CertificateInfo;
import utils.buildtools.osx.signer.MacSigner;
import utils.buildtools.win32.AuthenticodeSigner;
import utils.encryption.rsa.RSADecryptor;
import utils.encryption.rsa.RSAEncryptor;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.files.ZFilter;
import utils.files.ZipUtils;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.ostools.win32.ExeReader;
import utils.progtools.CheapTimingPrintStream;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.ProcessPrinter;
import utils.progtools.arrays.ArrayUtils;
import utils.stream.CFriendlyStreamUtils;
import utils.stream.NullOutputStream;
import utils.stream.StreamUtils;
import utils.stream.TinyWebServer;
import utils.string.CharStack;
import utils.string.Normaliser;
import utils.string.StringReplace;
import utils.string.WebBase64;
import utils.swing.icons.ICNSWriter;
import utils.swing.icons.ICOWriter;
import utils.swing.images.ImageHelper;
import utils.switches.Switches;
import utils.sync.DualPrintstream;
import utils.xml.XML14Util;

public class JWrapperCompiler {
    private static final File WINDOWS_WRAPPERS_DIR = new File("wrappers", "windows");
    private static final File OSX_WRAPPERS_DIR = new File("wrappers", "osx");
    private static final File LINUX_WRAPPERS_DIR = new File("wrappers", "linux");
    private static final File LINUX_ARM_WRAPPERS_DIR = new File(LINUX_WRAPPERS_DIR, "arm");
    private static final File HTML_WRAPPERS_DIR = new File("wrappers", "html");
    public static final byte[] marker = new byte[]{29, 67, 42, 80, 91, 122, 31, 100, 35, 71, 33, 36, 23, 50, 60, 80, 33, 108, 4, 102, 41, 92, 41, 123, 11, 91, 25, 51, 47, 79, 15, 77, 39, 88, 24, 36, 21, 57, 78, 121, 43, 118, 21, 89, 61, 87, 73, 0, 17, 41, 5, 101, 43, 16, 112, 102, 94, 45, 64, 96, 117, 67, 48, 8, 97, 74, 116, 126, 64, 27, 83, 59, 86, 70, 55, 30, 75, 44, 114, 89, 48, 68, 58, 60, 47, 68, 120, 43, 38, 101, 113, 113, 57, 115, 37, 35, 16, 20, 81, 36, 49, 112, 16, 74, 13, 5, 87, 42, 6, 10, 83, 33, 77, 44, 19, 0, 54, 41, 26, 116, 71, 45, 26, 85, 44, 47, 66, 99};
    private static final boolean INCLUDE_LAUNCHER = true;
    private static boolean IS_SH_BUILD = false;
    static PrintStream always;
    static final int PARAMS_BLOCK_LEN = 204800;
    private static boolean buildMacOS64Wrappers;
    private static boolean buildLinux64Wrappers;
    private static boolean buildWindows64Wrappers;
    private static boolean buildMacOS32Wrappers;
    private static boolean buildLinux32Wrappers;
    private static boolean buildWindows32Wrappers;
    private static boolean buildLinuxARM32Wrappers;
    private static boolean skipTimestamping;
    private static final AppVersionInfo versionInfo;
    private static long totalSigningTime;
    static boolean simulateHighJavaVersion;
    static String xmlpath;
    private static final byte[] buf;

    private static File getWindowsWrapperFor(String appElevation, boolean appUiAccess, boolean is64Bit) throws Exception {
        String suffix = ".exe";
        if (is64Bit) {
            suffix = "_64.exe";
        }
        if (appElevation.equalsIgnoreCase("None")) {
            return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_noelevation" + suffix);
        }
        if (appElevation.equalsIgnoreCase("AsInvoker")) {
            if (appUiAccess) {
                return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_asInvoker_0" + suffix);
            }
            return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_asInvoker_1" + suffix);
        }
        if (appElevation.equalsIgnoreCase("HighestAvailable")) {
            if (appUiAccess) {
                return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_highestAvailable_0" + suffix);
            }
            return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_highestAvailable_1" + suffix);
        }
        if (appElevation.equalsIgnoreCase("RequireAdministrator")) {
            if (appUiAccess) {
                return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_requireAdministrator_0" + suffix);
            }
            return new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_requireAdministrator_1" + suffix);
        }
        throw new Exception("Unrecognised elevation type: " + appElevation);
    }

    private static int getRequiredJavaVersion() {
        if (simulateHighJavaVersion) {
            always.println("[Build] Simulating high required Java version");
            return 99;
        }
        return Archive.versionChecker.getRequiredJavaVersion();
    }

    private static RSAEncryptor createRsaEncryptor() {
        RSAEncryptor rsaEnc = new RSAEncryptor(new BigInteger[]{new BigInteger(new byte[]{0, -126, -92, -128, 105, -24, -21, 15, -79, 69, 30, -7, 122, -127, -33, 123, 8, -31, 62, -39, -109, 42, 80, -41, -125, 85, -98, 18, 72, 33, -80, 110, 116, -35, -42, 63, 115, 29, -99, 57, 45, 127, 56, 62, -78, 70, -114, -57, -16, 118, -98, -102, 97, 23, -80, 98, -104, -54, 86, -59, -95, -31, -108, 118, -103, 16, -74, 44, 42, -44, -33, -63, -128, 12, 32, 55, -70, 2, -92, 125, -46, 90, 80, -96, 39, 97, 84, -117, 49, 13, -48, 31, 68, -115, -16, -107, -103, -79, 82, -93, -106, -86, -17, -46, 64, -51, 47, -27, 33, -52, -123, 38, -9, 106, -16, 125, 99, -90, 34, -109, 90, 58, -5, -57, -34, -20, -100, 4, 62, 12, -21, -128, 65, -110, 90, 90, 92, -111, 23, -34, 89, 124, -11, 26, 8, 86, 100, 38, 14, -13, -98, -34, 78, 82, 95, 62, 45, 68, -93, 80, -116, 86, -56, -37, 33, -42, 125, 76, -121, 62, -68, 93, -69, 91, -102, 77, 12, -109, -100, -51, -76, 110, 59, 8, -40, -12, 126, -108, -6, -18, -59, -29, -94, 57, -10, 72, 14, -16, 48, -52, -19, 16, -111, 120, -102, 104, -81, 101, -65, 72, 40, -56, -25, -117, 0, -2, 68, -71, 115, -89, -113, -60, 77, 113, -76, 28, -117, -6, 72, -78, 87, 20, -1, -14, -127, -37, -30, -104, -29, -19, -95, 37, 68, -31, 67, -101, -5, -118, -3, -104, 39, -72, -82, 63, -81, 85, 70, -128, 94, 22, -8, 103, 114, -96, -120, -101, -15, 22, -20, -56, 54, 125, -53, 120, -39, 9, 73, 4, -98, 111, 57, -110, 40, 51, -90, 100, -76, 20, -117, 13, 4, -99, -80, 124, -56, -98, 28, 52, 69, -111, 29, 46, -63, -88, -46, -71, -77, -20, 82, 33, 102, 84, -4, 58, 34, -6, -28, -90, 56, 40, -84, -71, -55, -119, -91, 11, -76, 27, -127, 74, 21, 43, 16, -32, -13, 58, -13, 70, 77, 115, -8, -41, -103, -121, 55, 35, 112, 0, 63, -18, 40, -40, 126, 25, -40, -9, -87, -70, 20, -5, -24, 104, 50, -103, 19, 20, -34, -46, 21, -121, 120, 27, -74, 12, 74, -12, -29, 50, -98, 44, 31, 31, 51, 124, -2, 103, 20, 64, -80, -83, 95, 118, 121}), new BigInteger(new byte[]{62, 123, 50, 72, -23, -44, -104, 51, 99, -41, 41, 103, 28, -72, -53, -119, -49, -26, 104, 14, -69, 49, -53, 62, -49, -25, 108, -22, -40, 117, -59, -123, -50, 69, 19, 55, 14, 41, -51, 110, -51, -118, 52, 63, 0, 90, -116, 37, 23, 86, -5, -21, -89, 39, -42, 28, -115, 74, -28, 21, -60, -19, -11, -16, 41, 98, 65, -91, 46, 40, 59, 38, -6, -85, 60, 11, 12, 100, -18, 67, 54, 83, 20, -15, 113, 84, -12, -88, 39, -1, 92, -34, 1, 26, 4, -61, -16, -95, -11, 49, -52, 47, -22, 30, -3, -11, -125, -40, -125, 52, -115, 18, 40, 3, -74, 103, 79, 116, -75, -58, -6, -47, 117, -39, -21, -104, -121, -104, 28, 112, -95, -125, -120, -57, 9, -45, 58, 67, 17, 76, 48, -95, -66, -119, -115, 125, -49, 107, 83, 31, 117, 115, 95, 12, 40, -35, -1, 111, 127, -111, 8, 29, 71, 105, 58, 15, 103, 98, 18, -33, -89, 67, 88, 84, -19, 50, -119, 97, 64, -3, 63, -39, 115, -119, 39, 4, -29, 19, -42, 94, -92, -123, 61, 28, -66, 73, 59, -75, -103, -16, -69, -93, -64, -88, 114, 36, 104, -23, 59, -34, 66, -108, -13, 67, 35, 105, -126, 88, 60, -54, 121, 36, 93, -22, -11, -5, -7, 70, 13, 54, 82, -37, -47, -61, -89, 42, 10, -101, -78, 101, 13, 22, -15, -33, -46, -120, -24, 11, 82, -71, -24, 0, 99, -120, -63, 108, 48, -63, -3, -9, -11, -120, 115, -128, 124, 91, -18, 10, -96, 105, -71, 65, 105, -102, -54, 71, -92, 112, -66, 42, 36, -90, -91, 29, -36, -98, 81, 48, 82, 109, 24, -75, 48, -40, 79, -58, -5, -39, 32, -46, 51, -73, 73, 105, -86, -121, 2, -89, 103, 19, 1, 25, -80, 92, -43, -2, -1, 31, -86, -81, 6, 112, 52, 38, 44, 44, -112, -114, 40, -125, 50, -62, 10, 26, -113, -53, -49, -125, -126, -47, -90, 0, -126, 47, 85, 91, -22, 17, 50, 43, 95, 108, -94, -86, -96, -31, -66, 69, -117, -115, 11, 104, 40, 63, -57, -13, 57, 69, -108, 42, -107, 116, -61, 127, 120, 17, -69, -81, 73, 71, 48, -32, 105, -97, 73, -38, 84, -116, 93, -29, -81, 123})});
        return rsaEnc;
    }

    private static RSADecryptor createRsaDecryptor() {
        RSADecryptor rsaDec = new RSADecryptor(new BigInteger[]{new BigInteger(new byte[]{0, -126, -92, -128, 105, -24, -21, 15, -79, 69, 30, -7, 122, -127, -33, 123, 8, -31, 62, -39, -109, 42, 80, -41, -125, 85, -98, 18, 72, 33, -80, 110, 116, -35, -42, 63, 115, 29, -99, 57, 45, 127, 56, 62, -78, 70, -114, -57, -16, 118, -98, -102, 97, 23, -80, 98, -104, -54, 86, -59, -95, -31, -108, 118, -103, 16, -74, 44, 42, -44, -33, -63, -128, 12, 32, 55, -70, 2, -92, 125, -46, 90, 80, -96, 39, 97, 84, -117, 49, 13, -48, 31, 68, -115, -16, -107, -103, -79, 82, -93, -106, -86, -17, -46, 64, -51, 47, -27, 33, -52, -123, 38, -9, 106, -16, 125, 99, -90, 34, -109, 90, 58, -5, -57, -34, -20, -100, 4, 62, 12, -21, -128, 65, -110, 90, 90, 92, -111, 23, -34, 89, 124, -11, 26, 8, 86, 100, 38, 14, -13, -98, -34, 78, 82, 95, 62, 45, 68, -93, 80, -116, 86, -56, -37, 33, -42, 125, 76, -121, 62, -68, 93, -69, 91, -102, 77, 12, -109, -100, -51, -76, 110, 59, 8, -40, -12, 126, -108, -6, -18, -59, -29, -94, 57, -10, 72, 14, -16, 48, -52, -19, 16, -111, 120, -102, 104, -81, 101, -65, 72, 40, -56, -25, -117, 0, -2, 68, -71, 115, -89, -113, -60, 77, 113, -76, 28, -117, -6, 72, -78, 87, 20, -1, -14, -127, -37, -30, -104, -29, -19, -95, 37, 68, -31, 67, -101, -5, -118, -3, -104, 39, -72, -82, 63, -81, 85, 70, -128, 94, 22, -8, 103, 114, -96, -120, -101, -15, 22, -20, -56, 54, 125, -53, 120, -39, 9, 73, 4, -98, 111, 57, -110, 40, 51, -90, 100, -76, 20, -117, 13, 4, -99, -80, 124, -56, -98, 28, 52, 69, -111, 29, 46, -63, -88, -46, -71, -77, -20, 82, 33, 102, 84, -4, 58, 34, -6, -28, -90, 56, 40, -84, -71, -55, -119, -91, 11, -76, 27, -127, 74, 21, 43, 16, -32, -13, 58, -13, 70, 77, 115, -8, -41, -103, -121, 55, 35, 112, 0, 63, -18, 40, -40, 126, 25, -40, -9, -87, -70, 20, -5, -24, 104, 50, -103, 19, 20, -34, -46, 21, -121, 120, 27, -74, 12, 74, -12, -29, 50, -98, 44, 31, 31, 51, 124, -2, 103, 20, 64, -80, -83, 95, 118, 121}), new BigInteger(new byte[]{23})});
        return rsaDec;
    }

    public static void signJar(File jardest, String jarSignerPath, KeyStoreDetails winSignKeystore, String winSignKeystoreType, String winSignTimestampURL) throws IOException, InterruptedException {
        ArrayList<String> jarsign = new ArrayList<String>();
        jarsign.add(jarSignerPath);
        jarsign.add("-verbose");
        jarsign.add("-keystore");
        jarsign.add(winSignKeystore.getKeystoreLocation().getCanonicalFile().getAbsolutePath());
        jarsign.add("-storetype");
        jarsign.add(winSignKeystoreType);
        jarsign.add("-storepass");
        jarsign.add(new String(winSignKeystore.getStorePassword()));
        jarsign.add("-keypass");
        jarsign.add(new String(winSignKeystore.getKeyPassword()));
        if (winSignTimestampURL != null) {
            jarsign.add("-tsa");
            jarsign.add(winSignTimestampURL);
        }
        jarsign.add(jardest.getCanonicalFile().getAbsolutePath());
        jarsign.add(winSignKeystore.getAlias());
        Object[] args = new String[jarsign.size()];
        jarsign.toArray(args);
        always.println(Arrays.toString(args));
        Process p = Runtime.getRuntime().exec((String[])args);
        new ProcessPrinter(p, always, always);
        int N = p.waitFor();
        if (N != 0) {
            always.println("ERROR: Jarsigner failed with exit code " + N);
            System.exit(1);
        }
    }

    public static void fail(String s) {
        always.println("Build FAILED for " + xmlpath);
        always.println("**********************************");
        always.println("*          BUILD FAILED          *");
        always.println("**********************************");
        always.println("** Reason: " + s);
        always.flush();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    public static void fail(Throwable x) {
        always.println("Build FAILED for " + xmlpath);
        always.println("**********************************");
        always.println("*          BUILD FAILED          *");
        always.println("**********************************");
        always.println("** Reason: " + x);
        always.println("** Error Trace:\n");
        x.printStackTrace(always);
        always.flush();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equalsIgnoreCase("jwcrypt")) {
            args = ArrayUtils.popFirst(args);
            CryptBuilder.main((String[])args);
            System.exit(0);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("jwsign")) {
            args = ArrayUtils.popFirst(args);
            try {
                if (args[0].equals("mac")) {
                    File dotApp = new File(args[1]);
                    CertificateInfo info = new CertificateInfo();
                    info.appleIncRootCertficate = new File(args[2]);
                    info.developerIDCACertificate = new File(args[3]);
                    info.developerIDp12 = new File(args[4]);
                    info.developerIDAlias = args[5];
                    info.developerIDPassword = args[6];
                    String[] wrapperNames = new String[]{args[7]};
                    MacSigner.signApp((CertificateInfo)info, (File)dotApp, (String[])wrapperNames, (String)wrapperNames[0]);
                } else {
                    File originalFile = new File(args[1]);
                    File destFile = new File(args[2]);
                    String description = args[3];
                    File keystore = new File(args[4]);
                    String winSignKeystoreType = args[5];
                    String winSignTimestampURL = args[6];
                    String alias = args[7];
                    String password = args[8];
                    String keyPassword = args[9];
                    KeyStoreDetails winSignKeystore = new KeyStoreDetails(keystore, alias, password.toCharArray(), keyPassword != null ? keyPassword.toCharArray() : null, winSignKeystoreType);
                    if (winSignKeystore.getPrivateKey() == null) {
                        always.println("WARNING: unable to retrieve private key fron keystore '" + keystore + "'");
                    }
                    long start = System.currentTimeMillis();
                    new AuthenticodeSigner(originalFile, destFile, description, winSignTimestampURL, winSignKeystore).sign(new byte[0]);
                    totalSigningTime += System.currentTimeMillis() - start;
                }
            }
            catch (ArrayIndexOutOfBoundsException x) {
                System.out.println("JWSign Usage");
                System.out.println();
                System.out.println("Windows exe signing:");
                System.out.println("  java -jar jwrapper.jar jwsign win <file.exe> <destination.exe> <description> <keystore file> <JKS|PKCS12> <timestamp URL> <alias> <keystore passw> <key passw>");
                System.out.println();
                System.out.println("Mac app signing:");
                System.out.println("  java -jar jwrapper.jar jwsign mac <App.app> <Apple root cert path> <Dev ID cert path> <Dev ID p12> <Dev ID alias> <Dev ID passw> <executable>");
            }
            always.println("Signing complete");
            System.exit(0);
        }
        long Tall = System.currentTimeMillis();
        try {
            File appArchive;
            File downloadpng;
            File lzma;
            File jre;
            File wfile;
            CryptBuilder crypt;
            File[] files;
            File finalLauncher;
            File sourceLauncherWithIcon;
            CompilerArchives carps;
            File appICNS;
            File appUninstallerICO;
            File wrappers;
            int osxBgHeight;
            File appOsxBG;
            File bundleSplash;
            String macversion;
            File buildver;
            String appversion;
            String guversion;
            boolean LIC_allowJWService;
            File bundlelic;
            FileStripper[] appStrippers;
            byte[] logo256;
            byte[] logo48;
            byte[] logo32;
            byte[] logo24;
            byte[] logo16;
            JWParameteriser jwparams;
            File pubkeyFile;
            Properties dynamicProps;
            String silentInstallParameter;
            String[] filesNotToPack200;
            String[] filesToKeep;
            boolean paramZeroUpdateUrl;
            int pack200Effort;
            boolean canOverrideSplash;
            int splashMinMS;
            String mainClassPreUninstall;
            String mainClassPostInstall;
            String mainClassVerifyJRE;
            String mainClassOnUpdate;
            boolean matchClientVersionToServerVersion;
            boolean dynamicUpdateURL;
            String updateURL;
            boolean haveUpdateURL;
            String rsaDerEncodedPublicKey;
            AsymmetricCipherKeyPair rsaKeys;
            String installType;
            boolean appUiAccess;
            String appElevation;
            String jarSignerPath;
            String appletSignTimestampURL;
            String winSignTimestampURL;
            String winSignKeystoreType;
            KeyStoreDetails winSignKeystore;
            File cacertsFile;
            CertificateInfo macCertInfo;
            boolean mustFork;
            ArrayList<JWApp> apps;
            ArrayList<File> appnotes;
            ArrayList<File> deleteme;
            File build;
            boolean protecting;
            ArrayList<String> jvmOptions;
            boolean deleteElevationFiles;
            String customHTML;
            long dmgSplashSizeBytes;
            String shortBundleName;
            String bundleName;
            Element root;
            boolean deltaBuild;
            boolean fullBuild;
            block643: {
                void var108_255;
                boolean LIC_allowSignatures;
                boolean LIC_allowJWCrypt;
                boolean LIC_allowCobranding;
                boolean LIC_allowRebranding;
                boolean LIC_showTrialDialog;
                FileStripper[] jreStrippers;
                boolean signingUpdates;
                String supportedLanguages;
                String macSignID;
                boolean noStripJREs;
                boolean AutoTesting;
                ArrayList<String> guJVMOptions;
                String mac64JRE;
                String linux32ARMJRE;
                String linux64JRE;
                String linux32JRE;
                String windows64JRE;
                String windows32JRE;
                String bundleLogoPNG;
                String splashPNG;
                String forceAppVer;
                boolean testSplash;
                boolean useCoSplash;
                boolean useFreeSplash;
                boolean simulateBrokenGU;
                String alternateUpdateURL;
                String bundleNameModifier;
                block640: {
                    Document doc;
                    bundleNameModifier = "";
                    alternateUpdateURL = "";
                    fullBuild = true;
                    deltaBuild = false;
                    simulateBrokenGU = false;
                    always = new PrintStream(new FileOutputStream(FileDescriptor.out), true);
                    always.println("JWrapperCompiler started (" + Arrays.toString(args) + ")");
                    Archive.setAlwaysPrintstream(always);
                    LaunchableArchive.setAlwaysPrintstream((PrintStream)always);
                    System.setOut(new PrintStream((OutputStream)new NullOutputStream()));
                    useFreeSplash = false;
                    useCoSplash = false;
                    testSplash = false;
                    boolean isDebugging = false;
                    forceAppVer = "";
                    while (args.length > 0) {
                        String s = args[0];
                        always.println("Next arg: " + s);
                        if (s.equals("-logtofile")) {
                            if (!isDebugging) {
                                always = new CheapTimingPrintStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(new File("jwrapper.log"))), true));
                                always.println("JWrapperCompiler started " + new Date());
                                Archive.setAlwaysPrintstream(always);
                                LaunchableArchive.setAlwaysPrintstream((PrintStream)always);
                                System.setErr(always);
                            }
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-logtofilets")) {
                            if (!isDebugging) {
                                Random r = new Random();
                                Thread.sleep(r.nextInt(100));
                                File f = new File("jwrapper-" + System.currentTimeMillis() + ".log");
                                while (!f.createNewFile()) {
                                    Thread.sleep(10L);
                                    f = new File("jwrapper-" + System.currentTimeMillis() + ".log");
                                }
                                always = new CheapTimingPrintStream(new PrintStream(new BufferedOutputStream(new FileOutputStream(f)), true));
                                always.println("JWrapperCompiler started " + new Date());
                                Archive.setAlwaysPrintstream(always);
                                LaunchableArchive.setAlwaysPrintstream((PrintStream)always);
                                System.setErr(always);
                            }
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-fullbuild")) {
                            fullBuild = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-devbuild")) {
                            fullBuild = false;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-deltabuild")) {
                            deltaBuild = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-shbuild")) {
                            IS_SH_BUILD = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-forceVersion")) {
                            args = ArrayUtils.popFirst(args);
                            forceAppVer = args[0].trim();
                            args = ArrayUtils.popFirst(args);
                            try {
                                Long.parseLong(forceAppVer);
                            }
                            catch (NumberFormatException x) {
                                forceAppVer = "";
                            }
                            continue;
                        }
                        if (s.equals("-debug")) {
                            isDebugging = true;
                            ZipUtils.VERBOSE = true;
                            ExeReader.VERBOSE_STRUCTURE = true;
                            ExeReader.VERBOSE_PARSING = true;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                            int rand = (int)(Math.random() * 1000.0);
                            File logfile = new File("jwcompiler-debug-" + sdf.format(new Date()) + "-" + rand + ".log");
                            File[] allFiles = new File(".").listFiles();
                            if (allFiles != null) {
                                for (File file : allFiles) {
                                    if (!file.getName().startsWith("jwcompiler-debug-") || System.currentTimeMillis() - file.lastModified() <= 604800000L) continue;
                                    file.delete();
                                }
                            }
                            PrintStream fsout = new PrintStream(new CheapTimingPrintStream(FileUtil.wopen(logfile)), true);
                            PrintStream stdout = new PrintStream(new FileOutputStream(FileDescriptor.out), true);
                            System.setOut(fsout);
                            System.setErr(fsout);
                            DualPrintstream dp = new DualPrintstream();
                            dp.addThroughStream(fsout);
                            dp.addThroughStream(stdout);
                            always = new PrintStream(dp.addOutputStream());
                            System.out.println("[Debugging] Debug log set up, logging to " + logfile);
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-testFreeSplash")) {
                            useFreeSplash = true;
                            testSplash = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-testCoSplash")) {
                            useCoSplash = true;
                            testSplash = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-altBundle")) {
                            args = ArrayUtils.popFirst(args);
                            bundleNameModifier = args[0].trim();
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-altUrl")) {
                            args = ArrayUtils.popFirst(args);
                            alternateUpdateURL = args[0].trim();
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-useFreeSplash")) {
                            useFreeSplash = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-useCoSplash")) {
                            useCoSplash = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-simulateBrokenGU")) {
                            simulateBrokenGU = true;
                            always.println("[Testing] Simulating broken GU");
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-simulateHighJavaVersion")) {
                            simulateHighJavaVersion = true;
                            always.println("[Testing] Simulating high java class version in archives");
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-runTestServer")) {
                            JWCompiler.CMDOPTION_DEMO = true;
                            args = ArrayUtils.popFirst(args);
                            continue;
                        }
                        if (s.equals("-autotest")) {
                            args = ArrayUtils.popFirst(args);
                            AutoTest.main((String[])args);
                            System.exit(0);
                            continue;
                        }
                        if (!s.equals("-testNewStuff")) break;
                        always.println("Testing new dev stuff...");
                        if (OS.isWindows()) {
                            JWNativeAPI.loadLibrary();
                            always.println("[Broken] User Start Menu/Programs folder: " + JWNativeAPI.getInstance().getWindowsUserProgramsFolder());
                            always.println("[Broken] All Start Menu/Programs folder: " + JWNativeAPI.getInstance().getWindowsAllProgramsFolder());
                        }
                        always.flush();
                        System.exit(0);
                    }
                    if (args.length == 0) {
                        always.println("Usage: JWrapperCompiler <JW XML File>");
                        new UpdateCheck().run();
                        System.exit(1);
                    }
                    if ((forceAppVer = forceAppVer.trim()).length() > 0) {
                        always.println("[Config] Forcing app version " + forceAppVer);
                    }
                    new UpdateCheck().start();
                    skipTimestamping = !fullBuild;
                    always.println("fullBuild is set to " + fullBuild);
                    if (!fullBuild) {
                        always.println("[Config] Will produce a DEVELOPER build, this will skip timestamping and compression to speed up build time");
                    } else {
                        always.println("[Config] Will produce a RELEASE build, this will include timestamping and compression but will take longer than a dev build");
                    }
                    always.println("[Config] JVM Memory limit for compilation is " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "mb");
                    String xmlfile = args[0];
                    xmlpath = new File(xmlfile).getCanonicalPath();
                    always.println("[Config] Building file is " + xmlfile);
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    try {
                        doc = builder.parse(new BufferedInputStream(new FileInputStream(xmlfile)));
                    }
                    catch (IOException x) {
                        throw new FailException("Unable to read input XML file " + xmlfile + " - " + x);
                    }
                    root = doc.getDocumentElement();
                    try {
                        bundleName = root.getElementsByTagName("BundleName").item(0).getTextContent();
                    }
                    catch (NullPointerException x) {
                        throw new FailException("Missing required BundleName tag");
                    }
                    try {
                        shortBundleName = root.getElementsByTagName("ShortBundleName").item(0).getTextContent();
                    }
                    catch (Exception x) {
                        shortBundleName = bundleName;
                    }
                    try {
                        splashPNG = root.getElementsByTagName("SplashPNG").item(0).getTextContent();
                    }
                    catch (NullPointerException x) {
                        throw new FailException("Missing required SplashPNG tag");
                    }
                    dmgSplashSizeBytes = 0L;
                    try {
                        String dmgSplashSize = root.getElementsByTagName("PadDMGSplashToBytes").item(0).getTextContent();
                        try {
                            dmgSplashSizeBytes = Long.parseLong(dmgSplashSize);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    catch (NullPointerException t) {
                        // empty catch block
                    }
                    try {
                        Element versionInfoElement = XML14Util.getChildByName(root, "VersionInfo");
                        if (versionInfoElement != null) {
                            JWrapperCompiler.versionInfo.appDescription = XML14Util.getChildText(versionInfoElement, "AppDescription", null);
                            JWrapperCompiler.versionInfo.appName = XML14Util.getChildText(versionInfoElement, "AppName", null);
                            JWrapperCompiler.versionInfo.companyName = XML14Util.getChildText(versionInfoElement, "CompanyName", null);
                            JWrapperCompiler.versionInfo.fileVersion = XML14Util.getChildText(versionInfoElement, "FileVersion", null);
                            JWrapperCompiler.versionInfo.productVersion = XML14Util.getChildText(versionInfoElement, "ProductVersion", null);
                            always.println("[JWrapperCompiler] VersionInfo-App: " + JWrapperCompiler.versionInfo.appName);
                            always.println("[JWrapperCompiler] VersionInfo-Description: " + JWrapperCompiler.versionInfo.appDescription);
                            always.println("[JWrapperCompiler] VersionInfo-Company: " + JWrapperCompiler.versionInfo.companyName);
                            always.println("[JWrapperCompiler] VersionInfo-FileVersion: " + JWrapperCompiler.versionInfo.fileVersion);
                            always.println("[JWrapperCompiler] VersionInfo-ProductVersion: " + JWrapperCompiler.versionInfo.productVersion);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        bundleLogoPNG = root.getElementsByTagName("BundleLogoPNG").item(0).getTextContent();
                    }
                    catch (NullPointerException x) {
                        throw new FailException("Missing required BundleLogoPNG tag");
                    }
                    customHTML = "";
                    try {
                        customHTML = root.getElementsByTagName("AppInfoHTML").item(0).getTextContent();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    deleteElevationFiles = root.getElementsByTagName("KeepElevationFiles").getLength() == 0;
                    NodeList list = root.getElementsByTagName("SkipMacOS");
                    boolean skipMacOS = false;
                    if (list.getLength() != 0 && !list.item(0).getTextContent().equalsIgnoreCase("false")) {
                        skipMacOS = true;
                    }
                    if (skipMacOS) {
                        buildMacOS32Wrappers = false;
                        buildMacOS64Wrappers = false;
                    } else {
                        buildMacOS32Wrappers = root.getElementsByTagName("SkipMacOS32").getLength() == 0;
                        buildMacOS64Wrappers = root.getElementsByTagName("SkipMacOS64").getLength() == 0;
                    }
                    list = root.getElementsByTagName("SkipWindows");
                    boolean skipWindows = false;
                    if (list.getLength() != 0 && !list.item(0).getTextContent().equalsIgnoreCase("false")) {
                        skipWindows = true;
                    }
                    if (skipWindows) {
                        buildWindows32Wrappers = false;
                        buildWindows64Wrappers = false;
                    } else {
                        buildWindows32Wrappers = root.getElementsByTagName("SkipWindows32").getLength() == 0;
                        buildWindows64Wrappers = root.getElementsByTagName("SkipWindows64").getLength() == 0;
                    }
                    list = root.getElementsByTagName("SkipLinux");
                    boolean skipLinux = false;
                    if (list.getLength() != 0 && !list.item(0).getTextContent().equalsIgnoreCase("false")) {
                        skipLinux = true;
                    }
                    if (skipLinux) {
                        buildLinux32Wrappers = false;
                        buildLinux64Wrappers = false;
                        buildLinuxARM32Wrappers = false;
                    } else {
                        buildLinux32Wrappers = root.getElementsByTagName("SkipLinux32").getLength() == 0;
                        buildLinux64Wrappers = root.getElementsByTagName("SkipLinux64").getLength() == 0;
                        boolean bl = buildLinuxARM32Wrappers = root.getElementsByTagName("SkipLinuxARM32").getLength() == 0;
                    }
                    if (!Switches.JW_ARMBUILDS) {
                        buildLinuxARM32Wrappers = false;
                    }
                    windows32JRE = null;
                    windows64JRE = null;
                    if (buildWindows32Wrappers) {
                        try {
                            windows32JRE = root.getElementsByTagName("Windows32JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required Windows32JRE tag");
                        }
                    }
                    if (buildWindows64Wrappers) {
                        try {
                            windows64JRE = root.getElementsByTagName("Windows64JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required Windows64JRE tag");
                        }
                    }
                    linux32JRE = null;
                    linux64JRE = null;
                    linux32ARMJRE = null;
                    if (buildLinux32Wrappers) {
                        try {
                            linux32JRE = root.getElementsByTagName("Linux32JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required Linux32JRE tag");
                        }
                    }
                    if (buildLinux64Wrappers) {
                        try {
                            linux64JRE = root.getElementsByTagName("Linux64JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required Linux64JRE tag");
                        }
                    }
                    if (Switches.JW_ARMBUILDS && buildLinuxARM32Wrappers) {
                        try {
                            linux32ARMJRE = root.getElementsByTagName("LinuxARM32JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required LinuxARM32JRE tag");
                        }
                    }
                    mac64JRE = null;
                    if (buildMacOS64Wrappers) {
                        try {
                            mac64JRE = root.getElementsByTagName("Mac64JRE").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("Missing required Mac64JRE tag");
                        }
                    }
                    if (bundleNameModifier.length() > 0) {
                        always.println("[App] Bundle name modifier is [" + bundleNameModifier + "]");
                        String nows = Normaliser.removeWhitespace(bundleNameModifier);
                        if (bundleName.indexOf(32) == -1) {
                            bundleName = bundleName + nows;
                            always.println("[App] New long bundle name is [" + bundleName + "]");
                        } else {
                            bundleName = bundleName + bundleNameModifier;
                            always.println("[App] New long bundle name is [" + bundleName + "]");
                        }
                        shortBundleName = shortBundleName + nows;
                        always.println("[App] New short bundle name is [" + shortBundleName + "]");
                    }
                    try {
                        if (bundleName.equals("Remote Support")) {
                            HeadlessOsxUtil.setOSXAppName("Porthos! (" + bundleName + ")");
                        } else if (bundleName.equals("SimpleHelp Technician")) {
                            HeadlessOsxUtil.setOSXAppName("Aramis! (" + bundleName + ")");
                        } else if (bundleName.equals("Remote Access")) {
                            HeadlessOsxUtil.setOSXAppName("Athos! (" + bundleName + ")");
                        } else {
                            HeadlessOsxUtil.setOSXAppName("JWrapper Compiling '" + bundleName + "'");
                        }
                        File logoFile = new File(PathUtil.makePathNative(bundleLogoPNG));
                        File doodad = new File(new File("wrappers"), "jwlogo64.png");
                        BufferedImage logo = ImageIO.read(logoFile);
                        if (!doodad.exists()) {
                            HeadlessOsxUtil.setOSXAppDockImage(logo);
                        } else {
                            BufferedImage overlay = ImageIO.read(doodad);
                            logo = ImageHelper.createOverlay(logo, overlay, true, true, 0.4, true);
                            HeadlessOsxUtil.setOSXAppDockImage(logo);
                        }
                    }
                    catch (Throwable logoFile) {
                        // empty catch block
                    }
                    String buildDir = "build";
                    try {
                        buildDir = root.getElementsByTagName("BuildOutputFolder").item(0).getTextContent();
                    }
                    catch (Exception doodad) {
                        // empty catch block
                    }
                    jvmOptions = new ArrayList<String>();
                    try {
                        Element opts = (Element)root.getElementsByTagName("JvmOptions").item(0);
                        NodeList list2 = opts.getElementsByTagName("JvmOption");
                        for (int i = 0; i < list2.getLength(); ++i) {
                            String tmp = list2.item(i).getTextContent();
                            jvmOptions.add(tmp.trim());
                        }
                    }
                    catch (Exception opts) {
                        // empty catch block
                    }
                    guJVMOptions = new ArrayList<String>();
                    try {
                        Element opts = (Element)root.getElementsByTagName("UpdaterJvmOptions").item(0);
                        NodeList list3 = opts.getElementsByTagName("UpdaterJvmOption");
                        for (int i = 0; i < list3.getLength(); ++i) {
                            String tmp = list3.item(i).getTextContent();
                            guJVMOptions.add(tmp.trim());
                        }
                    }
                    catch (Exception opts) {
                        // empty catch block
                    }
                    protecting = false;
                    NodeList list4 = root.getElementsByTagName("File");
                    for (int i = 0; i < list4.getLength(); ++i) {
                        String s;
                        Element el = (Element)list4.item(i);
                        File file = new File(el.getTextContent());
                        if (!el.hasAttribute("protected") || (s = el.getAttribute("protected")) == null || !s.equalsIgnoreCase("true") && !s.equalsIgnoreCase("yes")) continue;
                        protecting = true;
                    }
                    if (protecting) {
                        always.println("[JWCrypt] One or more files will be protected");
                        Collections.addAll(jvmOptions, CryptBuilder.mustHave);
                    }
                    build = new File(buildDir);
                    build.mkdirs();
                    deleteme = new ArrayList<File>();
                    appnotes = new ArrayList<File>();
                    boolean hasJreVerifier = false;
                    apps = new ArrayList<JWApp>();
                    NodeList nl = root.getElementsByTagName("App");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        String logoPNG;
                        Element el = (Element)nl.item(i);
                        JWApp app2 = new JWApp();
                        try {
                            app2.name = el.getElementsByTagName("Name").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("App tag is missing required Name tag");
                        }
                        app2.userAccessible = true;
                        try {
                            app2.userAccessible = el.getElementsByTagName("UserAccessible").item(0).getTextContent().equalsIgnoreCase("true");
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        try {
                            logoPNG = PathUtil.makePathNative(el.getElementsByTagName("LogoPNG").item(0).getTextContent());
                        }
                        catch (NullPointerException x) {
                            throw new FailException("App tag is missing required LogoPNG tag");
                        }
                        File png = new File(logoPNG);
                        ICOWriter.ImageList list5 = new ICOWriter.ImageList();
                        list5.image16 = png;
                        list5.image24 = png;
                        list5.image32 = png;
                        list5.image48 = png;
                        list5.image256 = png;
                        File outico = new File(build, "out.ico");
                        int[] pngInfo = ICOWriter.writeIcoFile((File)outico, (ICOWriter.ImageList)list5);
                        app2.logoICO = FileUtil.readFile(outico.getAbsolutePath());
                        app2.pngIndex = pngInfo[0];
                        app2.pngLen = pngInfo[1];
                        outico.delete();
                        try {
                            app2.mainClass = el.getElementsByTagName("MainClass").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("App tag is missing required MainClass tag");
                        }
                        if (app2.name.indexOf(45) != -1) {
                            throw new Exception("Dashes '-' not allowed in application name");
                        }
                        if (app2.name.equals(LaunchFile.JW_VAPP_COMPATIBILITY_APP)) {
                            hasJreVerifier = true;
                            if (Switches.SH_XXXX_useJreCheckShim) {
                                always.println("[App] Specifying JRE check shim class, shimming to " + app2.mainClass);
                                File tmp = new File(build, JWrapperJreCheckShim.JRE_CHECK_NOTE);
                                FileUtil.writeFileAsStringUTF8(tmp, app2.mainClass);
                                always.println("[App] Appnote saved to " + tmp.getAbsolutePath() + " / " + tmp.length());
                                deleteme.add(tmp);
                                appnotes.add(tmp);
                                always.println("[App] Appnotes " + appnotes.size());
                                app2.mainClass = JWrapperJreCheckShim.class.getName();
                            }
                        }
                        NodeList alist = el.getElementsByTagName("Param");
                        for (int k = 0; k < alist.getLength(); ++k) {
                            app2.args.add(alist.item(k).getTextContent());
                        }
                        if (protecting) {
                            app2.args.add(0, app2.mainClass);
                            app2.mainClass = CryptBuilder.JWCRYPT_START;
                            always.println("[JWCrypt] Supplanting main class");
                        }
                        apps.add(app2);
                    }
                    if (apps.size() == 0) {
                        throw new FailException("No apps specified (<App> tags)");
                    }
                    if (!hasJreVerifier && Switches.SH_XXXX_useJreCheckShim) {
                        always.println("[App] Specifying JRE check shim class, no JreVerifier to shim to");
                        JWApp app = new JWApp();
                        app.name = LaunchFile.JW_VAPP_COMPATIBILITY_APP;
                        app.userAccessible = false;
                        app.mainClass = JWrapperJreCheckShim.class.getName();
                        apps.add(app);
                    }
                    JWApp app = new JWApp();
                    app.name = "JWrapper Service Management App";
                    app.userAccessible = false;
                    app.mainClass = ManageService.class.getName();
                    if (Switches.JW_servicePostInstallClassloaderSupportJWCrypt && protecting) {
                        app.args.add(0, app.mainClass);
                        app.mainClass = CryptBuilder.JWCRYPT_START;
                        always.println("[JWCrypt] Supplanting main class of JWService to allow post-install classloading");
                    }
                    apps.add(app);
                    AutoTesting = false;
                    try {
                        AutoTesting = root.getElementsByTagName("AutoTesting").item(0).getTextContent().equalsIgnoreCase("true");
                    }
                    catch (Exception el) {
                        // empty catch block
                    }
                    mustFork = false;
                    try {
                        mustFork = root.getElementsByTagName("MustFork").item(0).getTextContent().equalsIgnoreCase("true");
                    }
                    catch (Exception app2) {
                        // empty catch block
                    }
                    noStripJREs = false;
                    try {
                        noStripJREs = root.getElementsByTagName("NoStripJREs").item(0).getTextContent().equalsIgnoreCase("true");
                    }
                    catch (Exception logoPNG) {
                        // empty catch block
                    }
                    macCertInfo = null;
                    macSignID = null;
                    try {
                        Element macSign = (Element)root.getElementsByTagName("SignForMac").item(0);
                        CertificateInfo info = new CertificateInfo();
                        info.appleIncRootCertficate = new File(macSign.getElementsByTagName("AppleRootCertificate").item(0).getTextContent());
                        info.developerIDCACertificate = new File(macSign.getElementsByTagName("DeveloperIdCertificate").item(0).getTextContent());
                        info.developerIDp12 = new File(macSign.getElementsByTagName("DeveloperIdP12").item(0).getTextContent());
                        info.developerIDAlias = macSign.getElementsByTagName("DeveloperIdAlias").item(0).getTextContent();
                        if (info.developerIDAlias.equals("netx information systems incorporated")) {
                            info.developerIDAlias = "netx information systems incorporated\u0000";
                        }
                        info.developerIDPassword = macSign.getElementsByTagName("DeveloperIdPassword").item(0).getTextContent();
                        macCertInfo = info;
                        macSignID = info.developerIDAlias;
                    }
                    catch (Exception macSign) {
                        // empty catch block
                    }
                    cacertsFile = null;
                    try {
                        String cacertsPath = root.getElementsByTagName("SetJRECACerts").item(0).getTextContent();
                        if (cacertsPath != null && cacertsPath.length() > 0) {
                            cacertsFile = new File(cacertsPath);
                            if (!cacertsFile.exists()) {
                                throw new FailException("The JRE CACerts path '" + cacertsPath + "' does not exist.");
                            }
                            always.println("[JWrapperCompiler] CACerts override file is " + cacertsFile);
                        }
                    }
                    catch (NullPointerException cacertsPath) {
                        // empty catch block
                    }
                    winSignKeystore = null;
                    winSignKeystoreType = "JKS";
                    winSignTimestampURL = null;
                    appletSignTimestampURL = null;
                    jarSignerPath = null;
                    try {
                        String password;
                        String alias;
                        String keystore;
                        Element sign = (Element)root.getElementsByTagName("SignForWindowsAndApplet").item(0);
                        if (sign == null) {
                            throw new NullPointerException("No SignForWindowsAndApplet tag");
                        }
                        try {
                            keystore = sign.getElementsByTagName("KeyStore").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("SignForWindowsAndApplet tag is missing required KeyStore tag");
                        }
                        try {
                            winSignKeystoreType = sign.getElementsByTagName("KeyStoreType").item(0).getTextContent();
                        }
                        catch (Exception x) {
                            // empty catch block
                        }
                        try {
                            alias = sign.getElementsByTagName("Alias").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("SignForWindowsAndApplet tag is missing required Alias tag");
                        }
                        try {
                            password = sign.getElementsByTagName("Password").item(0).getTextContent();
                        }
                        catch (NullPointerException x) {
                            throw new FailException("SignForWindowsAndApplet tag is missing required Password tag");
                        }
                        String keyPassword = null;
                        try {
                            keyPassword = sign.getElementsByTagName("KeyPassword").item(0).getTextContent();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!skipTimestamping) {
                            try {
                                winSignTimestampURL = sign.getElementsByTagName("WinTimestampURL").item(0).getTextContent();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                appletSignTimestampURL = sign.getElementsByTagName("AppletTimestampURL").item(0).getTextContent();
                            }
                            catch (Exception exception) {}
                        } else {
                            winSignTimestampURL = null;
                            appletSignTimestampURL = null;
                        }
                        try {
                            NodeList list6 = sign.getElementsByTagName("JarSignerPath");
                            for (int i = 0; i < list6.getLength(); ++i) {
                                String tmp = list6.item(i).getTextContent();
                                if (!new File(tmp).exists()) continue;
                                jarSignerPath = tmp;
                            }
                            if (list6.getLength() > 0 && jarSignerPath == null) {
                                always.println("WARNING: None of the jarsigner paths specified existed on this system");
                            }
                        }
                        catch (Exception list6) {
                            // empty catch block
                        }
                        try {
                            char[] keyPasswordArray = null;
                            if (keyPassword != null) {
                                keyPasswordArray = keyPassword.toCharArray();
                            }
                            if ((winSignKeystore = new KeyStoreDetails(new File(keystore), alias, password.toCharArray(), keyPasswordArray, winSignKeystoreType)).getPrivateKey() == null) {
                                always.println("WARNING: unable to retrieve private key fron keystore '" + keystore + "'");
                            }
                        }
                        catch (KeyStoreDetails.NoSuchAliasException ex) {
                            always.println("WARNING: The alias '" + alias + "' does not exist in the keystore '" + keystore + "'");
                        }
                        catch (KeyStoreException ex) {
                            always.println("WARNING: The keystore type " + winSignKeystoreType + " is not supported.");
                        }
                        catch (IOException ex) {
                            always.println("WARNING: Unable to open or process the keystore data in '" + keystore + "'. Verify the supplied keystore location and password.");
                            if (ex.getCause() instanceof UnrecoverableKeyException) {
                                always.println("WARNING: Keystore password is invalid.");
                            }
                        }
                        catch (CertificateException ex) {
                            always.println("WARNING: At least one certificate in '" + keystore + "' could not be loaded.");
                        }
                        catch (Throwable t) {
                            always.println("WARNING: Unable to initialise keystore " + keystore + ": " + t.getMessage());
                        }
                    }
                    catch (FailException x) {
                        throw x;
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    try {
                        appElevation = root.getElementsByTagName("WindowsElevation").item(0).getTextContent();
                    }
                    catch (NullPointerException x) {
                        appElevation = "None";
                    }
                    appUiAccess = false;
                    try {
                        appUiAccess = root.getElementsByTagName("WindowsElevationUiAccess").item(0).getTextContent().trim().equalsIgnoreCase("true");
                    }
                    catch (Exception alias) {
                        // empty catch block
                    }
                    try {
                        installType = root.getElementsByTagName("InstallType").item(0).getTextContent();
                    }
                    catch (NullPointerException x) {
                        throw new FailException("Missing required InstallType tag");
                    }
                    if (installType.equalsIgnoreCase("AllUsers")) {
                        installType = "perm_all";
                    }
                    if (installType.equalsIgnoreCase("CurrentUser")) {
                        installType = "perm_user";
                    }
                    if (installType.equalsIgnoreCase("NoInstall")) {
                        installType = "temp_user";
                    }
                    splashPNG = PathUtil.makePathNative(splashPNG);
                    bundleLogoPNG = PathUtil.makePathNative(bundleLogoPNG);
                    if (buildWindows32Wrappers) {
                        windows32JRE = PathUtil.makePathNative(windows32JRE);
                    }
                    if (buildWindows64Wrappers) {
                        windows64JRE = PathUtil.makePathNative(windows64JRE);
                    }
                    if (buildLinux32Wrappers) {
                        linux32JRE = PathUtil.makePathNative(linux32JRE);
                    }
                    if (buildLinux64Wrappers) {
                        linux64JRE = PathUtil.makePathNative(linux64JRE);
                    }
                    if (buildLinuxARM32Wrappers) {
                        linux32ARMJRE = PathUtil.makePathNative(linux32ARMJRE);
                    }
                    if (buildMacOS64Wrappers) {
                        mac64JRE = PathUtil.makePathNative(mac64JRE);
                    }
                    supportedLanguages = "en";
                    try {
                        supportedLanguages = root.getElementsByTagName("SupportedLanguages").item(0).getTextContent();
                        supportedLanguages = supportedLanguages.trim();
                    }
                    catch (Exception keyPassword) {
                        // empty catch block
                    }
                    rsaKeys = null;
                    rsaDerEncodedPublicKey = "";
                    signingUpdates = false;
                    try {
                        byte[] keystoreRandom = new byte[1000];
                        Random r = new Random(3212347823824892224L);
                        r.nextBytes(keystoreRandom);
                        NodeList nodes = root.getElementsByTagName("DigitalSignatureKeys");
                        if (nodes.getLength() <= 0) break block640;
                        signingUpdates = true;
                        Element dsig = (Element)nodes.item(0);
                        String mayCreate = dsig.getAttribute("mayCreate");
                        if (mayCreate == null) {
                            mayCreate = "no";
                        }
                        File signatureKeysFile = new File(PathUtil.makePathNative(dsig.getTextContent()));
                        BCUtil bcu = new BCUtil();
                        if (signatureKeysFile.exists()) {
                            always.println("[Build] Loading digital signature keys... IMPORTANT, you must BACK UP your digital signature key file!");
                            rsaKeys = bcu.loadServerRsaKeys(signatureKeysFile, keystoreRandom);
                            break block640;
                        }
                        if (mayCreate.equalsIgnoreCase("yes")) {
                            always.println("[Build] Creating digital signature keys... IMPORTANT, you must BACK UP your digital signature key file!");
                            rsaKeys = bcu.generateRsaKeyPair();
                            bcu.saveServerRsaKeys(rsaKeys, signatureKeysFile, keystoreRandom);
                            break block640;
                        }
                        throw new Exception("Invalid DigitalSignatureKeys - file not found");
                    }
                    catch (Exception x) {
                        throw new Exception("Invalid DigitalSignatureKeys - file not found", x);
                    }
                }
                if (rsaKeys != null) {
                    always.println("[Build] DER Encoding public key");
                    rsaDerEncodedPublicKey = BCUtil.getHexOfDEREncodedRSAKey((RSAKeyParameters)rsaKeys.getPublic());
                }
                String failURL = "http://0.0.254.254/";
                haveUpdateURL = false;
                updateURL = failURL;
                try {
                    updateURL = root.getElementsByTagName("UpdateURL").item(0).getTextContent();
                    if (updateURL.trim().length() == 0) {
                        always.println("[Build] Empty UpdateURL, interpreting as no UpdateURL");
                        updateURL = failURL;
                    } else {
                        haveUpdateURL = true;
                        if (updateURL.endsWith("/")) {
                            updateURL = updateURL.substring(0, updateURL.length() - 1);
                        }
                    }
                }
                catch (Exception dsig) {
                    // empty catch block
                }
                if (alternateUpdateURL.length() > 0) {
                    always.println("[Build] Overriding UpdateURL to " + alternateUpdateURL);
                    haveUpdateURL = true;
                    updateURL = alternateUpdateURL;
                }
                dynamicUpdateURL = false;
                try {
                    dynamicUpdateURL = root.getElementsByTagName("DynamicUpdateURL").item(0).getTextContent().equalsIgnoreCase("true");
                    if (dynamicUpdateURL) {
                        haveUpdateURL = true;
                        updateURL = "D";
                    }
                }
                catch (Exception mayCreate) {
                    // empty catch block
                }
                matchClientVersionToServerVersion = false;
                try {
                    matchClientVersionToServerVersion = root.getElementsByTagName("MatchClientVersionToServerVersion").item(0).getTextContent().equalsIgnoreCase("true");
                }
                catch (Exception signatureKeysFile) {
                    // empty catch block
                }
                boolean allowOsxAppNap = false;
                try {
                    allowOsxAppNap = root.getElementsByTagName("AllowOsxAppNap").item(0).getTextContent().equalsIgnoreCase("true");
                }
                catch (Exception bcu) {
                    // empty catch block
                }
                mainClassOnUpdate = null;
                try {
                    mainClassOnUpdate = root.getElementsByTagName("MainClassOnUpdate").item(0).getTextContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mainClassVerifyJRE = null;
                try {
                    mainClassVerifyJRE = root.getElementsByTagName("MainClassVerifyJRE").item(0).getTextContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mainClassPostInstall = null;
                try {
                    mainClassPostInstall = root.getElementsByTagName("MainClassPostInstall").item(0).getTextContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mainClassPreUninstall = null;
                try {
                    mainClassPreUninstall = root.getElementsByTagName("MainClassPreUninstall").item(0).getTextContent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                splashMinMS = 850;
                try {
                    splashMinMS = Integer.parseInt(root.getElementsByTagName("SplashMinTimeMS").item(0).getTextContent().trim());
                }
                catch (NumberFormatException x) {
                    throw new Exception("Invalid SplashMinTimeMS");
                }
                catch (Exception x) {
                    // empty catch block
                }
                canOverrideSplash = false;
                try {
                    canOverrideSplash = Boolean.parseBoolean(root.getElementsByTagName("CanOverrideSplash").item(0).getTextContent().trim());
                }
                catch (NumberFormatException x) {
                    throw new Exception("Invalid CanOverrideSplash");
                }
                catch (Exception x) {
                    // empty catch block
                }
                pack200Effort = 9;
                try {
                    pack200Effort = Integer.parseInt(root.getElementsByTagName("Pack200Effort").item(0).getTextContent().trim());
                    if (pack200Effort < 0) {
                        pack200Effort = 0;
                    } else if (pack200Effort > 9) {
                        pack200Effort = 9;
                    }
                }
                catch (NumberFormatException x) {
                    throw new Exception("Invalid Pack200Effort");
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (!fullBuild) {
                    always.println("[Build] Disabling pack200 for dev build");
                    pack200Effort = 0;
                }
                int tgzCompression = 0;
                paramZeroUpdateUrl = false;
                ArrayList<String> stripExceptionList = new ArrayList<String>();
                try {
                    Element opts = (Element)root.getElementsByTagName("StripExceptions").item(0);
                    NodeList list = opts.getElementsByTagName("Filename");
                    for (int i = 0; i < list.getLength(); ++i) {
                        String tmp = list.item(i).getTextContent();
                        stripExceptionList.add(tmp.trim());
                    }
                }
                catch (Exception opts) {
                    // empty catch block
                }
                ArrayList<String> userLpNames = new ArrayList<String>();
                ArrayList<String> userLpValues = new ArrayList<String>();
                try {
                    NodeList list = root.getElementsByTagName("DynamicLaunchProperty");
                    for (int i = 0; i < list.getLength(); ++i) {
                        Element dynprop = (Element)list.item(i);
                        String name = dynprop.getElementsByTagName("Name").item(0).getTextContent();
                        String value = dynprop.getElementsByTagName("Value").item(0).getTextContent();
                        if (name == null) {
                            throw new Exception("name null");
                        }
                        if (value == null) {
                            throw new Exception("value null");
                        }
                        userLpNames.add(name);
                        userLpValues.add(value);
                    }
                }
                catch (Exception list) {
                    // empty catch block
                }
                filesToKeep = new String[stripExceptionList.size() + 3];
                stripExceptionList.toArray(filesToKeep);
                filesToKeep[stripExceptionList.size()] = "/sunjce_provider.jar";
                filesToKeep[stripExceptionList.size() + 1] = "/jce.jar";
                filesToKeep[stripExceptionList.size() + 2] = "/sunec.jar";
                ArrayList<String> pack200ExceptionList = new ArrayList<String>();
                try {
                    Element opts = (Element)root.getElementsByTagName("Pack200Exceptions").item(0);
                    NodeList list = opts.getElementsByTagName("Filename");
                    for (int i = 0; i < list.getLength(); ++i) {
                        String tmp = list.item(i).getTextContent();
                        pack200ExceptionList.add(tmp.trim());
                    }
                }
                catch (Exception opts) {
                    // empty catch block
                }
                filesNotToPack200 = new String[pack200ExceptionList.size() + 2];
                pack200ExceptionList.toArray(filesNotToPack200);
                filesNotToPack200[pack200ExceptionList.size()] = "/sunjce_provider.jar";
                filesNotToPack200[pack200ExceptionList.size() + 1] = "/jce.jar";
                silentInstallParameter = null;
                try {
                    silentInstallParameter = root.getElementsByTagName("SilentInstallSwitch").item(0).getTextContent();
                    if (silentInstallParameter != null && silentInstallParameter.length() == 0) {
                        silentInstallParameter = null;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                for (int i = 0; i < apps.size(); ++i) {
                    always.println("[App " + (i + 1) + " of " + apps.size() + "] " + apps.get(i));
                }
                always.println("[Config] Build Folder: " + build);
                if (dynamicUpdateURL) {
                    always.println("[Config] UpdateURL: (dynamic)");
                } else if (!updateURL.equals(failURL)) {
                    always.println("[Config] UpdateURL: " + updateURL);
                } else {
                    always.println("[Config] UpdateURL: (no update URL specified)");
                }
                if (matchClientVersionToServerVersion) {
                    always.println("[Config] Client launches will be matched to update server version");
                }
                if (mainClassOnUpdate != null) {
                    always.println("[Config] MainClass on update: " + mainClassOnUpdate);
                } else {
                    always.println("[Config] MainClass on update: (none specified)");
                }
                if (mainClassVerifyJRE != null) {
                    always.println("[Config] MainClass to verify JRE compatibility: " + mainClassVerifyJRE);
                } else {
                    always.println("[Config] MainClass to verify JRE compatibility: (none specified)");
                }
                if (mainClassPostInstall != null) {
                    always.println("[Config] MainClass to run post-install: " + mainClassPostInstall);
                } else {
                    always.println("[Config] MainClass to run post-install: (none specified)");
                }
                if (mainClassPreUninstall != null) {
                    always.println("[Config] MainClass to run pre-uninstall: " + mainClassPreUninstall);
                } else {
                    always.println("[Config] MainClass to run pre-uninstall: (none specified)");
                }
                always.println("[Config] Minimum splash image time: " + splashMinMS + "ms");
                always.println("[Config] Splash PNG: " + splashPNG);
                always.println("[Config] Can Override Splash: " + canOverrideSplash);
                always.println("[Config] Bundle Logo PNG: " + bundleLogoPNG);
                for (String jvmOption : jvmOptions) {
                    always.println("[Config] JVM Option: " + jvmOption);
                }
                for (String jvmOption : guJVMOptions) {
                    always.println("[Config] Updater JVM Option: " + guJVMOptions);
                }
                if (protecting && mustFork) {
                    always.println("[Config] Must Fork: " + mustFork + " (required by JWCrypt)");
                } else {
                    always.println("[Config] Must Fork: " + mustFork);
                }
                always.println("[Config] OSX TGZ Compression level: " + tgzCompression);
                always.println("[Config] OSX 'App Nap' Allowed: " + allowOsxAppNap);
                if (buildMacOS32Wrappers || buildMacOS64Wrappers) {
                    if (macCertInfo != null) {
                        always.println("[Config] Will sign MacOS app under Developer Alias: " + macSignID);
                    } else {
                        always.println("[Config] Will produce an UNSIGNED app for MacOS (note OS GateKeeper will block this on Mountain Lion (10.8) and later)");
                    }
                }
                if (buildWindows32Wrappers || buildWindows64Wrappers) {
                    if (winSignKeystore != null) {
                        if (winSignTimestampURL != null) {
                            always.println("[Config] Will sign Windows executables with timestamp (" + winSignTimestampURL + ")");
                        } else {
                            always.println("[Config] Will sign Windows executables without timestamp (note non-timestamped signed exe's will cease to be considered signed when the certificate runs out)");
                        }
                    } else {
                        always.println("[Config] Will produce an UNSIGNED app for Windows (note elevated apps will have a more severe warning and Antivirus programs may complain)");
                        if (appUiAccess) {
                            always.println("[Config] *** WARNING, elevation for Windows specifies that app needs uiAccess but Windows requires the app to be signed for uiAccess");
                        }
                    }
                }
                if (silentInstallParameter != null) {
                    always.println("[Config] Silent install parameter is set to " + silentInstallParameter);
                }
                for (String aFilesToKeep : filesToKeep) {
                    always.println("[Config] Strip exception - keeping file " + aFilesToKeep);
                }
                for (String aFilesNotToPack200 : filesNotToPack200) {
                    always.println("[Config] Pack200 exception - not packing file " + aFilesNotToPack200);
                }
                if (pack200Effort > 0) {
                    always.println("[Config] Pack200 Effort is " + pack200Effort + "/9");
                } else {
                    always.println("[Config] Pack200 is DISABLED");
                }
                dynamicProps = new Properties();
                if (updateURL != null) {
                    dynamicProps.setProperty("update_url", updateURL);
                }
                if (matchClientVersionToServerVersion) {
                    dynamicProps.setProperty("match_versions", "true");
                }
                if (AutoTesting) {
                    dynamicProps.setProperty("wrapper_autotest", "true");
                }
                dynamicProps.setProperty("supported_langs", supportedLanguages);
                dynamicProps.setProperty("wrapper_app_versions", "3");
                dynamicProps.setProperty("wrapper_gu_versions", "2");
                if (!allowOsxAppNap) {
                    dynamicProps.setProperty("auto_disable_appnap", "true");
                } else {
                    dynamicProps.setProperty("auto_disable_appnap", "false");
                }
                if (bundleNameModifier.length() > 0) {
                    dynamicProps.setProperty("service_use_fq_names", "true");
                }
                for (int i = 0; i < userLpNames.size(); ++i) {
                    String name = (String)userLpNames.get(i);
                    String value = (String)userLpValues.get(i);
                    always.println("[Config] Dynamic Launch Property: [" + name + "] = [" + value + "]");
                    dynamicProps.setProperty(name, value);
                }
                if (!deltaBuild) {
                    File[] files2;
                    for (File file : files2 = build.listFiles()) {
                        if (!file.getName().contains("JRE") && !file.getName().contains("JWAppNote")) {
                            always.println("[Config] Deleting build file " + file.getName());
                            FileUtil.deleteDir(file);
                            continue;
                        }
                        always.println("[Config] Leaving build file " + file.getName());
                    }
                } else {
                    always.println("[Config] Performing DELTA build");
                }
                build.mkdir();
                pubkeyFile = null;
                if (rsaKeys != null) {
                    pubkeyFile = new File(build, GenericUpdater.AUTHOR_PUBKEY_FILE);
                    String hex = BCUtil.getPublicKeyToHex(rsaKeys);
                    always.println("[Build] Storing author public key: " + hex);
                    always.println("[Build] Will sign all archives with corresponding private key");
                    FileUtil.writeFileAsString(pubkeyFile.getPath(), hex);
                }
                jwparams = new JWParameteriser();
                always.println("[App] Rescaling logos");
                File logoFile = new File(bundleLogoPNG);
                BufferedImage logo = ImageIO.read(logoFile);
                BufferedImage image = ImageHelper.toBufferedImageARGB(logo);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                bout.reset();
                ImageIO.write((RenderedImage)ImageHelper.scale(image, 16, 16), "PNG", bout);
                logo16 = bout.toByteArray();
                bout.reset();
                ImageIO.write((RenderedImage)ImageHelper.scale(image, 24, 24), "PNG", bout);
                logo24 = bout.toByteArray();
                bout.reset();
                ImageIO.write((RenderedImage)ImageHelper.scale(image, 32, 32), "PNG", bout);
                logo32 = bout.toByteArray();
                bout.reset();
                ImageIO.write((RenderedImage)ImageHelper.scale(image, 48, 48), "PNG", bout);
                logo48 = bout.toByteArray();
                bout.reset();
                ImageIO.write((RenderedImage)ImageHelper.scale(image, 256, 256), "PNG", bout);
                logo256 = bout.toByteArray();
                ArrayList<String> jreList = new ArrayList<String>();
                ArrayList<String> jreSourceList = new ArrayList<String>();
                if (buildWindows32Wrappers) {
                    jreList.add(GenericUpdater.JRE_WIN32_APP);
                    jreSourceList.add(windows32JRE);
                }
                if (buildWindows64Wrappers) {
                    jreList.add(GenericUpdater.JRE_WIN64_APP);
                    jreSourceList.add(windows64JRE);
                }
                if (buildLinux32Wrappers) {
                    jreList.add(GenericUpdater.JRE_LIN32_APP);
                    jreSourceList.add(linux32JRE);
                }
                if (buildLinux64Wrappers) {
                    jreList.add(GenericUpdater.JRE_LIN64_APP);
                    jreSourceList.add(linux64JRE);
                }
                if (Switches.JW_ARMBUILDS && buildLinuxARM32Wrappers) {
                    jreList.add(GenericUpdater.JRE_LINARM32_APP);
                    jreSourceList.add(linux32ARMJRE);
                }
                if (buildMacOS64Wrappers) {
                    jreList.add(GenericUpdater.JRE_MAC64_APP);
                    jreSourceList.add(mac64JRE);
                }
                String[] allJREs = jreList.toArray(new String[0]);
                String[] jreSource = jreSourceList.toArray(new String[0]);
                appStrippers = new FileStripper[]{new CVSStripper()};
                if (noStripJREs) {
                    always.println("[Config] Will not strip JRE (leaving optional files)");
                    jreStrippers = new FileStripper[]{new CVSStripper()};
                } else {
                    always.println("[Config] Will strip JRE");
                    jreStrippers = new FileStripper[]{new CVSStripper(), new JREStripper()};
                }
                always.println("[JRE] About to archive all JREs, **IMPORTANT** this can take a long time the first time, future builds will be much faster...");
                for (int i = 0; i < allJREs.length; ++i) {
                    String jreName = allJREs[i];
                    boolean isWindows = jreName.toUpperCase().startsWith("WIN");
                    always.println("[JRE] Archiving JRE " + jreName);
                    always.println("[JRE] Searching for latest JRE in " + build);
                    File latestJREArchive = LaunchFile.getLatestVersionOf(jreName, build);
                    while (latestJREArchive != null && latestJREArchive.getName().endsWith(".encoding")) {
                        always.println("[JRE] Deleting unfinished encode " + latestJREArchive.getName());
                        latestJREArchive.delete();
                        latestJREArchive = LaunchFile.getLatestVersionOf(jreName, build);
                    }
                    boolean skipJREArchive = false;
                    if (latestJREArchive != null) {
                        String jreVersion = LaunchFile.pickVersionFromAppArchive(latestJREArchive);
                        always.println("[JRE] Latest JRE version is " + jreVersion);
                        if (!isWindows) {
                            always.println("[JRE] Archived " + jreName + " (" + jreVersion + ") already exists so skipping");
                            skipJREArchive = true;
                        } else {
                            always.println("[JRE] Archived " + jreName + " (" + jreVersion + ") already exists. Checking for native launcher...");
                            File cache = new File("cache");
                            cache.mkdirs();
                            String key = Normaliser.normaliseShort(latestJREArchive.getCanonicalPath());
                            File check = new File(cache, key);
                            boolean launcherKnownOK = false;
                            if (Switches.JW_cacheJreLauncherVerification && check.exists()) {
                                launcherKnownOK = FileUtil.readFileAsStringUTF8(check).equals("true");
                                always.println("[JRE] Native launcher found in cache (launcherFound = " + launcherKnownOK + ")");
                            } else {
                                always.println("[JRE] Native launcher check not found in cache");
                            }
                            if (launcherKnownOK) {
                                skipJREArchive = true;
                            } else {
                                WindowsLauncherArchiveListener listener = new WindowsLauncherArchiveListener();
                                Archive.enumerateArchive(latestJREArchive, true, listener);
                                if (listener.found) {
                                    FileUtil.writeFileAsStringUTF8(check, "true");
                                    always.println("[JRE] Native launcher found in JRE archive so skipping");
                                    skipJREArchive = true;
                                } else {
                                    always.println("[JRE] Native launcher not found in JRE archive so rebuilding");
                                }
                            }
                        }
                    }
                    if (!skipJREArchive) {
                        File javaLauncherTarget;
                        File[] files3;
                        String newVersion;
                        block641: {
                            File jre2;
                            File up200;
                            newVersion = VersionUtil.padVersion(VersionUtil.getVersionForNow());
                            if (jreName.toUpperCase().startsWith("WIN")) {
                                isWindows = true;
                                File jre22 = new File(jreSource[i]);
                                if (!jre22.exists()) {
                                    throw new Exception("Windows JRE path '" + jre22 + "' does not exist, a valid Windows JRE must be specified");
                                }
                                up200 = new File(jre22, "bin" + File.separator + "unpack200.exe");
                                System.out.println("Checking for " + up200.getAbsolutePath());
                                if (!up200.exists()) {
                                    throw new Exception("unpack200.exe not found in Windows JRE bin path");
                                }
                            } else if (jreName.toUpperCase().startsWith("LIN")) {
                                jre2 = new File(jreSource[i]);
                                if (!jre2.exists()) {
                                    throw new Exception("Linux JRE path '" + jre2 + "' does not exist, a valid Linux JRE must be specified");
                                }
                                up200 = new File(jre2, "bin" + File.separator + "unpack200");
                                System.out.println("Checking for " + up200.getAbsolutePath());
                                if (!up200.exists()) {
                                    throw new Exception("unpack200 not found in Linux JRE bin path");
                                }
                            } else if (jreName.toUpperCase().startsWith("MAC") && jreName.equals(GenericUpdater.JRE_MAC64_APP)) {
                                jre2 = new File(jreSource[i]);
                                if (!jre2.exists()) {
                                    throw new Exception("Mac-64 JRE '" + jre2 + "' path does not exist, a valid Mac JRE must be specified");
                                }
                                File contents = new File(jre2, "Contents");
                                if (!contents.exists()) {
                                    throw new Exception("Mac-64 JRE path '" + jre2 + "' exists but JRE is wrong type, must be a Mac app style JRE with a Contents folder rather than lib and bin folder");
                                }
                            }
                            System.out.println("Unpack200 found OK");
                            jre2 = new File(jreSource[i]);
                            if (!jre2.exists()) {
                                JWrapperCompiler.fail("JRE " + jre2 + " does not exist");
                            }
                            if ((files3 = jre2.listFiles()) == null) {
                                JWrapperCompiler.fail("JRE " + jre2 + " does not exist or is empty");
                            }
                            javaLauncherTarget = null;
                            if (isWindows) {
                                File tmpFolder;
                                javaLauncherTarget = new File(build, "windowslauncher.exe");
                                if (javaLauncherTarget.exists()) {
                                    javaLauncherTarget.delete();
                                }
                                if ((tmpFolder = new File(build, "tmp")).exists()) {
                                    FileUtil.deleteDir(tmpFolder);
                                }
                                tmpFolder.mkdirs();
                                File temporaryLauncher = new File(tmpFolder, "windowslauncher.exe");
                                if (temporaryLauncher.exists()) {
                                    temporaryLauncher.delete();
                                }
                                File javaLauncherSource = jreSource[i].equals(windows32JRE) ? new File(WINDOWS_WRAPPERS_DIR, "windowslauncher.exe") : new File(WINDOWS_WRAPPERS_DIR, "windowslauncher_64.exe");
                                try {
                                    void var108_247;
                                    ExeReader.embedIcons((String)javaLauncherSource.getAbsolutePath(), (String)temporaryLauncher.getAbsolutePath(), (byte[])logo16, (byte[])logo24, (byte[])logo32, (byte[])logo48, (byte[])logo256);
                                    Object var108_245 = null;
                                    if (winSignKeystore == null) {
                                        byte[] byArray = jwparams.getParameterisedBlock(dynamicProps, 204800);
                                    }
                                    JWrapperCompiler.appendTailToWrapperOrLauncher(temporaryLauncher, (byte[])var108_247, bundleName, splashMinMS, canOverrideSplash, rsaDerEncodedPublicKey, installType, silentInstallParameter, updateURL);
                                    JWrapperCompiler.setVersionInfo(temporaryLauncher);
                                    if (winSignKeystore != null) {
                                        always.println("[App] Signing launcher exe '" + temporaryLauncher + "'...");
                                        int X = 0;
                                        while (true) {
                                            ++X;
                                            try {
                                                long start = System.currentTimeMillis();
                                                new AuthenticodeSigner(temporaryLauncher, javaLauncherTarget, bundleName, winSignTimestampURL, winSignKeystore).sign(jwparams.getParameterisedBlock(dynamicProps, 204800));
                                                totalSigningTime += System.currentTimeMillis() - start;
                                                always.println("Signed OK");
                                                break block641;
                                            }
                                            catch (IOException x) {
                                                if (X == 10) {
                                                    throw x;
                                                }
                                                always.println("[App] Problem with signing (could be timestamp URL issue, will try again in 3s)...");
                                                Thread.sleep(3000L);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    FileUtil.copy(temporaryLauncher, javaLauncherTarget);
                                }
                                finally {
                                    if (tmpFolder != null && tmpFolder.exists()) {
                                        FileUtil.deleteDir(tmpFolder);
                                    }
                                }
                            }
                        }
                        always.println("[JRE] New " + jreName + " version is " + newVersion);
                        File jreArchive = new File(build, GenericUpdater.getArchiveNameFor(jreName, newVersion));
                        File tempOut = new File(jreArchive.getAbsolutePath() + ".encoding");
                        Archive archive = new Archive(tempOut, filesToKeep, filesNotToPack200, pack200Effort);
                        for (File file1 : files3) {
                            if (!file1.getName().equalsIgnoreCase("bin")) continue;
                            archive.addFile(file1, file1.getName(), jreStrippers);
                        }
                        for (File file : files3) {
                            if (file.getName().equalsIgnoreCase("bin")) continue;
                            archive.addFile(file, file.getName(), jreStrippers);
                        }
                        if (javaLauncherTarget != null) {
                            archive.addFile(javaLauncherTarget, "bin" + File.separator + javaLauncherTarget.getName());
                        }
                        archive.finishAndCompress(fullBuild, rsaKeys, null);
                        VersionUtil.writeAppVersionFile(build, jreName, newVersion);
                        tempOut.renameTo(jreArchive);
                        if (javaLauncherTarget != null) {
                            javaLauncherTarget.delete();
                        }
                    }
                    always.println("[JRE] JRE " + jreName + " finished");
                }
                always.println("[Licensing] Checking JWrapper licensing");
                bundlelic = new File(build, "jwrapper_licensing");
                JWLicense devlic = null;
                try {
                    devlic = JWLicense.load((File)new File("jwlicense"));
                }
                catch (Exception isWindows) {
                    // empty catch block
                }
                try {
                    devlic = JWLicense.load((File)new File("jwlicense.txt"));
                }
                catch (Exception isWindows) {
                    // empty catch block
                }
                if (devlic != null && devlic.hasExpired()) {
                    devlic = null;
                }
                if (devlic != null) {
                    always.println("[Licensing] JWrapper License found, " + devlic.getName() + " / " + devlic.getCompany());
                    LIC_showTrialDialog = devlic.mustShowTrial();
                    LIC_allowRebranding = devlic.allowRebranding();
                    LIC_allowCobranding = devlic.allowCobranding();
                    LIC_allowJWCrypt = devlic.allowJWCrypt();
                    LIC_allowJWService = devlic.allowJWService();
                    LIC_allowSignatures = LIC_allowJWCrypt;
                } else {
                    always.println("[Licensing] No JWrapper license found");
                    LIC_showTrialDialog = false;
                    LIC_allowRebranding = false;
                    LIC_allowCobranding = false;
                    LIC_allowJWCrypt = false;
                    LIC_allowJWService = false;
                    LIC_allowSignatures = false;
                    JWrapperCompiler.fail("Running JWrapper builds requires a valid license.  Go to JWrapper.com to set up a trial and see pricing.");
                    System.exit(1);
                }
                if (LIC_allowJWService) {
                    always.println("[Licensing] JWService allowed");
                } else {
                    always.println("[Licensing] JWService not allowed");
                }
                if (LIC_allowJWCrypt) {
                    always.println("[Licensing] JWCrypt allowed");
                } else {
                    always.println("[Licensing] JWCrypt not allowed");
                    if (protecting) {
                        JWrapperCompiler.fail("One or more jars or resources were marked to be protected but your license does not allow JWCrypt");
                    }
                }
                if (LIC_allowSignatures) {
                    always.println("[Licensing] JW Signed Updates allowed");
                } else {
                    always.println("[Licensing] JW Signed Updates not allowed");
                    if (signingUpdates) {
                        JWrapperCompiler.fail("A digital signature keys file was specified for signed updates but your license does not allow JWSign Updates");
                    }
                }
                if (!LIC_showTrialDialog) {
                    StringBuilder licData = new StringBuilder();
                    for (int i = 0; i < 10; ++i) {
                        licData.append("[BUNDLE_NAME]").append(bundleName);
                    }
                    long t = System.currentTimeMillis();
                    RSAEncryptor rSAEncryptor = JWrapperCompiler.createRsaEncryptor();
                    byte[] licenseData = rSAEncryptor.encrypt(licData.toString().getBytes("UTF8"));
                    FileUtil.writeFile(bundlelic, licenseData);
                    t = System.currentTimeMillis() - t;
                    System.out.println("[Licensing] JWrapper Licensing took " + t + "ms to set up");
                    t = System.currentTimeMillis();
                    RSADecryptor rSADecryptor = JWrapperCompiler.createRsaDecryptor();
                    String check = new String(rSADecryptor.decrypt(licenseData), "UTF8");
                    t = System.currentTimeMillis() - t;
                    if (!check.equals(licData.toString())) {
                        throw new Exception("[Licensing] Licensing not working on this platform!");
                    }
                    System.out.println("[Licensing] JWrapper Licensing verified OK");
                }
                guversion = GenericUpdater.GetVersion();
                appversion = VersionUtil.padVersion(VersionUtil.getVersionForNow());
                if (forceAppVer.length() > 0) {
                    appversion = forceAppVer;
                    always.println("[Config] Forcing App Version to [" + appversion + "]");
                }
                buildver = new File(build, "jwBuildVersion");
                FileUtil.writeFileAsString(buildver, appversion);
                macversion = appversion;
                while (macversion.startsWith("0")) {
                    macversion = macversion.substring(1);
                }
                if (LIC_allowRebranding) {
                    if (useFreeSplash) {
                        LIC_allowRebranding = false;
                        LIC_allowCobranding = false;
                    }
                    if (useCoSplash) {
                        LIC_allowRebranding = false;
                        LIC_allowCobranding = true;
                    }
                } else if (LIC_allowCobranding && useFreeSplash) {
                    LIC_allowRebranding = false;
                    LIC_allowCobranding = false;
                }
                if (LIC_allowRebranding || LIC_allowCobranding) {
                    String string = splashPNG;
                } else {
                    File wrappers2 = new File("wrappers");
                    byte[] jwdat = JWSplash.SPLASH((File)wrappers2);
                    String string = new File(wrappers2, "jwplainsplash600w.png").getAbsolutePath();
                    FileUtil.writeFile(string, jwdat);
                }
                if (!LIC_allowRebranding) {
                    File wrappers3 = new File("wrappers");
                    if (LIC_allowCobranding) {
                        always.println("[Licensing] Cobranding allowed, rebuilding splash using JWrapper splash and logo");
                    } else {
                        always.println("[Licensing] Rebranding not allowed, rebuilding splash using JWrapper splash and logo");
                    }
                    boolean midSplash = LIC_allowCobranding;
                    BufferedImage result = JWrapperCompiler.createSplashImage(wrappers3, splashPNG, midSplash);
                    splashPNG = new File(wrappers3, "jwbigsplash600w.png").getAbsolutePath();
                    ImageIO.write((RenderedImage)result, "PNG", new File(splashPNG));
                    if (testSplash) {
                        RunCommandGetOutput.runCommandGetOutput("open " + splashPNG);
                        System.exit(0);
                    }
                } else {
                    always.println("[Licensing] Rebranding allowed, using App splash");
                }
                bundleSplash = new File(build, GenericUpdater.getSplashFileNameFor(bundleName));
                File splashPngFile = new File(splashPNG);
                if (!splashPngFile.exists()) {
                    always.println("WARNING: The specified splash image does not exist (" + splashPngFile + ")");
                }
                ImageIO.write((RenderedImage)ImageIO.read(splashPngFile), "PNG", bundleSplash);
                appOsxBG = new File(build, "osxbg.png");
                BufferedImage msplash = ImageHelper.scaleDownToFitInside(ImageIO.read(new File((String)var108_255)), 600, 350);
                int width = msplash.getWidth();
                osxBgHeight = msplash.getHeight();
                System.out.println("OS BG Height is " + osxBgHeight);
                int diff = (600 - width) / 2;
                if (diff > 0) {
                    msplash = ImageHelper.addBorder(msplash, Color.white, new Insets(0, diff, 0, diff));
                }
                ImageIO.write((RenderedImage)msplash, "PNG", appOsxBG);
                wrappers = new File("wrappers");
                appUninstallerICO = new File(build, GenericUpdater.getUninstallerIcopngFileNameFor(bundleName));
                File png = new File(wrappers, "uninstaller.png");
                ICOWriter.ImageList list = new ICOWriter.ImageList();
                list.image16 = png;
                list.image24 = png;
                list.image32 = png;
                list.image48 = png;
                list.image256 = png;
                File outico = new File(build, "out.ico");
                int[] pngInfo = ICOWriter.writeIcoFile((File)outico, (ICOWriter.ImageList)list);
                byte[] ICO = FileUtil.readFile(outico.getAbsolutePath());
                File[] icopng = new IcoPng(ICO, pngInfo[0], pngInfo[1]);
                outico.delete();
                icopng.save(appUninstallerICO);
                appICNS = new File(build, GenericUpdater.getIcnsFileNameFor(bundleName));
                ICNSWriter.ImageList imageList = new ICNSWriter.ImageList();
                File logoFile2 = new File(bundleLogoPNG);
                BufferedImage logo2 = ImageIO.read(logoFile2);
                int logoMax = Math.max(((Image)logo2).getWidth(null), ((Image)logo2).getHeight(null));
                if (logoMax >= 1024) {
                    imageList.image1024 = logoFile2;
                } else if (logoMax >= 512) {
                    imageList.image512 = logoFile2;
                } else if (logoMax >= 256) {
                    imageList.image256 = logoFile2;
                } else if (logoMax >= 128) {
                    imageList.image128 = logoFile2;
                } else if (logoMax >= 48) {
                    imageList.image48 = logoFile2;
                } else if (logoMax >= 32) {
                    imageList.image32 = logoFile2;
                    imageList.image16 = logoFile2;
                }
                ICNSWriter.writeIcnsFile((File)appICNS, (ICNSWriter.ImageList)imageList);
                always.println("[JWrapper] Building JWrapper " + guversion);
                if (simulateBrokenGU) {
                    guversion = VersionUtil.padVersion(VersionUtil.getVersionForNow());
                    System.out.println("Simulating broken GU with new version: " + guversion);
                } else if (AutoTesting) {
                    guversion = VersionUtil.padVersion(VersionUtil.getVersionForNow());
                    System.out.println("Autotesting, so using brand new version for GU with every run: " + guversion);
                }
                LaunchableArchive jwarchive = new LaunchableArchive(simulateBrokenGU ? "jwrapper.BROKEN.GenericUpdaterLaunch" : "jwrapper.updater.GenericUpdaterLaunch", null, "jwrapper.updater.GenericUpdaterJreVerifierLaunch", null, null, bundleName, null, true, new File(build, GenericUpdater.getArchiveNameFor("JWrapper", guversion)), filesToKeep, filesNotToPack200, pack200Effort);
                jwarchive.addJvmOption(LaunchFile.JWRAPPER_JVM_OPTION);
                for (String updaterJVMOption : guJVMOptions) {
                    jwarchive.addJvmOption(updaterJVMOption);
                }
                jwarchive.setPack200Allowed(false);
                jwarchive.addFile(false, buildver, buildver.getName());
                jwarchive.addFile(true, "jwrapperlib/jwstandalonelaunch.jar");
                jwarchive.addFile(false, "jwrapperlib/jwstandalone.jar");
                if (!Switches.SH_1547_jwGuNotUseSevenzip) {
                    jwarchive.addFile(false, "jwrapperlib/sevenzip.jar");
                }
                jwarchive.addFile(false, bundleSplash, bundleSplash.getName());
                jwarchive.addFile(false, appICNS, appICNS.getName());
                jwarchive.addFile(false, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), "jwutils_win32.dll");
                jwarchive.addFile(false, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), "jwutils_win64.dll");
                jwarchive.addFile(false, new File(LINUX_WRAPPERS_DIR, "libjwutils_linux32.so"), "libjwutils_linux32.so");
                jwarchive.addFile(false, new File(LINUX_WRAPPERS_DIR, "libjwutils_linux64.so"), "libjwutils_linux64.so");
                if (Switches.JW_ARMBUILDS) {
                    jwarchive.addFile(false, new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux32arm.so"), "libjwutils_linux32arm.so");
                    if (Switches.JW_arm64) {
                        jwarchive.addFile(false, new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux64arm.so"), "libjwutils_linux64arm.so");
                    }
                }
                jwarchive.addFile(false, new File(OSX_WRAPPERS_DIR, "libjwutils_macos32.jnilib"), "libjwutils_macos32.jnilib");
                jwarchive.addFile(false, new File(OSX_WRAPPERS_DIR, "libjwutils_macos64.jnilib"), "libjwutils_macos64.jnilib");
                File tmp = File.createTempFile("simpleservice", "ver");
                try {
                    FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "SimpleService.exe"), tmp);
                    JWrapperCompiler.setVersionInfo(tmp);
                    jwarchive.addFile(false, tmp, "SimpleService.exe");
                }
                finally {
                    tmp.delete();
                }
                if (pubkeyFile != null) {
                    always.println("[Build] Storing author public key into JW GU archive");
                    jwarchive.addFile(false, pubkeyFile, GenericUpdater.AUTHOR_PUBKEY_FILE);
                }
                jwarchive.finishAndCompress(fullBuild, rsaKeys);
                VersionUtil.writeAppVersionFile(build, "JWrapper", guversion);
                always.println("[JWrapper] JWrapper " + guversion + " finished");
                always.println("[App] Building launchers");
                carps = new CompilerArchives(bundleName, appversion, pack200Effort, build);
                int BITS = 32;
                always.println("[App] Building Windows " + BITS + " bit launcher...");
                File sourceLauncher = JWrapperCompiler.getWindowsWrapperFor(appElevation, appUiAccess, BITS == 64);
                sourceLauncherWithIcon = new File(build, bundleName + "Launcher_icon.exe");
                ExeReader.embedIcons((String)sourceLauncher.getAbsolutePath(), (String)sourceLauncherWithIcon.getAbsolutePath(), (byte[])logo16, (byte[])logo24, (byte[])logo32, (byte[])logo48, (byte[])logo256);
                for (File sourceToAppendTailTo : new File[]{sourceLauncherWithIcon}) {
                    byte[] paramBlock = null;
                    if (winSignKeystore == null) {
                        paramBlock = jwparams.getParameterisedBlock(dynamicProps, 204800);
                    }
                    JWrapperCompiler.appendTailToWrapperOrLauncher(sourceToAppendTailTo, paramBlock, bundleName, splashMinMS, canOverrideSplash, rsaDerEncodedPublicKey, installType, silentInstallParameter, updateURL);
                }
                if (BITS == 32) {
                    dynamicProps.setProperty("jre_name", "Windows32JRE");
                } else {
                    dynamicProps.setProperty("jre_name", "Windows64JRE");
                }
                finalLauncher = new File(build, GenericUpdater.getLauncherNameFor(bundleName, false, BITS == 64, false, false));
                JWrapperCompiler.setVersionInfo(sourceLauncherWithIcon);
                if (winSignKeystore != null) {
                    always.println("[App] Signing launcher exe '" + finalLauncher + "'...");
                    int X = 0;
                    while (true) {
                        ++X;
                        try {
                            long start = System.currentTimeMillis();
                            new AuthenticodeSigner(sourceLauncherWithIcon, finalLauncher, bundleName, winSignTimestampURL, winSignKeystore).sign(jwparams.getParameterisedBlock(dynamicProps, 204800));
                            totalSigningTime += System.currentTimeMillis() - start;
                            always.println("Signed OK");
                            break block643;
                        }
                        catch (IOException x) {
                            if (X == 10) {
                                throw x;
                            }
                            always.println("[App] Problem with signing (could be timestamp URL issue, will try again in 3s)...");
                            Thread.sleep(3000L);
                            continue;
                        }
                        break;
                    }
                }
                FileUtil.copy(sourceLauncherWithIcon, finalLauncher);
            }
            sourceLauncherWithIcon.delete();
            always.println("[App-DEBUG] Created launcher " + finalLauncher + " size=" + finalLauncher.length());
            carps.addLauncherFileTo(CompilerArchives.cross_platform, finalLauncher);
            carps.addLauncherFileTo(CompilerArchives.windows, finalLauncher);
            always.println("[App] Windows launcher finished");
            ArrayList<BuildConfig> linuxBuilds = new ArrayList<BuildConfig>();
            linuxBuilds.add(new BuildConfig(32, "linux32", buildLinux32Wrappers, GenericUpdater.JRE_LIN32_APP, "linuxwrapper32", "lzma32", LINUX_WRAPPERS_DIR));
            linuxBuilds.add(new BuildConfig(64, "linux64", buildLinux64Wrappers, GenericUpdater.JRE_LIN64_APP, "linuxwrapper64", "lzma64", LINUX_WRAPPERS_DIR));
            if (Switches.JW_ARMBUILDS) {
                linuxBuilds.add(new BuildConfig(32, "linux32arm", buildLinuxARM32Wrappers, GenericUpdater.JRE_LINARM32_APP, "linuxwrapper32arm", "lzma32arm", LINUX_ARM_WRAPPERS_DIR));
            }
            for (BuildConfig config : linuxBuilds) {
                always.println("[App] Building Linux " + config.bits + " bit launcher... - " + config.description);
                File linLauncher = config.getWrapperFile(false);
                File applauncher = new File(build, GenericUpdater.getLauncherNameFor(bundleName, true, config.bits == 64, false, config.isARM()));
                FileUtil.copy(linLauncher, applauncher);
                BufferedOutputStream lout = new BufferedOutputStream(new FileOutputStream(applauncher, true));
                dynamicProps.setProperty("jre_name", config.jreApp);
                ((OutputStream)lout).write(jwparams.getParameterisedBlock(dynamicProps, 204800));
                ((OutputStream)lout).write(marker);
                CFriendlyStreamUtils.writeString(lout, bundleName);
                CFriendlyStreamUtils.writeString(lout, "");
                CFriendlyStreamUtils.writeString(lout, "");
                CFriendlyStreamUtils.writeString(lout, "");
                CFriendlyStreamUtils.writeString(lout, "" + splashMinMS);
                CFriendlyStreamUtils.writeString(lout, rsaDerEncodedPublicKey);
                if (canOverrideSplash) {
                    CFriendlyStreamUtils.writeString(lout, "1");
                } else {
                    CFriendlyStreamUtils.writeString(lout, "0");
                }
                CFriendlyStreamUtils.writeString(lout, installType);
                if (silentInstallParameter != null) {
                    CFriendlyStreamUtils.writeString(lout, silentInstallParameter);
                } else {
                    CFriendlyStreamUtils.writeString(lout, "");
                }
                CFriendlyStreamUtils.writeString(lout, "" + JWrapperCompiler.getRequiredJavaVersion());
                CFriendlyStreamUtils.writeString(lout, updateURL);
                ((OutputStream)lout).close();
                if (config.description.contains("arm")) {
                    carps.addLauncherFileTo(CompilerArchives.arm, applauncher);
                    if (Switches.JW_includeArmInCrossPlatform) {
                        carps.addLauncherFileTo(CompilerArchives.cross_platform, applauncher);
                    }
                } else {
                    if (config.bits == 32) {
                        carps.addLauncherFileTo(CompilerArchives.lin32, applauncher);
                    } else {
                        carps.addLauncherFileTo(CompilerArchives.lin64, applauncher);
                    }
                    carps.addLauncherFileTo(CompilerArchives.cross_platform, applauncher);
                }
                always.println("[App] Linux launcher finished");
            }
            always.println("[App] Building MacOS Native launcher [64bit]...");
            File linLauncher = macCertInfo != null ? new File(OSX_WRAPPERS_DIR, "osxwrapper64") : new File(OSX_WRAPPERS_DIR, "osxwrapper64_unsigned");
            File applauncher = new File(build, "osxwrapper64");
            FileUtil.copy(linLauncher, applauncher);
            File osxLauncher64 = macCertInfo != null ? new File(OSX_WRAPPERS_DIR, "osxlauncher64") : new File(OSX_WRAPPERS_DIR, "osxlauncher64_unsigned");
            File targetLauncher64 = new File(build, "osxlauncher64");
            FileUtil.copy(osxLauncher64, targetLauncher64);
            File dotApp = new File(build, GenericUpdater.getLauncherNameFor(bundleName, false, true, true, false));
            FileUtil.deleteDir(dotApp);
            FileUtil.copyFileOrDir(new File(wrappers, "Blank64.app"), dotApp);
            FileUtil.removeCVS(dotApp);
            File contents = new File(dotApp, "Contents");
            File resources = new File(contents, "Resources");
            File macos = new File(contents, "MacOS");
            macos.mkdirs();
            resources.mkdirs();
            BufferedOutputStream fout2 = new BufferedOutputStream(new FileOutputStream(new File(resources, "Tail")));
            CFriendlyStreamUtils.writeString(fout2, bundleName);
            CFriendlyStreamUtils.writeString(fout2, "");
            CFriendlyStreamUtils.writeString(fout2, "");
            CFriendlyStreamUtils.writeString(fout2, "");
            CFriendlyStreamUtils.writeString(fout2, "" + splashMinMS);
            CFriendlyStreamUtils.writeString(fout2, rsaDerEncodedPublicKey);
            if (canOverrideSplash) {
                CFriendlyStreamUtils.writeString(fout2, "1");
            } else {
                CFriendlyStreamUtils.writeString(fout2, "0");
            }
            CFriendlyStreamUtils.writeString(fout2, installType);
            if (silentInstallParameter != null) {
                CFriendlyStreamUtils.writeString(fout2, silentInstallParameter);
            } else {
                CFriendlyStreamUtils.writeString(fout2, "");
            }
            CFriendlyStreamUtils.writeString(fout2, "" + JWrapperCompiler.getRequiredJavaVersion());
            CFriendlyStreamUtils.writeString(fout2, updateURL);
            fout2.close();
            File appWrapper = new File(macos, "osxwrapper");
            FileUtil.copyFileOrDir(applauncher, appWrapper);
            File appLauncher = new File(macos, "osxlauncher");
            FileUtil.copyFileOrDir(targetLauncher64, appLauncher);
            File appParams = JWMacOS.getParameterisationFile(dotApp);
            appParams.mkdirs();
            appParams.delete();
            FileOutputStream apout = new FileOutputStream(appParams);
            apout.write(jwparams.getParameterisedBlock(dynamicProps, 204800));
            apout.close();
            File icns = new File(resources, OSXWrapper.getICNSFileName());
            FileUtil.copyFileOrDir(appICNS, icns);
            File splash = new File(resources, OSXWrapper.getAppSplashName());
            FileUtil.copyFileOrDir(bundleSplash, splash);
            File osxWrapperElevate = new File(resources, "elev_mac");
            FileUtil.copyFileOrDir(new File(OSX_WRAPPERS_DIR, "elev_mac"), osxWrapperElevate);
            File file = new File(contents, "Info.plist");
            String plist = FileUtil.readFileAsString(file.getAbsolutePath());
            plist = plist.replace("OSX_JW_BUNDLE_NAME", bundleName);
            plist = plist.replace("OSX_JW_BUNDLE_ID", JWConstants.buildOsxDomainFromBundle(bundleName));
            plist = plist.replace("OSX_JW_BUNDLE_VERSION", macversion);
            FileUtil.writeFile(file, plist.getBytes("UTF8"));
            if (macCertInfo != null) {
                always.println("[MacOS] Signing OSX App");
                long start = System.currentTimeMillis();
                MacSigner.signApp((CertificateInfo)macCertInfo, (File)dotApp, (String[])new String[]{"osxwrapper", "osxlauncher"}, (String)"osxwrapper");
                totalSigningTime += System.currentTimeMillis() - start;
                FileUtil.deleteDir(new File(macos, "osxwrapper.backup"));
                FileUtil.deleteDir(new File(macos, "osxlauncher.backup"));
            }
            applauncher.delete();
            if (targetLauncher64 != null) {
                targetLauncher64.delete();
            }
            carps.addLauncherFileTo(CompilerArchives.cross_platform, dotApp);
            carps.addLauncherFileTo(CompilerArchives.mac64, dotApp);
            always.println("[App] MacOS launcher finished [64bit]");
            always.println("[App] Building MacOS Java launcher [32bit]...");
            Properties jwp = new Properties();
            jwp.setProperty("app_name", bundleName);
            jwp.setProperty("wrapper_gu_version", "");
            jwp.setProperty("min_splash_ms", "" + splashMinMS);
            if (canOverrideSplash) {
                jwp.setProperty("can_override_splash", "1");
            } else {
                jwp.setProperty("can_override_splash", "0");
            }
            jwp.setProperty("install_type", installType);
            if (silentInstallParameter != null) {
                jwp.setProperty("silent_parameter", silentInstallParameter);
            }
            jwp.setProperty("java_version", "" + JWrapperCompiler.getRequiredJavaVersion());
            File jwprops = new File(build, "jwrapper_properties");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jwprops));
            jwp.store(out, "");
            ((OutputStream)out).close();
            if (pubkeyFile != null) {
                always.println("[App] Adding author pubkey to macos-java archive");
                files = new File[]{jwprops, pubkeyFile};
            } else {
                files = new File[]{jwprops};
            }
            FileUtil.deleteDir(new File(build, "osxwrapper.jar"));
            JWrapperCompiler.addFilesToExistingZip(new File(OSX_WRAPPERS_DIR, "osxwrapper.jar"), new File(build, "osxwrapper.jar"), files);
            File dotApp2 = new File(build, GenericUpdater.getLauncherNameFor(bundleName, false, false, true, false));
            FileUtil.deleteDir(dotApp2);
            FileUtil.copyFileOrDir(new File(wrappers, "Blank.app"), dotApp2);
            if (macCertInfo == null) {
                FileUtil.copy(new File(OSX_WRAPPERS_DIR, "JavaApplicationStub_unsigned"), new File(dotApp2, "Contents" + File.separator + "MacOS" + File.separator + "JavaApplicationStub"));
            }
            FileUtil.removeCVS(dotApp2);
            dynamicProps.setProperty("jre_name", "-");
            File appParams2 = JWMacOS.getParameterisationFile(dotApp2);
            appParams2.mkdirs();
            appParams2.delete();
            FileOutputStream apout2 = new FileOutputStream(appParams2);
            apout2.write(jwparams.getParameterisedBlock(dynamicProps, 204800));
            apout2.close();
            File icns2 = new File(dotApp2, "Contents" + File.separator + "Resources" + File.separator + OSXWrapper.getICNSFileName());
            FileUtil.copyFileOrDir(appICNS, icns2);
            File splash2 = new File(dotApp2, "Contents" + File.separator + "Resources" + File.separator + OSXWrapper.getAppSplashName());
            FileUtil.copyFileOrDir(bundleSplash, splash2);
            File plistFile2 = new File(dotApp2, "Contents" + File.separator + "Info.plist");
            String plist2 = FileUtil.readFileAsString(plistFile2.getAbsolutePath());
            String result = plist2.replace("OSX_JW_ARGUMENT_0_HERE", updateURL);
            result = result.replace("OSX_JW_BUNDLE_NAME", bundleName);
            result = result.replace("OSX_JW_BUNDLE_ID", "jwrapper.osx." + JWrapperCompiler.normaliseID(bundleName));
            result = result.replace("OSX_JW_BUNDLE_VERSION", macversion);
            FileUtil.writeFile(plistFile2, result.getBytes("UTF8"));
            File javadir = new File(dotApp2, "Contents" + File.separator + "Resources" + File.separator + "Java");
            javadir.mkdirs();
            FileUtil.copyFileOrDir(new File(build, "osxwrapper.jar"), new File(javadir, "osxwrapper.jar"));
            if (!Switches.SH_1547_jwGuNotUseSevenzip) {
                FileUtil.copyFileOrDir(new File("jwrapperlib", "sevenzip.jar"), new File(javadir, "sevenzip.jar"));
            }
            FileUtil.deleteDir(new File(build, "osxwrapper.jar"));
            FileUtil.deleteDir(new File(build, "jwrapper_properties"));
            if (macCertInfo != null) {
                always.println("[App] Signing OSX Launcher App " + dotApp2.getPath());
                long l = System.currentTimeMillis();
                MacSigner.signApp((CertificateInfo)macCertInfo, (File)new File(build, GenericUpdater.getLauncherNameFor(bundleName, false, false, true, false)));
                totalSigningTime += System.currentTimeMillis() - l;
                FileUtil.deleteDir(new File(dotApp2, "Contents" + File.separator + "MacOS" + File.separator + "JavaApplicationStub.backup"));
            }
            carps.addLauncherFileTo(CompilerArchives.cross_platform, dotApp2);
            carps.addLauncherFileTo(CompilerArchives.mac32, dotApp2);
            always.println("[App] OSX launcher finished");
            File appArchiveFile = deltaBuild ? new File(build, GenericUpdater.getArchiveNameFor(GenericUpdater.DELTA_NAME, appversion)) : new File(build, GenericUpdater.getArchiveNameFor(bundleName, appversion));
            always.println("[App] Building App archive " + bundleName + " " + appversion);
            LaunchableArchive apparchive = new LaunchableArchive(JWrapper.class.getName(), mainClassOnUpdate, mainClassVerifyJRE, mainClassPostInstall, mainClassPreUninstall, bundleName, appICNS.getName(), paramZeroUpdateUrl, appArchiveFile, filesToKeep, filesNotToPack200, pack200Effort);
            if (fullBuild) {
                apparchive.setPack200Allowed(true);
            } else {
                apparchive.setPack200Allowed(false);
            }
            if (mustFork) {
                apparchive.setMustFork(true);
            }
            if (jvmOptions != null) {
                for (String jvmOption : jvmOptions) {
                    apparchive.addJvmOption(jvmOption);
                }
            }
            always.println("[App] Adding Linux elevation to archive...");
            NodeList list = root.getElementsByTagName("File");
            boolean someProtected = false;
            boolean someClasspath = false;
            HashMap<String, ArrayList<AppFile>> auxArchives = new HashMap<String, ArrayList<AppFile>>();
            ArrayList<AppFile> flist = new ArrayList<AppFile>();
            ArrayList<AppFile> tomerge = new ArrayList<AppFile>();
            for (int i = 0; i < list.getLength(); ++i) {
                boolean bl;
                Element el = (Element)list.item(i);
                File file2 = new File(el.getTextContent());
                if (!file2.exists()) {
                    JWrapperCompiler.fail("Unable to find file included file: " + file2);
                }
                AppFile af = new AppFile();
                af.file = file2;
                boolean aux = false;
                if (Switches.JW_auxArchives && el.hasAttribute("aux")) {
                    ArrayList<AppFile> archive;
                    aux = true;
                    String string = el.getAttribute("aux");
                    if (string.contains(".") || string.contains(" ") || string.contains(",") || string.contains("-")) {
                        JWrapperCompiler.fail("Auxilury archive names should contain only letters and numbers, no other characters");
                    }
                    if ((archive = (ArrayList<AppFile>)auxArchives.get(string)) == null) {
                        archive = new ArrayList<AppFile>();
                        auxArchives.put(string, archive);
                        System.out.println("[App] Creating auxilury archive: " + string);
                    }
                    archive.add(af);
                }
                af.path = file2.getName();
                if (el.hasAttribute("path")) {
                    af.path = el.getAttribute("path");
                }
                af.cpath = false;
                if (el.hasAttribute("classpath") && !el.getAttribute("classpath").equals("no")) {
                    af.cpath = true;
                    if (aux) {
                        JWrapperCompiler.fail("Auxiliary archive files cannot be part of the classpath");
                    }
                    if (file2.isDirectory()) {
                        throw new Exception("Folder " + af.path + " cannot be part of classpath!");
                    }
                }
                af.protect = false;
                if (el.hasAttribute("protected") && (el.getAttribute("protected").equalsIgnoreCase("true") || el.getAttribute("protected").equalsIgnoreCase("yes"))) {
                    af.protect = true;
                    if (aux) {
                        JWrapperCompiler.fail("Auxiliary archive files cannot be protected with JWCrypt");
                    }
                }
                boolean bl2 = false;
                if (el.hasAttribute("merge") && (el.getAttribute("merge").equalsIgnoreCase("true") || el.getAttribute("merge").equalsIgnoreCase("yes"))) {
                    bl = true;
                    if (aux) {
                        JWrapperCompiler.fail("Auxilury archive files cannot be merged");
                    }
                    if (el.hasAttribute("path")) {
                        throw new Exception("Folder " + af.path + " cannot have a specific path if it is to be merged");
                    }
                    if (af.cpath) {
                        someClasspath = true;
                    }
                    if (af.protect) {
                        someProtected = true;
                    }
                }
                if (aux) continue;
                if (bl) {
                    tomerge.add(af);
                    always.println("[App] Will merge file before adding to archive... (" + file2 + ") (=" + af.path + ") (classpath=" + af.cpath + ") (dir=" + file2.isDirectory() + ") (protect=" + af.protect + ")");
                    continue;
                }
                flist.add(af);
                always.println("[App] Will add file to archive... (" + file2 + ") (=" + af.path + ") (classpath=" + af.cpath + ") (dir=" + file2.isDirectory() + ") (protect=" + af.protect + ")");
            }
            ArrayList<String> auxnames = new ArrayList<String>();
            ArrayList<Archive> auxiliaries = new ArrayList<Archive>();
            for (String auxname : auxArchives.keySet()) {
                always.println("[App] Building aux archive " + auxname);
                File auxfile = new File(build, GenericUpdater.getArchiveNameFor(GenericUpdater.getNameForAuxiliary(bundleName, auxname), appversion));
                Archive archive = new Archive(auxfile, new String[0], new String[0], pack200Effort);
                VersionUtil.writeAppVersionFile(build, GenericUpdater.getVersionFileNameFor(GenericUpdater.getNameForAuxiliary(bundleName, auxname)), appversion);
                ArrayList files4 = (ArrayList)auxArchives.get(auxname);
                for (AppFile af : files4) {
                    archive.addFile(af.file, af.path);
                }
                auxnames.add(auxname);
                auxiliaries.add(archive);
            }
            if (tomerge.size() > 0) {
                File merged = new File(build, "jwmerged.jar");
                File[] srcs = new File[tomerge.size()];
                for (int i = 0; i < tomerge.size(); ++i) {
                    AppFile appFile = (AppFile)tomerge.get(i);
                    srcs[i] = appFile.file;
                }
                always.println("[App] Building merged JAR...");
                ZipUtils.mergeZips(srcs, merged, true);
                AppFile af = new AppFile();
                af.file = merged;
                af.path = "jwmerged.jar";
                af.protect = someProtected;
                af.cpath = someClasspath;
                always.println("[App] Merged targeted JARs (" + af.file + ") (=" + af.path + ") (classpath=" + af.cpath + ") (bytes=" + af.file.length() + ") (protect=" + af.protect + ")");
                flist.add(af);
            }
            CryptBuilder jprot = crypt = new CryptBuilder();
            for (AppFile appFile : flist) {
                always.println("[App] Adding file to archive... (" + appFile.file + ") (=" + appFile.path + ") (classpath=" + appFile.cpath + ") (dir=" + appFile.file.isDirectory() + ") (protect=" + appFile.protect + ")");
                if (appFile.path.contains("jwrapper_license")) {
                    throw new Exception("Files containing 'jwrapper_license' are not allowed");
                }
                if (appFile.protect) {
                    always.println("[JWCrypt] Including " + appFile.file.getName() + " in protected files and folders");
                    apparchive.addFile(appFile.cpath, appFile.file, appFile.path, (JarProtector)jprot);
                    continue;
                }
                apparchive.addFile(appFile.cpath, appFile.file, appFile.path);
            }
            if (protecting) {
                always.println("[JWCrypt] Building protection for app");
                File cryptJar = new File(build, "jwcrypt.jar");
                File file3 = new File(build, "crypt");
                crypt.doFinal(15, cryptJar, file3);
                apparchive.addFile(true, cryptJar, "jwcrypt.jar");
                if (!CryptBuilder.DEBUG_SOURCE_FILES) {
                    FileUtil.deleteDir(file3);
                }
                cryptJar.delete();
                always.println("[JWCrypt] Protection complete (" + cryptJar.length() / 1024L + "k)");
            }
            always.println("[App] Adding supplementary files to archive...");
            for (JWApp jWApp : apps) {
                File appfile = jWApp.save(build);
                deleteme.add(appfile);
                apparchive.addFile(false, appfile, appfile.getName());
            }
            apparchive.addFile(false, bundleSplash, bundleSplash.getName());
            apparchive.addFile(false, appICNS, appICNS.getName());
            apparchive.addFile(false, appUninstallerICO, appUninstallerICO.getName());
            if (!Switches.JW_auxArchives) {
                ArrayList launchersAll = carps.getFileListFor(CompilerArchives.cross_platform);
                for (File f : launchersAll) {
                    apparchive.addFile(false, f, f.getName());
                }
            }
            File jwutilsSrc = new File("jwrapperlib" + File.separator + "jwrapper_utils.jar");
            if (!LIC_allowJWService) {
                always.println("[App] JWService not allowed");
                LicenseZFilter licenseZFilter = new LicenseZFilter(always);
                licenseZFilter.allowJWService = LIC_allowJWService;
                File jwutilsTarget = new File(build, "jwutilstmp.jar");
                ZipUtils.repackZip(jwutilsSrc, jwutilsTarget, -1, (ZFilter)licenseZFilter);
                apparchive.addFile(true, jwutilsTarget, "jwrapper_utils.jar");
                jwutilsTarget.delete();
            } else {
                always.println("[App] JWService allowed");
                apparchive.addFile(true, jwutilsSrc, "jwrapper_utils.jar");
            }
            if (Switches.JW_auxArchives && !Switches.JW_auxArchives_nativeUtilsInApp) {
                always.println("[App] Adding native libs to OS archives, (not the app archive)");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), "jwutils_win32.dll");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), "jwutils_win64.dll");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(LINUX_WRAPPERS_DIR, "libjwutils_linux32.so"), "libjwutils_linux32.so");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(LINUX_WRAPPERS_DIR, "libjwutils_linux64.so"), "libjwutils_linux64.so");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos32.jnilib"), "libjwutils_macos32.jnilib");
                carps.getArchiveFor(CompilerArchives.cross_platform).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos64.jnilib"), "libjwutils_macos64.jnilib");
                carps.getArchiveFor(CompilerArchives.windows).addFile(new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), "jwutils_win32.dll");
                carps.getArchiveFor(CompilerArchives.windows).addFile(new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), "jwutils_win64.dll");
                carps.getArchiveFor(CompilerArchives.lin32).addFile(new File(LINUX_WRAPPERS_DIR, "libjwutils_linux32.so"), "libjwutils_linux32.so");
                carps.getArchiveFor(CompilerArchives.lin64).addFile(new File(LINUX_WRAPPERS_DIR, "libjwutils_linux64.so"), "libjwutils_linux64.so");
                if (Switches.JW_ARMBUILDS) {
                    carps.getArchiveFor(CompilerArchives.arm).addFile(new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux32arm.so"), "libjwutils_linux32arm.so");
                    if (Switches.JW_arm64) {
                        carps.getArchiveFor(CompilerArchives.arm).addFile(new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux64arm.so"), "libjwutils_linux64arm.so");
                    }
                }
                carps.getArchiveFor(CompilerArchives.mac32).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos32.jnilib"), "libjwutils_macos32.jnilib");
                carps.getArchiveFor(CompilerArchives.mac32).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos64.jnilib"), "libjwutils_macos64.jnilib");
                carps.getArchiveFor(CompilerArchives.mac64).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos32.jnilib"), "libjwutils_macos32.jnilib");
                carps.getArchiveFor(CompilerArchives.mac64).addFile(new File(OSX_WRAPPERS_DIR, "libjwutils_macos64.jnilib"), "libjwutils_macos64.jnilib");
            } else {
                always.println("[App] Adding native libs to App archive");
                apparchive.addFile(false, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), "jwutils_win32.dll");
                apparchive.addFile(false, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), "jwutils_win64.dll");
                apparchive.addFile(false, new File(LINUX_WRAPPERS_DIR, "libjwutils_linux32.so"), "libjwutils_linux32.so");
                apparchive.addFile(false, new File(LINUX_WRAPPERS_DIR, "libjwutils_linux64.so"), "libjwutils_linux64.so");
                if (Switches.JW_ARMBUILDS) {
                    apparchive.addFile(false, new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux32arm.so"), "libjwutils_linux32arm.so");
                    if (Switches.JW_arm64) {
                        apparchive.addFile(false, new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux64arm.so"), "libjwutils_linux64arm.so");
                    }
                    if (!Switches.JW_includeArmInCrossPlatform) {
                        carps.getArchiveFor(CompilerArchives.arm).addFile(new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux32arm.so"), "libjwutils_linux32arm.so");
                        if (Switches.JW_arm64) {
                            carps.getArchiveFor(CompilerArchives.arm).addFile(new File(LINUX_ARM_WRAPPERS_DIR, "libjwutils_linux64arm.so"), "libjwutils_linux64arm.so");
                        }
                    }
                }
                apparchive.addFile(false, new File(OSX_WRAPPERS_DIR, "libjwutils_macos32.jnilib"), "libjwutils_macos32.jnilib");
                apparchive.addFile(false, new File(OSX_WRAPPERS_DIR, "libjwutils_macos64.jnilib"), "libjwutils_macos64.jnilib");
            }
            if (bundlelic.exists()) {
                apparchive.addFile(false, bundlelic, "jwrapper_license");
            }
            File file4 = new File(build, "session_win.exe");
            File versionedSessionWin = new File(build, "versioned_session_win.exe");
            if (versionedSessionWin.exists()) {
                versionedSessionWin.delete();
            }
            FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "session_win.exe"), versionedSessionWin);
            JWrapperCompiler.setVersionInfo(versionedSessionWin);
            if (winSignKeystore != null) {
                always.println("[App] Signing Windows session launcher...");
                int X = 0;
                while (true) {
                    ++X;
                    try {
                        long start = System.currentTimeMillis();
                        new AuthenticodeSigner(versionedSessionWin, file4, bundleName, winSignTimestampURL, winSignKeystore).sign();
                        totalSigningTime += System.currentTimeMillis() - start;
                        always.println("[App] Windows session launcher signed OK");
                    }
                    catch (IOException x) {
                        if (X == 10) {
                            throw x;
                        }
                        always.println("[App] Problem signing Windows session launcher (could be a timestamp URL issue, will try again in 3s...)");
                        Thread.sleep(3000L);
                        continue;
                    }
                    break;
                }
                always.println("[App] Adding Windows session launcher to archive...");
                if (!Switches.JW_auxArchives || Switches.SH_1550_auxArchives_elevAndSessionInApp) {
                    apparchive.addFile(false, file4, file4.getName());
                }
            } else {
                always.println("[App] No Windows signing information - App will be UNABLE TO ELEVATE LAUNCH INTO SESSION ON WINDOWS");
            }
            if (versionedSessionWin.exists()) {
                versionedSessionWin.delete();
            }
            File elev_win = new File(build, "elev_win.exe");
            File versionedElevWin = new File(build, "versioned_elev_win.exe");
            if (versionedElevWin.exists()) {
                versionedElevWin.delete();
            }
            FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "elev_win.exe"), versionedElevWin);
            JWrapperCompiler.setVersionInfo(versionedElevWin);
            if (winSignKeystore != null) {
                always.println("[App] Signing Windows elevation...");
                int X = 0;
                while (true) {
                    ++X;
                    try {
                        long start = System.currentTimeMillis();
                        new AuthenticodeSigner(versionedElevWin, elev_win, bundleName, winSignTimestampURL, winSignKeystore).sign();
                        totalSigningTime += System.currentTimeMillis() - start;
                        always.println("[App] Windows elevation signed OK");
                    }
                    catch (IOException x) {
                        if (X == 10) {
                            throw x;
                        }
                        always.println("[App] Problem signing Windows elevation (could be a timestamp URL issue, will try again in 3s...)");
                        Thread.sleep(3000L);
                        continue;
                    }
                    break;
                }
                always.println("[App] Adding Windows elevation to archive...");
                if (!Switches.JW_auxArchives || Switches.SH_1550_auxArchives_elevAndSessionInApp) {
                    apparchive.addFile(false, elev_win, elev_win.getName());
                }
            } else {
                always.println("[App] No Windows signing information - App will be UNABLE TO ELEVATE ON WINDOWS");
            }
            if (versionedElevWin.exists()) {
                versionedElevWin.delete();
            }
            always.println("[App] Adding MacOS elevation to archive...");
            File elev_mac = new File(OSX_WRAPPERS_DIR, "elev_mac");
            if (!Switches.JW_auxArchives || Switches.SH_1550_auxArchives_elevAndSessionInApp) {
                apparchive.addFile(false, elev_mac, elev_mac.getName());
            }
            if (Switches.JW_auxArchives && !Switches.SH_1550_auxArchives_elevAndSessionInApp) {
                carps.getArchiveFor(CompilerArchives.windows).addFile(elev_win, elev_win.getName());
                carps.getArchiveFor(CompilerArchives.windows).addFile(file4, file4.getName());
                carps.getArchiveFor(CompilerArchives.mac32).addFile(elev_mac, elev_mac.getName());
                carps.getArchiveFor(CompilerArchives.mac64).addFile(elev_mac, elev_mac.getName());
            }
            apparchive.addFile(false, buildver, buildver.getName());
            always.println("[App] Adding " + appnotes.size() + " appnotes");
            for (File appnote : appnotes) {
                always.println("[App] Adding appnote " + appnote.getAbsolutePath() + " / " + appnote.length());
                apparchive.addFile(false, appnote, appnote.getName());
            }
            if (!Switches.JW_auxArchives) {
                if (Switches.JW_ARMBUILDS && !Switches.JW_includeArmInCrossPlatform) {
                    always.println("[App] Compressing linuxarm offline app archive...");
                    carps.buildMergedArchiveForOs(CompilerArchives.arm, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, null);
                }
                always.println("[App] Compressing archive...");
                carps.deleteAllArchives();
                apparchive.finishAndCompress(fullBuild, rsaKeys);
            } else {
                OnDemandThreadPool odp = new OnDemandThreadPool("Archive compression", 48, 999999, 5);
                always.println("[App] Compressing windows offline app archive...");
                carps.buildMergedArchiveForOs(CompilerArchives.windows, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing linux32 offline app archive...");
                carps.buildMergedArchiveForOs(CompilerArchives.lin32, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing linux64 offline app archive...");
                carps.buildMergedArchiveForOs(CompilerArchives.lin64, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing macos32 offline app archive...");
                carps.buildMergedArchiveForOs(CompilerArchives.mac32, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing macos64 offline app archive...");
                carps.buildMergedArchiveForOs(CompilerArchives.mac64, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                if (Switches.JW_ARMBUILDS) {
                    always.println("[App] Compressing linuxarm offline app archive...");
                    carps.buildMergedArchiveForOs(CompilerArchives.arm, apparchive, auxiliaries, auxnames, fullBuild, rsaKeys, odp);
                }
                always.println("[App] Compressing online app archive...");
                apparchive.finishAndCompress(fullBuild, rsaKeys);
                always.println("[App] Compressing windows online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.windows, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing linux32 online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.lin32, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing linux64 online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.lin64, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing mac32 online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.mac32, fullBuild, rsaKeys, odp);
                always.println("[App] Compressing mac64 online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.mac64, fullBuild, rsaKeys, odp);
                if (Switches.JW_ARMBUILDS) {
                    always.println("[App] Compressing linuxarm online os archive...");
                    carps.finishAndCompressOsArchive(CompilerArchives.arm, fullBuild, rsaKeys, odp);
                }
                always.println("[App] Compressing cross platform online os archive...");
                carps.finishAndCompressOsArchive(CompilerArchives.cross_platform, fullBuild, rsaKeys, odp);
                for (int i = 0; i < auxnames.size(); ++i) {
                    String auxname = (String)auxnames.get(i);
                    Archive aux = (Archive)auxiliaries.get(i);
                    always.println("[App] Compressing online aux archive...");
                    aux.finishAndCompress(fullBuild, rsaKeys, odp);
                    VersionUtil.writeAppVersionFile(build, GenericUpdater.getNameForAuxiliary(bundleName, auxname), appversion);
                }
                odp.waitForAll();
            }
            for (File aDeleteme : deleteme) {
                aDeleteme.delete();
            }
            VersionUtil.writeAppVersionFile(build, bundleName, appversion);
            if (deleteElevationFiles) {
                elev_win.delete();
            }
            file4.delete();
            bundlelic.delete();
            always.println("[App] App archive finished");
            if (deltaBuild) {
                always.println("[CmdLine] Delta build COMPLETE");
                System.exit(0);
            }
            File appVersionFile = new File(build, GenericUpdater.getVersionFileNameFor(bundleName));
            File guArchive = new File(build, GenericUpdater.getArchiveNameFor("JWrapper", guversion));
            File guVersionFile = new File(build, GenericUpdater.getVersionFileNameFor("JWrapper"));
            always.println("[CmdLine] Building Command Line Java Wrapper");
            if (!Switches.SH_1547_jwGuNotUseSevenzip) {
                File szsrc = new File(new File("jwrapperlib"), "sevenzip.jar");
                File szdest = new File(build, bundleName + "-java-online_sz.jar");
                FileUtil.copyFileOrDir(szsrc, szdest);
            }
            File jarsrc = new File(wrappers, "jwrapperapplet.jar");
            File cmdlineJar = new File(build, bundleName + "-java-online.jar");
            always.println("[CmdLine] Constructing static properties file...");
            Properties staticProperties = new Properties();
            staticProperties.put("app_name", bundleName);
            staticProperties.put("min_splash_ms", "" + splashMinMS);
            if (canOverrideSplash) {
                staticProperties.put("can_override_splash", "1");
            } else {
                staticProperties.put("can_override_splash", "0");
            }
            staticProperties.put("match_versions", "" + matchClientVersionToServerVersion);
            if (silentInstallParameter != null) {
                staticProperties.put("silent_parameter", silentInstallParameter);
            }
            staticProperties.put("java_version", "" + JWrapperCompiler.getRequiredJavaVersion());
            if (!dynamicUpdateURL) {
                staticProperties.put("update_url", updateURL);
            }
            staticProperties.put("install_type", installType);
            File staticPropertiesFile = new File(build, "static.properties");
            FileOutputStream fout3 = new FileOutputStream(staticPropertiesFile);
            staticProperties.storeToXML(fout3, "");
            fout3.close();
            deleteme.add(staticPropertiesFile);
            File cacerts = JWrapperCompiler.setupCACerts(build, cacertsFile);
            if (pubkeyFile != null) {
                always.println("[CmdLine] Adding author pubkey to jar");
                JWrapperCompiler.addFilesToExistingZip(jarsrc, cmdlineJar, new File[]{staticPropertiesFile, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), cacerts, pubkeyFile});
            } else {
                JWrapperCompiler.addFilesToExistingZip(jarsrc, cmdlineJar, new File[]{staticPropertiesFile, new File(WINDOWS_WRAPPERS_DIR, "jwutils_win32.dll"), new File(WINDOWS_WRAPPERS_DIR, "jwutils_win64.dll"), cacerts});
            }
            cacerts.delete();
            staticPropertiesFile.delete();
            boolean haveProducedApplet = false;
            if (!Switches.JW_noMoreApplets) {
                always.println("[Applet] Building applet/cmdline wrapper");
                try {
                    if (jarSignerPath == null) {
                        File jarsigner;
                        always.println("[Applet] No explicit jarsigner path set, will try to autodetect from current JRE");
                        String home = System.getProperty("java.home");
                        String tmp = home + File.separator + "bin" + File.separator + "jarsigner";
                        if (OS.isWindows()) {
                            tmp = tmp + ".exe";
                        }
                        if (!(jarsigner = new File(tmp)).exists()) {
                            tmp = home + File.separator + ".." + File.separator + "bin" + File.separator + "jarsigner";
                            if (OS.isWindows()) {
                                tmp = tmp + ".exe";
                            }
                            jarsigner = new File(tmp);
                        }
                        if (jarsigner.exists()) {
                            jarSignerPath = jarsigner.getAbsoluteFile().getCanonicalPath();
                        }
                    }
                }
                catch (Exception x) {
                    always.println("[Applet] Failed to autodetect jarsigner path (" + x + ")");
                }
                if (winSignKeystore == null) {
                    always.println("[Applet] No applet signing info, unable to produce applet (must be signed to work properly)");
                } else if (jarSignerPath == null) {
                    always.println("[Applet] No jarsigner path, unable to produce applet, please add <JarSignerPath> inside <SignForWindowsAndApplet>");
                } else {
                    haveProducedApplet = true;
                    if (pubkeyFile != null) {
                        always.println("[Applet] Including author pubkey in jar");
                    }
                    File jarsrc2 = cmdlineJar;
                    File jardest = new File(build, bundleName + "Applet.jar");
                    FileUtil.copyFileOrDir(jarsrc2, jardest);
                    always.println("[Applet] Signing applet jar 1 of 2...");
                    long start = System.currentTimeMillis();
                    JWrapperCompiler.signJar(jardest, jarSignerPath, winSignKeystore, winSignKeystoreType, appletSignTimestampURL);
                    totalSigningTime += System.currentTimeMillis() - start;
                    if (!Switches.SH_1547_jwGuNotUseSevenzip) {
                        jarsrc2 = new File(new File("jwrapperlib"), "sevenzip.jar");
                        jardest = new File(build, bundleName + "Applet_sz.jar");
                        FileUtil.copyFileOrDir(jarsrc2, jardest);
                        always.println("[Applet] Signing applet jar 2 of 2...");
                        start = System.currentTimeMillis();
                        JWrapperCompiler.signJar(jardest, jarSignerPath, winSignKeystore, winSignKeystoreType, appletSignTimestampURL);
                        totalSigningTime += System.currentTimeMillis() - start;
                    }
                }
                always.println("[Applet] Applet wrapper finished");
            }
            always.println("[JavaScript] Building JS Download Embed Script");
            File csssrc = new File(HTML_WRAPPERS_DIR, "JWrapperEmbed.css");
            File cssdest = new File(build, bundleName + "Embed.css");
            if (IS_SH_BUILD) {
                cssdest = new File(build, "embed.css");
            }
            FileUtil.copyFileOrDir(csssrc, cssdest);
            String encodedBundleName = URLEncoder.encode(bundleName, "UTF-8");
            String js = FileUtil.readFileAsString(new File(HTML_WRAPPERS_DIR, "JWrapperEmbed.js").getAbsolutePath());
            js = StringReplace.replaceAll(js, "JWRAPPER_CUSTOM_JS", customHTML);
            js = StringReplace.replaceAll(js, "JWRAPPER_APP_NAME", bundleName);
            js = !Switches.SH_1547_jwGuNotUseSevenzip ? StringReplace.replaceAll(js, "JWRAPPER_ARCHIVE_PATH", encodedBundleName + "Applet.jar," + encodedBundleName + "Applet_sz.jar") : StringReplace.replaceAll(js, "JWRAPPER_ARCHIVE_PATH", encodedBundleName + "Applet.jar");
            js = StringReplace.replaceAll(js, "JWRAPPER_IMAGE_SRC_TAG", WebBase64.byteArrayToBase64(FileUtil.readFile(bundleSplash.getAbsolutePath())));
            if (!buildLinuxARM32Wrappers) {
                js = StringReplace.replaceAll(js, "var showArm = true;", "var showArm = false;");
            }
            if (IS_SH_BUILD) {
                FileUtil.writeFileAsString(new File(build, "embed.js").getAbsolutePath(), js);
            } else {
                FileUtil.writeFileAsString(new File(build, bundleName + "Embed.js").getAbsolutePath(), js);
            }
            String ht = FileUtil.readFileAsString(new File(HTML_WRAPPERS_DIR, "JWrapperEmbedExample.html").getAbsolutePath());
            ht = haveUpdateURL ? StringReplace.replaceAll(ht, "EMBED_JS_URL", updateURL + "/" + bundleName + "Embed.js") : StringReplace.replaceAll(ht, "EMBED_JS_URL", "http://localhost:33333/" + bundleName + "Embed.js");
            ht = haveUpdateURL ? (haveProducedApplet ? StringReplace.replaceAll(ht, "EMBED_JS_ORDER", "online*,offline,applet") : StringReplace.replaceAll(ht, "EMBED_JS_ORDER", "online*,offline")) : (haveProducedApplet ? StringReplace.replaceAll(ht, "EMBED_JS_ORDER", "offline*,applet") : StringReplace.replaceAll(ht, "EMBED_JS_ORDER", "offline*"));
            File embedHtml = new File(build, bundleName + "EmbedExample.html");
            if (!IS_SH_BUILD) {
                FileUtil.writeFileAsString(embedHtml.getAbsolutePath(), ht);
            }
            always.println("[JavaScript] JS Download Embed Script finished");
            for (int BITS = 32; BITS <= 64; BITS += 32) {
                if (BITS == 32 && !buildWindows32Wrappers || BITS == 64 && !buildWindows64Wrappers) continue;
                for (int OX = 0; OX < 2; ++OX) {
                    File[] files5;
                    boolean is64Bit;
                    boolean OFFLINE = OX == 0;
                    boolean bl = is64Bit = BITS == 64;
                    if (!OFFLINE && !haveUpdateURL) continue;
                    if (OFFLINE) {
                        always.println("[Windows] Building Windows Offline wrapper");
                        wfile = new File(build, bundleName + "-windows" + BITS + "-offline.exe");
                    } else {
                        always.println("[Windows] Building Windows Online wrapper");
                        wfile = new File(build, bundleName + "-windows" + BITS + "-online.exe");
                    }
                    if (BITS == 32) {
                        jre = LaunchFile.getLatestVersionOf(GenericUpdater.JRE_WIN32_APP, build);
                        dynamicProps.setProperty("jre_name", GenericUpdater.JRE_WIN32_APP);
                    } else {
                        jre = LaunchFile.getLatestVersionOf(GenericUpdater.JRE_WIN64_APP, build);
                        dynamicProps.setProperty("jre_name", GenericUpdater.JRE_WIN64_APP);
                    }
                    if (installType.equals("perm_all")) {
                        if (!is64Bit) {
                            FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_requireAdministrator_0.exe"), wfile);
                        } else {
                            FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_requireAdministrator_0_64.exe"), wfile);
                        }
                    } else if (installType.equals("temp_user")) {
                        FileUtil.copy(JWrapperCompiler.getWindowsWrapperFor(appElevation, appUiAccess, is64Bit), wfile);
                    } else if (!is64Bit) {
                        FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_asInvoker_0.exe"), wfile);
                    } else {
                        FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "windowswrapper_asInvoker_0_64.exe"), wfile);
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(wfile, true));
                    ((OutputStream)bufferedOutputStream).write(marker);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, bundleName);
                    if (OFFLINE) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, appversion);
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, LaunchFile.pickVersionFromAppArchive(jre));
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, guversion);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, "" + splashMinMS);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, rsaDerEncodedPublicKey);
                    if (canOverrideSplash) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "1");
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "0");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, installType);
                    if (silentInstallParameter != null) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, silentInstallParameter);
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, "" + JWrapperCompiler.getRequiredJavaVersion());
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, updateURL);
                    boolean FORCE_WINDOWS_SUBSYSTEM = false;
                    boolean MAKE_WIN_WRAPPER_USE_CONSOLE = false;
                    lzma = new File(build, "lzma.exe");
                    FileUtil.copy(new File(WINDOWS_WRAPPERS_DIR, "lzma.exe"), lzma);
                    if (FORCE_WINDOWS_SUBSYSTEM) {
                        ExeReader.setUseSubsystem((String)lzma.getAbsolutePath(), (boolean)false);
                    }
                    downloadpng = new File(build, "nativesplash.png");
                    FileUtil.copy(bundleSplash, downloadpng);
                    if (!Switches.JW_auxArchives) {
                        appArchive = appArchiveFile;
                    } else {
                        appArchive = carps.getMergedArchiveFileIfBuilt(CompilerArchives.windows);
                        if (appArchive == null) {
                            JWrapperCompiler.fail("Windows-specific offline app archive has not been built");
                        }
                    }
                    File[] cacerts2 = JWrapperCompiler.setupCACerts(build, cacertsFile);
                    if (OFFLINE) {
                        File[] files2 = new File[]{lzma, downloadpng, cacerts2, guArchive, guVersionFile, jre, appArchive, appVersionFile};
                    } else {
                        files5 = new File[]{lzma, downloadpng, cacerts2, guArchive, guVersionFile};
                    }
                    byte[] buf = new byte[200000];
                    for (File file5 : files5) {
                        if (file5 == null) continue;
                        Archive.addFileToStream("(Win" + BITS + "Tail)", bufferedOutputStream, buf, file5, file5.getName(), appStrippers, filesToKeep, filesNotToPack200, pack200Effort);
                    }
                    FileUtil.deleteDir(downloadpng);
                    FileUtil.deleteDir((File)cacerts2);
                    FileUtil.deleteDir(lzma);
                    if (winSignKeystore == null) {
                        ((OutputStream)bufferedOutputStream).write(jwparams.getParameterisedBlock(dynamicProps, 204800));
                    }
                    ((OutputStream)bufferedOutputStream).close();
                    File icofile = new File(wfile.getAbsolutePath() + "_icon.exe");
                    always.println("[Windows] Embedding icon...");
                    ExeReader.embedIcons((String)wfile.getAbsolutePath(), (String)icofile.getAbsolutePath(), (byte[])logo16, (byte[])logo24, (byte[])logo32, (byte[])logo48, (byte[])logo256);
                    if (MAKE_WIN_WRAPPER_USE_CONSOLE) {
                        ExeReader.setUseSubsystem((String)icofile.getAbsolutePath(), (boolean)true);
                    }
                    if (!wfile.delete()) {
                        throw new Exception("Unable to delete original EXE " + wfile);
                    }
                    JWrapperCompiler.setVersionInfo(icofile);
                    if (winSignKeystore != null) {
                        always.println("[Windows] Signing exe " + wfile + "...");
                        int X = 0;
                        while (true) {
                            ++X;
                            try {
                                long start = System.currentTimeMillis();
                                new AuthenticodeSigner(icofile, wfile, bundleName, winSignTimestampURL, winSignKeystore).sign(jwparams.getParameterisedBlock(dynamicProps, 204800));
                                totalSigningTime += System.currentTimeMillis() - start;
                                always.println("[Windows] Signed OK");
                            }
                            catch (IOException x) {
                                if (X == 10) {
                                    throw x;
                                }
                                always.println("[Windows] Problem with signing (could be a timestamp URL issue, will try again in 3s...)");
                                Thread.sleep(3000L);
                                continue;
                            }
                            break;
                        }
                        if (!icofile.delete()) {
                            throw new Exception("Unable to delete temporary unsigned EXE");
                        }
                    } else if (!icofile.renameTo(wfile)) {
                        throw new Exception("Unable to rename iconified to original EXE");
                    }
                    always.println("[Windows] Windows wrapper finished");
                }
            }
            for (BuildConfig config : linuxBuilds) {
                if (!config.doBuild) continue;
                for (int OX = 0; OX < 2; ++OX) {
                    File[] files6;
                    File appArchive2;
                    boolean OFFLINE;
                    boolean bl = OFFLINE = OX == 0;
                    if (!OFFLINE && !haveUpdateURL) continue;
                    if (OFFLINE) {
                        always.println("[Linux] Building Linux Offline wrapper - " + config.description);
                        wfile = new File(build, bundleName + "-" + config.description + "-offline");
                    } else {
                        always.println("[Linux] Building Linux Online wrapper - " + config.description);
                        wfile = new File(build, bundleName + "-" + config.description + "-online");
                    }
                    jre = LaunchFile.getLatestVersionOf(config.jreApp, build);
                    dynamicProps.setProperty("jre_name", config.jreApp);
                    if (installType.equals("perm_all")) {
                        FileUtil.copy(config.getWrapperFile(true), wfile);
                    } else {
                        FileUtil.copy(config.getWrapperFile(false), wfile);
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(wfile, true));
                    ((OutputStream)bufferedOutputStream).write(marker);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, bundleName);
                    if (OFFLINE) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, appversion);
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, LaunchFile.pickVersionFromAppArchive(jre));
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, guversion);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, "" + splashMinMS);
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, rsaDerEncodedPublicKey);
                    if (canOverrideSplash) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "1");
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "0");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, installType);
                    if (silentInstallParameter != null) {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, silentInstallParameter);
                    } else {
                        CFriendlyStreamUtils.writeString(bufferedOutputStream, "");
                    }
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, "" + JWrapperCompiler.getRequiredJavaVersion());
                    CFriendlyStreamUtils.writeString(bufferedOutputStream, updateURL);
                    File lzma2 = new File(build, "lzma" + config.bits);
                    FileUtil.copy(config.getLZMASourceFile(), lzma2);
                    File downloadpng2 = new File(build, "nativesplash.png");
                    FileUtil.copyFileOrDir(bundleSplash, downloadpng2);
                    if (!Switches.JW_auxArchives) {
                        if (Switches.JW_includeArmInCrossPlatform) {
                            File appArchive22 = appArchiveFile;
                        } else {
                            appArchive2 = config.isARM() ? carps.getMergedArchiveFileIfBuilt(CompilerArchives.arm) : appArchiveFile;
                        }
                    } else if (config.bits == 32) {
                        appArchive2 = config.isARM() ? carps.getMergedArchiveFileIfBuilt(CompilerArchives.arm) : carps.getMergedArchiveFileIfBuilt(CompilerArchives.lin32);
                        if (appArchive2 == null) {
                            JWrapperCompiler.fail("Linux32-specific (" + (config.isARM() ? "arm" : "x86") + ") offline app archive has not been built");
                        }
                    } else {
                        appArchive2 = config.isARM() ? carps.getMergedArchiveFileIfBuilt(CompilerArchives.arm) : carps.getMergedArchiveFileIfBuilt(CompilerArchives.lin64);
                        if (appArchive2 == null) {
                            JWrapperCompiler.fail("Linux64-specific (" + (config.isARM() ? "arm" : "x86") + ") offline app archive has not been built");
                        }
                    }
                    File cacerts3 = JWrapperCompiler.setupCACerts(build, cacertsFile);
                    if (OFFLINE) {
                        File[] files3 = new File[]{lzma2, downloadpng2, cacerts3, guArchive, guVersionFile, jre, appArchive2, appVersionFile};
                    } else {
                        files6 = new File[]{lzma2, downloadpng2, cacerts3, guArchive, guVersionFile};
                    }
                    byte[] buf = new byte[200000];
                    for (File file6 : files6) {
                        if (file6 == null) continue;
                        Archive.addFileToStream("Lin" + config.bits + "Tail", bufferedOutputStream, buf, file6, file6.getName(), appStrippers, filesToKeep, filesNotToPack200, pack200Effort);
                    }
                    FileUtil.deleteDir(downloadpng2);
                    FileUtil.deleteDir(lzma2);
                    FileUtil.deleteDir(cacerts3);
                    ((OutputStream)bufferedOutputStream).write(jwparams.getParameterisedBlock(dynamicProps, 204800));
                    ((OutputStream)bufferedOutputStream).close();
                    JWrapperCompiler.addAllToNewTar(new File(build, wfile.getName() + ".tar"), new File[]{wfile});
                    wfile.delete();
                    always.println("[Linux] Linux wrapper finished");
                }
            }
            if (buildMacOS64Wrappers) {
                for (int OX = 0; OX < 2; ++OX) {
                    File[] files7;
                    File wfile2;
                    boolean OFFLINE = OX == 0;
                    int BITS = 64;
                    if (OFFLINE) {
                        always.println("[MacOS] Building MacOS Offline wrapper [64bit]");
                    } else {
                        always.println("[MacOS] Building MacOS Online wrapper [64bit]");
                    }
                    if (!OFFLINE && !haveUpdateURL) continue;
                    if (OFFLINE) {
                        File wfile22 = new File(build, bundleName + "-macos" + BITS + "-offline");
                    } else {
                        wfile2 = new File(build, bundleName + "-macos" + BITS + "-online");
                    }
                    File jre3 = LaunchFile.getLatestVersionOf(GenericUpdater.JRE_MAC64_APP, build);
                    dynamicProps.setProperty("jre_name", GenericUpdater.JRE_MAC64_APP);
                    if (installType.equals("perm_all")) {
                        if (macCertInfo != null) {
                            FileUtil.copy(new File(OSX_WRAPPERS_DIR, "osxwrapper" + BITS + "_su"), wfile2);
                        } else {
                            FileUtil.copy(new File(OSX_WRAPPERS_DIR, "osxwrapper" + BITS + "_su_unsigned"), wfile2);
                        }
                    } else if (macCertInfo != null) {
                        FileUtil.copy(new File(OSX_WRAPPERS_DIR, "osxwrapper" + BITS), wfile2);
                    } else {
                        FileUtil.copy(new File(OSX_WRAPPERS_DIR, "osxwrapper" + BITS + "_unsigned"), wfile2);
                    }
                    File dotApp3 = new File(build, bundleName + ".app");
                    FileUtil.deleteDir(dotApp3);
                    FileUtil.copyFileOrDir(new File(wrappers, "Blank64.app"), dotApp3);
                    FileUtil.removeCVS(dotApp3);
                    File file7 = new File(dotApp3, "Contents");
                    File resources2 = new File(file7, "Resources");
                    File macos2 = new File(file7, "MacOS");
                    macos2.mkdirs();
                    resources2.mkdirs();
                    lzma = new File(build, "lzma" + BITS);
                    FileUtil.copy(new File(OSX_WRAPPERS_DIR, "lzma_macos" + BITS), lzma);
                    downloadpng = new File(build, "nativesplash.png");
                    FileUtil.copyFileOrDir(bundleSplash, downloadpng);
                    if (!Switches.JW_auxArchives) {
                        appArchive = appArchiveFile;
                    } else {
                        appArchive = carps.getMergedArchiveFileIfBuilt(CompilerArchives.mac64);
                        if (appArchive == null) {
                            JWrapperCompiler.fail("Mac64-specific offline app archive has not been built");
                        }
                    }
                    File cacerts4 = JWrapperCompiler.setupCACerts(build, cacertsFile);
                    if (OFFLINE) {
                        File[] files4 = new File[]{lzma, downloadpng, cacerts4, guArchive, guVersionFile, jre3, appArchive, appVersionFile};
                    } else {
                        files7 = new File[]{lzma, downloadpng, cacerts4, guArchive, guVersionFile};
                    }
                    BufferedOutputStream fout4 = new BufferedOutputStream(new FileOutputStream(new File(resources2, "Tail")));
                    CFriendlyStreamUtils.writeString(fout4, bundleName);
                    if (OFFLINE) {
                        CFriendlyStreamUtils.writeString(fout4, appversion);
                        CFriendlyStreamUtils.writeString(fout4, LaunchFile.pickVersionFromAppArchive(jre3));
                    } else {
                        CFriendlyStreamUtils.writeString(fout4, "");
                        CFriendlyStreamUtils.writeString(fout4, "");
                    }
                    CFriendlyStreamUtils.writeString(fout4, guversion);
                    CFriendlyStreamUtils.writeString(fout4, "" + splashMinMS);
                    CFriendlyStreamUtils.writeString(fout4, rsaDerEncodedPublicKey);
                    if (canOverrideSplash) {
                        CFriendlyStreamUtils.writeString(fout4, "1");
                    } else {
                        CFriendlyStreamUtils.writeString(fout4, "0");
                    }
                    CFriendlyStreamUtils.writeString(fout4, installType);
                    if (silentInstallParameter != null) {
                        CFriendlyStreamUtils.writeString(fout4, silentInstallParameter);
                    } else {
                        CFriendlyStreamUtils.writeString(fout4, "");
                    }
                    CFriendlyStreamUtils.writeString(fout4, "" + JWrapperCompiler.getRequiredJavaVersion());
                    CFriendlyStreamUtils.writeString(fout4, updateURL);
                    byte[] buf = new byte[200000];
                    for (File file8 : files7) {
                        if (file8 == null) continue;
                        Archive.addFileToStream("Mac64Tail", fout4, buf, file8, file8.getName(), appStrippers, filesToKeep, filesNotToPack200, pack200Effort);
                    }
                    ((OutputStream)fout4).close();
                    FileUtil.deleteDir(downloadpng);
                    FileUtil.deleteDir(lzma);
                    FileUtil.deleteDir(cacerts4);
                    File appWrapper2 = new File(macos2, "osxwrapper");
                    FileUtil.copyFileOrDir(wfile2, appWrapper2);
                    File launcher = new File(macos2, "osxlauncher");
                    if (macCertInfo != null) {
                        FileUtil.copyFileOrDir(new File(OSX_WRAPPERS_DIR, "osxlauncher" + BITS), launcher);
                    } else {
                        FileUtil.copyFileOrDir(new File(OSX_WRAPPERS_DIR, "osxlauncher" + BITS + "_unsigned"), launcher);
                    }
                    File appParams3 = JWMacOS.getParameterisationFile(dotApp3);
                    appParams3.mkdirs();
                    appParams3.delete();
                    FileOutputStream apout3 = new FileOutputStream(appParams3);
                    apout3.write(jwparams.getParameterisedBlock(dynamicProps, 204800));
                    apout3.close();
                    File icns3 = new File(resources2, OSXWrapper.getICNSFileName());
                    FileUtil.copyFileOrDir(appICNS, icns3);
                    File splash3 = new File(resources2, OSXWrapper.getAppSplashName());
                    FileUtil.copyFileOrDir(bundleSplash, splash3);
                    File osxWrapperElevate2 = new File(resources2, "elev_mac");
                    FileUtil.copyFileOrDir(new File(OSX_WRAPPERS_DIR, "elev_mac"), osxWrapperElevate2);
                    File plistFile3 = new File(file7, "Info.plist");
                    String plist3 = FileUtil.readFileAsString(plistFile3.getAbsolutePath());
                    plist3 = plist3.replace("OSX_JW_BUNDLE_NAME", bundleName);
                    plist3 = plist3.replace("OSX_JW_BUNDLE_ID", "jwrapper.osx." + JWrapperCompiler.normaliseID(bundleName));
                    plist3 = plist3.replace("OSX_JW_BUNDLE_VERSION", macversion);
                    FileUtil.writeFile(plistFile3, plist3.getBytes("UTF8"));
                    if (macCertInfo != null) {
                        always.println("[MacOS] Signing OSX App");
                        long start = System.currentTimeMillis();
                        MacSigner.signApp((CertificateInfo)macCertInfo, (File)new File(build, bundleName + ".app"), (String[])new String[]{"osxwrapper", "osxlauncher"}, (String)"osxwrapper");
                        totalSigningTime += System.currentTimeMillis() - start;
                        FileUtil.deleteDir(new File(macos2, "osxwrapper.backup"));
                        FileUtil.deleteDir(new File(macos2, "osxlauncher.backup"));
                    }
                    String name = OFFLINE ? bundleName + "-macos" + BITS + "-offline" : bundleName + "-macos" + BITS + "-online";
                    always.println("[MacOS] Compressing...");
                    DSConfig config = JWrapperCompiler.createDSConfig(shortBundleName, bundleName, osxBgHeight);
                    DMGHelper dmgHelper = new DMGHelper(new File(build, name + ".dmg"), dotApp3, appICNS, appOsxBG, config, dmgSplashSizeBytes);
                    dmgHelper.setPrintStream(always);
                    dmgHelper.createDMG();
                    FileUtil.deleteDir(dotApp3);
                    wfile2.delete();
                    always.println("[MacOS] MacOS wrapper finished [64bit]");
                }
            }
            if (buildMacOS32Wrappers) {
                for (int OX = 0; OX < 2; ++OX) {
                    void var130_360;
                    File appArchive3;
                    boolean OFFLINE;
                    boolean bl = OFFLINE = OX == 0;
                    if (OFFLINE) {
                        always.println("[MacOS] Building MacOS Offline wrapper [32bit]");
                    } else {
                        always.println("[MacOS] Building MacOS Online wrapper [32bit]");
                    }
                    if (!OFFLINE && !haveUpdateURL) continue;
                    dynamicProps.setProperty("jre_name", "-");
                    Properties jwp2 = new Properties();
                    jwp2.setProperty("app_name", bundleName);
                    if (OFFLINE) {
                        jwp2.setProperty("wrapper_app_version", appversion);
                    }
                    jwp2.setProperty("wrapper_gu_version", "" + guversion);
                    jwp2.setProperty("min_splash_ms", "" + splashMinMS);
                    if (canOverrideSplash) {
                        jwp2.setProperty("can_override_splash", "1");
                    } else {
                        jwp2.setProperty("can_override_splash", "0");
                    }
                    jwp2.setProperty("install_type", installType);
                    if (silentInstallParameter != null) {
                        jwp2.setProperty("silent_parameter", silentInstallParameter);
                    }
                    jwp2.setProperty("java_version", "" + JWrapperCompiler.getRequiredJavaVersion());
                    File jwprops2 = new File(build, "jwrapper_properties");
                    BufferedOutputStream out2 = new BufferedOutputStream(new FileOutputStream(jwprops2));
                    jwp2.store(out2, "");
                    ((OutputStream)out2).close();
                    if (!Switches.JW_auxArchives) {
                        File appArchive32 = appArchiveFile;
                    } else {
                        appArchive3 = carps.getMergedArchiveFileIfBuilt(CompilerArchives.mac32);
                        if (appArchive3 == null) {
                            JWrapperCompiler.fail("Mac32-specific offline app archive has not been built");
                        }
                    }
                    if (OFFLINE) {
                        File[] fileArray = new File[]{jwprops2, guArchive, guVersionFile, appArchive3, appVersionFile};
                    } else {
                        File[] fileArray = new File[]{jwprops2, guArchive, guVersionFile};
                    }
                    FileUtil.deleteDir(new File(build, "osxwrapper.jar"));
                    JWrapperCompiler.addFilesToExistingZip(new File(OSX_WRAPPERS_DIR, "osxwrapper.jar"), new File(build, "osxwrapper.jar"), (File[])var130_360);
                    File dotApp4 = new File(build, bundleName + ".app");
                    FileUtil.deleteDir(dotApp4);
                    FileUtil.copyFileOrDir(new File(wrappers, "Blank.app"), dotApp4);
                    if (macCertInfo == null) {
                        FileUtil.copy(new File(OSX_WRAPPERS_DIR, "JavaApplicationStub_unsigned"), new File(dotApp4, "Contents" + File.separator + "MacOS" + File.separator + "JavaApplicationStub"));
                    }
                    FileUtil.removeCVS(dotApp4);
                    File appParams4 = JWMacOS.getParameterisationFile(dotApp4);
                    appParams4.mkdirs();
                    appParams4.delete();
                    FileOutputStream apout4 = new FileOutputStream(appParams4);
                    apout4.write(jwparams.getParameterisedBlock(dynamicProps, 204800));
                    apout4.close();
                    File icns4 = new File(dotApp4, "Contents" + File.separator + "Resources" + File.separator + OSXWrapper.getICNSFileName());
                    FileUtil.copyFileOrDir(appICNS, icns4);
                    File splash4 = new File(dotApp4, "Contents" + File.separator + "Resources" + File.separator + OSXWrapper.getAppSplashName());
                    FileUtil.copyFileOrDir(bundleSplash, splash4);
                    File osxWrapperElevate3 = new File(dotApp4, "Contents" + File.separator + "Resources" + File.separator + "elev_mac");
                    FileUtil.copyFileOrDir(new File(OSX_WRAPPERS_DIR, "elev_mac"), osxWrapperElevate3);
                    File plistFile4 = new File(dotApp4, "Contents" + File.separator + "Info.plist");
                    String plist4 = FileUtil.readFileAsString(plistFile4.getAbsolutePath());
                    String result2 = plist4.replace("OSX_JW_ARGUMENT_0_HERE", updateURL);
                    result2 = result2.replace("OSX_JW_BUNDLE_NAME", bundleName);
                    result2 = result2.replace("OSX_JW_BUNDLE_ID", "jwrapper.osx." + JWrapperCompiler.normaliseID(bundleName));
                    result2 = result2.replace("OSX_JW_BUNDLE_VERSION", macversion);
                    FileUtil.writeFile(plistFile4, result2.getBytes("UTF8"));
                    File javadir2 = new File(dotApp4, "Contents" + File.separator + "Resources" + File.separator + "Java");
                    javadir2.mkdirs();
                    FileUtil.copyFileOrDir(new File(build, "osxwrapper.jar"), new File(javadir2, "osxwrapper.jar"));
                    if (!Switches.SH_1547_jwGuNotUseSevenzip) {
                        FileUtil.copyFileOrDir(new File("jwrapperlib", "sevenzip.jar"), new File(javadir2, "sevenzip.jar"));
                    }
                    FileUtil.deleteDir(new File(build, "osxwrapper.jar"));
                    FileUtil.deleteDir(new File(build, "jwrapper_properties"));
                    if (macCertInfo != null) {
                        always.println("[MacOS] Signing OSX App");
                        long start = System.currentTimeMillis();
                        MacSigner.signApp((CertificateInfo)macCertInfo, (File)new File(build, bundleName + ".app"));
                        totalSigningTime += System.currentTimeMillis() - start;
                        FileUtil.deleteDir(new File(dotApp4, "Contents" + File.separator + "MacOS" + File.separator + "JavaApplicationStub.backup"));
                    }
                    String name = OFFLINE ? bundleName + "-macos32-offline" : bundleName + "-macos32-online";
                    always.println("[MacOS] Compressing...");
                    DSConfig config = JWrapperCompiler.createDSConfig(shortBundleName, bundleName, osxBgHeight);
                    DMGHelper dmgHelper = new DMGHelper(new File(build, name + ".dmg"), dotApp4, appICNS, appOsxBG, config, dmgSplashSizeBytes);
                    dmgHelper.setPrintStream(always);
                    dmgHelper.createDMG();
                    FileUtil.deleteDir(dotApp4);
                    System.out.println("[MacOS] MacOS wrapper finished");
                }
            }
            System.out.println("Trying to cleanup...");
            ArrayList launchersAll = carps.getFileListFor(CompilerArchives.cross_platform);
            for (File f : launchersAll) {
                System.out.println("Removing " + f);
                FileUtil.deleteDir(f);
            }
            carps.cleanup();
            System.out.println("Removing " + appOsxBG);
            FileUtil.deleteDir(appOsxBG);
            System.out.println("Removing " + appICNS);
            FileUtil.deleteDir(appICNS);
            System.out.println("Removing " + appUninstallerICO);
            FileUtil.deleteDir(appUninstallerICO);
            always.println("[MacOS] Finished cleanup");
            always.println("Total signing time: " + totalSigningTime);
            always.println("Total Archive LZMA time: " + Archive.getTotalLZMATime());
            always.println("Total Archive Signing time: " + Archive.getTotalArchiveSigningTime());
            if (rsaKeys != null) {
                always.println("****************************************************");
                always.println("*                    IMPORTANT                     *");
                always.println("*                                                  *");
                always.println("*   You MUST BACK UP your digital signature file!  *");
                always.println("*                                                  *");
                always.println("* Without it you cannot issue updates for your app *");
                always.println("*                                                  *");
                always.println("****************************************************");
            }
            Tall = System.currentTimeMillis() - Tall;
            always.println("[FINISHED] JWrapper build is complete (" + Tall / 1000L + "s)");
            if (JWCompiler.CMDOPTION_DEMO) {
                always.println("Starting demo web server for app deployment, visit http://localhost:33333/" + embedHtml.getName());
                new TinyWebServer(33333, build);
                while (true) {
                    Thread.sleep(5000L);
                }
            }
            System.exit(0);
        }
        catch (FailException x) {
            JWrapperCompiler.fail(x.getMessage());
        }
        catch (Throwable x) {
            JWrapperCompiler.fail(x);
        }
    }

    private static DSConfig createDSConfig(String shortBundleName, String bundleName, int osxBgHeight) {
        DSConfig config = new DSConfig();
        config.showSidebar = false;
        config.showToolbar = false;
        config.keepArrangedBy = "none";
        config.windowBounds = new Rectangle(350, 250, 600, osxBgHeight + config.iconSize + config.iconSize / 2 + 25);
        config.yCoordOfArrow = osxBgHeight + config.iconSize / 2 + 7;
        config.locations = new DSConfig.FileLocation[]{new DSConfig.FileLocation("Applications", new Point(450, config.yCoordOfArrow)), new DSConfig.FileLocation(bundleName + ".app", new Point(160, config.yCoordOfArrow))};
        config.dmgName = shortBundleName;
        return config;
    }

    private static void setVersionInfo(File temporaryLauncher) {
        JWrapperCompiler.setVersionInfo(temporaryLauncher, null);
    }

    private static void setVersionInfo(File temporaryLauncher, String overrideDescription) {
        try {
            if (OS.isWindows() && versionInfo != null) {
                File verpatch = new File(WINDOWS_WRAPPERS_DIR, "verpatch.exe");
                ArrayList<String> command = new ArrayList<String>();
                command.add(verpatch.getCanonicalPath());
                command.add(temporaryLauncher.getCanonicalPath());
                command.add("/va");
                if (JWrapperCompiler.versionInfo.fileVersion != null) {
                    command.add(JWrapperCompiler.versionInfo.fileVersion);
                } else {
                    command.add("0.0.0.0");
                }
                if (overrideDescription != null) {
                    command.add("/s");
                    command.add("desc");
                    command.add(overrideDescription);
                } else if (JWrapperCompiler.versionInfo.appDescription != null) {
                    command.add("/s");
                    command.add("desc");
                    command.add(JWrapperCompiler.versionInfo.appDescription);
                }
                if (JWrapperCompiler.versionInfo.appName != null) {
                    command.add("/s");
                    command.add("ProductName");
                    command.add(JWrapperCompiler.versionInfo.appName);
                }
                if (JWrapperCompiler.versionInfo.companyName != null) {
                    command.add("/s");
                    command.add("Company");
                    command.add(JWrapperCompiler.versionInfo.companyName);
                }
                if (JWrapperCompiler.versionInfo.productVersion != null) {
                    command.add("/pv");
                    command.add(JWrapperCompiler.versionInfo.productVersion);
                }
                always.println("[VerPatch] " + command);
                ProcessBuilder verpatchLauncher = new ProcessBuilder(new String[0]);
                verpatchLauncher.command(command);
                Process p = verpatchLauncher.start();
                new ProcessPrinter(p, always, always);
                int retCode = p.waitFor();
                always.println("[VerPatch] Setting the version info returned " + retCode);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void appendTailToWrapperOrLauncher(File sourceToAppendTailTo, byte[] paramBlock, String bundleName, int splashMinMS, boolean canOverrideSplash, String rsaDerEncodedPublicKey, String installType, String silentInstallParameter, String updateURL) throws IOException {
        BufferedOutputStream lout = new BufferedOutputStream(new FileOutputStream(sourceToAppendTailTo, true));
        if (paramBlock != null) {
            ((OutputStream)lout).write(paramBlock);
        }
        ((OutputStream)lout).write(marker);
        CFriendlyStreamUtils.writeString(lout, bundleName);
        CFriendlyStreamUtils.writeString(lout, "");
        CFriendlyStreamUtils.writeString(lout, "");
        CFriendlyStreamUtils.writeString(lout, "");
        CFriendlyStreamUtils.writeString(lout, "" + splashMinMS);
        CFriendlyStreamUtils.writeString(lout, rsaDerEncodedPublicKey);
        if (canOverrideSplash) {
            CFriendlyStreamUtils.writeString(lout, "1");
        } else {
            CFriendlyStreamUtils.writeString(lout, "0");
        }
        CFriendlyStreamUtils.writeString(lout, installType);
        if (silentInstallParameter != null) {
            CFriendlyStreamUtils.writeString(lout, silentInstallParameter);
        } else {
            CFriendlyStreamUtils.writeString(lout, "");
        }
        CFriendlyStreamUtils.writeString(lout, "" + JWrapperCompiler.getRequiredJavaVersion());
        CFriendlyStreamUtils.writeString(lout, updateURL);
        ((OutputStream)lout).close();
    }

    private static File setupCACerts(File build, File cacertsFile) throws IOException {
        if (cacertsFile == null) {
            always.println("[JWrapperCompiler] NULL CACerts - creating an empty one");
            cacertsFile = new File(build, "cacerts");
            if (!cacertsFile.exists()) {
                cacertsFile.createNewFile();
            }
        } else {
            File old = cacertsFile;
            cacertsFile = new File(build, "cacerts");
            FileUtil.copy(old, cacertsFile);
            always.println("[JWrapperCompiler] Copied CACerts contents (new size is " + cacertsFile.length() + ")");
        }
        return cacertsFile;
    }

    public static BufferedImage createSplashImage(File wrappers, String splashPNG, boolean midSplash) throws Exception {
        byte[] jwComBytes;
        byte[] jwSplashBytes;
        Color greybg = new Color(228, 228, 228);
        if (midSplash) {
            jwSplashBytes = JWSplash.COSPLASH((File)wrappers);
            jwComBytes = JWSplash.JWCOM((File)wrappers);
        } else {
            jwSplashBytes = JWSplash.FREESPLASH((File)wrappers);
            jwComBytes = JWSplash.JWCOM((File)wrappers);
        }
        BufferedImage jwSplashImage = ImageIO.read(new ByteArrayInputStream(jwSplashBytes));
        BufferedImage jwComImage = ImageIO.read(new ByteArrayInputStream(jwComBytes));
        BufferedImage userImage = ImageHelper.toBufferedImageARGB(ImageIO.read(new ByteArrayInputStream(FileUtil.readFile(splashPNG))));
        int maxUserImageWidth = 550;
        int maxUserImageHeight = 300;
        userImage = ImageHelper.scaleDownProportionallyToFitInside(userImage, maxUserImageWidth, maxUserImageHeight, false);
        int addW = (int)((double)userImage.getWidth(null) * 0.1);
        int addH = (int)((double)userImage.getHeight(null) * 0.1);
        addH = addW = Math.min(addW, addH);
        userImage = ImageHelper.addBorder(userImage, Color.white, new Insets(addH, addW, addH, addW));
        int dotComHeight = 10;
        int jwHeight = midSplash ? 55 : 120;
        int whiteHeight = userImage.getHeight();
        int minWhiteHeight = jwHeight + dotComHeight;
        whiteHeight = Math.max(whiteHeight, minWhiteHeight);
        int targetImageWidth = 600;
        int targetImageHeight = whiteHeight + jwHeight + dotComHeight;
        boolean whiteY = false;
        int jwY = targetImageHeight - jwHeight - dotComHeight;
        int dotComY = targetImageHeight - dotComHeight;
        BufferedImage result = new BufferedImage(targetImageWidth, targetImageHeight, 2);
        Graphics2D g = result.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, result.getWidth(), whiteHeight);
        g.setColor(greybg);
        g.fillRect(0, jwY, result.getWidth(), jwHeight);
        g.setColor(greybg);
        g.fillRect(0, dotComY, result.getWidth(), dotComHeight);
        jwSplashImage = ImageHelper.scaleDownProportionallyToFitInside(jwSplashImage, targetImageWidth, jwHeight, false);
        g.drawImage((Image)userImage, targetImageWidth / 2 - userImage.getWidth() / 2, (whiteHeight - userImage.getHeight()) / 2, null);
        int y = jwY + (jwHeight - jwSplashImage.getHeight(null)) / 2;
        if (midSplash) {
            y += 5;
        }
        g.drawImage((Image)jwSplashImage, targetImageWidth / 2 - jwSplashImage.getWidth(null) / 2, y, null);
        Insets dotComBorder = new Insets(3, 3, 3, 3);
        g.drawImage((Image)jwComImage, targetImageWidth - jwComImage.getWidth() - dotComBorder.right, targetImageHeight - jwComImage.getHeight() - dotComBorder.bottom, null);
        g.dispose();
        return result;
    }

    public static String normaliseID(String bundleName) {
        return JWConstants.normaliseID(bundleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllToNewTGZ(File dest, File[] files, int compressionLevel) throws IOException {
        LevelGzipOutputStream gout = new LevelGzipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dest)), compressionLevel);
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dest)));
        try {
            for (File file : files) {
                JWrapperCompiler.addAllToTar(out, file, "");
            }
        }
        finally {
            out.close();
            gout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllToNewTar(File dest, File[] files) throws IOException {
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dest)));
        try {
            for (File file : files) {
                JWrapperCompiler.addAllToTar(out, file, "");
            }
        }
        finally {
            out.close();
        }
    }

    private static void addAllToTar(TarArchiveOutputStream out, File file, String mypath) throws IOException {
        if (file.isDirectory()) {
            if (file.getName().equals("CVS")) {
                return;
            }
            TarArchiveEntry ze = new TarArchiveEntry(mypath + file.getName() + "/");
            ze.setMode(509);
            out.putArchiveEntry((ArchiveEntry)ze);
            out.closeArchiveEntry();
            String subpath = mypath + file.getName() + "/";
            File[] files = file.listFiles();
            if (files != null) {
                for (File file1 : files) {
                    JWrapperCompiler.addAllToTar(out, file1, subpath);
                }
            }
        } else {
            int len;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            TarArchiveEntry ze = new TarArchiveEntry(mypath + file.getName());
            String name = file.getName();
            if (name.endsWith("JavaApplicationStub") || name.endsWith(".exe") || name.endsWith("java") || name.endsWith(".sh")) {
                System.out.println("Making executable: " + name);
                ze.setMode(509);
            } else {
                ze.setMode(511);
            }
            ze.setSize(file.length());
            out.putArchiveEntry((ArchiveEntry)ze);
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeArchiveEntry();
            ((InputStream)in).close();
        }
    }

    public static void addFilesToExistingZip(File srcFile, File destZip, File[] files) throws IOException {
        ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destZip)));
        ZipArchiveInputStream zin = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile)));
        ZipArchiveEntry entry = zin.getNextZipEntry();
        while (entry != null) {
            int len;
            String name = entry.getName();
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(name));
            while ((len = zin.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            entry = zin.getNextZipEntry();
        }
        zin.close();
        for (File file : files) {
            int len;
            if (file.getName().equals("CVS")) continue;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(file.getName()));
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeArchiveEntry();
            ((InputStream)in).close();
        }
        out.close();
    }

    static {
        buildMacOS64Wrappers = true;
        buildLinux64Wrappers = true;
        buildWindows64Wrappers = true;
        buildMacOS32Wrappers = true;
        buildLinux32Wrappers = true;
        buildWindows32Wrappers = true;
        buildLinuxARM32Wrappers = true;
        skipTimestamping = false;
        versionInfo = new AppVersionInfo();
        totalSigningTime = 0L;
        simulateHighJavaVersion = false;
        buf = new byte[64000];
    }

    static class WindowsLauncherArchiveListener
    implements Archive.ArchiveListener {
        boolean found = false;

        WindowsLauncherArchiveListener() {
        }

        public void p200Archive(String path, long len) {
        }

        public void folder(String readString) {
        }

        public void file(String path, long len) {
            if (path.contains("windowslauncher.exe") || path.contains("windowslauncher_64.exe")) {
                this.found = true;
            }
        }
    }

    static class FailException
    extends Exception {
        public FailException(String s) {
            super(s);
        }
    }

    static class UpdateCheck
    extends Thread {
        UpdateCheck() {
        }

        public void run() {
            always.println("[Updates] Checking for updates...");
            try {
                URL url = new URL("http://simple-help.com/media/static/jwrapper/version.html");
                String val = StreamUtils.readAllAsString(url.openStream());
                CharStack cs = new CharStack(val);
                cs.popUntil("LATEST_BUILD_");
                long version = (long)cs.popNumber();
                long mine = Long.parseLong(GenericUpdater.GetVersion());
                always.println("[Updates] Update check: " + mine + " vs " + version + " (online)");
                if (version > mine) {
                    always.println("[Updates] *********************************************");
                    always.println("[Updates] *           NEW VERSION AVAILABLE           *");
                    always.println("[Updates] *********************************************");
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    static class AppVersionInfo {
        String fileVersion;
        String appDescription;
        String appName;
        String companyName;
        String productVersion;

        AppVersionInfo() {
        }
    }

    static class BuildConfig {
        private final boolean doBuild;
        private final int bits;
        private final String description;
        private final String jreApp;
        private final String wrapperSourceName;
        private final String lzmaSourceName;
        private final File wrapperFolder;

        public BuildConfig(int bits, String description, boolean doBuild, String jreApp, String wrapperName, String lzmaSourceName, File wrapperFolder) {
            this.bits = bits;
            this.description = description;
            this.doBuild = doBuild;
            this.jreApp = jreApp;
            this.wrapperSourceName = wrapperName;
            this.lzmaSourceName = lzmaSourceName;
            this.wrapperFolder = wrapperFolder;
        }

        public File getLZMASourceFile() {
            return new File(this.wrapperFolder, this.lzmaSourceName);
        }

        public File getWrapperFile(boolean includesu) {
            if (includesu) {
                return new File(this.wrapperFolder, this.wrapperSourceName + "_su");
            }
            return new File(this.wrapperFolder, this.wrapperSourceName);
        }

        public boolean isARM() {
            return this.description.toLowerCase().contains("arm");
        }
    }
}

