/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import javax.swing.JPanel;

public class CustomProgressBar
extends JPanel {
    protected static final Color BACKGROUND = Color.WHITE;
    protected static Color BORDERCOLOR = new Color(80, 129, 190);
    protected static Color TEXTCOLOR = new Color(30, 30, 30);
    protected static Color SHADE_TOP = new Color(185, 225, 247);
    protected static Color SHADE_BOTTOM = new Color(157, 199, 230);
    private int value;
    private int min;
    private int max;
    private Dimension dim;
    private String text = "";
    private String postfix = "";

    public CustomProgressBar(int min, int max, Color background) {
        this.min = min;
        this.max = max;
        this.dim = new Dimension();
        this.dim.height = 22;
        this.dim.width = 500;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPostFixText(String postfix) {
        this.postfix = postfix;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        float frac = (float)this.value / (float)(this.max - this.min);
        Graphics2D g2d = (Graphics2D)g;
        int totalWidth = this.getWidth();
        int totalHeight = this.getHeight();
        int leftBuffer = Math.max(0, (totalWidth - this.getWidth()) / 2) + 4;
        int buffer = 2;
        int fullWidth = (int)(frac * (float)(totalWidth - 2 * leftBuffer - 3));
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(BACKGROUND);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(BORDERCOLOR);
        g2d.drawRect(leftBuffer, 0, totalWidth - 2 * leftBuffer, this.getHeight() - 1);
        GradientPaint gp1 = new GradientPaint(leftBuffer, buffer, SHADE_TOP, leftBuffer, totalHeight - 2 * buffer, SHADE_BOTTOM);
        g2d.setPaint(gp1);
        g2d.fillRect(leftBuffer + buffer, buffer, fullWidth, totalHeight - 2 * buffer);
        g2d.setColor(TEXTCOLOR);
        Font font = Font.decode("SansSerif-BOLD-10");
        g2d.setFont(font);
        String textToShow = this.text + " ";
        TextLayout tl = new TextLayout(textToShow, font, g2d.getFontRenderContext());
        tl.draw(g2d, (float)((double)this.getWidth() - tl.getBounds().getWidth()) / 2.0f, (float)((double)this.getHeight() + tl.getBounds().getHeight()) / 2.0f - 1.0f);
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public Dimension getMaximumSize() {
        return this.dim;
    }

    public Dimension getMinimumSize() {
        return this.dim;
    }
}

