/*
 * Decompiled with CFR 0.152.
 */
package jpty.linux;

import jpty.JPty;
import jpty.NativeMethods;
import jpty.Termios;
import jwrapper.jwutils.pty.WinSize;

public class JPtyImplLinux
implements JPty.JPtyInterface {
    private static final int TIOCGWINSZ = 21523;
    private static final int TIOCSWINSZ = 21524;

    public JPtyImplLinux() {
        JPty.ONLCR = 4;
        JPty.VINTR = 0;
        JPty.VQUIT = 1;
        JPty.VERASE = 2;
        JPty.VKILL = 3;
        JPty.VSUSP = 10;
        JPty.VREPRINT = 12;
        JPty.VWERASE = 14;
        JPty.ECHOKE = 1;
        JPty.ECHOCTL = 64;
    }

    @Override
    public int execve(String command, String[] argv, String[] env) {
        return NativeMethods.execve(command, argv, env);
    }

    @Override
    public int forkpty(int[] amaster, byte[] name, Termios term, WinSize win) {
        return NativeMethods.forkpty(amaster, name, null, null);
    }

    @Override
    public int getWinSize(int fd, WinSize winSize) {
        int r = NativeMethods.ioctlGetWinSize(fd, winSize);
        if (r < 0) {
            return r;
        }
        return r;
    }

    @Override
    public int kill(int pid, int signal) {
        return NativeMethods.kill(pid, signal);
    }

    @Override
    public int setWinSize(int fd, WinSize winSize) {
        return NativeMethods.ioctlSetWinSize(fd, winSize);
    }

    @Override
    public int waitpid(int pid, int[] stat, int options) {
        return NativeMethods.waitpid(pid, stat, options);
    }
}

