/*
 * Decompiled with CFR 0.152.
 */
package jpty;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jpty.Constants;
import jpty.JPty;
import jpty.NativeMethods;
import jwrapper.jwutils.pty.WinSize;

public final class Pty
implements Closeable {
    private volatile int m_childPid;
    private volatile int m_fdMaster;
    private volatile InputStream m_masterIS;
    private volatile OutputStream m_masterOS;

    Pty(int fdMaster, int childPid) {
        this.m_fdMaster = fdMaster;
        this.m_childPid = childPid;
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean terminateChild) throws IOException {
        int fd = this.m_fdMaster;
        int childPid = this.m_childPid;
        this.m_fdMaster = -1;
        this.m_childPid = -1;
        if (fd != -1) {
            int err;
            int flags = NativeMethods.fcntl(fd, Constants.F_GETFL, 0);
            NativeMethods.fcntl(fd, Constants.F_SETFL, flags |= Constants.O_NONBLOCK);
            if (terminateChild && JPty.isProcessAlive(childPid)) {
                JPty.signal(childPid, JPty.SIGKILL);
            }
            if ((err = NativeMethods.close(fd)) != 0) {
                throw new IOException("Failed to close pseudoterminal!");
            }
            this.m_masterIS = Pty.closeSilently(this.m_masterIS);
            this.m_masterOS = Pty.closeSilently(this.m_masterOS);
        }
    }

    public InputStream getInputStream() {
        this.checkState();
        if (this.m_masterIS != null) {
            return this.m_masterIS;
        }
        this.m_masterIS = new InputStream(){

            @Override
            public int available() throws IOException {
                Pty.this.checkState();
                int[] available = new int[]{0};
                if (NativeMethods.ioctlAvailable(Pty.this.m_fdMaster, available) < 0) {
                    this.close();
                    throw new EOFException();
                }
                return available[0];
            }

            @Override
            public void close() throws IOException {
                Pty.this.checkState();
                super.close();
            }

            @Override
            public int read() throws IOException {
                Pty.this.checkState();
                byte[] b = new byte[1];
                int read = this.read(b, 0, 1);
                return read == 1 ? b[0] & 0xFF : -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                Pty.this.checkState();
                int read = NativeMethods.read(Pty.this.m_fdMaster, b, len);
                if (read == 0) {
                    return -1;
                }
                if (read < 0) {
                    Pty.this.closeWithException("I/O read failed with errno #" + NativeMethods.errno() + "!");
                }
                return read;
            }
        };
        return this.m_masterIS;
    }

    public OutputStream getOutputStream() {
        this.checkState();
        if (this.m_masterOS != null) {
            return this.m_masterOS;
        }
        this.m_masterOS = new OutputStream(){
            private final byte[] m_buffer = new byte[2048];

            @Override
            public void close() throws IOException {
                Pty.this.checkState();
                super.close();
            }

            @Override
            public void flush() throws IOException {
                Pty.this.checkState();
                if (NativeMethods.tcdrain(Pty.this.m_fdMaster) < 0) {
                    Pty.this.closeWithException("I/O flush failed with errno #" + NativeMethods.errno() + "!");
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                Pty.this.checkState();
                while (len > 0) {
                    int n = Math.min(len, Math.min(this.m_buffer.length, b.length - off));
                    if (off > 0) {
                        System.arraycopy(b, off, this.m_buffer, 0, n);
                        n = NativeMethods.write(Pty.this.m_fdMaster, this.m_buffer, n);
                    } else {
                        n = NativeMethods.write(Pty.this.m_fdMaster, b, n);
                    }
                    if (n < 0) {
                        Pty.this.closeWithException("I/O write failed with errno #" + NativeMethods.errno() + "!");
                    }
                    len -= n;
                    off += n;
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }
        };
        return this.m_masterOS;
    }

    public WinSize getWinSize() throws IOException {
        WinSize result = new WinSize();
        if (JPty.getWinSize(this.m_fdMaster, result) < 0) {
            throw new IOException("Failed to get window size: " + JPty.errno());
        }
        return result;
    }

    public boolean isChildAlive() {
        return JPty.isProcessAlive(this.m_childPid);
    }

    public void setWinSize(WinSize winSize) throws IOException {
        System.out.println("setWinSize for " + this.m_fdMaster);
        if (winSize == null) {
            throw new IllegalArgumentException("WinSize cannot be null!");
        }
        if (JPty.setWinSize(this.m_fdMaster, winSize) < 0) {
            throw new IOException("Failed to set window size: " + JPty.errno());
        }
    }

    public int waitFor() throws InterruptedException {
        if (this.m_childPid < 0) {
            return -1;
        }
        int[] stat = new int[]{-1};
        JPty.waitpid(this.m_childPid, stat, 0);
        return stat[0];
    }

    void checkState() {
        if (this.m_fdMaster < 0) {
            throw new IllegalStateException("Invalid file descriptor; PTY already closed?!");
        }
    }

    void closeWithException(String msg) throws IOException {
        IOException cause = null;
        try {
            this.close();
        }
        catch (IOException suppressed) {
            cause = suppressed;
        }
        IOException ex = new IOException(msg);
        ex.initCause(cause);
        throw ex;
    }

    static <T extends Closeable> T closeSilently(T resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

