/*
 * Decompiled with CFR 0.152.
 */
package com.jw;

import jwrapper.AsyncAuxDownloader;
import utils.ostools.OS;

public class AuxConfig {
    private static final String AUX_WINDOWS_32 = "winutils32";
    private static final String AUX_WINDOWS_64 = "winutils64";
    private static final String AUX_LINUX_32 = "linutils32";
    private static final String AUX_LINUX_64 = "linutils64";
    private static final String AUX_MAC_32 = "macutils32";
    private static final String AUX_MAC_64 = "macutils64";
    private static final String AUX_LINUX_32_ARM = "linutils32";

    private static String getAuxDownloadName() {
        boolean is64Bit = System.getProperty("os.arch").contains("64");
        if (OS.isMacOS()) {
            if (is64Bit) {
                return AUX_MAC_64;
            }
            return AUX_MAC_32;
        }
        if (OS.isWindows()) {
            if (is64Bit) {
                return AUX_WINDOWS_64;
            }
            return AUX_WINDOWS_32;
        }
        if (OS.isARM()) {
            return null;
        }
        if (OS.isLinux()) {
            if (is64Bit) {
                return AUX_LINUX_64;
            }
            return "linutils32";
        }
        return null;
    }

    public static void initAuxDownload() {
        AsyncAuxDownloader.startAuxiliaryArchiveFetch(AuxConfig.getAuxDownloadName());
    }

    public static void blockUntilAuxDownloaded() {
        try {
            AsyncAuxDownloader.blockUntilDownloaderFinishes(AuxConfig.getAuxDownloadName());
        }
        catch (AsyncAuxDownloader.NoSuchDownloaderException e) {
            e.printStackTrace();
        }
    }
}

