/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal;

import com.grahamedgecombe.jterminal.TerminalCell;
import com.grahamedgecombe.jterminal.TerminalModel;
import com.grahamedgecombe.jterminal.vt100.Vt100TerminalModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class JTerminal
implements FocusListener,
Vt100TerminalModel.TerminalScroller {
    public static final int BORDER_WIDTH = 3;
    public static final int CELL_WIDTH = SimpleHelpLookAndFeel.scale(8);
    public static final int CELL_HEIGHT = SimpleHelpLookAndFeel.scale(14);
    JComponent rootComponent = new JPanel();
    Point dragStart = null;
    Point dragEnd = null;
    private boolean dragging = false;
    private TerminalCell dragStartCell;
    private TerminalCell dragEndCell;
    static Font font;
    private static final long serialVersionUID = 2871625194146986567L;
    private JScrollBar scrollBar;
    private TerminalModel model;
    private Terminal terminal;

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void updateScrollBar() {
        if (this.scrollBar != null) {
            int start = this.scrollBar.getValue();
            int cursorRow = this.model.getCursorRow();
            int minVisibleRow = start;
            int endVisibleRow = minVisibleRow + this.model.getRows();
            this.scrollBar.setMaximum(Math.min(this.model.getBufferSize(), this.model.getCursorRow()));
            this.scrollBar.setVisibleAmount(endVisibleRow - minVisibleRow - 1);
            if (cursorRow >= endVisibleRow) {
                this.scrollBar.setValue(Math.max(0, cursorRow - this.model.getRows() + 1));
            } else if (cursorRow < minVisibleRow) {
                this.scrollBar.setValue(cursorRow);
            }
        }
    }

    private static Font loadFont() {
        if (font != null) {
            return font;
        }
        try {
            font = new Font("Monospaced", 0, CELL_HEIGHT - 2);
        }
        catch (Throwable t) {
            t.printStackTrace();
            font = new Font("Monospaced", 0, CELL_HEIGHT - 2);
        }
        return font;
    }

    public JTerminal() {
        this(new Vt100TerminalModel());
    }

    public JTerminal(TerminalModel model) {
        this.setModel(model);
        if (model instanceof Vt100TerminalModel) {
            ((Vt100TerminalModel)model).setTerminalScroller(this);
        }
        this.init();
    }

    private void init() {
        this.rootComponent.setLayout(new BorderLayout(0, 0));
        this.rootComponent.addFocusListener(this);
        int rows = this.model.getRows();
        int bufferSize = this.model.getBufferSize();
        if (bufferSize > rows) {
            this.scrollBar = new JScrollBar(1, 0, rows, 0, bufferSize + 1);
            this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent evt) {
                    JTerminal.this.rootComponent.repaint();
                }
            });
            this.rootComponent.add("After", this.scrollBar);
        }
        this.terminal = new Terminal();
        this.terminal.setFocusTraversalKeysEnabled(false);
        this.terminal.addFocusListener(this);
        JPanel padded = new JPanel(new GridLayout(1, 1));
        padded.setBorder(SHBorderFactory.createLineBorder(this.model.getDefaultBackgroundColor(), 3));
        padded.add(this.terminal);
        this.rootComponent.add("Center", padded);
        this.rootComponent.repaint();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public TerminalModel getModel() {
        return this.model;
    }

    public void setModel(TerminalModel model) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        this.model = model;
    }

    public void println(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.print(str.concat("\r\n"));
    }

    public void print(String str) {
        if (!this.dragging) {
            this.clearSelection();
        }
        this.model.print(str);
    }

    private void clearSelection() {
        this.dragStart = null;
        this.dragEnd = null;
        this.dragStartCell = null;
        this.dragEndCell = null;
        this.rootComponent.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.rootComponent) {
            System.out.println("[JTerminal:Root] Focus Gained.");
            this.getTerminal().requestFocusInWindow();
        } else {
            System.out.println("[JTerminal:Term] Focus Gained.");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.rootComponent) {
            System.out.println("[JTerminal:Root] Focus Lost.");
        } else {
            System.out.println("[JTerminal:Term] Focus Lost.");
        }
    }

    public String getSelectionText() {
        if (this.dragStart == null || this.dragEnd == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int start = this.scrollBar == null ? 0 : this.scrollBar.getValue();
        int columnStart = this.dragStart.x / CELL_WIDTH;
        int rowStart = start + this.dragStart.y / CELL_HEIGHT;
        int columnEnd = this.dragEnd.x / CELL_WIDTH;
        int rowEnd = start + this.dragEnd.y / CELL_HEIGHT;
        for (int row = rowStart; row <= rowEnd; ++row) {
            int colBegin = 0;
            int colEnd = this.model.getColumns();
            if (row == rowStart) {
                colBegin = columnStart;
            }
            if (row == rowEnd) {
                colEnd = columnEnd + 1;
            }
            for (int col = colBegin; col < colEnd; ++col) {
                buffer.append(this.model.getCell(col, row).getCharacter());
            }
        }
        this.clearSelection();
        return buffer.toString();
    }

    static /* synthetic */ Font access$000() {
        return JTerminal.loadFont();
    }

    public class Terminal
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private final Font font = JTerminal.access$000();
        private static final long serialVersionUID = 8832602559840777008L;

        private Terminal() {
            this.setDoubleBuffered(true);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(JTerminal.this.model.getColumns() * CELL_WIDTH, JTerminal.this.model.getRows() * CELL_HEIGHT);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(JTerminal.this.model.getDefaultBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setFont(this.font);
            JTerminal.this.model.lock();
            try {
                int width = JTerminal.this.model.getColumns();
                int height = JTerminal.this.model.getRows();
                g.setColor(JTerminal.this.model.getDefaultBackgroundColor());
                g.fillRect(0, 0, width * CELL_WIDTH, height * CELL_HEIGHT);
                int start = JTerminal.this.scrollBar == null ? 0 : JTerminal.this.scrollBar.getValue();
                boolean select = false;
                for (int y = start; y < start + height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        boolean cursorHere;
                        TerminalCell cell = JTerminal.this.model.getCell(x, y);
                        if (cell != null && JTerminal.this.dragStartCell != null && cell.equals(JTerminal.this.dragStartCell)) {
                            select = !select;
                        }
                        boolean bl = cursorHere = JTerminal.this.model.getCursorRow() == y && JTerminal.this.model.getCursorColumn() == x;
                        if (cursorHere && cell == null) {
                            cell = new TerminalCell(' ', JTerminal.this.model.getDefaultBackgroundColor(), JTerminal.this.model.getDefaultForegroundColor());
                        }
                        if (cell == null) continue;
                        int px = x * CELL_WIDTH;
                        int py = (y - start) * CELL_HEIGHT - 1;
                        g.setColor(cursorHere ? cell.getForegroundColor() : cell.getBackgroundColor());
                        if (select) {
                            g.setColor(new Color(82, 82, 82));
                        }
                        g.fillRect(px, py, CELL_WIDTH, CELL_HEIGHT);
                        int baseline = g.getFontMetrics().getLeading() + g.getFontMetrics().getAscent();
                        int descent = g.getFontMetrics().getDescent();
                        g.setColor(cursorHere ? cell.getBackgroundColor() : cell.getForegroundColor());
                        g.drawChars(new char[]{cell.getCharacter()}, 0, 1, px, py + (CELL_HEIGHT - descent));
                        if (JTerminal.this.dragEndCell == null || !cell.equals(JTerminal.this.dragEndCell)) continue;
                        select = !select;
                    }
                }
            }
            finally {
                JTerminal.this.model.unlock();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTerminal.this.dragStart = e.getPoint();
            JTerminal.this.dragging = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTerminal.this.dragging = false;
            if (e.getClickCount() == 3) {
                JTerminal.this.dragStart.x = 0;
                JTerminal.this.dragEnd = new Point(JTerminal.this.dragStart);
                int column = this.xToColumn(JTerminal.this.dragStart.x);
                int row = this.yToRow(JTerminal.this.dragStart.y);
                for (int i = column; i < JTerminal.this.getModel().getColumns(); ++i) {
                    if (JTerminal.this.getModel().getCell(i, row) == null) continue;
                    JTerminal.this.dragEnd.x = i * CELL_WIDTH + 1;
                }
                this.updateSelection();
                this.repaint();
            } else if (e.getClickCount() == 2) {
                TerminalCell terminalCell;
                JTerminal.this.dragEnd = new Point(JTerminal.this.dragStart);
                int rightX = JTerminal.this.dragStart.x;
                for (int leftX = JTerminal.this.dragStart.x; leftX >= 0 && (terminalCell = this.pointToCell(new Point(leftX, JTerminal.this.dragStart.y))) != null && Character.isLetterOrDigit(terminalCell.getCharacter()); leftX -= CELL_WIDTH) {
                    JTerminal.this.dragStart.x = leftX;
                }
                while (rightX < JTerminal.this.model.getColumns() * CELL_WIDTH - 1 && (terminalCell = this.pointToCell(new Point(rightX, JTerminal.this.dragEnd.y))) != null && Character.isLetterOrDigit(terminalCell.getCharacter())) {
                    JTerminal.this.dragEnd.x = rightX;
                    rightX += CELL_WIDTH;
                }
                this.updateSelection();
                this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JTerminal.this.dragEnd = e.getPoint();
            this.updateSelection();
            this.repaint();
        }

        private void updateSelection() {
            TerminalCell tmp = this.pointToCell(JTerminal.this.dragStart);
            if (tmp != null) {
                JTerminal.this.dragStartCell = tmp;
            }
            if ((tmp = this.pointToCell(JTerminal.this.dragEnd)) != null) {
                JTerminal.this.dragEndCell = tmp;
            }
        }

        private TerminalCell pointToCell(Point dragPoint) {
            return JTerminal.this.model.getCell(this.xToColumn(dragPoint.x), this.yToRow(dragPoint.y));
        }

        private int yToRow(int y) {
            int start = JTerminal.this.scrollBar == null ? 0 : JTerminal.this.scrollBar.getValue();
            return start + y / CELL_HEIGHT;
        }

        private int xToColumn(int x) {
            return x / CELL_WIDTH;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

