/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.multiplex;

import com.aem.utils.StreamUtils;
import com.aem.utils.multiplex.MultiplexerByteInputStream;
import com.aem.utils.multiplex.MultiplexingInput;
import com.aem.utils.mutex.UnqueuedMutex;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class MultiplexerInputStream
implements MultiplexingInput {
    InputStream instream;
    Object lock = new Object();
    Object notifier = new Object();
    HashMap instreams = new HashMap();
    HashMap locks = new HashMap();
    boolean closed = false;
    IOException ioexception;
    int MAXBUF = 200000;
    boolean printBufferFills = false;

    private void checkIoException(String err) throws IOException {
        if (this.ioexception != null) {
            IOException tmp = new IOException(err);
            tmp.initCause(this.ioexception);
            throw tmp;
        }
    }

    public MultiplexerInputStream(InputStream in, String readername) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    public void showBufferMaxouts(boolean b) {
        this.printBufferFills = b;
    }

    public MultiplexerInputStream(InputStream in, String readername, ThreadGroup tg) {
        this.instream = new BufferedInputStream(in);
        ReaderThread rthread = new ReaderThread(tg, readername);
        rthread.setDaemon(true);
        rthread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        this.closed = true;
        Object object = this.lock;
        synchronized (object) {
            Collection tmp = this.instreams.values();
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                ((MultiplexerByteInputStream)it.next()).setClosed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(IOException e) {
        this.closed = true;
        this.ioexception = e;
        Object object = this.lock;
        synchronized (object) {
            Collection tmp = this.instreams.values();
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                ((MultiplexerByteInputStream)it.next()).setClosed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(short n, String name) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            MultiplexerByteInputStream in = (MultiplexerByteInputStream)this.instreams.get(N);
            if (in == null) {
                in = new MultiplexerByteInputStream(this.MAXBUF, this.printBufferFills);
                this.instreams.put(N, in);
            }
            in.setName(name + "-" + N);
            if (this.closed) {
                if (this.ioexception != null) {
                    in.setClosed(this.ioexception);
                } else {
                    in.setClosed();
                }
            }
            return in;
        }
    }

    class ReaderThread
    extends Thread {
        ThreadGroup tg;

        public ReaderThread() {
            this.tg = null;
        }

        public ReaderThread(String name) {
            super(name);
            this.tg = null;
        }

        public ReaderThread(ThreadGroup tg, String name) {
            super(tg, name);
            this.tg = null;
            this.tg = tg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                short n = 0;
                byte[] dat = null;
                while (!MultiplexerInputStream.this.closed) {
                    n = StreamUtils.readShort(MultiplexerInputStream.this.instream);
                    dat = StreamUtils.readNBytes(MultiplexerInputStream.this.instream, 500000000);
                    if (dat.length <= 0) continue;
                    Integer N = new Integer(n);
                    Object object = MultiplexerInputStream.this.lock;
                    synchronized (object) {
                        MultiplexerByteInputStream in = (MultiplexerByteInputStream)MultiplexerInputStream.this.instreams.get(N);
                        if (in == null) {
                            in = new MultiplexerByteInputStream(MultiplexerInputStream.this.MAXBUF, MultiplexerInputStream.this.printBufferFills);
                            in.setName(Thread.currentThread().getName() + "-" + N);
                            MultiplexerInputStream.this.instreams.put(N, in);
                        }
                        in.addData(dat);
                    }
                }
                return;
            }
            catch (EOFException e) {
                MultiplexerInputStream.this.closeAll();
                if (this.tg == null) return;
                this.tg.uncaughtException(this, e);
                return;
            }
            catch (IOException e) {
                MultiplexerInputStream.this.closeAll(e);
                if (this.tg == null) return;
                this.tg.uncaughtException(this, e);
                return;
            }
            catch (Throwable t) {
                MultiplexerInputStream.this.closeAll(new IOException("unknown error "));
                if (this.tg == null) return;
                this.tg.uncaughtException(this, t);
            }
        }
    }
}

