/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.keyhandling;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class KeysList
implements Comparator {
    private static String[] COMMON = new String[]{"VK_ESCAPE", "VK_UP", "VK_DOWN", "VK_LEFT", "VK_RIGHT", "VK_HOME", "VK_END", "VK_PAGE_UP", "VK_PAGE_DOWN", "VK_INSERT", "VK_DELETE"};
    private static ArrayList<String[]> commonkeys;
    private static ArrayList<String[]> allkeys;
    private static HashMap<String, Integer> vkmap;

    public static HashMap<String, Integer> getVkMap() {
        KeysList.init();
        return vkmap;
    }

    public static ArrayList<String[]> getAllKeys() {
        KeysList.init();
        return allkeys;
    }

    public static ArrayList<String[]> getCommonKeys() {
        KeysList.init();
        return commonkeys;
    }

    private static String getVisibleName(String name) {
        String vis = name.substring(3);
        vis = vis.replace('_', ' ');
        vis = vis.toLowerCase().trim();
        boolean capitalise = true;
        StringBuilder cc = new StringBuilder();
        for (int k = 0; k < vis.length(); ++k) {
            char c = vis.charAt(k);
            if (capitalise) {
                capitalise = false;
                cc.append(Character.toUpperCase(c));
            } else {
                cc.append(c);
            }
            if (c != ' ') continue;
            capitalise = true;
        }
        vis = cc.toString();
        return vis;
    }

    private static void init() {
        if (allkeys == null) {
            ArrayList<String[]> tmp = new ArrayList<String[]>();
            Field[] fields = KeyEvent.class.getDeclaredFields();
            Arrays.sort(fields, new KeysList());
            for (Field field1 : fields) {
                String name = field1.getName();
                if (!name.startsWith("VK_") || name.contains("JAPAN") || name.contains("KANA") || name.contains("KANJI") || name.contains("KATAKANA") || name.contains("INPUT_METHOD_") || name.contains("UNDEFINED")) continue;
                tmp.add(new String[]{name, KeysList.getVisibleName(name)});
            }
            allkeys = tmp;
            tmp = new ArrayList();
            for (String aCOMMON : COMMON) {
                tmp.add(new String[]{aCOMMON, KeysList.getVisibleName(aCOMMON)});
            }
            commonkeys = tmp;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (Field field : fields) {
                try {
                    map.put(field.getName(), ((Number)field.get(null)).intValue());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            vkmap = map;
        }
    }

    public int compare(Object arg0, Object arg1) {
        Field f0 = (Field)arg0;
        Field f1 = (Field)arg1;
        return f0.getName().compareTo(f1.getName());
    }
}

