/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.crc;

import com.aem.utils.crc.Adler32CRC;
import com.aem.utils.crc.BlowfishCRC;
import com.aem.utils.crc.CRC16;
import com.aem.utils.crc.CRC32;
import com.aem.utils.crc.CRC64;
import com.aem.utils.crc.CompoundCRC;
import com.aem.utils.crc.XOR;
import java.util.Arrays;
import java.util.Random;

public abstract class CRC {
    public abstract void reset();

    public abstract byte[] getDigest();

    public abstract void add(byte var1);

    public void add(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.add(b[i]);
        }
    }

    public void add(byte[] b, int off, int len) {
        len += off;
        for (int i = off; i < len; ++i) {
            this.add(b[i]);
        }
    }

    public void add(int n) {
        this.add((byte)(n >>> 24 & 0xFF));
        this.add((byte)(n >>> 16 & 0xFF));
        this.add((byte)(n >>> 8 & 0xFF));
        this.add((byte)(n & 0xFF));
    }

    public void add(long n) {
        this.add((byte)(n >>> 56 & 0xFFL));
        this.add((byte)(n >>> 48 & 0xFFL));
        this.add((byte)(n >>> 40 & 0xFFL));
        this.add((byte)(n >>> 32 & 0xFFL));
        this.add((byte)(n >>> 24 & 0xFFL));
        this.add((byte)(n >>> 16 & 0xFFL));
        this.add((byte)(n >>> 8 & 0xFFL));
        this.add((byte)(n & 0xFFL));
    }

    public static void main(String[] args) {
        CRC[] crcs = new CRC[]{new XOR(), new CRC16(), new CRC32(), new CRC64(), new CompoundCRC(), new Adler32CRC(), new BlowfishCRC(4)};
        for (int i = 0; i < crcs.length; ++i) {
            CRC.test(crcs[i]);
        }
    }

    private static boolean compare(byte[] b1, byte[] b2) {
        return Arrays.equals(b1, b2);
    }

    private static byte[] getEmptyTestData(int len) {
        byte[] b = new byte[len];
        Arrays.fill(b, (byte)0);
        return b;
    }

    private static byte[] getRandomTestData(int len) {
        Random rand = new Random(len);
        byte[] b = new byte[len];
        rand.nextBytes(b);
        return b;
    }

    private static byte[] getLinearTestData(int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)i;
        }
        return b;
    }

    public static void testDigest(String name, CRC crc, int length) {
        crc.reset();
        crc.add(CRC.getEmptyTestData(length));
        byte[] b1 = crc.getDigest();
        crc.reset();
        crc.add(CRC.getEmptyTestData(length));
        byte[] b2 = crc.getDigest();
        if (!CRC.compare(b1, b2)) {
            System.out.println(name + " FAILED :" + length + " byte empty data test");
        }
        crc.reset();
        crc.add(CRC.getLinearTestData(length));
        b1 = crc.getDigest();
        crc.reset();
        crc.add(CRC.getLinearTestData(length));
        b2 = crc.getDigest();
        if (!CRC.compare(b1, b2)) {
            System.out.println(name + " FAILED :" + length + " byte linear data test");
        }
        crc.reset();
        crc.add(CRC.getRandomTestData(length));
        b1 = crc.getDigest();
        crc.reset();
        crc.add(CRC.getRandomTestData(length));
        b2 = crc.getDigest();
        if (!CRC.compare(b1, b2)) {
            System.out.println(name + " FAILED :" + length + " byte random data test");
        }
    }

    public static void testTime(String name, CRC crc, int len) {
        byte[] b = CRC.getRandomTestData(len);
        crc.reset();
        int COUNT = 4;
        long t = System.currentTimeMillis();
        for (int i = 0; i < COUNT; ++i) {
            crc.add(b);
        }
        t = System.currentTimeMillis() - t;
        System.out.println(name + " SPEED: " + len + " bytes took " + (t /= (long)COUNT) + "ms");
    }

    public static void testCollision(String name, CRC crc, int len) {
        byte[] b = crc.getDigest();
        System.out.println(name + " COLLISIONS: best case 1 collision every " + Math.pow(2.0, b.length * 8) + " CRCs");
    }

    public static void test(CRC crc) {
        String name = crc.getClass().getName();
        System.out.println("Testing CRC " + name);
        byte[] b1 = crc.getDigest();
        crc.reset();
        byte[] b2 = crc.getDigest();
        if (!CRC.compare(b1, b2)) {
            System.out.println(name + " FAILED :empty digest test");
        }
        CRC.testDigest(name, crc, 4);
        CRC.testDigest(name, crc, 8);
        CRC.testDigest(name, crc, 99);
        CRC.testDigest(name, crc, 100);
        CRC.testDigest(name, crc, 128);
        CRC.testDigest(name, crc, 1000);
        CRC.testDigest(name, crc, 1024);
        CRC.testDigest(name, crc, 10000);
        CRC.testDigest(name, crc, 99912);
        CRC.testTime(name, crc, 10000);
        CRC.testTime(name, crc, 50000);
        CRC.testTime(name, crc, 100000);
        CRC.testTime(name, crc, 1000000);
        CRC.testTime(name, crc, 5000000);
        CRC.testCollision(name, crc, 1000);
    }
}

