/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.blowfish;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class Blowfish {
    int IVL = 0;
    int IVR = 0;
    int CTR = 0;
    byte[] outlr = new byte[8];
    byte[] outbuffer = null;
    private static final int[] STATIC_ORIG_P = new int[]{608135816, -2052912941, 320440878, 57701188, -1542899678, 698298832, 137296536, -330404727, 1160258022, 953160567, -1101764913, 887688300, -1062458953, -914599715, 1065670069, -1253635817, -1843997223, -1988494565};
    private static final int[][] STATIC_ORIG_S = new int[][]{{-785314906, -1730169428, 805139163, -803545161, -1193168915, 1780907670, -1166241723, -248741991, 614570311, -1282315017, 134345442, -2054226922, 1667834072, 1901547113, -1537671517, -191677058, 227898511, 1921955416, 1904987480, -2112533778, 2069144605, -1034266187, -1674521287, 720527379, -976113629, 677414384, -901678824, -1193592593, -1904616272, 1614419982, 1822297739, -1340175810, -686458943, -1120842969, 2024746970, 1432378464, -430627341, -1437226092, 1464375394, 1676153920, 1439316330, 715854006, -1261675468, 289532110, -1588296017, 2087905683, -1276242927, 1668267050, 732546397, 1947742710, -832815594, -1685613794, -1344882125, 1814351708, 2050118529, 680887927, 999245976, 1800124847, -994056165, 1713906067, 1641548236, -81679983, 1216130144, 1575780402, -276538019, -377129551, -601480446, -345695352, 596196993, -745100091, 258830323, -2081144263, 772490370, -1534844924, 1774776394, -1642095778, 566650946, -152474470, 1728879713, -1412200208, 1783734482, -665571480, -1777359064, -1420741725, 1861159788, 326777828, -1170476976, 2130389656, -1578015459, 967770486, 1724537150, -2109534584, -1930525159, 1164943284, 2105845187, 998989502, -529566248, -2050940813, 1075463327, 1455516326, 1322494562, 910128902, 469688178, 1117454909, 936433444, -804646328, -619713837, 1240580251, 122909385, -2137449605, 634681816, -152510729, -469872614, -1233564613, -1754472259, 79693498, -1045868618, 1084186820, 1583128258, 426386531, 1761308591, 1047286709, 322548459, 995290223, 1845252383, -1691314900, -863943356, -1352745719, -1092366332, -567063811, 1712269319, 422464435, -1060394921, 1170764815, -771006663, -1177289765, 1434042557, 442511882, -694091578, 1076654713, 1738483198, -81812532, -1901729288, -617471240, 1014306527, -43947243, 793779912, -1392160085, 842905082, -48003232, 1395751752, 1040244610, -1638115397, -898659168, 445077038, -552113701, -717051658, 679411651, -1402522938, -1940957837, 1767581616, -1144366904, -503340195, -1192226400, 284835224, -48135240, 1258075500, 768725851, -1705778055, -1225243291, -762426948, 1274779536, -505548070, -1530167757, 1660621633, -823867672, -283063590, 913787905, -797008130, 737222580, -1780753843, -1366257256, -357724559, 1804850592, -795946544, -1345903136, -1908647121, -1904896841, -1879645445, -233690268, -2004305902, -1878134756, 1336762016, 1754252060, -774901359, -1280786003, 791618072, -1106372745, -361419266, -1962795103, -442446833, -1250986776, 413987798, -829824359, -1264037920, -49028937, 2093235073, -760370983, 375366246, -2137688315, -1815317740, 555357303, -424861595, 2008414854, -950779147, -73583153, -338841844, 2067696032, -700376109, -1373733303, 2428461, 544322398, 577241275, 1471733935, 610547355, -267798242, 1432588573, 1507829418, 2025931657, -648391809, 545086370, 48609733, -2094660746, 1653985193, 298326376, 1316178497, -1287180854, 2064951626, 458293330, -1705826027, -703637697, -1130641692, 727753846, -2115603456, 146436021, 1461446943, -224990101, 705550613, -1235000031, -407242314, -13368018, -981117340, 1404054877, -1449160799, 146425753, 1854211946}, {1266315497, -1246549692, -613086930, -1004984797, -1385257296, 1235738493, -1662099272, -1880247706, -324367247, 1771706367, 1449415276, -1028546847, 422970021, 1963543593, -1604775104, -468174274, 1062508698, 1531092325, 1804592342, -1711849514, -1580033017, -269995787, 1294809318, -265986623, 1289560198, -2072974554, 1669523910, 35572830, 157838143, 1052438473, 1016535060, 1802137761, 1753167236, 1386275462, -1214491899, -1437595849, 1040679964, 2145300060, -1904392980, 1461121720, -1338320329, -263189491, -266592508, 33600511, -1374882534, 1018524850, 629373528, -603381315, -779021319, 2091462646, -1808644237, 586499841, 988145025, 935516892, -927631820, -1695294041, -1455136442, 265290510, -322386114, -1535828415, -499593831, 1005194799, 847297441, 406762289, 1314163512, 1332590856, 1866599683, -167115585, 750260880, 613907577, 1450815602, -1129346641, -560302305, -644675568, -1282691566, -590397650, 1427272223, 778793252, 1343938022, -1618686585, 2052605720, 1946737175, -1130390852, -380928628, -327488454, -612033030, 1661551462, -1000029230, -283371449, 840292616, -582796489, 616741398, 312560963, 711312465, 1351876610, 322626781, 1910503582, 271666773, -2119403562, 1594956187, 70604529, -677132437, 1007753275, 1495573769, -225450259, -1745748998, -1631928532, 504708206, -2031925904, -353800271, -2045878774, 1514023603, 1998579484, 1312622330, 694541497, -1712906993, -2143385130, 1382467621, 776784248, -1676627094, -971698502, -1797068168, -1510196141, 503983604, -218673497, 907881277, 423175695, 432175456, 1378068232, -149744970, -340918674, -356311194, -474200683, -1501837181, -1317062703, 26017576, -1020076561, -1100195163, 1700274565, 1756076034, -288447217, -617638597, 720338349, 1533947780, 354530856, 688349552, -321042571, 1637815568, 332179504, -345916010, 53804574, -1442618417, -1250730864, 1282449977, -711025141, -877994476, -288586052, 1617046695, -1666491221, -1292663698, 1686838959, 431878346, -1608291911, 1700445008, 1080580658, 1009431731, 832498133, -1071531785, -1688990951, -2023776103, -1778935426, 1648197032, -130578278, -1746719369, 300782431, 375919233, 238389289, -941219882, -1763778655, 2019080857, 1475708069, 455242339, -1685863425, 448939670, -843904277, 1395535956, -1881585436, 1841049896, 1491858159, 885456874, -30872223, -293847949, 1565136089, -396052509, 1108368660, 540939232, 1173283510, -1549095958, -613658859, -87339056, -951913406, -278217803, 1699691293, 1103962373, -669091426, -2038084153, -464828566, 1031889488, -815619598, 1535977030, -58162272, -1043876189, 2132092099, 1774941330, 1199868427, 1452454533, 157007616, -1390851939, 342012276, 595725824, 1480756522, 206960106, 497939518, 591360097, 863170706, -1919713727, -698356495, 1814182875, 2094937945, -873565088, 1082520231, -831049106, -1509457788, 435703966, -386934699, 1641649973, -1452693590, -989067582, 1510255612, -2146710820, -1639679442, -1018874748, -36346107, 236887753, -613164077, 274041037, 1734335097, -479771840, -976997275, 1899903192, 1026095262, -244449504, 356393447, -1884275382, -421290197, -612127241}, {-381855128, -1803468553, -162781668, -1805047500, 1091903735, 1979897079, -1124832466, -727580568, -737663887, 857797738, 1136121015, 1342202287, 507115054, -1759230650, 337727348, -1081374656, 1301675037, -1766485585, 1895095763, 1721773893, -1078195732, 62756741, 2142006736, 835421444, -1762973773, 1442658625, -635090970, -1412822374, 676362277, 1392781812, 170690266, -373920261, 1759253602, -683120384, 1745797284, 664899054, 1329594018, -393761396, -1249058810, 2062866102, -1429332356, -751345684, -830954599, 1080764994, 553557557, -638351943, -298199125, 991055499, 499776247, 1265440854, 648242737, -354183246, 980351604, -581221582, 1749149687, -898096901, -83167922, -654396521, 1161844396, -1169648345, 0x55533A3A, 545492359, -26498633, -795437749, 1437099964, -1592419752, -861329053, -1713251533, -1507177898, 1060185593, 1593081372, -1876348548, -34019326, 69676912, -2135222948, 86519011, -1782508216, -456757982, 1220612927, -955283748, 133810670, 1090789135, 1078426020, 1569222167, 845107691, -711212847, -222510705, 1091646820, 628848692, 1613405280, -537335645, 526609435, 236106946, 48312990, -1352249391, -892239595, 1797494240, 859738849, 992217954, -289490654, -2051890674, -424014439, -562951028, 765654824, -804095931, -1783130883, 1685915746, -405998096, 1414112111, -2021832454, -1013056217, -214004450, 172450625, -1724973196, 980381355, -185008841, -1475158944, -1578377736, -1726226100, -613520627, -964995824, 1835478071, 660984891, -590288892, -248967737, -872349789, -1254551662, 1762651403, 1719377915, -824476260, -1601057013, -652910941, -1156370552, 1364962596, 2073328063, 1983633131, 926494387, -871278215, -2144935273, -198299347, 1749200295, -966120645, 309677260, 2016342300, 1779581495, -1215147545, 111262694, 1274766160, 443224088, 298511866, 1025883608, -488520759, 1145181785, 168956806, -653464466, -710153686, 1689216846, -628709281, -1094719096, 1692713982, -1648590761, -252198778, 1618508792, 1610833997, -771914938, -164094032, 2001055236, -684262196, -2092799181, -266425487, -1333771897, 1006657119, 2006996926, -1108824540, 1430667929, -1084739999, 1314452623, -220332638, -193663176, -2021016126, 1399257539, -927756684, -1267338667, 1190975929, 2062231137, -1960976508, -2073424263, -1856006686, 1181637006, 548689776, -1932175983, -922558900, -1190417183, -1149106736, 296247880, 1970579870, -1216407114, -525738999, 1714227617, -1003338189, -396747006, 166772364, 1251581989, 493813264, 448347421, 195405023, -1584991729, 677966185, -591930749, 1463355134, -1578971493, 1338867538, 1343315457, -1492745222, -1610435132, 233230375, -1694987225, 2000651841, -1017099258, 1638401717, -266896856, -1057650976, 6314154, 819756386, 300326615, 590932579, 1405279636, -1027467724, -1144263082, -1866680610, -335774303, -833020554, 1862657033, 1266418056, 963775037, 2089974820, -2031914401, 1917689273, 448879540, -744572676, -313240200, 150775221, -667058989, 1303187396, 508620638, -1318983944, -1568336679, 1817252668, 1876281319, 1457606340, 908771278, -574175177, -677760460, -1838972398, 1729034894, 1080033504}, {976866871, -738527793, -1413318857, 1522871579, 1555064734, 1336096578, -746444992, -1715692610, -720269667, -1089506539, -701686658, -956251013, -1215554709, 564236357, -1301368386, 1781952180, 1464380207, -1131123079, -962365742, 1699332808, 1393555694, 1183702653, -713881059, 1288719814, 691649499, -1447410096, -1399511320, -1101077756, -1577396752, 1781354906, 1676643554, -1702433246, -1064713544, 1126444790, -1524759638, -1661808476, -2084544070, -1679201715, -1880812208, -1167828010, 673620729, -1489356063, 1269405062, -279616791, -953159725, -145557542, 1057255273, 2012875353, -2132498155, -2018474495, -1693849939, 993977747, -376373926, -1640704105, 753973209, 36408145, -1764381638, 25011837, -774947114, 2088578344, 530523599, -1376601957, 1524020338, 1518925132, -534139791, -535190042, 1202760957, -309069157, -388774771, 674977740, -120232407, 2031300136, 2019492241, -311074731, -141160892, -472686964, 352677332, -1997247046, 60907813, 90501309, -1007968747, 1016092578, -1759044884, -1455814870, 457141659, 509813237, -174299397, 652014361, 1966332200, -1319764491, 55981186, -1967506245, 676427537, -1039476232, -1412673177, -861040033, 1307055953, 942726286, 933058658, -1826555503, -361066302, -79791154, 1361170020, 2001714738, -1464409218, -1020707514, 1222529897, 1679025792, -1565652976, -580013532, 1770335741, 151462246, -1281735158, 1682292957, 1483529935, 471910574, 1539241949, 458788160, -858652289, 1807016891, -576558466, 978976581, 1043663428, -1129001515, 1927990952, -94075717, -1922690386, -1086558393, -761535389, 1412390302, -1362987237, -162634896, 1947078029, -413461673, -126740879, -1353482915, 1077988104, 1320477388, 886195818, 18198404, -508558296, -1785185763, 112762804, -831610808, 1866414978, 891333506, 18488651, 661792760, 1628790961, -409780260, -1153795797, 876946877, -1601685023, 1372485963, 791857591, -1608533303, -534984578, -1127755274, -822013501, -1578587449, 445679433, -732971622, -790962485, -720709064, 54117162, -963561881, -1913048708, -525259953, -140617289, 1140177722, -220915201, 668550556, -1080614356, 367459370, 261225585, -1684794075, -85617823, -826893077, -1029151655, 314222801, -1228863650, -486184436, 282218597, -888953790, -521376242, 379116347, 1285071038, 846784868, -1625320142, -523005217, -744475605, -1989021154, 453669953, 1268987020, -977374944, -1015663912, -550133875, -1684459730, -435458233, 266596637, -447948204, 517658769, -832407089, -851542417, 370717030, -47440635, -2070949179, -151313767, -182193321, -1506642397, -1817692879, 1456262402, -1393524382, 1517677493, 1846949527, -1999473716, -560569710, -2118563376, 1280348187, 1908823572, -423180355, 846861322, 1172426758, -1007518822, -911584259, 1655181056, -1155153950, 901632758, 1897031941, -1308360158, -1228157060, -847864789, 1393639104, 373351379, 950779232, 625454576, -1170726756, -146354570, 2007998917, 544563296, -2050228658, -1964470824, 2058025392, 1291430526, 424198748, 50039436, 29584100, -689184263, -1865090967, -1503863136, 1057563949, -1039604065, -1219600078, -831004069, 1469046755, 985887462}};
    int[] INST_P = new int[STATIC_ORIG_P.length];
    int[][] INST_S = new int[STATIC_ORIG_S.length][STATIC_ORIG_S[0].length];
    int val32 = 0;
    private static final int[] CRC32 = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};

    public void init(String key) {
        try {
            this.init(key.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.init(key.getBytes());
        }
    }

    public void init(byte[] key) {
        long tmplong;
        int i;
        int keyLen = key.length;
        if (keyLen > 72) {
            byte[] tmp = new byte[72];
            int imod = 0;
            for (int i2 = 0; i2 < keyLen; ++i2) {
                imod = i2 % 72;
                tmp[imod] = (byte)(tmp[imod] ^ key[i2]);
            }
            key = tmp;
            keyLen = 72;
        }
        for (i = 0; i < 4; ++i) {
            System.arraycopy(STATIC_ORIG_S[i], 0, this.INST_S[i], 0, 256);
        }
        int j = 0;
        for (i = 0; i < 18; ++i) {
            int data = 0;
            for (int k = 0; k < 4; ++k) {
                data <<= 8;
                data |= key[j] & 0xFF;
                if (++j < keyLen) continue;
                j = 0;
            }
            this.INST_P[i] = STATIC_ORIG_P[i] ^ data;
        }
        int datal = 0;
        int datar = 0;
        for (i = 0; i < 18; i += 2) {
            tmplong = this.encrypt(datal, datar);
            datal = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            datar = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
            this.INST_P[i] = datal;
            this.INST_P[i + 1] = datar;
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 256; j += 2) {
                tmplong = this.encrypt(datal, datar);
                datal = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                datar = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                this.INST_S[i][j] = datal;
                this.INST_S[i][j + 1] = datar;
            }
        }
        this.IVL = 0;
        this.IVR = 0;
        this.CTR = 0;
    }

    public boolean test(String key) {
        int L = 1;
        int R = 2;
        this.init(key);
        long tmplong = this.encrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        tmplong = this.decrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        return L == 1 && R == 2;
    }

    public boolean test() {
        int L = 1;
        int R = 2;
        this.test("!@#$%^&*()_+=<>?:'\"{}|[]\\`~");
        this.init("TESTKEY");
        long tmplong = this.encrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        if (L != -550289454 || R != 816257972) {
            return false;
        }
        tmplong = this.decrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        if (L != 1 || R != 2) {
            return false;
        }
        return this.test(0L, 0L, 5690745928405278072L) && this.test(-1L, -1L, 5874505727663328138L) && this.test(0x3000000000000000L, 0x1000000000000001L, 9044758135489717234L) && this.test(0x1111111111111111L, 0x1111111111111111L, 2623027407222095005L) && this.test(81985529216486895L, 0x1111111111111111L, 7059888845982118038L) && this.test(0x1111111111111111L, 81985529216486895L, 9010794866872557255L) && this.test(0L, 0L, 5690745928405278072L) && this.test(-81985529216486896L, 81985529216486895L, 778747869826949773L) && this.test(8980477021735513687L, 117611255094011714L, 6469001151571634219L) && this.test(86088881178490734L, 6689337107006052314L, -5640534185043097184L) && this.test(549741787767056006L, 164614723499094386L, 1671087763365698980L) && this.test(4055886516176695710L, 5856169732564009994L, -6746822877516508693L) && this.test(340327136592049590L, 4827089350059065250L, 3834958779591331610L) && this.test(77609513531011790L, 404019981405066298L, 5257055948861053208L) && this.test(103848277426812390L, 528848464848052690L, 4837309891264773272L) && this.test(4839539656546808830L, 8513233451820730474L, 1436720113764866789L) && this.test(551430852305365526L, 4313623329492117506L, 3381599224412216441L) && this.test(317663223366892335L, 2780233246153072794L, -2844058103233796381L) && this.test(4021832892757538118L, 1607044272340030002L, 6888766144289061225L) && this.test(2236079052714821214L, 7711690988273491146L, 5333803728129726331L) && this.test(6359121586699264374L, 21346945391353954L, 4981035896711862926L) && this.test(168909270948622343L, 5191868619451491058L, 8454855439414953917L) && this.test(5294331816167286159L, 4860862602324950266L, 6036336002209923097L) && this.test(5742192969548264359L, 517143888688272018L, 8831132235466705315L) && this.test(5325890758360836543L, 215703803915661610L, -3486809231690650187L) && this.test(108949354149783254L, 2133963297529473218L, -3338378365516396680L) && this.test(2042522189576687599L, 3482745036057028954L, 6182095888362435073L) && this.test(0x101010101010101L, 81985529216486895L, -417449070253938510L) && this.test(2242545357694045710L, 81985529216486895L, -6372460083780371282L) && this.test(-2234100979542855170L, 81985529216486895L, -4351032297459522787L) && this.test(0L, -1L, 92662307954357988L) && this.test(-1L, 0L, -1000192228265801284L) && this.test(81985529216486895L, 0L, 2619202209687287450L) && this.test(-81985529216486896L, -1L, 7736157887547705946L);
    }

    public byte[] encryptSecure(byte[] orig, boolean withCrc) {
        return this.encryptSecure(orig, 0, orig.length, withCrc);
    }

    public byte[] encryptSecure(byte[] orig, int off, boolean withCrc) {
        return this.encryptSecure(orig, off, orig.length, withCrc);
    }

    public byte[] encryptSecure(byte[] orig, int off, int len, boolean withCrc) {
        int i;
        int extra = withCrc ? 4 : 0;
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        byte[] bytes = new byte[4 + rounded_len + 2 * extra];
        int shift = bytes.length * 8;
        for (i = 0; i < 4; ++i) {
            bytes[i] = (byte)(len >>> (shift -= 8));
        }
        if (withCrc) {
            this.resetCrc();
            for (i = 0; i < len; ++i) {
                this.addCrc(orig[off + i]);
            }
            int crcval = this.getCrc();
            shift = bytes.length * 8;
            for (int i2 = 0; i2 < 4; ++i2) {
                bytes[4 + i2] = (byte)(crcval >>> (shift -= 8));
                bytes[8 + rounded_len + i2] = (byte)(crcval >>> shift);
            }
        }
        System.arraycopy(orig, off, bytes, 4 + extra, len);
        this.processSecure(bytes, 4, rounded_len + extra * 2, bytes, 4, true);
        return bytes;
    }

    public byte[] hashSecure(byte[] orig, int off, int len) {
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        byte[] bytes = new byte[rounded_len];
        System.arraycopy(orig, off, bytes, 0, len);
        this.processSecure(bytes, 0, len, bytes, 0, true);
        return bytes;
    }

    public byte[] decryptSecure(byte[] orig, int off, boolean withCrc) {
        byte[] bytes;
        int extra = withCrc ? 4 : 0;
        int len = 0;
        for (int i = off; i < off + 4; ++i) {
            len = (len << 8) + (orig[i] & 0xFF);
        }
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        if (withCrc) {
            bytes = new byte[orig.length];
            System.arraycopy(orig, 0, bytes, 0, orig.length);
            this.processSecure(orig, 4, rounded_len + extra * 2, bytes, 4, false);
            int crc1 = 0;
            for (int i = 0; i < 4; ++i) {
                crc1 = (crc1 << 8) + (bytes[4 + i] & 0xFF);
            }
            int crc2 = 0;
            for (int i = 0; i < 4; ++i) {
                crc2 = (crc2 << 8) + (bytes[8 + rounded_len + i] & 0xFF);
            }
            byte[] chop = new byte[len];
            System.arraycopy(bytes, 8, chop, 0, len);
            bytes = chop;
            if (crc1 != crc2) {
                throw new Error("Incorrect CRC in data");
            }
            this.resetCrc();
            for (int i = 0; i < chop.length; ++i) {
                this.addCrc(chop[i]);
            }
            if (crc1 != this.getCrc()) {
                throw new Error("Incorrect CRC in data");
            }
        } else {
            bytes = new byte[len];
            this.processSecure(orig, 4, len, bytes, 0, false);
        }
        return bytes;
    }

    public void streamSecure(byte[] buffer, int len, OutputStream out, boolean encrypt) throws IOException {
        int max = len;
        if (len % 8 != 0) {
            max += 8 - len % 8;
        }
        if (this.outbuffer == null || max > this.outbuffer.length) {
            this.outbuffer = new byte[max];
        }
        if (len % 8 != 0) {
            int missing = 8 - len % 8;
            for (int i = len; i < len + missing; ++i) {
                buffer[i] = -1;
            }
        }
        if (encrypt) {
            for (int i = 0; i < len; i += 8) {
                int L = (buffer[i] & 0xFF) << 24;
                L |= (buffer[i + 1] & 0xFF) << 16;
                L |= (buffer[i + 2] & 0xFF) << 8;
                L |= buffer[i + 3] & 0xFF;
                int R = (buffer[i + 4] & 0xFF) << 24;
                R |= (buffer[i + 5] & 0xFF) << 16;
                R |= (buffer[i + 6] & 0xFF) << 8;
                R |= buffer[i + 7] & 0xFF;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                this.IVL ^= (L ^= this.IVL);
                this.IVR ^= (R ^= this.IVR);
                this.outbuffer[i] = (byte)(0xFF & L >>> 24);
                this.outbuffer[i + 1] = (byte)(0xFF & L >>> 16);
                this.outbuffer[i + 2] = (byte)(0xFF & L >>> 8);
                this.outbuffer[i + 3] = (byte)(0xFF & L);
                this.outbuffer[i + 4] = (byte)(0xFF & R >>> 24);
                this.outbuffer[i + 5] = (byte)(0xFF & R >>> 16);
                this.outbuffer[i + 6] = (byte)(0xFF & R >>> 8);
                this.outbuffer[i + 7] = (byte)(0xFF & R);
            }
        } else {
            for (int i = 0; i < len; i += 8) {
                int L = (buffer[i] & 0xFF) << 24;
                L |= (buffer[i + 1] & 0xFF) << 16;
                L |= (buffer[i + 2] & 0xFF) << 8;
                int R = (buffer[i + 4] & 0xFF) << 24;
                R |= (buffer[i + 5] & 0xFF) << 16;
                R |= (buffer[i + 6] & 0xFF) << 8;
                int ORL = L |= buffer[i + 3] & 0xFF;
                int ORR = R |= buffer[i + 7] & 0xFF;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                R ^= this.IVR;
                this.IVL ^= ORL;
                this.IVR ^= ORR;
                this.outbuffer[i] = (byte)(0xFF & (L ^= this.IVL) >>> 24);
                if (i + 1 < len) {
                    this.outbuffer[i + 1] = (byte)(0xFF & L >>> 16);
                }
                if (i + 2 < len) {
                    this.outbuffer[i + 2] = (byte)(0xFF & L >>> 8);
                }
                if (i + 3 < len) {
                    this.outbuffer[i + 3] = (byte)(0xFF & L);
                }
                if (i + 4 < len) {
                    this.outbuffer[i + 4] = (byte)(0xFF & R >>> 24);
                }
                if (i + 5 < len) {
                    this.outbuffer[i + 5] = (byte)(0xFF & R >>> 16);
                }
                if (i + 6 < len) {
                    this.outbuffer[i + 6] = (byte)(0xFF & R >>> 8);
                }
                if (i + 7 >= len) continue;
                this.outbuffer[i + 7] = (byte)(0xFF & R);
            }
        }
        out.write(this.outbuffer, 0, max);
    }

    public void old_streamSecure(InputStream in, OutputStream out, int len, boolean encrypt) throws IOException {
        if (encrypt) {
            for (int i = 0; i < len; i += 8) {
                int L = (in.read() & 0xFF) << 24;
                L |= (in.read() & 0xFF) << 16;
                L |= (in.read() & 0xFF) << 8;
                L |= in.read() & 0xFF;
                int R = (in.read() & 0xFF) << 24;
                R |= (in.read() & 0xFF) << 16;
                R |= (in.read() & 0xFF) << 8;
                R |= in.read() & 0xFF;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                this.IVL ^= (L ^= this.IVL);
                this.IVR ^= (R ^= this.IVR);
                out.write((byte)(0xFF & L >>> 24));
                out.write((byte)(0xFF & L >>> 16));
                out.write((byte)(0xFF & L >>> 8));
                out.write((byte)(0xFF & L));
                out.write((byte)(0xFF & R >>> 24));
                out.write((byte)(0xFF & R >>> 16));
                out.write((byte)(0xFF & R >>> 8));
                out.write((byte)(0xFF & R));
            }
        } else {
            for (int i = 0; i < len; i += 8) {
                int L = (in.read() & 0xFF) << 24;
                L |= (in.read() & 0xFF) << 16;
                L |= (in.read() & 0xFF) << 8;
                int R = (in.read() & 0xFF) << 24;
                R |= (in.read() & 0xFF) << 16;
                R |= (in.read() & 0xFF) << 8;
                int ORL = L |= in.read() & 0xFF;
                int ORR = R |= in.read() & 0xFF;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                R ^= this.IVR;
                this.IVL ^= ORL;
                this.IVR ^= ORR;
                out.write((byte)(0xFF & (L ^= this.IVL) >>> 24));
                if (i + 1 < len) {
                    out.write((byte)(0xFF & L >>> 16));
                }
                if (i + 2 < len) {
                    out.write((byte)(0xFF & L >>> 8));
                }
                if (i + 3 < len) {
                    out.write((byte)(0xFF & L));
                }
                if (i + 4 < len) {
                    out.write((byte)(0xFF & R >>> 24));
                }
                if (i + 5 < len) {
                    out.write((byte)(0xFF & R >>> 16));
                }
                if (i + 6 < len) {
                    out.write((byte)(0xFF & R >>> 8));
                }
                if (i + 7 >= len) continue;
                out.write((byte)(0xFF & R));
            }
        }
    }

    private void processSecure(byte[] orig, int off, int len, byte[] target, int toff, boolean encrypt) {
        int iplus = 0;
        int tplus = 0;
        if (encrypt) {
            for (int i = 0; i < len; i += 8) {
                iplus = off + i;
                tplus = toff + i;
                int L = (orig[iplus] & 0xFF) << 24 | (orig[iplus + 1] & 0xFF) << 16 | (orig[iplus + 2] & 0xFF) << 8 | orig[iplus + 3] & 0xFF;
                int R = (orig[iplus + 4] & 0xFF) << 24 | (orig[iplus + 5] & 0xFF) << 16 | (orig[iplus + 6] & 0xFF) << 8 | orig[iplus + 7] & 0xFF;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                this.IVL ^= (L ^= this.IVL);
                this.IVR ^= (R ^= this.IVR);
                target[tplus] = (byte)(0xFF & L >>> 24);
                target[tplus + 1] = (byte)(0xFF & L >>> 16);
                target[tplus + 2] = (byte)(0xFF & L >>> 8);
                target[tplus + 3] = (byte)(0xFF & L);
                target[tplus + 4] = (byte)(0xFF & R >>> 24);
                target[tplus + 5] = (byte)(0xFF & R >>> 16);
                target[tplus + 6] = (byte)(0xFF & R >>> 8);
                target[tplus + 7] = (byte)(0xFF & R);
            }
        } else {
            for (int i = 0; i < len; i += 8) {
                iplus = off + i;
                tplus = toff + i;
                int L = (orig[iplus] & 0xFF) << 24 | (orig[iplus + 1] & 0xFF) << 16 | (orig[iplus + 2] & 0xFF) << 8 | orig[iplus + 3] & 0xFF;
                int R = (orig[iplus + 4] & 0xFF) << 24 | (orig[iplus + 5] & 0xFF) << 16 | (orig[iplus + 6] & 0xFF) << 8 | orig[iplus + 7] & 0xFF;
                int ORL = L;
                int ORR = R;
                long tmplong = this.encrypt(this.IVL + this.CTR++, this.IVR + this.CTR++);
                this.IVL = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                this.IVR = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
                L ^= this.IVL;
                R ^= this.IVR;
                this.IVL ^= ORL;
                this.IVR ^= ORR;
                try {
                    target[tplus] = (byte)(0xFF & L >>> 24);
                    target[tplus + 1] = (byte)(0xFF & L >>> 16);
                    target[tplus + 2] = (byte)(0xFF & L >>> 8);
                    target[tplus + 3] = (byte)(0xFF & L);
                    target[tplus + 4] = (byte)(0xFF & R >>> 24);
                    target[tplus + 5] = (byte)(0xFF & R >>> 16);
                    target[tplus + 6] = (byte)(0xFF & R >>> 8);
                    target[tplus + 7] = (byte)(0xFF & R);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public byte[] encryptOld(byte[] orig, int off, int len) {
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        byte[] bytes = new byte[4 + rounded_len];
        int shift = bytes.length * 8;
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(len >>> (shift -= 8));
        }
        System.arraycopy(orig, off, bytes, 4, len);
        for (int i = 4; i < bytes.length; i += 8) {
            int L = (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8 | bytes[i + 3] & 0xFF;
            int R = (bytes[i + 4] & 0xFF) << 24 | (bytes[i + 5] & 0xFF) << 16 | (bytes[i + 6] & 0xFF) << 8 | bytes[i + 7] & 0xFF;
            long tmplong = this.encrypt(L, R);
            L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
            bytes[i] = (byte)(0xFF & L >>> 24);
            bytes[i + 1] = (byte)(0xFF & L >>> 16);
            bytes[i + 2] = (byte)(0xFF & L >>> 8);
            bytes[i + 3] = (byte)(0xFF & L);
            bytes[i + 4] = (byte)(0xFF & R >>> 24);
            bytes[i + 5] = (byte)(0xFF & R >>> 16);
            bytes[i + 6] = (byte)(0xFF & R >>> 8);
            bytes[i + 7] = (byte)(0xFF & R);
        }
        return bytes;
    }

    public byte[] hashOld(byte[] orig, int off, int len) {
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        byte[] bytes = new byte[rounded_len];
        System.arraycopy(orig, off, bytes, 0, len);
        for (int i = 0; i < bytes.length; i += 8) {
            int L = (bytes[i] & 0xFF) << 24 | (bytes[i + 1] & 0xFF) << 16 | (bytes[i + 2] & 0xFF) << 8 | bytes[i + 3] & 0xFF;
            int R = (bytes[i + 4] & 0xFF) << 24 | (bytes[i + 5] & 0xFF) << 16 | (bytes[i + 6] & 0xFF) << 8 | bytes[i + 7] & 0xFF;
            long tmplong = this.encrypt(L, R);
            L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
            bytes[i] = (byte)(0xFF & L >>> 24);
            bytes[i + 1] = (byte)(0xFF & L >>> 16);
            bytes[i + 2] = (byte)(0xFF & L >>> 8);
            bytes[i + 3] = (byte)(0xFF & L);
            bytes[i + 4] = (byte)(0xFF & R >>> 24);
            bytes[i + 5] = (byte)(0xFF & R >>> 16);
            bytes[i + 6] = (byte)(0xFF & R >>> 8);
            bytes[i + 7] = (byte)(0xFF & R);
        }
        return bytes;
    }

    public byte[] decryptOld(byte[] orig, int off) {
        int len = 0;
        for (int i = off; i < off + 4; ++i) {
            len = (len << 8) + (orig[i] & 0xFF);
        }
        int rounded_len = len / 8 * 8;
        if (len % 8 > 0) {
            rounded_len += 8;
        }
        byte[] bytes = new byte[len];
        int iplus = 0;
        for (int i = 0; i < len; i += 8) {
            iplus = off + i;
            int L = (orig[iplus + 4] & 0xFF) << 24 | (orig[iplus + 5] & 0xFF) << 16 | (orig[iplus + 6] & 0xFF) << 8 | orig[iplus + 7] & 0xFF;
            int R = (orig[iplus + 8] & 0xFF) << 24 | (orig[iplus + 9] & 0xFF) << 16 | (orig[iplus + 10] & 0xFF) << 8 | orig[iplus + 11] & 0xFF;
            long tmplong = this.decrypt(L, R);
            L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
            R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
            try {
                bytes[i] = (byte)(0xFF & L >>> 24);
                bytes[i + 1] = (byte)(0xFF & L >>> 16);
                bytes[i + 2] = (byte)(0xFF & L >>> 8);
                bytes[i + 3] = (byte)(0xFF & L);
                bytes[i + 4] = (byte)(0xFF & R >>> 24);
                bytes[i + 5] = (byte)(0xFF & R >>> 16);
                bytes[i + 6] = (byte)(0xFF & R >>> 8);
                bytes[i + 7] = (byte)(0xFF & R);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return bytes;
    }

    long encrypt(int xl, int xr) {
        int Xl = xl;
        int Xr = xr;
        Xr ^= (this.INST_S[0][(short)((Xl ^= this.INST_P[0]) >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[1];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[2];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[3];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[4];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[5];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[6];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[7];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[8];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[9];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[10];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[11];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[12];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[13];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[14];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[15];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[16];
        long returnlong = 0L;
        returnlong = (long)(Xr ^= this.INST_P[17]) << 32 & 0xFFFFFFFF00000000L;
        return returnlong |= (long)Xl & 0xFFFFFFFFL;
    }

    long decrypt(int xl, int xr) {
        int Xl = xl;
        int Xr = xr;
        Xr ^= (this.INST_S[0][(short)((Xl ^= this.INST_P[17]) >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[16];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[15];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[14];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[13];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[12];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[11];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[10];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[9];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[8];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[7];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[6];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[5];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[4];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[3];
        Xr ^= (this.INST_S[0][(short)(Xl >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xl >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xl >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xl & 0xFF)] ^ this.INST_P[2];
        Xl ^= (this.INST_S[0][(short)(Xr >>> 24 & 0xFF)] + this.INST_S[1][(short)(Xr >>> 16 & 0xFF)] ^ this.INST_S[2][(short)(Xr >>> 8 & 0xFF)]) + this.INST_S[3][(short)(Xr & 0xFF)] ^ this.INST_P[1];
        long returnlong = 0L;
        returnlong = (long)(Xr ^= this.INST_P[0]) << 32 & 0xFFFFFFFF00000000L;
        return returnlong |= (long)Xl & 0xFFFFFFFFL;
    }

    boolean test(long keyb, long clear, long encoded) {
        byte[] key = new byte[]{(byte)(keyb >>> 56 & 0xFFL), (byte)(keyb >>> 48 & 0xFFL), (byte)(keyb >>> 40 & 0xFFL), (byte)(keyb >>> 32 & 0xFFL), (byte)(keyb >>> 24 & 0xFFL), (byte)(keyb >>> 16 & 0xFFL), (byte)(keyb >>> 8 & 0xFFL), (byte)(keyb & 0xFFL)};
        int L = (int)(clear >>> 32 & 0xFFFFFFFFL);
        int R = (int)(clear & 0xFFFFFFFFL);
        int EL = (int)(encoded >>> 32 & 0xFFFFFFFFL);
        int ER = (int)(encoded & 0xFFFFFFFFL);
        this.init(key);
        long tmplong = this.encrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        if (L != EL || R != ER) {
            System.out.println("L = " + Integer.toHexString(L) + " != " + Integer.toHexString(EL));
            System.out.println("R = " + Integer.toHexString(R) + " != " + Integer.toHexString(ER));
            return false;
        }
        tmplong = this.decrypt(L, R);
        L = (int)(tmplong >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        R = (int)(tmplong & 0xFFFFFFFFFFFFFFFFL);
        if (L != (int)(clear >>> 32 & 0xFFFFFFFFL) || R != (int)(clear & 0xFFFFFFFFL)) {
            return false;
        }
        this.init(key);
        return true;
    }

    public static void main(String[] args) {
        if (new Blowfish().test()) {
            System.out.println("test was ok");
        } else {
            System.out.println("TEST FAILED!");
        }
    }

    private int getCrc() {
        return this.val32;
    }

    private void resetCrc() {
        this.val32 = 0;
    }

    private void addCrc(byte b) {
        this.val32 = this.val32 << 8 ^ CRC32[this.val32 >>> 24 ^ b & 0xFF];
    }
}

