/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class TrayNotifier {
    private Image image;
    private static Object systemTrayObject = null;
    private static Class systemTrayClass;
    private static Dimension trayIconSize;
    private Object trayIconObject = null;
    private Class trayIconClass;
    private Class messageTypeClass;
    private Method systemTrayAdd;
    private Method systemTrayRemove;
    private Method trayIconSetPopup;
    private Method trayIconSetImage;
    private Method trayIconDisplayMessage;
    private Method trayIconSetAutoSize;
    private Method trayIconSetTooltip;
    private Object[] messageTypeEnums = null;
    private static Boolean supported;

    public static Dimension getTrayIconSize() {
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            return trayIconSize;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void setToolTip(String tooltip) {
        if (tooltip == null) {
            tooltip = "";
        }
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIconSetTooltip.invoke(this.trayIconObject, tooltip);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setImageAutoSize(boolean size) {
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIconSetAutoSize.invoke(this.trayIconObject, new Boolean(size));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean isSupported() {
        if (supported != null) {
            return supported;
        }
        try {
            systemTrayClass = Class.forName("java.awt.SystemTray");
            Method method = systemTrayClass.getDeclaredMethod("getSystemTray", new Class[0]);
            systemTrayObject = method.invoke(null, new Object[0]);
            Method isSupported = systemTrayClass.getDeclaredMethod("isSupported", new Class[0]);
            supported = (Boolean)isSupported.invoke(null, new Object[0]);
            Method getTrayIconSize = systemTrayClass.getMethod("getTrayIconSize", new Class[0]);
            trayIconSize = (Dimension)getTrayIconSize.invoke(systemTrayObject, new Object[0]);
            return supported;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public TrayNotifier(Image initialImage) throws TrayIconNotSupportedException {
        this.image = initialImage;
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIconClass = Class.forName("java.awt.TrayIcon");
            this.messageTypeClass = Class.forName("java.awt.TrayIcon$MessageType");
            Method getEnumConstants = Class.class.getDeclaredMethod("getEnumConstants", new Class[0]);
            this.messageTypeEnums = (Object[])getEnumConstants.invoke((Object)this.messageTypeClass, new Object[0]);
            this.systemTrayAdd = systemTrayClass.getMethod("add", this.trayIconClass);
            this.systemTrayRemove = systemTrayClass.getMethod("remove", this.trayIconClass);
            Constructor constructor = this.trayIconClass.getConstructor(Image.class);
            this.trayIconObject = constructor.newInstance(this.image);
            this.trayIconSetPopup = this.trayIconClass.getMethod("setPopupMenu", PopupMenu.class);
            this.trayIconSetImage = this.trayIconClass.getMethod("setImage", Image.class);
            this.trayIconDisplayMessage = this.trayIconClass.getMethod("displayMessage", String.class, String.class, this.messageTypeClass);
            this.trayIconSetAutoSize = this.trayIconClass.getMethod("setImageAutoSize", Boolean.TYPE);
            this.trayIconSetTooltip = this.trayIconClass.getMethod("setToolTip", String.class);
            this.systemTrayAdd.invoke(systemTrayObject, this.trayIconObject);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new TrayIconNotSupportedException();
        }
    }

    public void setPopupMenu(PopupMenu menu) {
        if (this.trayIconObject != null && menu != null) {
            try {
                this.trayIconSetPopup.invoke(this.trayIconObject, menu);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void removeTrayIcon() {
        if (this.trayIconObject != null) {
            try {
                this.systemTrayRemove.invoke(systemTrayObject, this.trayIconObject);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.trayIconObject != null && image != null) {
            try {
                this.trayIconSetImage.invoke(this.trayIconObject, image);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void displayError(String string, String string2) {
        this.displayMessage(string, string2, this.messageTypeEnums[0]);
    }

    public void displayWarning(String string, String string2) {
        this.displayMessage(string, string2, this.messageTypeEnums[1]);
    }

    public void displayInfo(String string, String string2) {
        this.displayMessage(string, string2, this.messageTypeEnums[2]);
    }

    public void displayMessage(String string, String string2) {
        this.displayMessage(string, string2, this.messageTypeEnums[3]);
    }

    private void displayMessage(String string, String string2, Object messageType) {
        if (this.trayIconObject != null && string != null && string2 != null && messageType != null) {
            try {
                this.trayIconDisplayMessage.invoke(this.trayIconObject, string, string2, messageType);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        supported = null;
    }

    public static class TrayIconNotSupportedException
    extends Exception {
    }
}

