/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.File;
import utils.ostools.OS;

public class NativeLibraryLoader {
    static boolean load_attempted = false;
    static boolean load_success = false;
    public static final String WINPTY_WINDOWS_32 = "winpty.dll";
    public static final String WINPTY_WINDOWS_64 = "winpty64.dll";
    public static final String LIB_WINDOWS_32 = "utils_wnative.dll";
    public static final String LIB_WINDOWS_64 = "utils_wnative64.dll";
    public static final String LIB_LION_MACOS_32 = "libutils_m_lion_native.jnilib";
    public static final String LIB_LION_MACOS_64 = "libutils_m_lion_native64.jnilib";
    public static final String LIB_LEOPARD_MACOS_32 = "libutils_mnative.jnilib";
    public static final String LIB_LEOPARD_MACOS_64 = "libutils_mnative64.jnilib";
    public static final String LIB_LINUX_32 = "libutils_lnative.so";
    public static final String LIB_LINUX_64 = "libutils_lnative64.so";
    public static final String LIB_LINUX_ARM_32 = "libutils_lnative32arm.so";
    public static final String LIB_LINUX_ARM_64 = "libutils_lnative64arm.so";

    private static String getAppropriateLibName() {
        boolean x86_64 = System.getProperty("os.arch").toLowerCase().indexOf("64") != -1;
        String osname = System.getProperty("os.name").toLowerCase();
        if (x86_64) {
            System.out.println("[NativeLibraryLoader] Detected 64-bit architecture");
        } else {
            System.out.println("[NativeLibraryLoader] Detected 32-bit architecture");
        }
        if (osname.indexOf("win") != -1) {
            System.out.println("[NativeLibraryLoader] Detected Windows OS");
            if (x86_64) {
                return LIB_WINDOWS_64;
            }
            return LIB_WINDOWS_32;
        }
        if (osname.indexOf("mac") != -1 || osname.indexOf("darwin") != -1) {
            if (System.getProperty("os.version").startsWith("10.5") || System.getProperty("os.version").startsWith("10.6")) {
                System.out.println("[NativeLibraryLoader] Detected Mac OS - 10.6 or before");
                if (x86_64) {
                    return LIB_LEOPARD_MACOS_64;
                }
                return LIB_LEOPARD_MACOS_32;
            }
            System.out.println("[NativeLibraryLoader] Detected Mac OS - 10.7 or later");
            if (x86_64) {
                return LIB_LION_MACOS_64;
            }
            return LIB_LION_MACOS_32;
        }
        if (osname.indexOf("lin") != -1) {
            System.out.println("[NativeLibraryLoader] Detected Linux OS (" + System.getProperty("os.arch") + ")");
            if (OS.isARM()) {
                if (x86_64) {
                    return LIB_LINUX_ARM_64;
                }
                return LIB_LINUX_ARM_32;
            }
            if (x86_64) {
                return LIB_LINUX_64;
            }
            return LIB_LINUX_32;
        }
        System.out.println("[NativeLibraryLoader] Unknown OS");
        return null;
    }

    public static boolean isNativeLibraryLoadedOK() {
        return load_success;
    }

    public static void loadLibrary() {
        File sh = new File("../SimpleHelp/lib");
        if (!sh.exists()) {
            sh = new File("SimpleHelp/lib");
        }
        if (sh.exists()) {
            NativeLibraryLoader.loadLibrary(sh);
        } else {
            NativeLibraryLoader.loadLibrary(new File("."));
        }
    }

    public static void loadLibrary(File libraryDirectory) {
        if (!load_attempted || !load_success) {
            load_attempted = true;
            System.out.println("[NativeLibraryLoader] Attempting load in " + libraryDirectory);
            String library = NativeLibraryLoader.getAppropriateLibName();
            if (library == null) {
                System.out.println("[NativeLibraryLoader] No native library exists for this system.");
                return;
            }
            File winptyDLL = null;
            if (library.equals(LIB_WINDOWS_32)) {
                winptyDLL = new File(libraryDirectory, WINPTY_WINDOWS_32);
            } else if (library.equals(LIB_WINDOWS_64)) {
                winptyDLL = new File(libraryDirectory, WINPTY_WINDOWS_64);
            }
            if (winptyDLL != null) {
                try {
                    String absolutePathToLibrary = winptyDLL.getCanonicalPath();
                    System.out.println("[NativeLibraryLoader] Trying to load winPTY library " + absolutePathToLibrary + " [exists: " + winptyDLL.exists() + "]");
                    System.load(absolutePathToLibrary);
                    System.out.println("[NativeLibraryLoader] winPTY library loaded.");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.out.println("[NativeLibraryLoader] Warning - unable to load winPTY library (" + t.getMessage() + ")");
                }
            }
            File targetLibrary = new File(libraryDirectory, library);
            try {
                String absolutePathToLibrary = targetLibrary.getCanonicalPath();
                System.out.println("[NativeLibraryLoader] Trying to load native library " + absolutePathToLibrary + " [exists: " + targetLibrary.exists() + "]");
                System.load(absolutePathToLibrary);
                System.out.println("[NativeLibraryLoader] Library loaded.");
                load_success = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println("[NativeLibraryLoader] Warning - unable to load native library (" + t.getMessage() + ")");
                load_success = false;
            }
        }
    }
}

