/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JFrame;
import utils.message.Message;
import utils.ostools.OS;
import utils.string.HexData;
import utils.swing.images.ImageHelper;

public class CursorInfo {
    public static final byte FORMAT_ARGB = 0;
    public static final byte FORMAT_BGRA = 1;
    public static final byte FORMAT_RGBA = 2;
    public int signature;
    public double width;
    public double height;
    public double hotSpotX;
    public double hotSpotY;
    public long dataLength;
    public byte[] data;
    public int firstPossibleFrameSplit = -1;
    public byte pixelFormat;
    private BufferedImage cachedImage = null;
    private boolean downscaleRequired = false;

    public String toString() {
        return "Cursor " + this.width + "x" + this.height + " h=" + this.hotSpotX + "," + this.hotSpotY + " dataLength=" + this.dataLength + " format=" + this.pixelFormat;
    }

    public Message toMessage() {
        Message m = new Message();
        m.append(this.width);
        m.append(this.height);
        m.append(this.hotSpotX);
        m.append(this.hotSpotY);
        m.append(this.dataLength);
        m.append(this.data);
        m.append(this.signature);
        m.append(this.pixelFormat);
        return m;
    }

    public static CursorInfo fromMessage(Message m) {
        CursorInfo cInfo = new CursorInfo();
        int i = 0;
        cInfo.width = m.getAsDouble(i++);
        cInfo.height = m.getAsDouble(i++);
        cInfo.hotSpotX = m.getAsDouble(i++);
        cInfo.hotSpotY = m.getAsDouble(i++);
        cInfo.dataLength = m.getAsLong(i++);
        cInfo.data = (byte[])m.get(i++);
        cInfo.signature = m.getAsInt(i++);
        cInfo.pixelFormat = m.getAsByte(i++);
        return cInfo;
    }

    public Cursor getJavaCursor(double scalingFactor) {
        BufferedImage image = this.getImage();
        if (image != null && image.getWidth() > 0 && image.getHeight() > 0 && scalingFactor != 1.0) {
            int newW = (int)((double)image.getWidth() * scalingFactor);
            int newH = (int)((double)image.getHeight() * scalingFactor);
            image = ImageHelper.scale(image, newW, newH);
        }
        return CursorInfo.getJavaCursor(image, (int)(this.hotSpotX * scalingFactor), (int)(this.hotSpotY * scalingFactor), Integer.toString(this.signature));
    }

    private static Cursor getJavaCursor(Image image, int hotSpotX, int hotSpotY, String name) {
        Point hotSpot = new Point(hotSpotX, hotSpotY);
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(image, hotSpot, name);
        if (c == null) {
            System.out.println("[CursorInfo] Cursor is null!");
        }
        return c;
    }

    public BufferedImage crop(BufferedImage src, Rectangle rect) {
        BufferedImage dest = new BufferedImage(rect.width, rect.height, 2);
        Graphics g = dest.getGraphics();
        g.drawImage(src, 0, 0, rect.width, rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, null);
        g.dispose();
        return dest;
    }

    public BufferedImage getImage() {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        Dimension bestCursorSize = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getBestCursorSize((int)this.width, (int)this.height) : new Dimension((int)this.width, (int)this.height);
        this.downscaleRequired = (double)bestCursorSize.width < this.width || (double)bestCursorSize.height < this.height;
        BufferedImage image = !this.downscaleRequired ? new BufferedImage(bestCursorSize.width, bestCursorSize.height, 2) : new BufferedImage((int)this.width, (int)this.height, 2);
        int index = 0;
        int emptyRowsInSequenceCount = 0;
        int h = 0;
        while ((double)h < this.height) {
            boolean rowIsEmpty = true;
            int w = 0;
            while ((double)w < this.width) {
                int a;
                int b;
                int g;
                int r;
                if (this.pixelFormat == 2) {
                    r = this.data[index++];
                    g = this.data[index++];
                    b = this.data[index++];
                    a = this.data[index++];
                } else if (this.pixelFormat == 1) {
                    b = this.data[index++];
                    g = this.data[index++];
                    r = this.data[index++];
                    a = this.data[index++];
                } else {
                    a = this.data[index++];
                    r = this.data[index++];
                    g = this.data[index++];
                    b = this.data[index++];
                }
                if (a < 0) {
                    a = 256 + a;
                }
                if (r < 0) {
                    r = 256 + r;
                }
                if (g < 0) {
                    g = 256 + g;
                }
                if (b < 0) {
                    b = 256 + b;
                }
                if (OS.isWindows()) {
                    a = a < 150 ? 0 : 255;
                }
                if (a > 0) {
                    rowIsEmpty = false;
                }
                int col = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                image.setRGB(w, h, col);
                ++w;
            }
            emptyRowsInSequenceCount = rowIsEmpty && h > 10 ? ++emptyRowsInSequenceCount : 0;
            if (emptyRowsInSequenceCount == 4 && this.firstPossibleFrameSplit == -1) {
                this.firstPossibleFrameSplit = h - 2;
            }
            ++h;
        }
        if (this.height > 2.0 * this.width && this.firstPossibleFrameSplit > 0) {
            image = this.crop(image, new Rectangle(0, 0, (int)this.width, this.firstPossibleFrameSplit + 1));
            this.width = image.getWidth();
            this.height = image.getHeight();
            bestCursorSize = !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getBestCursorSize((int)this.width, (int)this.height) : new Dimension((int)this.width, (int)this.height);
            this.downscaleRequired = (double)bestCursorSize.width < this.width || (double)bestCursorSize.height < this.height;
        }
        if (this.downscaleRequired) {
            BufferedImage image2 = new BufferedImage(bestCursorSize.width, bestCursorSize.height, 2);
            Graphics2D g2d = image2.createGraphics();
            g2d.drawImage(image, 0, 0, bestCursorSize.width, bestCursorSize.height, 0, 0, (int)this.width, (int)this.height, null);
            g2d.dispose();
            image = image2;
            double xRatio = (double)bestCursorSize.width / this.width;
            double yRatio = (double)bestCursorSize.height / this.height;
            this.hotSpotX = Math.round(this.hotSpotX * xRatio);
            this.hotSpotY = Math.round(this.hotSpotY * yRatio);
        }
        this.cachedImage = image;
        return image;
    }

    public boolean isVisible() {
        return this.width > 0.0 && this.height > 0.0;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        BufferedImage image = new BufferedImage(64, 64, 2);
        CursorInfo.getJavaCursor(image, 10, 10, "moonpig");
        NativeLibraryLoader.loadLibrary(new File("."));
        if (NativeUtils.getInstance() == null) {
            NativeLibraryLoader.loadLibrary(new File("../SimpleHelp/lib"));
        }
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        Thread.sleep(1000L);
        System.out.println("Grabbing system cursor and showing it");
        CursorInfo cInfo = new CursorInfo();
        NativeScreenUtil.getInstance().cursorHasChanged();
        NativeScreenUtil.getInstance().getCursorInfo(cInfo);
        System.out.println(cInfo);
        System.out.println(HexData.byteArrayToHexString(cInfo.data));
        System.out.println(cInfo.dataLength);
        System.out.println(cInfo.pixelFormat);
        Thread.sleep(1000L);
        Cursor javaCursor = cInfo.getJavaCursor(1.0);
        frame.setCursor(javaCursor);
    }

    public static class CursorInfoCache
    extends LinkedList {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToCache(CursorInfo cInfo) {
            CursorInfoCache cursorInfoCache = this;
            synchronized (cursorInfoCache) {
                this.addFirst(cInfo);
                if (this.size() > 20) {
                    this.removeLast();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CursorInfo getFromCache(int signature) {
            CursorInfoCache cursorInfoCache = this;
            synchronized (cursorInfoCache) {
                for (int i = 0; i < this.size(); ++i) {
                    CursorInfo cInfo = (CursorInfo)this.get(i);
                    if (cInfo.signature != signature) continue;
                    this.remove(i);
                    this.addFirst(cInfo);
                    return cInfo;
                }
                return null;
            }
        }
    }
}

