/*
 * Decompiled with CFR 0.152.
 */
package com.aem.thp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AemRle {
    public static boolean DEBUG = false;
    ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);

    public static void main(String[] args) throws Exception {
        int i;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        for (i = 0; i < 100; ++i) {
            bout.write(65);
        }
        for (i = 0; i < 1000; ++i) {
            bout.write(i);
        }
        for (i = 0; i < 100; ++i) {
            bout.write(65);
        }
        for (i = 0; i < 4; ++i) {
            bout.write(66);
        }
        for (i = 0; i < 100; ++i) {
            bout.write(67);
        }
        for (i = 0; i < 4; ++i) {
            bout.write(66);
        }
        AemRle rle = new AemRle();
        rle.compress(rle.decompress(rle.compress(bout.toByteArray())));
    }

    public int compressedSize(byte[] dat) throws IOException {
        if (DEBUG) {
            System.out.println("--encoding");
        }
        int TOTAL = 0;
        if (dat.length < 10) {
            return 3 + dat.length;
        }
        ++TOTAL;
        boolean encoding = false;
        int sofar = 0;
        int matching = 0;
        byte prev = dat[0];
        for (int i = 1; i < dat.length; ++i) {
            byte cur = dat[i];
            ++sofar;
            if (cur == prev) {
                ++matching;
            } else {
                if (encoding) {
                    ++matching;
                    TOTAL += 3;
                    ++TOTAL;
                    sofar = 0;
                    matching = 0;
                    encoding = false;
                }
                matching = 0;
            }
            if (matching == 4) {
                int badlen = sofar - matching;
                if (badlen > 0) {
                    int len = sofar - matching;
                    TOTAL += 3 + len;
                    sofar = 0;
                }
                encoding = true;
            }
            prev = cur;
        }
        if (encoding) {
            TOTAL += 1 + matching + 1;
        } else {
            int len = 1 + sofar;
            TOTAL += 3 + len;
        }
        return TOTAL;
    }

    public byte[] compress(byte[] dat) throws IOException {
        if (DEBUG) {
            System.out.println("--encoding");
        }
        this.bout.reset();
        if (dat.length < 10) {
            if (DEBUG) {
                System.out.println("Ignored type (0)");
            }
            this.bout.write(0);
            AemRle.writeInt(this.bout, dat.length);
            this.bout.write(dat);
            return this.bout.toByteArray();
        }
        if (DEBUG) {
            System.out.println("Encoded type (1)");
        }
        this.bout.write(1);
        boolean encoding = false;
        int sofar = 0;
        int matching = 0;
        byte prev = dat[0];
        for (int i = 1; i < dat.length; ++i) {
            byte cur = dat[i];
            ++sofar;
            if (cur == prev) {
                ++matching;
            } else {
                if (encoding) {
                    ++matching;
                    if (DEBUG) {
                        System.out.println(i + " " + matching + " bytes of encoded (" + (char)prev + ")");
                    }
                    AemRle.writeInt(this.bout, -matching);
                    this.bout.write(prev);
                    sofar = 0;
                    matching = 0;
                    encoding = false;
                }
                matching = 0;
            }
            if (matching == 4) {
                int badlen = sofar - matching;
                if (badlen > 0) {
                    int index = i - sofar;
                    int len = sofar - matching;
                    if (DEBUG) {
                        System.out.println(i + " " + len + " bytes of non-encoded (ix=" + index + ")");
                    }
                    AemRle.writeInt(this.bout, len);
                    this.bout.write(dat, index, len);
                    sofar = 0;
                }
                encoding = true;
            }
            prev = cur;
        }
        if (encoding) {
            if (DEBUG) {
                System.out.println("end " + (1 + matching) + " bytes of encoded (" + (char)prev + ")");
            }
            AemRle.writeInt(this.bout, -(1 + matching));
            this.bout.write(prev);
        } else {
            int len = 1 + sofar;
            int index = dat.length - len;
            if (DEBUG) {
                System.out.println("end " + len + " bytes of non-encoded (ix=" + index + ")");
            }
            AemRle.writeInt(this.bout, len);
            this.bout.write(dat, index, len);
        }
        return this.bout.toByteArray();
    }

    public byte[] decompress(byte[] dat) throws IOException {
        if (DEBUG) {
            System.out.println("--unencoding");
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        this.bout.reset();
        int type = bin.read();
        if (type == 0) {
            int len = AemRle.readInt(bin);
            byte[] ret = new byte[len];
            int tot = 0;
            int n = 0;
            while (n != -1 && tot != len) {
                n = bin.read(ret, tot, len - tot);
                if (n <= 0) continue;
                tot += n;
            }
            return ret;
        }
        if (DEBUG) {
            System.out.println("Encoded type (1)");
        }
        while (bin.available() > 0) {
            int s = AemRle.readInt(bin);
            if (s < 0) {
                int b = bin.read();
                s = -s;
                if (DEBUG) {
                    System.out.println(s + " bytes of encoded " + (char)b);
                }
                for (int i = 0; i < s; ++i) {
                    this.bout.write(b);
                }
                continue;
            }
            if (DEBUG) {
                System.out.println(s + " bytes of non-encoded");
            }
            for (int i = 0; i < s; ++i) {
                this.bout.write(bin.read());
            }
        }
        return this.bout.toByteArray();
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        if ((n & 0xFF000000) != 0) {
            AemRle.writeByteNum(out, 4);
            out.write((byte)(n >>> 24));
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF0000) != 0) {
            AemRle.writeByteNum(out, 3);
            out.write((byte)(n >>> 16));
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF00) != 0) {
            AemRle.writeByteNum(out, 2);
            out.write((byte)(n >>> 8));
            out.write((byte)n);
        } else if ((n & 0xFF) != 0) {
            AemRle.writeByteNum(out, 1);
            out.write((byte)n);
        } else {
            AemRle.writeByteNum(out, 0);
        }
    }

    public static int readInt(InputStream in) throws IOException {
        int bytes = AemRle.readByteNum(in);
        int n = 0;
        int r = 0;
        for (int i = 0; i < bytes; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream while reading int");
            }
            n = n << 8 | r;
        }
        return n;
    }

    public static void writeByteNum(OutputStream out, int n) throws IOException {
        out.write((byte)n);
    }

    public static int readByteNum(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException("End of stream while reading bytecount for number");
        }
        return n;
    }
}

