/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests.suites.tests;

import com.aem.tests.TestUtils;
import com.aem.tests.suites.ContinuousTestSpec;
import com.aem.tests.suites.LargeContinuousTest;
import java.io.IOException;
import java.util.Properties;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;

public class SessionReconnectTest
extends LargeContinuousTest {
    Object TERM_LOCK = new Object();
    Object CONN_LOCK = new Object();

    private SessionReconnectTest(ContinuousTestSpec spec) {
        super(spec);
    }

    public static SessionReconnectTest createSessionReconnectTest(int sessions) {
        ContinuousTestSpec spec = new ContinuousTestSpec();
        spec.N_techUi = JWTestControl.getConnected(TestUtils.APP_TECH_TEST);
        spec.N_accessSessions = sessions;
        return new SessionReconnectTest(spec);
    }

    @Override
    protected void launchTestControl() throws Exception {
        for (int i = 0; i < this.spec.N_accessSessions; ++i) {
            new ReconnectDriver().start();
        }
        new ReconnectOrchestrator().start();
    }

    @Override
    public Properties getLaunchProperties() {
        return null;
    }

    class ReconnectDriver
    extends Thread {
        ReconnectDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String name = "Reconnect Session " + this.hashCode() % 1000;
            try {
                while (true) {
                    System.out.println("[Reconnect Session] Reconnect Session Driver connecting to session...");
                    JWTestable session = JWTestControl.popShared(TestUtils.APP_TECH_SESSION_GUI, 86400000);
                    System.out.println("[Reconnect Session] Continuing...");
                    Object object = SessionReconnectTest.this.TERM_LOCK;
                    synchronized (object) {
                        try {
                            SessionReconnectTest.this.TERM_LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    System.out.println("[Reconnect Session] Requesting terminate now...");
                    session.call(TestUtils.SS_CMD_closeconnection, null);
                    object = SessionReconnectTest.this.CONN_LOCK;
                    synchronized (object) {
                        try {
                            SessionReconnectTest.this.CONN_LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    System.out.println("[Reconnect Session] Requesting reconnect now...");
                    session.call(TestUtils.SS_CMD_reconnect, null);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                return;
            }
        }
    }

    class ReconnectOrchestrator
    extends Thread {
        ReconnectOrchestrator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                System.out.println("[Reconnect Orchestrator] Sleeping for three minutes...");
                try {
                    Thread.sleep(180000L);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                System.out.println("[Reconnect Orchestrator] Requesting all sessions to terminate now...");
                Object x = SessionReconnectTest.this.TERM_LOCK;
                synchronized (x) {
                    SessionReconnectTest.this.TERM_LOCK.notifyAll();
                }
                try {
                    Thread.sleep(180000L);
                }
                catch (Exception x2) {
                    x2.printStackTrace();
                }
                System.out.println("[Reconnect Orchestrator] Requesting all sessions to reconnect now...");
                Object object = SessionReconnectTest.this.CONN_LOCK;
                synchronized (object) {
                    SessionReconnectTest.this.CONN_LOCK.notifyAll();
                }
            }
        }
    }
}

