/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.TestResourceBundle;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.images.Icons;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.RAClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.tests.FrameworkBattery;
import com.aem.tests.TestUtils;
import com.aem.tests.Testing;
import com.aem.tests.WdsSelectTimeoutTest;
import com.aem.tests.suites.tests.LongChurnTest;
import com.aem.tests.suites.tests.SessionReconnectTest;
import com.aem.tests.suites.tests.SessionStageTest;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import jwrapper.failover.FailoverMonitor;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.TypedMap;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.progtools.Counter;
import utils.progtools.net.URLParser;
import utils.stream.UrlFetch;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.listeners.SystemExitWindowListener;

public class TechTest {
    static long Tupdate = 0L;
    static int PROCS_MAX = 8;
    static Stats stats = OsStats.getOsStats();
    static TechClient tc;
    static String deferredControlToHost;
    static RootPaneContainer rpc;
    static String updateUrlOverride;
    static Properties testLaunchProperties;
    static Random r;
    static ArrayList<Method> tests;
    static Counter counter;
    static JWTesting jwa;
    static JTextField tchost;
    static GbPanel tcon;
    static Font font;
    static String passw;
    static String serverPkhash;
    static String raClientMachineID;

    public static void updateStats() {
        if (Tupdate + 5000L < System.currentTimeMillis()) {
            stats.update();
            Tupdate = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) throws Exception {
        FailoverMonitor.DEBUG_DISABLE = true;
        if (JWLaunchProperties.getBooleanProperty("TEST_SETUP_TECH_CLIENT", false)) {
            System.out.println("TechTest used as a low level test environment, wil set up TechClient");
            URLParser parser = new URLParser(JWSystem.getUpdateURL());
            System.out.println("URL is " + JWSystem.getUpdateURL());
            TechCredentials creds = new TechCredentials();
            creds.setUsername(JWLaunchProperties.getProperty("technician"));
            creds.setPassword(JWLaunchProperties.getProperty("password"));
            System.out.println("Logging in");
            TechClient client = new TechClient("en", (ResourceBundle)new TestResourceBundle(), parser.getHostname(), parser.getPort(true), creds, false, new TechClientAdapter());
            String targetMachineID = JWSystem.getAppLaunchProperty("TEST_RACLIENT_TARGET");
            System.out.println("Target RAClient machine ID is " + targetMachineID);
            if (targetMachineID.length() > 0) {
                RAClient ras;
                if (Math.random() < 0.5) {
                    System.out.println("[Testing] Will open a DIRECT client to target machine " + targetMachineID);
                    ras = client.getDirectRAClient(targetMachineID, 30000L);
                } else {
                    System.out.println("[Testing] Will open a PATCHED client to target machine " + targetMachineID);
                    ras = client.getRAClient(targetMachineID);
                }
                System.out.println("Remote time is: " + ras.getRemoteTime());
                System.out.println("Exiting now, without explicit shutdown");
            }
            System.out.println("TechTest exiting now");
            System.exit(0);
        }
        jwa = JWTesting.createReportServer();
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
        SimpleHelpFrame.setLnf();
        Method[] methods = TechTest.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("test") && !name.startsWith("hidden")) continue;
            System.out.println("[Testcase] " + name);
            tests.add(methods[i]);
        }
        long seed = System.currentTimeMillis();
        r = new Random(seed);
        System.out.println("[Seed] " + seed);
        TestUI testui = new TestUI();
        rpc = testui;
    }

    public static void runOneTestcase(JWTesting jwa, String name) throws Exception {
        Method method = null;
        if (name == null) {
            int choice = r.nextInt(tests.size());
            method = tests.get(choice);
        } else {
            for (int i = 0; i < tests.size(); ++i) {
                System.out.println("[Testing] Checking vs " + tests.get(i).getName());
                if (!tests.get(i).getName().equalsIgnoreCase(name)) continue;
                System.out.println("[Testing] Matched: " + tests.get(i));
                method = tests.get(i);
                break;
            }
        }
        System.out.println("[Testing] running testcase " + name + " / " + method.getName() + " (already run x" + counter.getInt(method.getName(), 0) + ")");
        counter.add(method.getName(), 1.0);
        Properties props = new Properties();
        props.setProperty("TEST_AM_TESTING", "true");
        props.setProperty("RANDOMISE_CONNECTION_TYPES", "true");
        if (testLaunchProperties != null) {
            for (String string : testLaunchProperties.keySet()) {
                String value = testLaunchProperties.getProperty(string);
                System.out.println("[Testing] Setting launch property sent from test control: " + string + "=" + value);
                props.setProperty(string, value);
            }
        } else {
            System.out.println("[Testing] WARNING no test launch properties, if this is a local test and we didn't defer control that is OK");
        }
        jwa.prepareTestInstance(props);
        method.invoke((Object)new TechTest(), props);
        System.out.println("[Testing] Launching with props: " + props);
        String vapp = props.getProperty("TEST_VAPP");
        if (vapp != null) {
            JWSystem.forkVirtualApp(vapp, props, new String[0]);
        } else {
            JWSystem.forkVirtualApp(OemBranding.OEM_TECHNICIAN_APP_NAME, props, new String[0]);
        }
        Thread.sleep(2000L);
    }

    public void hiddenTestTechClientDeferControl(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_DEFER_CONTROL", "true");
        props.setProperty("TEST_TECHUI_LOGIN_DEFER_TO_HOST", deferredControlToHost);
        JWTesting.reportAttempt("TechUI Login", "", 60000);
    }

    public void testLongRunningSessionStability(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_CYCLEUI_LAUNCH_ONE_ACCESS_SESSION", "true");
        props.setProperty("TEST_SESSIONS_CHECK_CONN_STABILITY", "true");
    }

    public void testConnectionPatching(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_CYCLEUI_LAUNCH_ONE_ACCESS_SESSION", "true");
        props.setProperty("TEST_SESSIONS_CHECK_PATCHING", "true");
    }

    public void testRandomQuitSessionPatching(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_LAUNCH_ONE_ACCESS_SESSION_QUIT", "true");
        props.setProperty("TEST_SESSIONS_CHECK_PATCHING", "true");
    }

    public void testCloseSession(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_CYCLEUI_LAUNCH_ONE_ACCESS_SESSION", "true");
        props.setProperty("TEST_SESSIONS_DO_NOTHING_DISCONNECT", "true");
    }

    public void testChurnAlertUpdates(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_CHURN_ALERTS", "true");
    }

    public void testQuitTechUiBeforeLoginAttempt(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_QUIT_TECHUI_BEFORE_LOGIN_ATTEMPT", "true");
    }

    public void testQuitTechUiAfterLogin(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_QUIT_TECHUI_AFTER_LOGIN", "true");
    }

    public void testTechUiRandomQuit(Properties props) {
        this.setupAutoLogin(props);
        JWLaunchProperties.overrideProperty("exit_timebomb", "" + Testing.getFrontWeightedRandom(15000, 90000));
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_TECHUI_CYCLEUI", "true");
        props.setProperty("TEST_TECHUI_WAIT_FOREVER", "true");
    }

    public void testCloseTechUiAfterLogin(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
        props.setProperty("TEST_CLOSE_TECHUI_AFTER_LOGIN", "true");
    }

    public void testTechUiLoginLogout(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_TECHUI_LOGIN_LOGOUT", "true");
        JWTesting.reportAttempt("TechUI Login", "", 60000);
    }

    public void testRaInstallAndUpgrade(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_VAPP", "SgSetupUtility");
        props.setProperty("launch_elevate", "true");
    }

    public void testRaClientRandomTerminate(Properties props) {
        this.setupAutoLogin(props);
        props.setProperty("TEST_VAPP", "AutoTest");
        props.setProperty("TEST_SETUP_TECH_CLIENT", "true");
        props.setProperty("TEST_RACLIENT_TARGET", raClientMachineID);
        JWLaunchProperties.overrideProperty("exit_timebomb", "" + Testing.getFrontWeightedRandom(15000, 90000));
    }

    public void setupAutoLogin(Properties props) {
        if (updateUrlOverride != null) {
            System.out.println("Overriding update URL to " + updateUrlOverride);
            props.setProperty("update_url", updateUrlOverride);
            JWLaunchProperties.overrideDynamicProperty("update_url", updateUrlOverride);
        }
        props.setProperty("shpkhash", serverPkhash);
        props.setProperty("technician", OemBranding.OEM_ADMIN_USERNAME);
        props.setProperty("password", passw);
    }

    static {
        deferredControlToHost = "none";
        updateUrlOverride = null;
        tests = new ArrayList();
        counter = new Counter();
        tchost = new JTextField("localhost");
        tcon = new GbPanel();
    }

    static class Driver
    extends Thread {
        String mode;

        public Driver(String mode) {
            this.mode = mode;
        }

        @Override
        public void run() {
            boolean openBrowser;
            block61: {
                openBrowser = true;
                try {
                    System.out.println("Asked to launch " + this.mode);
                    if (this.mode.contains("Random Mix")) break block61;
                    if (this.mode.contains("Tech Session Launch Test")) {
                        try {
                            jwa.openBrowser();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                        while (true) {
                            try {
                                TechTest.runOneTestcase(jwa, "testCloseSession");
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (Exception x) {}
                        }
                    }
                    if (this.mode.contains("Tech Quit Test")) {
                        for (int i = 0; i < 10000000; ++i) {
                            int next = r.nextInt(100);
                            if (next < 10) {
                                TechTest.runOneTestcase(jwa, "testQuitTechUiBeforeLoginAttempt");
                            } else if (next < 20) {
                                TechTest.runOneTestcase(jwa, "testQuitTechUiAfterLogin");
                            } else if (next < 30) {
                                TechTest.runOneTestcase(jwa, "testCloseSession");
                            } else if (Math.random() < 0.5) {
                                TechTest.runOneTestcase(jwa, "testTechUiRandomQuit");
                            } else {
                                TechTest.runOneTestcase(jwa, "testRandomQuitSessionPatching");
                            }
                            Thread.sleep(14400L);
                        }
                    } else if (this.mode.contains("Alert Churn")) {
                        TechTest.runOneTestcase(jwa, "testChurnAlertUpdates");
                    } else if (this.mode.contains("Session Quit Test")) {
                        openBrowser = false;
                        for (int i = 0; i < 1000; ++i) {
                            int next = r.nextInt(20);
                            if (next < 10) {
                                TechTest.runOneTestcase(jwa, "testRandomQuitSessionPatching");
                            } else if (next < 20) {
                                TechTest.runOneTestcase(jwa, "testCloseSession");
                            }
                            Thread.sleep(14400L);
                        }
                    } else if (this.mode.contains("Stability Test x4")) {
                        for (int i = 0; i < 4; ++i) {
                            TechTest.runOneTestcase(jwa, "testLongRunningSessionStability");
                            Thread.sleep(1000L);
                        }
                    } else if (this.mode.contains("RAClient Leak Test")) {
                        openBrowser = false;
                        raClientMachineID = SHGlassOptionPane.showInputDialog(rpc, "Target RA Service ID", "Target RA Service", "Continue", "SG_...");
                        for (int i = 0; i < 4000; ++i) {
                            TechTest.runOneTestcase(jwa, "testRaClientRandomTerminate");
                            Thread.sleep(20000L);
                        }
                    } else if (this.mode.contains("Hung Socket Test (HTTP)")) {
                        openBrowser = false;
                        String url = JWSystem.getUpdateURL();
                        if (url.toLowerCase().startsWith("https://")) {
                            url = "http" + url.substring(5);
                        }
                        FrameworkBattery.testHungSgSocketTimeouts(url, 300);
                        SHGlassOptionPane.showMessageDialog(rpc, "300 HTTP sockets generated OK", "Complete", null, "Close");
                    } else if (this.mode.contains("Hung Socket Test (HTTPS)")) {
                        openBrowser = false;
                        String url = JWSystem.getUpdateURL();
                        if (url.toLowerCase().startsWith("http://")) {
                            url = "https" + url.substring(4);
                        }
                        FrameworkBattery.testHungSgSocketTimeouts(url, 300);
                        SHGlassOptionPane.showMessageDialog(rpc, "300 HTTPS (SSL) sockets generated OK", "Complete", null, "Close");
                    } else if (this.mode.contains("SelectPool Timeout Test")) {
                        openBrowser = false;
                        String url = JWSystem.getUpdateURL();
                        URLParser parser = new URLParser(url);
                        SHGlassOptionPane.showMessageDialog(rpc, "Opening 120 HTTP sockets and selectable queries (approx 2 mins)", "Ready", null, "Close");
                        WdsSelectTimeoutTest.provokeSelectPoolTimeouts(120, 1000L, false, parser.getHostname(), parser.getPort(true));
                        SHGlassOptionPane.showMessageDialog(rpc, "Opening 120 HTTPS sockets and selectable queries (approx 2 mins)", "Ready", null, "Close");
                        WdsSelectTimeoutTest.provokeSelectPoolTimeouts(120, 1000L, true, parser.getHostname(), parser.getPort(true));
                        SHGlassOptionPane.showMessageDialog(rpc, "All sockets complete, please wait 10 minutes and check for leaked sockets", "Complete", null, "Close");
                    } else if (this.mode.contains("Server API Level Test")) {
                        openBrowser = false;
                        String url = JWSystem.getUpdateURL();
                        URLParser parser = new URLParser(url);
                        FrameworkBattery battery = new FrameworkBattery(parser.getHostname(), parser.getPort(true), passw);
                        String errors = battery.getErrors();
                        if (errors.length() == 0) {
                            SHGlassOptionPane.showMessageDialog(rpc, "All tests completed OK\n" + battery.getInfo(), "Complete", null, "Close");
                        } else {
                            SHGlassOptionPane.showMessageDialog(rpc, "Tests completed with some errors:\n" + errors + "\n\n" + battery.getInfo(), "Complete", null, "Close");
                        }
                    } else if (this.mode.contains("RA Install and Upgrade")) {
                        TechTest.runOneTestcase(jwa, "testRaInstallAndUpgrade");
                        jwa.setInactivityTimeout(900000);
                    } else if (this.mode.contains("Patching Test x4")) {
                        for (int i = 0; i < 4; ++i) {
                            TechTest.runOneTestcase(jwa, "testConnectionPatching");
                            Thread.sleep(1000L);
                        }
                    } else {
                        if (this.mode.contains("Session Concurrency")) {
                            if (JWTestControl.getConnected(TestUtils.APP_TECH_TEST) == 0) {
                                SHGlassOptionPane.showMessageDialog(rpc, "Please launch one or more Tech Test clients and defer control to this host", "No Tech Test clients available", null, "Close");
                                return;
                            }
                            openBrowser = false;
                            Message msg = new Message();
                            msg.append(JWLaunchProperties.getProperty("update_url"));
                            msg.append(passw);
                            JWTestControl.callAll(TestUtils.APP_TECH_TEST, TestUtils.TT_CMD_setServerInfo, msg);
                            String ret = SHGlassOptionPane.showInputDialog(rpc, "Enter the number of required sessions", "Remote Access Sessions", "Launch", "2");
                            SessionReconnectTest.createSessionReconnectTest(Integer.parseInt(ret)).launch();
                            return;
                        }
                        if (this.mode.contains("Session Stage")) {
                            if (JWTestControl.getConnected(TestUtils.APP_TECH_TEST) == 0) {
                                SHGlassOptionPane.showMessageDialog(rpc, "Please launch one or more Tech Test clients and defer control to this host", "No Tech Test clients available", null, "Close");
                                return;
                            }
                            openBrowser = false;
                            Message msg = new Message();
                            msg.append(JWLaunchProperties.getProperty("update_url"));
                            msg.append(passw);
                            JWTestControl.callAll(TestUtils.APP_TECH_TEST, TestUtils.TT_CMD_setServerInfo, msg);
                            String ret = SHGlassOptionPane.showInputDialog(rpc, "Enter the number of required sessions", "Remote Access Sessions", "Launch", "2");
                            SessionStageTest.createSessionStageTest(Integer.parseInt(ret), rpc).launch();
                            return;
                        }
                        if (this.mode.contains("Long Mix")) {
                            if (JWTestControl.getConnected(TestUtils.APP_TECH_TEST) == 0) {
                                SHGlassOptionPane.showMessageDialog(rpc, "Please launch one or more Tech Test and RA Service instances and defer control to this host", "No Tech Test clients available", null, "Close");
                                return;
                            }
                            LongChurnTest.createLongChurnTest(false).launch();
                            return;
                        }
                        TechTest.runOneTestcase(jwa, this.mode);
                    }
                }
                catch (Throwable t) {
                    System.out.println("***ERROR executing " + this.mode + ": " + t);
                    t.printStackTrace();
                }
            }
            if (openBrowser) {
                try {
                    jwa.openBrowser();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            JWAutomate.sleep(20000L);
            jwa.noMoreTestcases();
            System.out.println("[Testing] All Testing FINISHED");
        }
    }

    static class TestUI
    extends JFrame
    implements ActionListener,
    JWTestable {
        JPanel top = new JPanel();
        JTabbedPane pane = new JTabbedPane();
        JLabel shared = new JLabel("Shared Apps: (please wait...)");
        GbPanel login = new GbPanel();
        GbPanel inds = new GbPanel();
        GbPanel main = new GbPanel();
        String adminPass;
        ArrayList<JButton> buttons = new ArrayList();
        ArrayList<JButton> bigdriven = new ArrayList();
        Insets is = new Insets(3, 3, 3, 3);
        int H = 0;
        int HI = 0;
        static String CONTROL_DEFERRED = null;

        String delim() {
            return ",   ";
        }

        String getCount(String name) {
            return JWTestControl.getAvailable(name) + "/" + JWTestControl.getConnected(name);
        }

        public TestUI() {
            this.addWindowListener(new SystemExitWindowListener());
            this.getContentPane().add(this.top);
            this.shared.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.top.setLayout(new BorderLayout());
            this.top.add("Center", this.pane);
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.add("North", this.shared);
            this.top.add("North", tmp);
            new SharedAppsUpdate().start();
            this.pane.addTab("Tests", new JScrollPane(this.main));
            this.pane.addTab("Test Control", tcon);
            tcon.add(new JLabel("Defer control to"), 0, 0, 1, 1, 1, 1, 18, 0, this.is);
            tcon.add(tchost, 1, 0, 2, 1, 1, 1, 18, 2, this.is);
            JButton defer = new JButton("Defer Control");
            JButton deferAuto = new JButton("Defer Automatically");
            defer.addActionListener(this);
            deferAuto.addActionListener(this);
            tcon.add(defer, 1, 1, 1, 1, 1, 1, 13, 0, this.is);
            tcon.add(deferAuto, 2, 1, 1, 1, 1, 1, 13, 0, this.is);
            tcon.add(new JPanel(), 1, 3, 1, 1, 100, 100, 10, 1, this.is);
            this.addButton("images/svg/security/shield.svg,48", "Stability Test x4 (1-2days)", "1) Run the specified number of sessions.\n2) Switch through all the connection options at least once.\n3) Allow them to run for at least 5 minutes to check their stability.", false);
            this.addButton("images/svg/arrows/refresh.svg,48", "Patching Test x4 (1-2hrs)", "1) Run the specified number of sessions.\n2) Switch through all the connection options x1000 total as quickly as possible, then finish.", false);
            this.addButton("images/svg/technology/screen.svg,48", "images/svg/arrows/refresh.svg,24", "RA Install and Upgrade", "Tests RA installation and upgrades on the local machine.\nRun ONLY ONE at a time otherwise they may interfere with each other.", false);
            this.addButton("images/svg/technology/screen.svg,48", "images/svg/computing/network.svg,24", "RAClient Leak Test", "Opens RAClients to the designated remote machine, both direct and patched.  Terminates them at random times without cleanup.\nThe socket and NL connection will be left open so you should watch the thread and memory usage of the remote RA service.", false);
            this.addButton("images/svg/computing/monolith.svg,48", "images/svg/security/shield.svg,24", "Hung Socket Test (HTTP)", "Creates hundreds of (simulated) Remote Access Service ping attempts that will hang during the select phase for the server.\nThe socket will be left open, verify the server times them out using check on server using PX_DEBUG_SOCKET_LEAKS or PX_DEBUG_SOCKET_ALL.", false);
            this.addButton("images/svg/computing/monolith.svg,48", "images/svg/security/shield.svg,24", "Hung Socket Test (HTTPS)", "Creates hundreds of (simulated) Remote Access Service ping attempts that will hang during the select phase for the server.\nThe socket will be left open, verify the server times them out using check on server using PX_DEBUG_SOCKET_LEAKS or PX_DEBUG_SOCKET_ALL.", false);
            this.addButton("images/svg/computing/monolith.svg,48", "images/svg/computing/network.svg,24", "Server API Level Test", "Opens a tech client to the server, analyses the available machines for a HTTP, HTTPS and UDP service, then polls them quickly for configuration files.\nRuns a number of other tests to verify concurrent and fast API access.", false);
            this.addButton("images/svg/computing/window.svg,48", "images/svg/general/remove.svg,24", "Tech Quit Test (cont)", "Continuously launch TechUI and session instances over time that quit randomly or close before or after login.\n\n(Test result output is NOT meaningful, instead check server memory usage, thread count and dumps)", false);
            this.addButton("images/svg/computing/window.svg,48", "images/svg/arrows/refresh.svg,24", "Tech Session Launch Test", "Launch sessions continuously and ensure they connect correctly.", false);
            this.addButton("images/svg/alert-flags/yellow.svg,48", "Alert Churn (cont)", "Continuously churn all alerts on and off over time to create model updates to machines", false);
            this.addButton("images/svg/computing/window.svg,48", "images/svg/general/table.svg,24", "Session Concurrency Test (cont)", "Requires Tech Test clients to defer control to this host for test control.\n\nLaunch the specified number of sessions and continuously reconnects them at the same time.\n\n(Test result output is NOT meaningful, instead check server for pauses etc)", false);
            this.addButton("images/svg/computing/window.svg,48", "images/svg/general/ok.svg,24", "Session Stage Test (cont)", "Requires Tech Test clients to defer control to this host for test control.\n\nLaunch the specified number of sessions and takes them through stages at the same time.\n\n(Test result output is NOT meaningful, instead check server for spikes etc)", false);
            this.addButton("images/svg/general/hourglass.svg,48", "Long Mix x" + PROCS_MAX + " (days)", "Requires RA Services Test clients to defer control to this host for test control.\n\n1) Launch a selection of testcases, monitoring and sessions.\n2) Keep up to " + PROCS_MAX + " of them running continuously, varying everything possible including RA services going online/offline/changing configs/monitoring states/various types of forced failure etc", true);
            for (int i = 0; i < tests.size(); ++i) {
                Method m = tests.get(i);
                this.addSinglesButton("images/svg/dialogs/information.svg,48", m.getName(), "", false);
            }
            this.main.add(new JPanel(), 0, this.H++, 1, 1, 1, 1000, 15, 3, this.is);
            this.inds.add(new JPanel(), 0, this.HI++, 1, 1, 1, 1000, 15, 3, this.is);
            this.setBounds(100, 100, 800, 800);
            this.setVisible(true);
            String deferHost = JWLaunchProperties.getProperty("DEFER_CONTROL");
            if (JWLaunchProperties.getBooleanProperty("AUTO_DEFER_CONTROL", false)) {
                System.out.println("[Testing] Will automatically defer test control if possible");
                new ShareThread(null).start();
            } else if (deferHost.length() > 0) {
                System.out.println("[Testing] Will automatically defer test control to " + deferHost);
                new ShareThread(deferHost).start();
            } else {
                System.out.println("[Testing] Listening for shared deferred test controls...");
                try {
                    JWTestControl.listenForShared(TestUtils.TESTCONTROL_PORT, TestUtils.TESTCONTROL_MCPORT);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
            try {
                String target;
                File targetServer = new File("techTestTargetServer");
                System.out.println("[Testing] My server is " + JWSystem.getUpdateURL());
                if (targetServer.exists()) {
                    target = SHGlassOptionPane.showInputDialog(this, "Target server (empty for default)", "Target Server URL", "Continue", FileUtil.readFileAsStringUTF8(targetServer));
                } else {
                    String url = JWSystem.getUpdateURL();
                    if (url.endsWith("technician/")) {
                        url = url.substring(0, url.length() - "technician/".length());
                    }
                    target = SHGlassOptionPane.showInputDialog(this, "Target server (leave for default)", "Target Server URL", "Continue", url);
                }
                if (target.trim().length() == 0) {
                    target = JWSystem.getUpdateURL();
                } else {
                    FileUtil.writeFileAsStringUTF8(targetServer, target);
                }
                JWLaunchProperties.overrideDynamicProperty("update_url", target);
                System.out.println("[Testing] Target server is now " + target);
                serverPkhash = UrlFetch.grabAsUTF8(UrlFetch.buildUrlFrom(target, "/pubkeyhash"));
                System.out.println("[Testing] Target server pkhash is " + serverPkhash);
                JWLaunchProperties.overrideDynamicProperty("shpkhash", serverPkhash);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            try {
                File folder = new File(".");
                try {
                    folder = JWSystem.getAllAppVersionsSharedFolder();
                }
                catch (Exception target) {
                    // empty catch block
                }
                File adminPassFile = new File(folder, "techTestServerPass");
                this.adminPass = adminPassFile.exists() ? SHGlassOptionPane.showInputDialog(this, "Please enter the admin password", "Admin Password", "Continue", FileUtil.readFileAsStringUTF8(adminPassFile)) : SHGlassOptionPane.showInputDialog(this, "Please enter the admin password", "Admin Password", "Continue", "");
                passw = this.adminPass;
                FileUtil.writeFileAsStringUTF8(adminPassFile, this.adminPass);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public void addButton(String icon, String s, String desc, boolean requiresTestApps) {
            this.addButton(icon, null, s, desc, requiresTestApps);
        }

        public void addButton(String icon, String overlay, String s, String desc, boolean requiresTestApps) {
            GbPanel panel = new GbPanel();
            Color g = panel.getBackground();
            g = new Color(g.getRed() - 40, g.getGreen() - 40, g.getBlue() - 20);
            LineBorder lb = new LineBorder(g, 1, true);
            panel.setBorder(new CompoundBorder(lb, new EmptyBorder(5, 5, 5, 5)));
            JButton button = new JButton(s);
            button.addActionListener(this);
            JTextArea jl = new JTextArea(desc);
            jl.setWrapStyleWord(true);
            jl.setLineWrap(true);
            jl.setFont(panel.getFont());
            jl.setBackground(panel.getBackground());
            jl.setForeground(panel.getForeground());
            jl.setEditable(false);
            jl.setHighlighter(null);
            JLabel head = new JLabel(s);
            head.setFont(head.getFont().deriveFont(1));
            JLabel label = overlay != null ? new JLabel(ImageLoader.getImageIcon(Icons.overlay(icon, overlay))) : new JLabel(ImageLoader.getImageIcon(icon));
            panel.add(label, 0, 0, 1, 3, 1, 1, 18, 0, this.is);
            panel.add(head, 1, 0, 1, 1, 1, 1, 10, 0, this.is);
            panel.add(jl, 1, 1, 1, 1, 100, 1, 18, 2, this.is);
            panel.add(button, 1, 2, 1, 1, 1, 1, 13, 0, this.is);
            this.main.add(panel, 0, this.H++, 1, 1, 1, 1, 10, 2, this.is);
            if (requiresTestApps) {
                this.bigdriven.add(button);
            }
        }

        public void addSinglesButton(String icon, String s, String desc, boolean requiresTestApps) {
            JButton button = new JButton(s);
            button.setToolTipText(desc);
            button.addActionListener(this);
            this.inds.add(button, 1, this.HI++, 1, 1, 1, 1, 10, 2, this.is);
            this.buttons.add(button);
            if (requiresTestApps) {
                this.bigdriven.add(button);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = ((JButton)e.getSource()).getText();
            if (text.contains("Defer Control")) {
                String host;
                deferredControlToHost = host = tchost.getText();
                try {
                    JWTestControl.shareJWT(this, host, TestUtils.TESTCONTROL_PORT);
                    CONTROL_DEFERRED = host;
                    SHGlassOptionPane.showMessageDialog(this, "Deferring control to " + host, "Deferring Control", null, "Close");
                }
                catch (IOException x) {
                    SHGlassOptionPane.showMessageDialog(this, "Failed to defer control to " + host + " (" + x + ")", "Failed to defer control", null, "Close");
                }
            } else if (text.contains("Defer Auto")) {
                new ShareThread(null).start();
            } else {
                passw = this.adminPass;
                for (int i = 0; i < this.buttons.size(); ++i) {
                    this.buttons.get(i).setEnabled(false);
                }
                new Driver(text).start();
            }
        }

        @Override
        public String getTestableAppName() {
            return TestUtils.APP_TECH_TEST;
        }

        @Override
        public void call(String str, Message m) throws IOException {
            if (str.equals(TestUtils.TT_CMD_setServerInfo)) {
                try {
                    updateUrlOverride = m.getNextString();
                    passw = m.getNextString();
                    System.out.println("TestControl set server admin password and update URL to " + updateUrlOverride);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else if (str.equals(TestUtils.TT_CMD_startTechUi)) {
                try {
                    TechTest.runOneTestcase(jwa, "hiddenTestTechClientDeferControl");
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else if (str.equals(TestUtils.TT_CMD_setLaunchProps)) {
                TypedMap map = TypedMap.fromCompressedMessage(m);
                testLaunchProperties = map.getPropertiesCopy("all");
            }
        }

        @Override
        public void testControlConnectionFailed() {
            System.out.println("[Testing] JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail("JWTestControl connection failed to TechTest", "");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }

        class ShareThread
        extends Thread {
            String target;

            public ShareThread(String target) {
                this.target = target;
            }

            @Override
            public void run() {
                try {
                    if (this.target != null) {
                        JWTestControl.shareJWT(TestUI.this, this.target, TestUtils.TESTCONTROL_PORT);
                        deferredControlToHost = this.target;
                        SHGlassOptionPane.showMessageDialog(TestUI.this, "Deferred control to " + this.target + " OK", "Deferring Control", null, "Close");
                    } else {
                        deferredControlToHost = CONTROL_DEFERRED = JWTestControl.shareJWT(TestUI.this, TestUtils.TESTCONTROL_MCPORT);
                        SHGlassOptionPane.showMessageDialog(TestUI.this, "Deferred control to " + CONTROL_DEFERRED + " OK", "Deferring Control", null, "Close");
                    }
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }

        class SharedUpdate
        implements Runnable {
            String s;

            public SharedUpdate(String s) {
                this.s = s;
            }

            @Override
            public void run() {
                TestUI.this.shared.setText(this.s);
                TestUI.this.shared.repaint();
                boolean valid = true;
                if (JWTestControl.getConnected(TestUtils.APP_RA_TEST) == 0 || JWTestControl.getConnected(TestUtils.APP_RS_CUST_TEST) == 0 || JWTestControl.getConnected(TestUtils.APP_TECH_TEST) == 0) {
                    valid = false;
                }
                for (int i = 0; i < TestUI.this.bigdriven.size(); ++i) {
                    TestUI.this.bigdriven.get(i).setEnabled(valid);
                }
            }
        }

        class SharedAppsUpdate
        extends Thread {
            SharedAppsUpdate() {
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("Shared Apps:  ");
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_RA_TEST) + " AccessTest" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_RS_CUST_TEST) + " CustTest" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_TECH_TEST) + " TechTest" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_RA_SERVICE) + " Service" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_RS_CUST) + " Customer" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_TECH_UI) + " TechUi" + TestUI.this.delim());
                    sb.append(" " + TestUI.this.getCount(TestUtils.APP_TECH_SESSION_GUI) + " Session");
                    SwingUtilities.invokeLater(new SharedUpdate(sb.toString()));
                }
            }
        }
    }
}

