/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.tests.TestUtils;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.message.Message;
import utils.progtools.Counter;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.layout.GbPanel;
import utils.swing.listeners.SystemExitWindowListener;

public class CustomerTest {
    static Random r;
    static ArrayList<Method> tests;
    static Counter counter;
    static JWTesting jwa;
    static TestUI testui;
    static String CONTROL_DEFERRED;
    static int overallMachines;
    static int totalMachines;
    static String baseurl;
    static Font font;
    static String passw;

    public static void main(String[] args) throws Exception {
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
        SimpleHelpFrame.setLnf();
        Method[] methods = CustomerTest.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("test")) continue;
            System.out.println("[Testcase] " + name.substring(4));
            tests.add(methods[i]);
        }
        long seed = System.currentTimeMillis();
        r = new Random(seed);
        System.out.println("[Seed] " + seed);
        jwa = JWTesting.createReportServer(TestUtils.CU_PORT);
        testui = new TestUI();
    }

    public static void runOneTestcase(JWTesting jwa, String name) throws Exception {
        Method method = null;
        if (name == null) {
            int choice = r.nextInt(tests.size());
            method = tests.get(choice);
        } else {
            for (int i = 0; i < tests.size() && !(method = tests.get(i)).getName().equalsIgnoreCase(name); ++i) {
            }
        }
        System.out.println("[Testing] running testcase " + method.getName().substring(4) + " (already run x" + counter.getInt(method.getName(), 0) + ")");
        counter.add(method.getName(), 1.0);
        Properties props = new Properties();
        props.setProperty("TEST_AM_TESTING", "true");
        jwa.prepareTestInstance(props);
        method.invoke((Object)new CustomerTest(), props);
        JWSystem.forkVirtualApp("Remote Support", props, new String[0]);
    }

    public void configureCustomer(Properties props, boolean http) {
        String tmp = baseurl.substring(baseurl.indexOf(58));
        tmp = http ? "http" + tmp : "udp" + tmp;
        System.out.println("URL will be " + tmp);
        props.setProperty("INFO_CUST_URL", tmp);
        props.setProperty("INFO_CUST_NAME", "Test Customer " + Math.abs(r.nextInt()));
        if (CONTROL_DEFERRED != null) {
            props.setProperty("INFO_CUST_DEFER", CONTROL_DEFERRED);
        }
    }

    public void testCustomer(Properties props) {
        this.configureCustomer(props, true);
        JWTesting.reportAttempt("Remote Support Customer Join Queue", "", 120000);
    }

    static {
        tests = new ArrayList();
        counter = new Counter();
        CONTROL_DEFERRED = null;
    }

    static class Driver
    extends Thread {
        String mode;
        boolean sel;

        public Driver(String mode, boolean sel) {
            this.mode = mode;
            this.sel = sel;
        }

        @Override
        public void run() {
            try {
                if (this.mode.contains("Random Mix")) {
                    for (int i = 0; i < totalMachines; ++i) {
                        Thread.sleep(2500L);
                        CustomerTest.runOneTestcase(jwa, null);
                    }
                } else {
                    for (int i = 0; i < totalMachines; ++i) {
                        Thread.sleep(2500L);
                        CustomerTest.runOneTestcase(jwa, this.mode);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            JWAutomate.sleep(20000L);
            System.out.println("[Testing] All Testing FINISHED");
        }
    }

    static class TestUI
    extends JFrame
    implements ActionListener,
    JWTestable {
        JTabbedPane tabs = new JTabbedPane();
        GbPanel main = new GbPanel();
        JTextField jpw = new JTextField();
        JTextField url = new JTextField();
        JTextField tchost = new JTextField("localhost");
        Insets is = new Insets(3, 3, 3, 3);
        int H = 0;
        GbPanel tcon = new GbPanel();

        public TestUI() {
            this.getContentPane().add(this.tabs);
            this.tabs.addTab("Manual Control", new JScrollPane(this.main));
            this.tabs.addTab("Test Control", this.tcon);
            this.tcon.add(new JLabel("Defer control to"), 0, 0, 1, 1, 1, 1, 18, 0, this.is);
            this.tcon.add(this.tchost, 1, 0, 1, 1, 1, 1, 18, 2, this.is);
            JButton defer = new JButton("Defer Control");
            defer.addActionListener(this);
            this.tcon.add(defer, 1, 1, 1, 1, 1, 1, 13, 0, this.is);
            this.tcon.add(new JPanel(), 1, 2, 1, 1, 100, 100, 10, 1, this.is);
            String upd = JWSystem.getUpdateURL();
            if (upd.endsWith("access/")) {
                upd = upd.substring(0, upd.length() - "access/".length());
            }
            if (upd.endsWith("access")) {
                upd = upd.substring(0, upd.length() - "access".length());
            }
            this.url.setText(upd);
            this.main.add(new JLabel("Total Customers"), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            this.main.add(this.jpw, 1, this.H, 1, 1, 100, 1, 17, 2, this.is);
            ++this.H;
            this.jpw.setText("1");
            this.main.add(new JLabel("Server URL"), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            this.main.add(this.url, 1, this.H, 1, 1, 100, 1, 17, 2, this.is);
            ++this.H;
            this.addButton("Random Mix");
            for (int i = 0; i < tests.size(); ++i) {
                Method m = tests.get(i);
                this.addButton(m.getName());
            }
            this.main.add(new JLabel("Test Controls", 0), 0, this.H, 1, 1, 1, 1, 17, 0, this.is);
            ++this.H;
            this.main.add(new JPanel(), 0, this.H++, 1, 1, 1, 1000, 15, 3, this.is);
            this.setBounds(50, 50, 500, 500);
            this.setVisible(true);
            this.addWindowListener(new SystemExitWindowListener());
            if (JWLaunchProperties.getBooleanProperty("AUTO_DEFER_CONTROL", false)) {
                System.out.println("[Testing] Will automatically defer test control if possible");
                new ShareThread().start();
            }
        }

        public void addToggleButton(String s, boolean state) {
            JToggleButton button = new JToggleButton(s, state);
            button.addActionListener(this);
            this.main.add(button, 1, this.H++, 1, 1, 1, 1, 10, 2, this.is);
        }

        public void addButton(String s) {
            JButton button = new JButton(s);
            button.addActionListener(this);
            this.main.add(button, 1, this.H++, 1, 1, 1, 1, 10, 2, this.is);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionPerformed(e.getSource());
        }

        public void actionPerformed(Object o) {
            AbstractButton button = (AbstractButton)o;
            String text = button.getText();
            totalMachines = Integer.parseInt(this.jpw.getText());
            baseurl = this.url.getText();
            if (text.contains("Defer Control")) {
                String host = this.tchost.getText();
                try {
                    JWTestControl.shareJWT(this, host, TestUtils.TESTCONTROL_PORT);
                    CONTROL_DEFERRED = host;
                    SHGlassOptionPane.showMessageDialog(this, "Deferring control to " + host, "Deferring Control", null, "Close");
                }
                catch (IOException x) {
                    SHGlassOptionPane.showMessageDialog(this, "Failed to defer control to " + host + " (" + x + ")", "Failed to defer control", null, "Close");
                }
            } else {
                new Driver(text, button.isSelected()).start();
            }
        }

        @Override
        public String getTestableAppName() {
            return TestUtils.APP_RS_CUST_TEST;
        }

        @Override
        public void call(String str, Message m) throws IOException {
            try {
                baseurl = this.url.getText();
                if (str.contains(TestUtils.RSC_CMD_startCustomer)) {
                    CustomerTest.runOneTestcase(jwa, "testCustomer");
                }
            }
            catch (Exception x) {
                IOException tmp = new IOException("Failed " + x);
                tmp.initCause(x);
                throw tmp;
            }
        }

        @Override
        public void testControlConnectionFailed() {
            System.out.println("[Testing] JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail("JWTestControl connection failed to CustomerTest", "");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }

        class ShareThread
        extends Thread {
            ShareThread() {
            }

            @Override
            public void run() {
                try {
                    CONTROL_DEFERRED = JWTestControl.shareJWT(TestUI.this, TestUtils.TESTCONTROL_MCPORT);
                    SHGlassOptionPane.showMessageDialog(TestUI.this, "Deferring control to " + CONTROL_DEFERRED, "Deferring Control", null, "Close");
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

