/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.swing;

import com.aem.shelp.common.Language;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.SHComboBox;
import utils.swing.layout.GbPanel;

public class RequestAccessTimeoutPanel {
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private JCheckBox allowAccessBox;
    private SHComboBox allowAccessCombo;
    private boolean allow;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public RequestAccessTimeoutPanel() {
        this.initUI();
    }

    private void initUI() {
        this.allowAccessBox = new JCheckBox(Language.get("AUTOMATICALLY_ALLOW"));
        this.allowAccessCombo = new SHComboBox(new String[]{"30 " + Language.get("UNIT_SECONDS"), "1 " + Language.get("UNIT_MINUTE"), "2 " + Language.get("UNIT_MINUTES"), "5 " + Language.get("UNIT_MINUTES")});
        SwingUtil.setHeight(this.allowAccessCombo, this.allowAccessBox.getPreferredSize().height);
        this.rootComponent.add(this.allowAccessBox, 0, 0, 1, 1, 0, 0, 17, 0);
        this.rootComponent.add(this.allowAccessCombo, 1, 0, 1, 1, 1, 0, 17, 0);
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.allowAccessBox.setSelected(true);
            if (timeout == 30000L) {
                this.allowAccessCombo.setSelectedIndex(0);
            } else if (timeout == 60000L) {
                this.allowAccessCombo.setSelectedIndex(1);
            } else if (timeout == 120000L) {
                this.allowAccessCombo.setSelectedIndex(2);
            } else {
                this.allowAccessCombo.setSelectedIndex(3);
            }
        } else {
            this.allowAccessBox.setSelected(false);
        }
    }

    public long getTimeout() {
        if (this.allowAccessBox.isSelected()) {
            switch (this.allowAccessCombo.getSelectedIndex()) {
                case 0: {
                    return 30000L;
                }
                case 1: {
                    return 60000L;
                }
                case 2: {
                    return 120000L;
                }
            }
            return 300000L;
        }
        return 0L;
    }

    public void setEnabled(boolean enabled) {
        this.allowAccessBox.setEnabled(enabled);
        this.allowAccessCombo.setEnabled(enabled && this.allowAccessBox.isSelected());
    }

    public boolean eventIsFromPanel(ActionEvent e) {
        return e.getSource() == this.allowAccessBox || e.getSource() == this.allowAccessCombo;
    }

    public void addActionListener(ActionListener listener) {
        this.allowAccessBox.addActionListener(listener);
        this.allowAccessCombo.addActionListener(listener);
    }
}

