/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.security;

import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.entropy.EntropyGatherer;
import com.aem.utils.entropy.TimedEntropyWrap;
import com.aem.utils.random.GenericRandom;
import com.aem.utils.random.SecureRandomWrap;
import com.aem.utils.rsa.RSADecryptor;
import com.aem.utils.rsa.RSAEncryptor;
import com.aem.utils.rsa.RSAKeyGen;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import utils.message.Message;
import utils.message.MessageUtils;

public class SecurityUtil {
    public static final int seedbytes = 128;
    public static int sym_keysize = 676;
    public static int rsa_keysize = 1536;
    static GenericRandom rnd = new SecureRandomWrap();
    static EntropyGatherer ent = new TimedEntropyWrap();
    static String[] myPublicKey;
    static RSADecryptor myDecryptor;
    static boolean inited;
    static Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextSecureID() {
        SecurityUtil.init();
        Object object = LOCK;
        synchronized (object) {
            return rnd.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object = LOCK;
        synchronized (object) {
            if (!inited) {
                rnd.init(ent.getBytes(128));
                inited = true;
            }
        }
    }

    public static void testPubkeyGenSpeed(int keysize) {
        long t = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            long tt = System.currentTimeMillis();
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(keysize);
                PublicKey pkey = keyGen.genKeyPair().getPublic();
                KeyFactory fact = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec pub = fact.getKeySpec(pkey, RSAPublicKeySpec.class);
                System.out.println(pub.getModulus());
                System.out.println(pub.getPublicExponent());
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            tt = System.currentTimeMillis() - tt;
            System.out.println("...(Java)" + i + " = " + tt + "ms");
            tt = System.currentTimeMillis();
            RSAKeyGen rsa_keygen = new RSAKeyGen(keysize, rnd, ent, true);
            BigInteger[] pub_key = rsa_keygen.getPublicKey();
            System.out.println(pub_key[0]);
            System.out.println(pub_key[1]);
            tt = System.currentTimeMillis() - tt;
            System.out.println("...(SH)" + i + " = " + tt + "ms");
        }
        t = System.currentTimeMillis() - t;
        System.out.println(keysize + " bits = " + t / 10L + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup() {
        SecurityUtil.init();
        Object object = LOCK;
        synchronized (object) {
            if (myDecryptor == null) {
                RSAKeyGen rsa_keygen = new RSAKeyGen(rsa_keysize, rnd, ent, true);
                BigInteger[] pub_key = rsa_keygen.getPublicKey();
                myPublicKey = new String[2];
                SecurityUtil.myPublicKey[0] = pub_key[0].toString();
                SecurityUtil.myPublicKey[1] = pub_key[1].toString();
                myDecryptor = new RSADecryptor(rsa_keygen.getPrivateKeyCRT());
            }
        }
    }

    public static Object getLOCK() {
        return LOCK;
    }

    public static RSADecryptor getMyRSADecryptor() {
        SecurityUtil.init();
        SecurityUtil.startup();
        return myDecryptor;
    }

    public static String[] getMyPublicKey() {
        SecurityUtil.init();
        SecurityUtil.startup();
        return myPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMyPublicKeySync() {
        SecurityUtil.init();
        Object object = LOCK;
        synchronized (object) {
            if (myDecryptor == null) {
                new GetKeyThread().start();
            }
        }
    }

    public static void WARNING_resetAll() {
        sym_keysize = 676;
        rsa_keysize = 1024;
        rnd = new SecureRandomWrap();
        ent = new TimedEntropyWrap();
        myPublicKey = null;
        myDecryptor = null;
        inited = false;
        LOCK = new Object();
    }

    public static RSAEncryptor getRSAEncryptor(String[] pubkey) {
        SecurityUtil.init();
        BigInteger[] cpub_key = new BigInteger[]{new BigInteger(pubkey[0]), new BigInteger(pubkey[1])};
        RSAEncryptor rsa_enc = new RSAEncryptor(cpub_key);
        return rsa_enc;
    }

    public static byte[] generateSymmetricKey() {
        return SecurityUtil.generateSymmetricKey(sym_keysize / 8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateSymmetricKey(int length, boolean setFirstByteTo1) {
        SecurityUtil.init();
        Object object = LOCK;
        synchronized (object) {
            byte[] keyb = new byte[length];
            rnd.nextBytes(keyb);
            if (setFirstByteTo1) {
                keyb[0] = 1;
            }
            return keyb;
        }
    }

    public static Message readMessage(InputStream bin, Blowfish bfish) throws IOException {
        byte[] dat = StreamUtils.readNBytes(bin, 512000000);
        dat = bfish.decryptSecure(dat, 0, true);
        return MessageUtils.bytesToMessage(dat);
    }

    public static void writeMessage(OutputStream bout, Message m, Blowfish bfish) throws IOException {
        byte[] dat = MessageUtils.messageToBytes(m);
        dat = bfish.encryptSecure(dat, 0, dat.length, true);
        StreamUtils.writeBytes(bout, dat);
        bout.flush();
    }

    public static Message encryptMessage(Message m, Blowfish bfish) {
        byte[] dat = MessageUtils.messageToBytes(m);
        dat = bfish.encryptSecure(dat, 0, dat.length, true);
        Message t = new Message();
        t.append(dat);
        return t;
    }

    public static Message decryptMessage(Message m, Blowfish bfish) {
        byte[] dat = (byte[])m.get(0);
        dat = bfish.decryptSecure(dat, 0, true);
        return MessageUtils.bytesToMessage(dat);
    }

    public static String generateNonAmbiguousCode(int codeLength) {
        byte[] generateSymmetricKey = SecurityUtil.generateSymmetricKey(codeLength * 2, false);
        StringBuffer buffer = new StringBuffer();
        String ambiguousChars = "0O1QIL";
        int keyIndex = 0;
        for (int i = 0; i < codeLength; ++i) {
            char newChar = '0';
            boolean okChar = false;
            while (!okChar) {
                int c;
                int nextByte;
                if (keyIndex == generateSymmetricKey.length) {
                    generateSymmetricKey = SecurityUtil.generateSymmetricKey(codeLength * 2, false);
                }
                if ((nextByte = generateSymmetricKey[keyIndex++]) < 0) {
                    nextByte += 256;
                }
                if (ambiguousChars.indexOf(newChar = (c = nextByte % 34) < 26 ? (char)(65 + c) : (char)(48 + (c - 26))) != -1) continue;
                okChar = true;
            }
            buffer.append(newChar);
        }
        return buffer.toString();
    }

    static {
        inited = false;
        LOCK = new Object();
    }

    static class GetKeyThread
    extends Thread {
        public GetKeyThread() {
            super("GetKeyThread");
        }

        @Override
        public void run() {
            SecurityUtil.init();
            SecurityUtil.startup();
        }
    }
}

