/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.progress;

import com.aem.shelp.util.progress.SHColorProvider;
import java.awt.GridLayout;
import javax.swing.JPanel;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.icons.ProgressRef;

public class SHProgressIcons {
    public static final int SIZE_72 = SimpleHelpLookAndFeel.scale(72);
    public static final int SIZE_56 = SimpleHelpLookAndFeel.scale(56);
    public static final int SIZE_48 = SimpleHelpLookAndFeel.scale(48);
    public static final int SIZE_24 = SimpleHelpLookAndFeel.scale(24);
    public static final int SIZE_16 = SimpleHelpLookAndFeel.scale(16);

    public static CircularProgressLabel getCircularLabel(int size) {
        return new CircularProgressLabel(SHProgressIcons.getCircular(size));
    }

    public static CircularProgressLabel getCircularInfiniteLabel(int size) {
        return new CircularProgressLabel(SHProgressIcons.getCircularInfinite(size));
    }

    public static InfiniteCircularProgressIcon getCircularInfinite(int size) {
        InfiniteCircularProgressIcon icon = new InfiniteCircularProgressIcon(size, size, new SHColorProvider());
        if (size <= SIZE_16) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(8), SimpleHelpLookAndFeel.scale(0));
            icon.reinitRingCount(1);
            icon.setForceInnerSpace(false);
        } else if (size <= SIZE_24) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(2));
            icon.reinitRingCount(2);
            icon.setForceInnerSpace(false);
        } else if (size <= SIZE_56) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(12), SimpleHelpLookAndFeel.scale(2));
            icon.reinitRingCount(3);
        } else {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(14), SimpleHelpLookAndFeel.scale(2));
            icon.reinitRingCount(3);
        }
        icon.setDrawBackground(true);
        return icon;
    }

    public static CircularProgressIcon getCircular(int size) {
        CircularProgressIcon icon = new CircularProgressIcon(size, size, new SHColorProvider());
        if (size <= SIZE_16) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(8), 0);
            icon.setForceInnerSpace(false);
        } else if (size <= SIZE_24) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(10), SimpleHelpLookAndFeel.scale(2));
            icon.setForceInnerSpace(false);
        } else if (size <= SIZE_56) {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(12), SimpleHelpLookAndFeel.scale(2));
        } else {
            icon.setArcDimensions(SimpleHelpLookAndFeel.scale(14), SimpleHelpLookAndFeel.scale(2));
        }
        icon.setDrawBackground(true);
        return icon;
    }

    private static CircularProgressIcon getCircular(int size, ProgressRef[] refs) {
        CircularProgressIcon icons = SHProgressIcons.getCircular(size);
        for (int i = 0; i < refs.length; ++i) {
            if (size == 16 && i == 1) {
                return icons;
            }
            icons.addProgressRef(refs[i]);
        }
        return icons;
    }

    public static void main(String[] args) throws Exception {
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        JPanel main = new JPanel(new GridLayout(4, 4));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 16px", new InfiniteCircularProgressIcon(16, 16)));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 24px", new InfiniteCircularProgressIcon(24, 24)));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 32px", new InfiniteCircularProgressIcon(32, 32)));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 48px", new InfiniteCircularProgressIcon(48, 48)));
        InfiniteCircularProgressIcon icon = new InfiniteCircularProgressIcon(48, 48);
        icon.setOuterBuffer(4);
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 48px - Border 4px", icon));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 56px", new InfiniteCircularProgressIcon(56, 56)));
        main.add(new CircularProgressIcon.LabeledIcon("Infinite 72px", new InfiniteCircularProgressIcon(72, 72)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Infinite 16px", SHProgressIcons.getCircularInfinite(16)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Infinite 24px", SHProgressIcons.getCircularInfinite(24)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Infinite 32px", SHProgressIcons.getCircularInfinite(32)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Infinite 48px", SHProgressIcons.getCircularInfinite(48)));
        CircularProgressIcon cpuLoadAverage = new CircularProgressIcon(56, 56);
        cpuLoadAverage.setRemoveWhenDone(false);
        cpuLoadAverage.setArcDimensions(12, 2);
        ProgressRef[] refs = new ProgressRef[3];
        for (int i = 0; i < 3; ++i) {
            refs[i] = new ProgressRef();
            refs[i].setProgress(0.5 + (double)i * 0.15);
            cpuLoadAverage.addProgressRef(refs[i]);
            cpuLoadAverage.setDrawBackground(false);
        }
        main.add(new CircularProgressIcon.LabeledIcon("SH - Machine Details 56px", cpuLoadAverage));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Circular 16px", SHProgressIcons.getCircular(16, refs)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Circular 24px", SHProgressIcons.getCircular(24, refs)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Circular 32px", SHProgressIcons.getCircular(32, refs)));
        main.add(new CircularProgressIcon.LabeledIcon("SH - Circular 48px", SHProgressIcons.getCircular(48, refs)));
        frame.getContentPane().add(main);
        frame.setVisible(true);
    }
}

