/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.filter;

import com.aem.shelp.util.filter.FilterInterface;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilterTreeModel
implements TreeModel,
FilterInterface {
    private String[] filter = null;
    private ArrayList listeners = new ArrayList();
    protected TreeModel delegate;

    public FilterTreeModel(TreeModel delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getChild(Object parent, int index) {
        int count = 0;
        for (int i = 0; i < this.delegate.getChildCount(parent); ++i) {
            Object child = this.delegate.getChild(parent, i);
            if (!this.isShown(child) || count++ != index) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int count = 0;
        for (int i = 0; i < this.delegate.getChildCount(parent); ++i) {
            Object tempChild = this.delegate.getChild(parent, i);
            if (!this.isShown(tempChild)) continue;
            if (tempChild.equals(child)) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        for (int i = 0; i < this.delegate.getChildCount(parent); ++i) {
            Object child = this.delegate.getChild(parent, i);
            if (!this.isShown(child)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.delegate.isLeaf(node);
    }

    protected boolean matches(String[] filter, Object node) {
        String string = node.toString();
        String tempy = string.toLowerCase();
        for (String aFilter : filter) {
            if (tempy.contains(aFilter)) continue;
            return false;
        }
        return true;
    }

    private boolean doDepthCheck(String[] filter, Object parent) {
        if (filter == null) {
            return true;
        }
        if (this.matches(filter, parent)) {
            return true;
        }
        for (int i = 0; i < this.delegate.getChildCount(parent); ++i) {
            if (!this.doDepthCheck(filter, this.delegate.getChild(parent, i))) continue;
            return true;
        }
        return false;
    }

    private boolean isShown(Object node) {
        return this.doDepthCheck(this.filter, node);
    }

    @Override
    public void setFilters(String[] filter) {
        this.filter = filter;
        if (filter != null) {
            for (int i = 0; i < filter.length; ++i) {
                filter[i] = filter[i].toLowerCase();
            }
        }
        this.refreshEntireTree();
    }

    public void refreshEntireTree() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.delegate.getRoot()});
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TreeModelListener)this.listeners.get(i)).treeStructureChanged(event);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.delegate.valueForPathChanged(path, newValue);
    }

    @Override
    public String[] getFilters() {
        return this.filter;
    }
}

