/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.WEnv;
import com.aem.utils.NativeUtils;
import java.io.File;
import jwrapper.hidden.JWNativeAPI;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.string.CharStack;

public class WSessionInfo {
    private File queryAbsolutePathFile = null;
    private int id;
    private String user;
    private boolean isConsole;
    private String sid;
    private static Object LOCK = new Object();
    private static WSessionThread thread = null;
    private static WSessionInfo info = null;
    private static Object userList_LOCK = new Object();
    private static String[] lines;
    private static String[] out;

    public String getSessionUsername() {
        return this.user;
    }

    public String getSessionSid() {
        return this.sid;
    }

    public int getSessionID() {
        return this.id;
    }

    public boolean isSessionConsole() {
        return this.isConsole;
    }

    public static void main(String[] args) {
        new WSessionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearStaticWSessionInfo() {
        Object object = LOCK;
        synchronized (object) {
            thread = null;
            info = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSessionInfo getStaticWSessionInfo_Slow() {
        WSessionThread th;
        System.out.println("[WSessionInfo] getStaticWSessionInfo called.");
        if (!OS.isWindows()) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            if (thread == null) {
                thread = new WSessionThread();
                thread.start();
            }
            th = thread;
        }
        try {
            th.join();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return info;
    }

    public WSessionInfo() {
        System.out.println("[WSessionInfo] New session info requested.");
        this.init();
    }

    private void init() {
        boolean nativeDetectionOk = false;
        this.isConsole = true;
        this.id = 0;
        boolean redetectUsername = false;
        try {
            System.out.println("[WSessionInfo] Trying native session detection...");
            this.id = JWNativeAPI.getInstance().getTsMySessionId();
            System.out.println("[WSessionInfo] natively detected session as " + this.id);
            int consoleId = JWNativeAPI.getInstance().getTsConsoleSessionId();
            System.out.println("[WSessionInfo] natively detected console as " + consoleId);
            if (this.id == NativeUtils.TS_GET_SESSION_FAILED || consoleId == NativeUtils.TS_GET_SESSION_FAILED) {
                throw new Exception("Failed to natively detect session");
            }
            this.isConsole = this.id == consoleId;
            this.user = JWNativeAPI.getInstance().getUsernameForSession(this.id);
            if (!this.getSidFromUser(true)) {
                this.user = WEnv.getEnv("USERNAME");
                System.out.println("[WSessionInfo] natively detected user as " + this.user);
                if (!this.getSidFromUser(false)) {
                    this.user = System.getProperty("user.name");
                    System.out.println("[WSessionInfo] non-natively redetected user as " + this.user);
                    if (!this.getSidFromUser(false)) {
                        redetectUsername = true;
                    }
                }
            }
            nativeDetectionOk = true;
        }
        catch (Throwable t) {
            System.out.println("[WSessionInfo] Native session detection not possible...");
        }
        if (!nativeDetectionOk || redetectUsername) {
            String[] out;
            try {
                System.out.println("[WSessionInfo] Trying alternative windows current session detection...");
                out = RunCommandGetOutput.runCommandGetOutputThrowErrors("query session");
            }
            catch (Throwable t) {
                System.out.println("[WSessionInfo] Error: " + t.getMessage());
                System.out.println("[WSessionInfo] Trying alternative windows current session detection...");
                try {
                    File queryexe;
                    NativeUtils nutils = null;
                    try {
                        nutils = NativeUtils.getInstance();
                        System.out.println("[WSessionInfo] Got NativeUtils OK in WSessionInfo, trying alternative windows current session detection");
                    }
                    catch (Throwable nt) {
                        System.out.println("[WSessionInfo] Unable to load NativeUtils in WSessionInfo, will use WEnv (" + nt + "), trying alternative windows current session detection");
                    }
                    String windir = WEnv.getEnv("WINDIR").trim();
                    System.out.println("[WSessionInfo] Windir is '" + windir + "'");
                    if (!windir.endsWith("\\")) {
                        windir = windir + "\\";
                    }
                    if (!(queryexe = new File(windir + "System32\\dllcache\\query.exe")).exists()) {
                        queryexe = new File(windir + "System32\\query.exe");
                    }
                    if (!queryexe.exists()) {
                        queryexe = new File(windir + "sysnative\\query.exe");
                    }
                    if (!queryexe.exists()) {
                        queryexe = new File(windir + "SysWOW64\\query.exe");
                    }
                    if (!queryexe.exists() && (queryexe = this.searchForQuery(windir)) != null) {
                        System.out.println("[WSessionInfo] Search for query returned: " + queryexe.getAbsolutePath());
                    }
                    out = RunCommandGetOutput.runCommandGetOutputThrowErrors("\"" + queryexe.getAbsolutePath() + "\" session");
                }
                catch (Throwable tt) {
                    System.out.println("[WSessionInfo] Windows current session detection not possible (" + tt + ")");
                    tt.printStackTrace();
                    return;
                }
            }
            String output = out[0].trim();
            if (output.trim().length() == 0) {
                System.out.println("[WSessionInfo] no output from session query...\n\n");
            }
            String[] lines = output.split("\n");
            System.out.println("[WSessionInfo] picked out zero line:\n" + lines[0]);
            int idIndex = lines[0].indexOf("ID");
            if (idIndex == -1) {
                System.out.println("[WSessionInfo] Unable to find ID index in session query...\n\n");
                idIndex = 36;
            } else {
                idIndex -= 6;
            }
            int userIndex = lines[0].indexOf("USERNAME");
            if (userIndex == -1) {
                System.out.println("[WSessionInfo] Unable to find username index in session query...\n\n");
                userIndex = 19;
            }
            String active = null;
            for (int k = 1; k < lines.length; ++k) {
                if (!lines[k].startsWith(">")) continue;
                active = lines[k].trim();
            }
            System.out.println("[WSessionInfo] picked out active line:\n" + active);
            if (!redetectUsername) {
                this.isConsole = active.startsWith(">console");
                if (this.isConsole) {
                    System.out.println("[WSessionInfo] current session is console");
                } else {
                    System.out.println("[WSessionInfo] current session is not console");
                }
            }
            if (!redetectUsername) {
                try {
                    CharStack cs = new CharStack(active.substring(idIndex));
                    cs.popWhitespace();
                    this.id = (int)cs.popInteger();
                    System.out.println("[WSessionInfo] picked out ID " + this.id);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            try {
                CharStack cs = new CharStack(active.substring(userIndex));
                cs.popWhitespace();
                this.user = cs.popText(true);
                System.out.println("[WSessionInfo] picked out Username " + this.user);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.getSidFromUser(false);
        }
    }

    private File searchForQuery(String windir) {
        if (this.queryAbsolutePathFile != null && this.queryAbsolutePathFile.exists()) {
            return this.queryAbsolutePathFile;
        }
        System.out.println("[WSessionInfo] Cannot find query.exe. Searching...");
        File directory = new File(windir + "winsxs");
        return this.searchForQuery(directory, 2);
    }

    private File searchForQuery(File directory, int depth) {
        if (directory == null || !directory.exists()) {
            return null;
        }
        File[] children = directory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File result;
            File child = children[i];
            if (child == null) continue;
            if (child.isDirectory() && depth != 0 && (result = this.searchForQuery(child, depth - 1)) != null) {
                return result;
            }
            if (!child.getName().toLowerCase().equals("query.exe")) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void slowLoadAllUserSids() {
        Object object = userList_LOCK;
        synchronized (object) {
            if (lines == null) {
                System.out.println("[WSessionInfo] warming up wmic");
                out = WmicUtil.launchWmicCommandGetOutput(new String[]{"registry", "get", "status"});
                System.out.println("[WSessionInfo] calling wmic");
                out = WmicUtil.launchWmicCommandGetOutput(new String[]{"PATH", "Win32_UserAccount", "get", "name,sid"});
                System.out.println("[WSessionInfo] done calling wmic");
                String output = out[0].trim();
                if (output.trim().length() == 0) {
                    System.out.println("[WSessionInfo] empty account query...\n\nSTDOUT[" + out[0] + "]\n\nSTDERR[" + out[1] + "]\n\n");
                }
                lines = output.split("\n");
            }
        }
    }

    private boolean getSidFromUser(boolean currentUser) {
        if (this.user == null) {
            this.user = "";
        }
        System.out.println("[WSessionInfo] WARNING: forced to call old WMIC session detection");
        this.sid = null;
        try {
            WSessionInfo.slowLoadAllUserSids();
            for (int i = 1; i < lines.length; ++i) {
                try {
                    CharStack cs = new CharStack(lines[i]);
                    cs.popWhitespace();
                    String wuser = cs.popText(true);
                    cs.popWhitespace();
                    String wsid = cs.popText(true);
                    if (!this.user.equals(wuser)) continue;
                    this.sid = wsid;
                    System.out.println("[WSessionInfo] picked out SID " + this.sid);
                    break;
                }
                catch (Exception xx) {
                    System.out.println("[WSessionInfo] unable to parse line: " + lines[i]);
                }
            }
            if (this.sid == null) {
                System.out.println("[WSessionInfo] unable to pick sid from account query...\n\nSTDOUT[" + out[0] + "]\n\nSTDERR[" + out[1] + "]\n\n");
                this.sid = "";
                return false;
            }
            return true;
        }
        catch (Exception x) {
            if (this.sid == null) {
                this.sid = "";
            }
            return false;
        }
    }

    static class WSessionThread
    extends Thread {
        WSessionThread() {
        }

        @Override
        public void run() {
            WSessionInfo inf = new WSessionInfo();
            info = inf;
        }
    }
}

