/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.util.WReg;
import utils.ostools.OS;

public class UacPromptModifier {
    private static String uacPath = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\System";
    private static String uacKey = "PromptOnSecureDesktop";
    private static String uacAdminKey = "ConsentPromptBehaviorAdmin";
    private static String uacUserKey = "ConsentPromptBehaviorUser";
    private static String shOrigUacKey = "PromptOnSecureDesktopShOrigSetting";
    private static String shOrigUacAdminKey = "ConsentPromptBehaviorAdminShOrigSetting";
    private static String shOrigUacUserKey = "ConsentPromptBehaviorUserShOrigSetting";
    private static final int DESIRED_ADMINKEY_VAL = 5;
    private static final int DESIRED_USERKEY_VAL = 5;

    public static void enableUACAndWait() {
        if (OS.isWindowsVistaOrAbove()) {
            System.out.println("[UacModifier] asked to enable UAC and wait");
            new EnableThread().run();
        }
    }

    public static void disableUACAndWait() {
        if (OS.isWindowsVistaOrAbove()) {
            System.out.println("[UacModifier] asked to disable UAC and wait");
            new DisableThread().run();
        }
    }

    public static void main(String[] args) throws Exception {
        if (OS.isWindowsVistaOrAbove()) {
            if (args[0].equals("disable")) {
                System.out.println("Disabling UAC...");
                UacPromptModifier.disableUACAndWait();
            } else {
                System.out.println("Enabling UAC...");
                UacPromptModifier.enableUACAndWait();
            }
        }
    }

    static class DisableThread
    extends Thread {
        DisableThread() {
        }

        @Override
        public void run() {
            try {
                if (WReg.get(uacPath, shOrigUacKey, "REG_DWORD").trim().length() != 0) {
                    System.out.println("[UacModifier] UAC is already disabled by SH (sh uac key present)");
                    return;
                }
                String adminVal = null;
                try {
                    adminVal = WReg.get(uacPath, uacAdminKey, "REG_DWORD");
                    int adminOrig = Integer.parseInt(adminVal);
                    WReg.set(uacPath, shOrigUacAdminKey, adminOrig + "", "REG_DWORD");
                }
                catch (Exception x) {
                    System.out.println("[UacDisabler] failed to query admin UAC value, " + adminVal);
                    x.printStackTrace();
                }
                String userVal = null;
                try {
                    userVal = WReg.get(uacPath, uacUserKey, "REG_DWORD");
                    int userOrig = Integer.parseInt(userVal);
                    WReg.set(uacPath, shOrigUacUserKey, userOrig + "", "REG_DWORD");
                }
                catch (Exception x) {
                    System.out.println("[UacDisabler] failed to query user UAC value, " + adminVal);
                    x.printStackTrace();
                }
                String uacVal = null;
                try {
                    uacVal = WReg.get(uacPath, uacKey, "REG_DWORD");
                    int adminOrig = Integer.parseInt(uacVal);
                    WReg.set(uacPath, shOrigUacKey, adminOrig + "", "REG_DWORD");
                }
                catch (Exception x) {
                    System.out.println("[UacModifier] failed to query UAC value, " + uacVal);
                    x.printStackTrace();
                }
                WReg.set(uacPath, uacAdminKey, "5", "REG_DWORD");
                WReg.set(uacPath, uacUserKey, "5", "REG_DWORD");
                WReg.set(uacPath, uacKey, "0", "REG_DWORD");
            }
            catch (Exception x) {
                System.out.println("[UacModifier] unable to disable UAC: " + x);
            }
        }
    }

    static class EnableThread
    extends Thread {
        EnableThread() {
        }

        @Override
        public void run() {
            try {
                int orig;
                int setting;
                try {
                    setting = Integer.parseInt(WReg.get(uacPath, uacAdminKey, "REG_DWORD"));
                    if (setting == 5) {
                        orig = Integer.parseInt(WReg.get(uacPath, shOrigUacAdminKey, "REG_DWORD"));
                        WReg.set(uacPath, uacAdminKey, "" + orig, "REG_DWORD");
                    }
                }
                catch (Exception x) {
                    System.out.println("[UacDisabler] failed to restore admin UAC value");
                    x.printStackTrace();
                }
                try {
                    setting = Integer.parseInt(WReg.get(uacPath, uacUserKey, "REG_DWORD"));
                    if (setting == 5) {
                        orig = Integer.parseInt(WReg.get(uacPath, shOrigUacUserKey, "REG_DWORD"));
                        WReg.set(uacPath, uacUserKey, "" + orig, "REG_DWORD");
                    }
                }
                catch (Exception x) {
                    System.out.println("[UacDisabler] failed to restore admin UAC value");
                    x.printStackTrace();
                }
                try {
                    int setting2 = Integer.parseInt(WReg.get(uacPath, uacKey, "REG_DWORD"));
                    if (setting2 == 0) {
                        orig = Integer.parseInt(WReg.get(uacPath, shOrigUacKey, "REG_DWORD"));
                        WReg.set(uacPath, uacKey, "" + orig, "REG_DWORD");
                    }
                }
                catch (Exception x) {
                    System.out.println("[UacModifier] failed to restore UAC value");
                    x.printStackTrace();
                }
                WReg.deleteValue(uacPath, shOrigUacAdminKey);
                WReg.deleteValue(uacPath, shOrigUacUserKey);
                WReg.deleteValue(uacPath, shOrigUacKey);
            }
            catch (Exception x) {
                System.out.println("[UacModifier] unable to enable UAC: " + x);
            }
        }
    }
}

