/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

public class SubnetPicker {
    int bestMyIndex = 0;
    int bestTheirIndex = 0;

    public SubnetPicker(String[] myIps, String[] theirIps) {
        int longestMatch = 0;
        for (int i = 0; i < myIps.length; ++i) {
            for (int k = 0; k < theirIps.length; ++k) {
                int len = this.getMatchLength(myIps[i], theirIps[k]);
                if (len <= longestMatch) continue;
                this.bestMyIndex = i;
                this.bestTheirIndex = k;
                longestMatch = len;
            }
        }
        System.out.println("[SPicker] Best IPs are " + myIps[this.bestMyIndex] + " " + theirIps[this.bestTheirIndex]);
    }

    private int getMatchLength(String s1, String s2) {
        System.out.print("[SubnetPicker] Comparing " + s1 + " vs " + s2 + "...");
        int score = 0;
        int len = Math.min(s1.length(), s2.length());
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) {
                ++score;
                if (c1 != '.') continue;
                score += 99;
                continue;
            }
            System.out.println(score);
            return score;
        }
        System.out.println(score);
        return score;
    }

    public static void main(String[] args) {
        new SubnetPicker(new String[]{"192.168.1.66", "10.0.11.1"}, new String[]{"192.168.133.56", "10.0.0.5", "192.168.1.33", "10.0.11.5"});
    }
}

