/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import build.BuildConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Properties;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.jwutils.JWSystem;
import jwrapper.logging.LogPoller;
import jwrapper.logging.ProcessOutputUtil;
import jwrapper.logging.ProcessResult;
import utils.message.Message;

public class SimpleGatewayUninstaller {
    private String updateURL;
    private ProcessOutputUtil outputUtil = null;
    private String supportedLanguages;

    public SimpleGatewayUninstaller(String updateURL, String supportedLanguages) throws Exception {
        this.updateURL = updateURL;
        this.supportedLanguages = supportedLanguages;
    }

    public SimpleGatewayUninstaller(Message installMessage) throws Exception {
        this.updateURL = installMessage.getAsString(0);
        String logFileLocation = installMessage.getAsString(1);
        this.outputUtil = SimpleGatewayUninstaller.initLog(new File(logFileLocation));
        this.supportedLanguages = installMessage.getAsString(2);
    }

    private static ProcessOutputUtil initLog(File logFile) throws FileNotFoundException {
        ProcessOutputUtil output = new ProcessOutputUtil("SimpleGatewayUninstaller", logFile);
        output.logMessage("Created log file: " + logFile.getAbsolutePath());
        return output;
    }

    public static String getSGUpdateURL() {
        int doubleSlash;
        String updateURL = JWSystem.getUpdateURL();
        int nextSlash = updateURL.indexOf(47, (doubleSlash = updateURL.indexOf("://")) + 3);
        if (nextSlash != -1) {
            updateURL = updateURL.substring(0, nextSlash);
        }
        updateURL = updateURL + "/access";
        return updateURL;
    }

    public static Message getUninstallMessageFor(String updateURL, String supportedLanguages, String logFileToWriteTo) {
        Message m = new Message();
        m.append(updateURL);
        m.append(logFileToWriteTo);
        m.append(supportedLanguages);
        return m;
    }

    public void uninstallSimpleGateway(boolean waitForResult) {
        try {
            this.doUninstallSimpleGateway(waitForResult);
            this.outputUtil.writeResult(1);
        }
        catch (Throwable t) {
            this.error(t.getMessage());
            this.stacktrace(t);
            this.outputUtil.writeResult(2);
        }
        finally {
            this.outputUtil.close();
        }
    }

    private void checkUpdateURL() {
        if (this.updateURL.endsWith("/")) {
            this.updateURL = this.updateURL.substring(0, this.updateURL.length() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUninstallSimpleGateway(boolean waitForResult) throws Exception {
        block7: {
            this.checkUpdateURL();
            this.println("[SimpleGatewayInstaller] Initiating all platforms installation");
            String appName = BuildConstants.BUNDLE_SG_SERVICE;
            String installType = "perm_all";
            boolean matchVersions = false;
            Properties lprops = new Properties();
            lprops.setProperty("sg_silent_uninstall", "true");
            lprops.setProperty("supported_langs", this.supportedLanguages);
            lprops.setProperty("show_no_ui", "true");
            long WAIT = 300000L;
            lprops.setProperty("debug_logging_until", "" + (System.currentTimeMillis() + WAIT));
            this.println("[SimpleGatewayInstaller] Launching JW All Platforms Wrapper now");
            PrintStream originalSout = System.out;
            System.setOut(this.outputUtil.getPrintStream());
            try {
                AllPlatformWrapper apw = new AllPlatformWrapper(appName, this.updateURL, installType, false, null, matchVersions, lprops, false, "5");
                LogPoller lp = apw.getLogPoller();
                lp.addReturnIfAutoupdateFailed();
                lp.addReturnOnErrorCase("Remote Access Configure");
                lp.addReturnOnAnyCase("Remote Access Service");
                apw.prepareForLaunch();
                apw.launchNow();
                if (!waitForResult) {
                    this.println("[SimpleGatewayInstaller] JW All Platforms Wrapper launched, ignoring result");
                    return;
                }
                this.println("[SimpleGatewayInstaller] JW All Platforms Wrapper launched, waiting for result");
                ProcessResult result = lp.waitForResult(WAIT);
                this.println("[SimpleGatewayInstaller] Got result");
                if (result != null && result.isOK()) {
                    this.println("[SimpleGatewayInstaller] Silent install worked");
                    break block7;
                }
                if (result == null) {
                    this.println("[SimpleGatewayInstaller] Silent install timed out");
                    throw new Exception("SimpleGateway installation timed out");
                }
                this.println("[SimpleGatewayInstaller] Silent install failed " + result);
                throw new Exception("SimpleGateway installation failed - " + result.getErrors());
            }
            finally {
                System.setOut(originalSout);
            }
        }
    }

    private void error(String err) {
        System.err.println(err);
        if (this.outputUtil != null) {
            this.outputUtil.logError(err);
        }
    }

    private void stacktrace(Throwable t) {
        t.printStackTrace();
        if (this.outputUtil != null) {
            this.outputUtil.logStackTrace(t);
        }
    }

    private void println(String s) {
        System.out.println(s);
        if (this.outputUtil != null) {
            this.outputUtil.logMessage(s);
        }
    }
}

