/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeUtils;
import com.aem.utils.NativeUtilsMonitor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import utils.ostools.OS;

public class ScreenDimension {
    private static final int UPDATE_TIME = 5000;
    private int screenNumber;
    private Rectangle physicalBounds = new Rectangle();
    private int originalLogicalX;
    private int originalLogicalY;
    private int originalPhysicalX;
    private int originalPhysicalY;
    private Rectangle logicalBounds = new Rectangle();
    private Object o;
    private String idString;
    private static ScreenDimension[] previousDimensions = null;
    private static long previousDimensionCheckTime = 0L;
    private static final Object LOCK = new Object();

    public Rectangle getPhysicalBounds() {
        return this.physicalBounds;
    }

    public Rectangle getLogicalBounds() {
        return this.physicalBounds;
    }

    public Rectangle getOriginalPhysicalBounds() {
        return new Rectangle(this.originalPhysicalX, this.originalPhysicalY, this.physicalBounds.width, this.physicalBounds.height);
    }

    public Rectangle getOriginalLogicalBounds() {
        return new Rectangle(this.originalLogicalX, this.originalLogicalY, this.logicalBounds.width, this.logicalBounds.height);
    }

    public ScreenDimension(Rectangle bounds, int screenNumber, String idString) {
        this(bounds.x, bounds.y, bounds.width, bounds.height, screenNumber, idString);
    }

    public ScreenDimension(int x, int y, int width, int height, int screenNumber, String idString) {
        this.physicalBounds.x = x;
        this.physicalBounds.y = y;
        this.physicalBounds.width = width;
        this.physicalBounds.height = height;
        this.logicalBounds.x = x;
        this.logicalBounds.y = y;
        this.logicalBounds.width = width;
        this.logicalBounds.height = height;
        this.originalPhysicalX = x;
        this.originalPhysicalY = y;
        this.originalLogicalX = x;
        this.originalLogicalY = y;
        this.screenNumber = screenNumber;
        this.idString = idString;
    }

    public String toString() {
        return "[" + this.screenNumber + " P(" + this.physicalBounds.x + "," + this.physicalBounds.y + "," + this.physicalBounds.width + "," + this.physicalBounds.height + ") L(" + this.logicalBounds.x + "," + this.logicalBounds.y + "," + this.logicalBounds.width + "," + this.logicalBounds.height + ") ID(" + this.idString + ")]";
    }

    public int getScreenNumber() {
        return this.screenNumber;
    }

    public void setUserObject(Object o) {
        this.o = o;
    }

    public Object getUserObject() {
        return this.o;
    }

    public static void main(String[] args) throws InterruptedException {
        NativeLibraryLoader.loadLibrary();
        System.out.println(Arrays.toString(ScreenDimension.detectScreenDimensions()));
        Point pp = new Point(100, 150);
        ScreenDimension.toPhysical(pp);
        System.out.println(pp);
        ScreenDimension.toLogical(pp);
        System.out.println(pp);
    }

    public static boolean toLogical(Point2D p) {
        ScreenDimension[] dims;
        for (ScreenDimension dim : dims = ScreenDimension.detectScreenDimensions()) {
            if (!dim.physicalBounds.contains(p)) continue;
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toLogical] Matched screen " + dim + " using point " + p);
            }
            double translatedX = p.getX() - dim.physicalBounds.getX();
            double translatedY = p.getY() - dim.physicalBounds.getY();
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toLogical] Translations " + translatedX + "," + translatedY);
            }
            double factorX = translatedX / dim.physicalBounds.getWidth();
            double factorY = translatedY / dim.physicalBounds.getHeight();
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toLogical] Factors " + factorX + "," + factorY);
            }
            p.setLocation(dim.logicalBounds.getX() + factorX * dim.logicalBounds.getWidth(), dim.logicalBounds.getY() + factorY * dim.logicalBounds.getHeight());
            return true;
        }
        return false;
    }

    public static boolean toPhysical(Point2D p) {
        ScreenDimension[] dims;
        for (ScreenDimension dim : dims = ScreenDimension.detectScreenDimensions()) {
            if (!dim.logicalBounds.contains(p)) continue;
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toPhysical] Matched screen " + dim + " using point " + p);
            }
            double translatedX = p.getX() - dim.logicalBounds.getX();
            double translatedY = p.getY() - dim.logicalBounds.getY();
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toPhysical] Translations " + translatedX + "," + translatedY);
            }
            double factorX = translatedX / dim.logicalBounds.getWidth();
            double factorY = translatedY / dim.logicalBounds.getHeight();
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension:toPhysical] Factors " + factorX + "," + factorY);
            }
            p.setLocation(dim.physicalBounds.getX() + factorX * dim.physicalBounds.getWidth(), dim.physicalBounds.getY() + factorY * dim.physicalBounds.getHeight());
            return true;
        }
        return false;
    }

    public static ScreenDimension[] detectScreenDimensions() {
        return ScreenDimension.detectScreenDimensions(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScreenDimension[] detectScreenDimensions(boolean primaryFirst) {
        Object object = LOCK;
        synchronized (object) {
            if (previousDimensions != null && System.currentTimeMillis() - previousDimensionCheckTime < 5000L) {
                return previousDimensions;
            }
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension] Detecting screen dimensions");
            }
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            ArrayList<ScreenDimension> screenDimensions = new ArrayList<ScreenDimension>();
            int minX = 0;
            int minY = 0;
            int minOriginalX = 0;
            int minOriginalY = 0;
            GraphicsDevice primaryMonitor = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            for (GraphicsDevice device : devices) {
                ScreenDimension.addBounds(primaryMonitor, device, screenDimensions);
            }
            if (OS.isWindows() && OS.isWindowsVistaOrAbove() && NativeUtils.getInstance() != null) {
                NativeUtilsMonitor[] allMonitors = NativeUtils.getInstance().getMonitorSizes();
                if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                    int i;
                    for (i = 0; i < screenDimensions.size(); ++i) {
                        System.out.println("++++++++++++++ ScreenDimension " + i + " ++++++++++++++");
                        System.out.println(screenDimensions.get(i));
                    }
                    for (i = 0; i < allMonitors.length; ++i) {
                        System.out.println("++++++++++++++ Natively Detected Monitor " + i + " ++++++++++++++");
                        System.out.println("\tAdapter: " + allMonitors[i].adapter);
                        System.out.println("\tAdapter Name: " + allMonitors[i].adapterName);
                        System.out.println("\tMonitor Name: " + allMonitors[i].monitorName);
                        System.out.println("\tBounds: " + allMonitors[i].bounds);
                        System.out.println("\tLogical Bounds: " + allMonitors[i].logicalBounds);
                    }
                }
                for (ScreenDimension screenDimension : screenDimensions) {
                    NativeUtilsMonitor monitor;
                    if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                        System.out.println("[ScreenDimension] Looking for match of " + screenDimension);
                    }
                    if ((monitor = ScreenDimension.pickMonitorWithLogicalBounds(allMonitors, screenDimension.logicalBounds)) != null) {
                        screenDimension.setPhysicalBounds(monitor.bounds);
                        continue;
                    }
                    screenDimension.setPhysicalBounds(screenDimension.logicalBounds);
                }
            }
            for (ScreenDimension dim : screenDimensions) {
                minX = Math.min(minX, dim.physicalBounds.x);
                minY = Math.min(minY, dim.physicalBounds.y);
                minOriginalX = Math.min(minOriginalX, dim.logicalBounds.x);
                minOriginalY = Math.min(minOriginalY, dim.logicalBounds.y);
            }
            if (minX != 0 || minY != 0) {
                for (ScreenDimension dim : screenDimensions) {
                    dim.physicalBounds.x -= minX;
                    dim.physicalBounds.y -= minY;
                    dim.logicalBounds.x -= minOriginalX;
                    dim.logicalBounds.y -= minOriginalY;
                }
            }
            previousDimensions = new ScreenDimension[screenDimensions.size()];
            screenDimensions.toArray(previousDimensions);
            previousDimensionCheckTime = System.currentTimeMillis();
            return previousDimensions;
        }
    }

    private static NativeUtilsMonitor pickMonitorWithLogicalBounds(NativeUtilsMonitor[] allMonitors, Rectangle logicalBounds) {
        if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
            System.out.println("[ScreenDimension] Searching for match on logical bounds " + logicalBounds);
        }
        for (NativeUtilsMonitor monitor : allMonitors) {
            if (!monitor.logicalBounds.equals(logicalBounds)) continue;
            if (CentralDebugging.SCREEN_DPI_TRANSLATION) {
                System.out.println("[ScreenDimension] Found match - " + monitor);
            }
            return monitor;
        }
        System.out.println("[Warning] Unable to find a monitor with logical bounds " + logicalBounds);
        for (int i = 0; i < allMonitors.length; ++i) {
            System.out.println("++++++++++++++ Monitor " + i + " ++++++++++++++");
            System.out.println("\tAdapter: " + allMonitors[i].adapter);
            System.out.println("\tAdapter Name: " + allMonitors[i].adapterName);
            System.out.println("\tMonitor Name: " + allMonitors[i].monitorName);
            System.out.println("\tBounds: " + allMonitors[i].bounds);
            System.out.println("\tLogical Bounds: " + allMonitors[i].logicalBounds);
        }
        return null;
    }

    private void setPhysicalBounds(Rectangle rectangle) {
        this.physicalBounds = rectangle;
    }

    private static void addBounds(GraphicsDevice primaryMonitor, GraphicsDevice monitor, ArrayList<ScreenDimension> screenDimensions) {
        Rectangle bounds = monitor.getDefaultConfiguration().getBounds();
        ScreenDimension dim = new ScreenDimension(bounds, screenDimensions.size() + 1, monitor.getIDstring());
        if (primaryMonitor.equals(monitor)) {
            screenDimensions.add(0, dim);
        } else {
            screenDimensions.add(dim);
        }
    }

    public static Rectangle getPhysicalScreenBounds() {
        ScreenDimension[] screenDimensions = ScreenDimension.detectScreenDimensions();
        int leftX = 0;
        int rightX = 0;
        int leftY = 0;
        int rightY = 0;
        for (int i = 0; i < screenDimensions.length; ++i) {
            if (i == 0) {
                leftX = screenDimensions[i].physicalBounds.x;
                leftY = screenDimensions[i].physicalBounds.y;
                rightX = screenDimensions[i].physicalBounds.x + screenDimensions[i].physicalBounds.width;
                rightY = screenDimensions[i].physicalBounds.y + screenDimensions[i].physicalBounds.height;
                continue;
            }
            leftX = Math.min(leftX, screenDimensions[i].physicalBounds.x);
            leftY = Math.min(leftY, screenDimensions[i].physicalBounds.y);
            rightX = Math.max(rightX, screenDimensions[i].physicalBounds.x + screenDimensions[i].physicalBounds.width);
            rightY = Math.max(rightY, screenDimensions[i].physicalBounds.y + screenDimensions[i].physicalBounds.height);
        }
        return new Rectangle(leftX, leftY, rightX - leftX, rightY - leftY);
    }

    public static Rectangle getLogicalScreenBounds() {
        ScreenDimension[] screenDimensions = ScreenDimension.detectScreenDimensions();
        int leftX = 0;
        int rightX = 0;
        int leftY = 0;
        int rightY = 0;
        for (int i = 0; i < screenDimensions.length; ++i) {
            if (i == 0) {
                leftX = screenDimensions[i].logicalBounds.x;
                leftY = screenDimensions[i].logicalBounds.y;
                rightX = screenDimensions[i].logicalBounds.x + screenDimensions[i].logicalBounds.width;
                rightY = screenDimensions[i].logicalBounds.y + screenDimensions[i].logicalBounds.height;
                continue;
            }
            leftX = Math.min(leftX, screenDimensions[i].logicalBounds.x);
            leftY = Math.min(leftY, screenDimensions[i].logicalBounds.y);
            rightX = Math.max(rightX, screenDimensions[i].logicalBounds.x + screenDimensions[i].logicalBounds.width);
            rightY = Math.max(rightY, screenDimensions[i].logicalBounds.y + screenDimensions[i].logicalBounds.height);
        }
        return new Rectangle(leftX, leftY, rightX - leftX, rightY - leftY);
    }

    public static Dimension getPhysicalScreenSize() {
        return ScreenDimension.getPhysicalScreenBounds().getSize();
    }

    public static Dimension getLogicalScreenSize() {
        return ScreenDimension.getLogicalScreenBounds().getSize();
    }

    public static Rectangle getOriginalScreenBoundsFor(int index) {
        ScreenDimension[] dims = ScreenDimension.detectScreenDimensions();
        return dims[index].getOriginalPhysicalBounds();
    }
}

