/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.shelp.util.ShFork;
import com.aem.utils.LogicalArray;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.progtools.MemoryCache;
import utils.stream.OpenByteArrayOutputStream;

public class ProcessCache {
    Process p;
    OutputStream pout;
    InputStream pin;
    static final int chunk_pixels = 4096;
    static final int MEGS = 45;
    static final int MEM = 46080000;
    static MemoryCache memCache;
    static byte[] empty;

    public ProcessCache(Process p) {
        this.p = p;
        this.pout = new BufferedOutputStream(p.getOutputStream());
        this.pin = new BufferedInputStream(p.getInputStream());
    }

    public void quit() throws IOException {
        this.pout.write(113);
        this.pout.flush();
    }

    public void testLatency() throws IOException {
        long T = System.currentTimeMillis();
        this.pout.write(108);
        this.pout.flush();
        StreamUtils.readBoolean(this.pin);
        T = System.currentTimeMillis() - T;
        System.out.println("Latency: " + T + "ms");
    }

    public void testBandwidth() throws IOException {
        this.pout.write(116);
        this.pout.flush();
        int N = 200;
        byte[] dat = new byte[1024000];
        long T = System.currentTimeMillis();
        StreamUtils.writeInt(this.pout, N);
        for (int i = 0; i < N; ++i) {
            StreamUtils.writeBytes(this.pout, dat);
        }
        this.pout.flush();
        StreamUtils.readBoolean(this.pin);
        T = System.currentTimeMillis() - T;
        double ps = N;
        System.out.println((ps /= (double)T / 1000.0) + "MB per second");
    }

    public void testSpeed() throws IOException {
        byte[] dat = new byte[12288];
        int N = 0;
        long T = System.currentTimeMillis() + 1000L;
        while (System.currentTimeMillis() < T) {
            for (int i = 0; i < 100; ++i) {
                this.addToCache(0L, dat, 0, dat.length);
                ++N;
            }
        }
        System.out.println(N + " per second");
    }

    public void clear() throws IOException {
        this.pout.write(119);
        this.pout.flush();
    }

    public boolean containsKey(long key) throws IOException {
        this.pout.write(99);
        StreamUtils.writeLong(this.pout, key);
        this.pout.flush();
        return StreamUtils.readBoolean(this.pin);
    }

    public byte[] getFromCache(long key) throws IOException {
        this.pout.write(103);
        StreamUtils.writeLong(this.pout, key);
        this.pout.flush();
        return StreamUtils.readNBytes(this.pin, 100000);
    }

    public void readFromCache(long key, LogicalArray la) throws IOException {
        int x;
        int y;
        this.pout.write(103);
        StreamUtils.writeLong(this.pout, key);
        this.pout.flush();
        int w = la.getWidth();
        int h = la.getHeight();
        int target = StreamUtils.readInt(this.pin);
        if (w * h * 3 != target) {
            if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                System.out.println("*****CACHE FAIL*****");
                System.out.println("Asked to load " + key);
                System.out.println("Stored length is " + target);
                System.out.println("Expected length is " + w + " * " + h + " * 3 = " + w * h * 3);
            }
            if (CentralDebugging.VISUALLY_SHOW_CACHING) {
                for (int y2 = 0; y2 < h; y2 += 2) {
                    for (int x2 = y2 % 1; x2 < w; x2 += 2) {
                        la.setXY(x2, y2, -4194304);
                    }
                }
            }
            return;
        }
        if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
            System.out.println("+++++CACHE HIT+++++");
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                la.setXY(x, y, StreamUtils.readRgbOnlyInt(this.pin));
            }
        }
        if (CentralDebugging.VISUALLY_SHOW_CACHING) {
            for (y = 0; y < h; y += 2) {
                for (x = y % 1; x < w; x += 2) {
                    la.setXY(x, y, -16711681);
                }
            }
        }
    }

    public void addToCache(long key, byte[] value, int off, int len) throws IOException {
        this.pout.write(97);
        StreamUtils.writeLong(this.pout, key);
        StreamUtils.writeBytes(this.pout, value, off, len);
        this.pout.flush();
    }

    public void addToCache(long key, LogicalArray la) throws IOException {
        this.pout.write(97);
        StreamUtils.writeLong(this.pout, key);
        int w = la.getWidth();
        int h = la.getHeight();
        StreamUtils.writeInt(this.pout, w * h * 3);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                StreamUtils.writeRgbOnlyInt(this.pout, la.getXY(x, y));
            }
        }
        this.pout.flush();
    }

    public static int getStoredChunkSize(LogicalArray la) {
        return la.getWidth() * la.getHeight() * 3;
    }

    public static byte[] storeLogicalArray(LogicalArray la) throws IOException {
        int w = la.getWidth();
        int h = la.getHeight();
        int byteArrayLength = w * h * 3;
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream(byteArrayLength + 4);
        StreamUtils.writeInt(bout, byteArrayLength);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                StreamUtils.writeRgbOnlyInt(bout, la.getXY(x, y));
            }
        }
        return bout.getByteArray();
    }

    public static void loadLogicalArray(byte[] dat, LogicalArray la) throws IOException {
        int x;
        int y;
        int target;
        int h;
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        int w = la.getWidth();
        int len = w * (h = la.getHeight()) * 3;
        if (len != (target = StreamUtils.readInt(bin))) {
            if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                System.out.println("*****CACHE FAIL*****");
                System.out.println("Asked to load in-mem cache entry");
                System.out.println("Stored length is " + target);
                System.out.println("Expected length is " + w + " * " + h + " * 3 = " + len);
            }
            if (CentralDebugging.VISUALLY_SHOW_CACHING) {
                for (int y2 = 0; y2 < h; y2 += 2) {
                    for (int x2 = y2 % 1; x2 < w; x2 += 2) {
                        la.setXY(x2, y2, -4194304);
                    }
                }
            }
            return;
        }
        if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
            System.out.println("+++++CACHE HIT+++++");
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                la.setXY(x, y, StreamUtils.readRgbOnlyInt(bin));
            }
        }
        if (CentralDebugging.VISUALLY_SHOW_CACHING) {
            for (y = 0; y < h; y += 2) {
                for (x = y % 1; x < w; x += 2) {
                    la.setXY(x, y, -16711681);
                }
            }
        }
    }

    public static ProcessCache forkProcessCacheTechnicianSide() throws Exception {
        Process p = ShFork.forkTechnicianSessionJVM(ProcessCache.class.getName(), new String[0]);
        ProcessCache pc = new ProcessCache(p);
        return pc;
    }

    public static ProcessCache forkProcessCacheCustomerSide() throws Exception {
        Process p = ShFork.forkCustomerSessionJVM(false, ProcessCache.class.getName(), new String[0]);
        ProcessCache pc = new ProcessCache(p);
        return pc;
    }

    public static MemoryCache getEquivalentCacheCustomerSide() {
        return new MemoryCache(46080000);
    }

    public static MemoryCache getProcessMemoryCacheTechnicianSide() {
        return new MemoryCache(46080000);
    }

    public static int getMemoryRequiredForInProcessCachingInMegs() {
        return 45;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("--test")) {
            int i;
            Process p = ShFork.forkTechnicianSessionJVM(ProcessCache.class.getName(), new String[0]);
            ProcessCache pc = new ProcessCache(p);
            System.out.println("Got process cache");
            System.out.println("Getting from cache");
            for (i = 0; i <= 110; i += 10) {
                System.out.println(pc.getFromCache(i).length);
            }
            System.out.println("Adding to cache");
            for (i = 0; i < 100; ++i) {
                pc.addToCache(i, new byte[i], 0, i);
            }
            System.out.println("Getting from cache");
            for (i = 0; i <= 110; i += 10) {
                System.out.println(pc.getFromCache(i + 1).length);
            }
            pc.testBandwidth();
            pc.testLatency();
            pc.testSpeed();
            System.exit(0);
        }
        memCache = ProcessCache.getProcessMemoryCacheTechnicianSide();
        BufferedInputStream in = new BufferedInputStream(System.in);
        BufferedOutputStream out = new BufferedOutputStream(System.out);
        try {
            while (true) {
                byte[] dat;
                long key;
                char ins;
                if ((ins = (char)((InputStream)in).read()) == 'a') {
                    key = StreamUtils.readLong(in);
                    dat = StreamUtils.readNBytes(in, 100000);
                    memCache.addToCache(new Long(key), dat, dat.length);
                } else if (ins == 'w') {
                    memCache.clear();
                } else if (ins == 'c') {
                    key = StreamUtils.readLong(in);
                    boolean contains = memCache.containsKey(new Long(key));
                    StreamUtils.writeBoolean(out, contains);
                } else if (ins == 't') {
                    long N = StreamUtils.readInt(in);
                    int i = 0;
                    while ((long)i < N) {
                        StreamUtils.readNBytes(in, 1000000000);
                        ++i;
                    }
                    StreamUtils.writeBoolean(out, true);
                } else if (ins == 'l') {
                    StreamUtils.writeBoolean(out, true);
                } else if (ins == 'g') {
                    key = StreamUtils.readLong(in);
                    dat = (byte[])memCache.getFromCache(new Long(key));
                    if (dat == null) {
                        StreamUtils.writeBytes(out, empty);
                    } else {
                        StreamUtils.writeBytes(out, dat);
                    }
                } else if (ins == 'r') {
                    memCache = null;
                    System.gc();
                    memCache = new MemoryCache(46080000);
                } else if (ins == 'q') {
                    System.exit(0);
                } else {
                    System.out.println("ERROR, instruction " + ins);
                    System.exit(0);
                }
                ((OutputStream)out).flush();
            }
        }
        catch (Throwable throwable) {
            System.exit(0);
            return;
        }
    }

    static {
        empty = new byte[0];
    }
}

