/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.shelp.common.Language;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JWindow;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.SafeAwtUtilities;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ColorFader;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class PopupNotificationWindow
implements ActionListener {
    private JWindow dialog = new JWindow();
    private final Object LOCK = new Object();
    private boolean okPressed = false;
    private JButton allow;
    private JButton deny;
    public static final int ORIENTATION_TOP = 1;
    public static final int ORIENTATION_BOTTOM = 1;
    private ColorFader borderColorFader = new ColorFader(SHStyle.ROW_SELECTION_BACKGROUND, new Color(250, 0, 22), 20, true);
    private Color borderColor = this.borderColorFader.nextColor();
    GbPanel contentPanel = new GbPanel(){

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setStroke(new BasicStroke(SimpleHelpLookAndFeel.scale(8.0f)));
            g2d.setColor(PopupNotificationWindow.this.borderColor);
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    };

    public boolean showMessage(String text, long timeout) throws NotificationTimedOut {
        if (OS.isMacOS()) {
            return this.showMessage(text, 1, timeout);
        }
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.dialog.getGraphicsConfiguration());
        if (toolHeight.bottom > toolHeight.top) {
            return this.showMessage(text, 1, timeout);
        }
        return this.showMessage(text, 1, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showMessage(String text, int dialogOrientation, long timeout) throws NotificationTimedOut {
        System.out.println("[PopupNotificationWindow] Showing message dialog...");
        OSXAdapter.requestForeground(true);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        this.initContent(text);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.dialog.getGraphicsConfiguration());
        int x = scrSize.width - this.dialog.getWidth() - 20;
        int y = scrSize.height - toolHeight.bottom - this.dialog.getHeight() - 20;
        if (dialogOrientation == 1) {
            y = toolHeight.top + 20;
        }
        this.dialog.setLocation(x, y);
        System.out.println("[PopupNotificationWindow] Location is " + x + "," + y);
        this.dialog.getContentPane().add(this.contentPanel);
        TimeoutThread thread = null;
        if (timeout > 0L) {
            thread = new TimeoutThread(timeout);
        }
        Object object = this.LOCK;
        synchronized (object) {
            new WindowFader(this.dialog).start();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException ex) {
                return false;
            }
            if (thread != null && thread.isTimedOut) {
                this.closeDialog();
                throw new NotificationTimedOut();
            }
        }
        return this.okPressed;
    }

    private void initContent(String text) {
        JLabel accessIcon = new JLabel(ImageLoader.getImageIcon("images/svg/dialogs/question.svg,48"));
        JLabel title = new JLabel(Language.get("ACCESS_REQUEST"));
        HashMap<TextAttribute, Float> textAttributes = new HashMap<TextAttribute, Float>();
        textAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        textAttributes.put(TextAttribute.SIZE, Float.valueOf(SimpleHelpLookAndFeel.scale(18.0f)));
        Font font = title.getFont().deriveFont(textAttributes);
        title.setFont(font);
        this.contentPanel.add(accessIcon, 0, 0, 1, 2, 0, 0, 11, 0, new ScaledInsets(15, 15, 0, 15));
        this.contentPanel.add(title, 1, 0, 1, 1, 1, 0, 18, 2, new ScaledInsets(20, 0, 0, 0));
        textAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        textAttributes.put(TextAttribute.SIZE, Float.valueOf(SimpleHelpLookAndFeel.scale(12.0f)));
        font = title.getFont().deriveFont(textAttributes);
        JLabel message = new JLabel("<html>" + text);
        message.setVerticalAlignment(1);
        message.setFont(font);
        this.contentPanel.add(message, 1, 1, 1, 1, 1, 100, 11, 1, new ScaledInsets(5, 2, 0, 10));
        this.dialog.setSize(SimpleHelpLookAndFeel.scale(400), SimpleHelpLookAndFeel.scale(100) + this.contentPanel.getPreferredSize().height);
        this.allow = new JButton(Language.get("ALLOW"));
        if (Language.exists("GRANT_ACCESS")) {
            this.allow.setText(Language.get("GRANT_ACCESS"));
        }
        SHButtonUI.makeButtonBlue(this.allow);
        this.allow.setIcon(ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
        this.deny = new JButton(Language.get("DENY"));
        this.deny.setOpaque(false);
        this.deny.setIcon(ImageLoader.getImageIconDisabled("images/svg/general/cancel.svg,16"));
        SHButtonUI.makeButtonBlue(this.allow);
        this.allow.setMargin(new ScaledInsets(7, 10, 7, 10));
        this.deny.setMargin(new ScaledInsets(7, 10, 7, 10));
        GbPanel panel = new GbPanel();
        panel.setOpaque(false);
        panel.add(this.deny, 0, 0, 1, 1, 1, 0, 17, 3);
        panel.add(this.allow, 1, 0, 1, 1, 0, 0, 17, 3);
        this.contentPanel.add(panel, 1, 2, 1, 1, 1, 1, 13, 1, new ScaledInsets(20, 0, 20, 20));
        this.dialog.setSize(SimpleHelpLookAndFeel.scale(400), SimpleHelpLookAndFeel.scale(120) + SwingUtil.getPreferredSizeOfHtml((String)message.getText(), (boolean)true, (int)SimpleHelpLookAndFeel.scale((int)220)).height);
        title.setForeground(new Color(100, 100, 100));
        message.setForeground(new Color(50, 50, 50));
        this.allow.addActionListener(this);
        this.deny.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDialog() {
        Object object = this.LOCK;
        synchronized (object) {
            this.dialog.setVisible(false);
            this.LOCK.notify();
        }
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        System.setProperty("apple.awt.UIElement", "true");
        SimpleHelpFrame.setLnf();
        new PopupNotificationWindow().showMessage("George has requested access to this m", 15000L);
        System.out.println("DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.LOCK;
        synchronized (object) {
            this.okPressed = e.getSource() == this.allow;
            this.dialog.setVisible(false);
            this.LOCK.notify();
        }
    }

    public static class ClosablePopupNotificationWindow
    extends PopupNotificationWindow
    implements NodeLinkStatusListener {
        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            System.out.println("[ClosablePopupNotificationWindow] Link down");
            this.closeDialog();
        }

        @Override
        public void linkOK(NodeLink link) {
        }

        @Override
        public void linkDead(NodeLink link, String reason) {
            System.out.println("[ClosablePopupNotificationWindow] Link dead");
            this.closeDialog();
        }
    }

    class WindowMover
    extends Thread {
        private JWindow dialog;
        private Insets toolHeight;
        private Dimension scrSize;
        private int x;

        public WindowMover(int x, Dimension scrSize, Insets toolHeight, JWindow dialog) {
            this.x = x;
            this.scrSize = scrSize;
            this.toolHeight = toolHeight;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            int endHeight = this.scrSize.height - this.toolHeight.bottom - this.dialog.getHeight() - 20;
            for (int offset = this.dialog.getHeight(); offset >= 0; offset -= 2) {
                int y = endHeight + offset;
                this.dialog.setLocation(this.x, y);
                try {
                    Thread.sleep(7L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class WindowFader
    extends Thread {
        private JWindow dialog;

        public WindowFader(JWindow dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            if (!SafeAwtUtilities.isSupported()) {
                this.dialog.setVisible(true);
            } else {
                SafeAwtUtilities.setWindowOpacity(this.dialog, 0.0f);
                this.dialog.setVisible(true);
                float f = 0.0f;
                while (f <= 1.0f) {
                    SafeAwtUtilities.setWindowOpacity(this.dialog, f);
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    f = (float)((double)f + 0.2);
                }
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.dialog.isVisible()) {
                try {
                    if (PopupNotificationWindow.this.borderColorFader.atStart()) {
                        Thread.sleep(3000L);
                    } else {
                        Thread.sleep(30L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PopupNotificationWindow.this.borderColor = PopupNotificationWindow.this.borderColorFader.nextColor();
                this.dialog.repaint();
            }
        }
    }

    class TimeoutThread
    extends Thread {
        private final long timeout;
        private boolean isTimedOut = false;

        public TimeoutThread(long timeout) {
            this.timeout = timeout;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.isTimedOut = true;
            Object object = PopupNotificationWindow.this.LOCK;
            synchronized (object) {
                PopupNotificationWindow.this.LOCK.notifyAll();
            }
        }
    }

    public class NotificationTimedOut
    extends Exception {
    }
}

