/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Machine;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;
import utils.ostools.OSDirs;
import utils.progtools.EnElapsedTimeFormatter;
import utils.progtools.profiler.SamplingProfiler;
import utils.string.Normaliser;
import utils.swing.dialog.glassdialog.ProgressGlassDialog;
import utils.swing.glassdialog.GlassOptionDialog;
import utils.swing.logview.LogView;
import utils.swing.logview.shelp.SHMinerSet;

public class LogGatherer
extends Thread
implements AWTEventListener {
    static WeakReference<JFrame> frame;
    static WeakReference<TechClient> client;
    static WeakReference<Machine> machine;
    private static Object LOCK;
    public static LogGatherer INSTANCE;
    long lastDispatch = 0L;
    static long MIN;
    static long MAX_AGE;
    boolean popup;

    public static void setFrame(JFrame frame) {
        LogGatherer.frame = new WeakReference<JFrame>(frame);
    }

    public static void setTechClient(TechClient client) {
        LogGatherer.client = new WeakReference<TechClient>(client);
    }

    public static void setSelectedMachine(Machine machine) {
        LogGatherer.machine = new WeakReference<Machine>(machine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadListener() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new LogGatherer(false);
                try {
                    Toolkit.getDefaultToolkit().addAWTEventListener(INSTANCE, 8L);
                }
                catch (Throwable t) {
                    System.out.println("[CDBGLauncher] Unable to register global event listener. Headless?");
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        boolean modifiersOK;
        KeyEvent e = (KeyEvent)event;
        boolean bl = modifiersOK = e.isAltDown() && e.isControlDown() && e.isShiftDown();
        if (!modifiersOK) {
            return;
        }
        if (System.currentTimeMillis() - this.lastDispatch < 500L) {
            return;
        }
        String keyText = KeyEvent.getKeyText(e.getKeyCode());
        if (keyText.equalsIgnoreCase("0") || keyText.equalsIgnoreCase("L")) {
            boolean logview = keyText.equalsIgnoreCase("0");
            this.lastDispatch = System.currentTimeMillis();
            GlassOptionDialog dialog = new GlassOptionDialog((RootPaneContainer)frame.get(), "Log Fetch", "Retrieve logs written to in the past:", null, new String[]{"1m", "10m", "1hr", "1d", "All"}, 0);
            int option = dialog.getOption();
            System.out.println("Option: " + option);
            if (option == 0) {
                MAX_AGE = 1L * MIN;
            } else if (option == 1) {
                MAX_AGE = 10L * MIN;
            } else if (option == 2) {
                MAX_AGE = 60L * MIN;
            } else if (option == 3) {
                MAX_AGE = 1440L * MIN;
            } else if (option == 4) {
                MAX_AGE = 5256000L * MIN;
            }
            new LogGatherer(logview).start();
        }
    }

    public LogGatherer(boolean popup) {
        this.popup = popup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressGlassDialog dialog;
        block34: {
            Machine machine;
            TechClient client = (TechClient)LogGatherer.client.get();
            if (client == null) {
                System.out.println("[LogGatherer] TechClient is null");
                return;
            }
            dialog = null;
            JFrame frame = (JFrame)LogGatherer.frame.get();
            if (frame != null) {
                dialog = new ProgressGlassDialog(frame, "Fetching remote log files, please wait...", "Log Fetch", "Quit");
                dialog.showNoBlock();
            }
            if ((machine = (Machine)LogGatherer.machine.get()) != null) {
                try {
                    client.requestComparativeStateDump(machine.getID());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                boolean windows = machine.getOsBaseType() == 0;
                boolean linux = machine.getOsBaseType() == 2;
                boolean macos = machine.getOsBaseType() == 1;
                boolean preVista = machine.getOsVariant() == 3 || machine.getOsVariant() == 4 || machine.getOsVariant() == 5;
                System.out.println("[LogGatherer] Target machine is " + machine.getName());
                TechClientFS fs = new TechClientFS(client, machine.getMachineID());
                try {
                    File[] logs;
                    GFile[] list;
                    GFile dir;
                    if (macos) {
                        System.out.println("[LogGatherer] MacOS");
                        dir = new GFile("/Library/Application Support/JWrapper-Remote Access/logs", "logs", 0L, 0L, true, false);
                        list = fs.listDir(dir);
                    } else if (windows && !preVista) {
                        System.out.println("[LogGatherer] Late Windows");
                        dir = new GFile("C:\\ProgramData\\JWrapper-Remote Access\\logs", "logs", 0L, 0L, true, false);
                        list = fs.listDir(dir);
                    } else if (windows && preVista) {
                        System.out.println("[LogGatherer] Early Windows");
                        dir = new GFile("C:\\Documents and Settings\\All Users\\Application Data\\JWrapper-Remote Access\\logs", "logs", 0L, 0L, true, false);
                        list = fs.listDir(dir);
                    } else if (linux) {
                        System.out.println("[LogGatherer] Linux");
                        dir = new GFile("/opt/JWrapper-Remote Access/logs", "logs", 0L, 0L, true, false);
                        list = fs.listDir(dir);
                    } else {
                        throw new IOException("Unable to handle OS type?");
                    }
                    long remoteTime = System.currentTimeMillis();
                    try {
                        remoteTime = fs.getRemoteTime();
                    }
                    catch (Exception x) {
                        System.out.println("[LogGatherer] Remote time not supported by this remote machine (too old)");
                    }
                    long time = System.currentTimeMillis();
                    long skew = time - remoteTime;
                    System.out.println("[LogGatherer] My time: " + time);
                    System.out.println("[LogGatherer] Remote time: " + remoteTime);
                    System.out.println("[LogGatherer] Skew: " + (skew < 1L ? "" : "+") + skew);
                    long maxSize = 0x200000L;
                    long maxAge = MAX_AGE;
                    ArrayList<GFile> fetch = new ArrayList<GFile>();
                    for (GFile file : list) {
                        long lastmod = fs.getLastModifiedTime(file);
                        long age = time - (lastmod += skew);
                        EnElapsedTimeFormatter etf = new EnElapsedTimeFormatter();
                        String modified = etf.getFormattedTime(age);
                        if (age < maxAge) {
                            System.out.println("[LogGatherer] RECENT file: (" + modified + ") " + file);
                            fetch.add(file);
                            continue;
                        }
                        System.out.println("[LogGatherer] old: (" + modified + ") " + file);
                    }
                    File desktop = OSDirs.getDesktopDir();
                    File logview = new File(desktop, "LogView");
                    File tmpdir = new File(logview, "Fetch_" + time + "_" + Normaliser.normaliseShort(machine.getMachineName().getName()));
                    tmpdir.mkdirs();
                    long sizeHalf = maxSize / 2L;
                    for (GFile file : fetch) {
                        System.out.println("[LogGatherer] Fetching " + file);
                        File[] output = new File(tmpdir, file.name);
                        long len = file.getSize();
                        int block = 500000;
                        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream((File)output));
                        try {
                            byte[] chunk;
                            for (long ptr = 0L; ptr < len; ptr += (long)chunk.length) {
                                chunk = fs.readFileChunk(file, ptr, Math.min(block, (int)(len - ptr)));
                                bout.write(chunk);
                            }
                        }
                        finally {
                            bout.close();
                        }
                    }
                    try {
                        System.out.println("[LogGatherer] Fetching server log");
                        String serverLog = client.fetchServerLog();
                        File server = new File(tmpdir, "server.log");
                        FileUtil.writeFileAsString(server, serverLog);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    File folder = JWSystem.getAllAppLoggingFolder();
                    System.out.println("[LogGatherer] Fetching local logs from " + folder);
                    for (File file : logs = folder.listFiles()) {
                        long lastmod = file.lastModified();
                        long age = time - lastmod;
                        EnElapsedTimeFormatter etf = new EnElapsedTimeFormatter();
                        String modified = etf.getFormattedTime(age);
                        if (age < maxAge) {
                            System.out.println("[LogGatherer] RECENT file: (" + modified + ") " + file);
                            FileUtil.copyFast(file, new File(tmpdir, file.getName()));
                            continue;
                        }
                        System.out.println("[LogGatherer] old: (" + modified + ") " + file);
                    }
                    if (!this.popup) break block34;
                    SamplingProfiler profiler = new SamplingProfiler();
                    profiler.startSampling(50);
                    try {
                        File[] files;
                        LogView view = new LogView();
                        view.addMinerSet(SHMinerSet.SET);
                        for (File file : files = tmpdir.listFiles()) {
                            System.out.println("[LogGatherer] Will add log file " + file);
                        }
                        for (File file : files) {
                            System.out.println("[LogGatherer] Adding log file " + file);
                            view.addLogFile(file);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    profiler.stopSampling();
                    profiler.dump(1.0);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            } else {
                System.out.println("[LogGatherer] No machine selected");
            }
        }
        if (dialog != null) {
            dialog.complete();
        }
    }

    static {
        LOCK = new Object();
        MIN = 60000L;
        MAX_AGE = 10L * MIN;
    }
}

