/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.KeyStoreUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;

public class KeytoolUtil {
    public static final int LOAD_OK = 0;
    public static final int LOAD_KEYSTORE_FAIL = 1;
    public static final int LOAD_PRIVATE_KEY_FAIL = 2;
    private static final int SELFSIGN_WAIT_SECS = 30;
    String jhome = System.getProperty("java.home");
    String keytoolPath;

    public static void main(String[] args) throws Exception {
        KeyStore keyStore = KeytoolUtil.loadKeystore(new File("Branding/netx/certs/apple.p12"), "Simple-XVUE-NetX".toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            System.out.println(aliases.nextElement());
        }
        System.out.println(keyStore.containsAlias("netx information systems incorporated\u0000"));
    }

    public KeytoolUtil() {
        StringBuffer kt = new StringBuffer(this.jhome);
        kt.append(File.separatorChar);
        kt.append("bin");
        kt.append(File.separatorChar);
        kt.append("keytool");
        System.out.println("[KeyTool] path is " + kt.toString());
        if (OS.isWindows()) {
            kt.append(".exe");
        } else {
            RunCommandGetOutput.runCommandGetOutput(new String[]{"chmod", "755", kt.toString()});
        }
        this.keytoolPath = kt.toString();
    }

    public void generateSelfSignedCertificateNoKeytool(String domain, String organisation, String keystorePath, String keystorePass) throws IOException {
    }

    public void generateSelfSignedCertificate(String domain, String organisation, String keystorePath, String keystorePass) throws IOException {
        String country;
        System.out.println("[SslCertificates] Asked to generate self signed certificate for " + domain + " / " + organisation);
        if (new File(keystorePath).exists()) {
            System.out.println("[SslCertificates] Deleting existing keystore");
            new File(keystorePath).delete();
        }
        if ((country = Locale.getDefault().getCountry()).length() == 0) {
            country = "US";
        }
        System.out.println("[SslCertificates] Using country " + country);
        System.out.println("[SslCertificates] Launching keytool");
        Process p = Runtime.getRuntime().exec(new String[]{this.keytoolPath, "-genkey", "-keyalg", "RSA", "-alias", "selfsigned", "-keystore", keystorePath, "-storepass", keystorePass, "-validity", "3600", "-keysize", "2048", "-dname", "CN=" + domain + ", OU=Administration, O=" + organisation + ", L=" + country + ", S=" + country + ", C=" + country, "-keypass", keystorePass}, null, new File("."));
        new ProcessPrinter(p, System.out, System.out);
        System.out.println("[SslCertificates] Keytool launched, waiting for completion...");
        for (int i = 0; i < 30; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                p.exitValue();
                System.out.println("[SslCertificates] Keytool appears to have completed");
                break;
            }
            catch (Exception exception) {
                if (i != 14) continue;
                System.out.println("[SslCertificates] Keytool does not appear to have completed yet, returning anyway");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(File location, char[] password) throws Exception {
        KeyStore keyStore;
        try {
            FileInputStream fin = new FileInputStream(location);
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(fin, password);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception ex) {
            FileInputStream fin = new FileInputStream(location);
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(fin, password);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return keyStore;
    }

    public static KeyStoreResult testKeystore(String location, String storepass, String keypass) {
        return KeytoolUtil.testKeystore(new File(location), storepass, keypass);
    }

    public static KeyStoreResult testKeystore(File location, String storepass, String keypass) {
        KeyStoreResult result = new KeyStoreResult();
        try {
            KeyStore keyStore = KeytoolUtil.loadKeystore(location, storepass.toCharArray());
            System.out.println("[SslCertificates] Keystore valid, checking entries...");
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                System.out.println("[SslCertificates] Keystore entry " + alias + ":");
                try {
                    Certificate cert = keyStore.getCertificate(alias);
                    System.out.println("[SslCertificates] -- certificate format: " + cert.getType());
                    if (cert instanceof X509Certificate) {
                        X509Certificate x509 = (X509Certificate)cert;
                        System.out.println("[SslCertificates] -- certificate algorithm: " + x509.getSigAlgName());
                        System.out.println("[SslCertificates] -- certificate issuer: " + x509.getIssuerDN());
                        System.out.println("[SslCertificates] -- certificate subject: " + x509.getSubjectDN());
                        System.out.println("[SslCertificates] -- certificate not before: " + x509.getNotBefore());
                        System.out.println("[SslCertificates] -- certificate not after: " + x509.getNotAfter());
                    }
                }
                catch (NullPointerException x) {
                    System.out.println("[SslCertificates] -- no certificate found for alias " + alias);
                }
                catch (Exception x) {
                    System.out.println("[SslCertificates] -- no certificate found for alias " + alias + " (" + x + ")");
                }
                try {
                    Key key = keyStore.getKey(alias, keypass.toCharArray());
                    System.out.println("[SslCertificates] -- key format: " + key.getFormat());
                    System.out.println("[SslCertificates] -- key algorithm: " + key.getAlgorithm());
                }
                catch (NullPointerException x) {
                    System.out.println("[SslCertificates] -- no key found for alias " + alias);
                }
                catch (UnrecoverableKeyException x) {
                    System.out.println("[SslCertificates] -- WARNING! Unable to load key for " + alias + " due to invalid password (" + x + ")");
                    result.success = 2;
                    result.errorMessage = x.getMessage();
                    return result;
                }
                catch (Exception x) {
                    System.out.println("[SslCertificates] -- WARNING! Unable to load key for " + alias + " (" + x + ")");
                    result.success = 2;
                    result.errorMessage = x.getMessage();
                    return result;
                }
            }
            result.expiryDate = KeyStoreUtility.getExpiryDate(keyStore);
            result.success = 0;
        }
        catch (Exception x) {
            System.out.println("[SslCertificates] Problem checking keystore (see below)");
            x.printStackTrace();
            result.success = 1;
            result.errorMessage = x.getMessage();
        }
        return result;
    }

    public static class KeyStoreResult {
        public long expiryDate = 0L;
        public String errorMessage;
        public int success;
        public String keystorePath;
    }
}

