/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.attempt.Attempt;
import com.aem.nodelink.attempt.ConcurrentAttempt;
import com.aem.nodelink.attempt.ConcurrentAttemptListener;
import com.aem.nodelink.attempt.NodelinkAttempt;
import com.aem.nodelink.utils.NodelinkStopper;
import com.aem.nodelink.utils.UnqueuedSemaphore;
import com.aem.shelp.util.ConnectionDiagnoser;
import com.aem.utils.StreamUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

public class ConnectionDiagnosis
implements ConcurrentAttemptListener,
NodeLinkStatusListener {
    static ConnectionDiagnoser forReferenceJarBuilderOnly;
    public static boolean VERBOSE_PROGRESS;
    public static boolean PERFORM_PARALLEL_CONNECTIONS_IN_DIAGNOSE;
    public static long STOPMEIN;
    public static long DIAGNOSIS_MIN_MS;
    int failures = 0;

    public String[] diagnoseFromClient(NodelinkAttempt orig, boolean extended, boolean liveConnection, StringBuffer sb) {
        orig = orig.cloneNew();
        StringBuffer summary = new StringBuffer();
        summary.append(" " + orig.getName() + "\n");
        sb.append(new Date() + ": - Diagnosing connection type " + orig.getName() + "\n");
        sb.append(new Date() + ": -- (Initial Connect)\n");
        if (VERBOSE_PROGRESS) {
            System.out.println("[ConnectionDiagnosis] Diagnosing connection type " + orig.getName() + "\n");
        }
        ConcurrentAttempt cat = new ConcurrentAttempt(this);
        cat.appendAttemptToCurrentLayer(orig);
        long T = System.currentTimeMillis();
        sb.append(new Date() + ": --- trying to establish connection\n");
        Attempt attempt = cat.attemptNow();
        if (attempt == null) {
            sb.append(new Date() + ": --- unable to establish a connection\n");
            summary.append(" --- Could not connect to the server.\n");
            return new String[]{summary.toString(), sb.toString(), "FAIL"};
        }
        T = System.currentTimeMillis() - T;
        sb.append(new Date() + ": --- connection established OK, took " + T + "ms\n");
        if (VERBOSE_PROGRESS) {
            System.out.println("[ConnectionDiagnosis] connection established OK, took " + T + "ms\n");
        }
        NodelinkAttempt nla = (NodelinkAttempt)attempt;
        NodeLink sock = nla.getNodeLink();
        NodelinkStopper stopper = null;
        if (stopper != null) {
            stopper.stopMeIn(STOPMEIN);
        }
        sock.addLinkStatusListener(this);
        sb.append(new Date() + ": --- connection is " + sock + "\n");
        InputStream in = sock.getInputStream();
        OutputStream out = sock.getOutputStream();
        Random r = new Random();
        long[] latencies = new long[2];
        try {
            StreamUtils.writeLong(out, 944162751881113601L);
            out.flush();
            if (1 != StreamUtils.readInt(in)) {
                throw new Exception("Server does not allow connection diagnosis (too old?)");
            }
            sb.append(new Date() + ": --- server ready for connection diagnosis\n");
            System.out.println(new Date() + ": beginning diagnosis of " + orig.getName());
            if (stopper != null) {
                stopper.stopMeIn(STOPMEIN);
            }
            this.appendFailures(sb);
            this.performLatencyCheck(sb, in, out, latencies);
            if (stopper != null) {
                stopper.stopMeIn(STOPMEIN);
            }
            sb.append(new Date() + ": -- (Upload Throughput)\n");
            if (VERBOSE_PROGRESS) {
                System.out.println("[ConnectionDiagnosis] Checking upload throughput\n");
            }
            this.performIncrementalSpeedUpload(sb, in, out, r);
            this.appendFailures(sb);
            this.performLatencyCheck(sb, in, out, latencies);
            if (stopper != null) {
                stopper.stopMeIn(STOPMEIN);
            }
            sb.append(new Date() + ": -- (Download Throughput)\n");
            if (VERBOSE_PROGRESS) {
                System.out.println("[ConnectionDiagnosis] Checking download throughput\n");
            }
            this.performIncrementalSpeedDownload(sb, in, out, r);
            this.appendFailures(sb);
            this.performLatencyCheck(sb, in, out, latencies);
            UnqueuedSemaphore sem = new UnqueuedSemaphore(0);
            UnqueuedSemaphore sig = new UnqueuedSemaphore(0);
            if (PERFORM_PARALLEL_CONNECTIONS_IN_DIAGNOSE) {
                sb.append(new Date() + ": -- (Multiple Connections Initial Connect)\n");
                sb.append(new Date() + ": --- Starting two additional connections...\n");
                ArrayList<ConcurrentSpeedTest> tests = new ArrayList<ConcurrentSpeedTest>();
                int N = 2;
                for (int i = 0; i < N; ++i) {
                    ConcurrentSpeedTest cst = new ConcurrentSpeedTest(nla, sem, sig);
                    cst.start();
                    tests.add(cst);
                }
                if (stopper != null) {
                    stopper.dontStopMe();
                }
                sig.acquire(N);
                sem.release(N);
                sb.append(new Date() + ": -- (Multiple Connections Upload Throughput)\n");
                sb.append(new Date() + ": --- Running x3 connection upload bandwidth test...\n");
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                double uploadKbPerSec = this.performIncrementalSpeedUpload(new StringBuffer(), in, out, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out);
                if (stopper != null) {
                    stopper.dontStopMe();
                }
                sig.acquire(N);
                sem.release(N);
                sb.append(new Date() + ": -- (Multiple Connections Download Throughput)\n");
                sb.append(new Date() + ": --- Running x3 connection download bandwidth test...\n");
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                double downloadKbPerSec = this.performIncrementalSpeedDownload(new StringBuffer(), in, out, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out);
                if (stopper != null) {
                    stopper.dontStopMe();
                }
                sig.acquire(N);
                boolean OK = true;
                for (int i = 0; i < N; ++i) {
                    ConcurrentSpeedTest cst = (ConcurrentSpeedTest)tests.get(i);
                    uploadKbPerSec += cst.uploadKbPerSec;
                    downloadKbPerSec += cst.downloadKbPerSec;
                    if (cst.success) continue;
                    OK = false;
                }
                if (OK) {
                    sb.append(new Date() + ": --- x3 connection total upload bandwidth was " + uploadKbPerSec + "kb/sec\n");
                    sb.append(new Date() + ": --- x3 connection total download bandwidth was " + downloadKbPerSec + "kb/sec\n");
                } else {
                    sb.append(new Date() + ": --- x3 connection total was not valid, one or more parallel connections failed\n");
                }
            }
            if (extended) {
                sb.append(new Date() + ": -- (Ongoing Upload)\n");
                int KP = 5;
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                this.performTimedUpload(sb, in, out, KP, 60, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out, latencies);
                sb.append(new Date() + ": -- (Ongoing Download)\n");
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                this.performTimedDownload(sb, in, out, KP, 60, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out, latencies);
                sb.append(new Date() + ": -- (Ongoing Upload)\n");
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                this.performTimedUpload(sb, in, out, KP, 60, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out, latencies);
                sb.append(new Date() + ": -- (Ongoing Download)\n");
                if (stopper != null) {
                    stopper.stopMeIn(STOPMEIN);
                }
                this.performTimedDownload(sb, in, out, KP, 60, r);
                this.appendFailures(sb);
                this.performLatencyCheck(sb, in, out, latencies);
            }
            sb.append(new Date() + ": --- Average connection latency: " + latencies[0] / latencies[1] + "ms\n");
            System.out.println(new Date() + ": diagnosis / 100%");
            StreamUtils.writeInt(out, 93000);
            out.flush();
            Thread.sleep(500L);
        }
        catch (Throwable t) {
            sb.append(new Date() + ": --- failed to test connection " + t + "\n");
            ++this.failures;
            t.printStackTrace();
        }
        try {
            sock.stop("end of diagnosis, closing test connection to server");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        summary.append(" --- Connected to the server OK, ");
        if (this.failures > 0) {
            summary.append("but the connection died " + this.failures + " times.\n");
        } else {
            summary.append("and the connection was stable (no failures).\n");
        }
        return new String[]{summary.toString(), sb.toString(), "OK"};
    }

    private void appendFailures(StringBuffer sb) {
        sb.append(new Date() + ": --- total underlying network failures so far: " + this.failures + " (" + (this.failures == 0 ? "OK" : "***WARNING***") + ")\n");
    }

    private void performLatencyCheck(StringBuffer sb, InputStream in, OutputStream out) throws Exception {
        this.performLatencyCheck(sb, in, out, null);
    }

    private void performLatencyCheck(StringBuffer sb, InputStream in, OutputStream out, long[] latencies) throws Exception {
        long T = System.currentTimeMillis();
        StreamUtils.writeInt(out, 96000);
        out.flush();
        if (1 != StreamUtils.readInt(in)) {
            throw new Exception("Unexpected response after latency check\n");
        }
        T = System.currentTimeMillis() - T;
        sb.append(new Date() + ": --- Connection latency is (" + T + "ms)\n");
        if (latencies != null) {
            latencies[0] = latencies[0] + T;
            latencies[1] = latencies[1] + 1L;
        }
    }

    private double performIncrementalSpeedUpload(StringBuffer sb, InputStream in, OutputStream out, Random r) throws Exception {
        return this.performIncrementalSpeedTest(sb, in, out, r, true);
    }

    private double performIncrementalSpeedDownload(StringBuffer sb, InputStream in, OutputStream out, Random r) throws Exception {
        return this.performIncrementalSpeedTest(sb, in, out, r, false);
    }

    private double performIncrementalSpeedTest(StringBuffer sb, InputStream in, OutputStream out, Random r, boolean upload) throws Exception {
        sb.append(new Date() + ": --- transferring data to ascertain " + (upload ? "up" : "down") + "load bandwidth...\n");
        int K = 10;
        int N = 5;
        long T = 0L;
        long min = DIAGNOSIS_MIN_MS;
        while (T < min) {
            if (T != 0L) {
                int bestFactor = (int)(min / (1000L + T));
                if (++bestFactor < 3) {
                    bestFactor = 3;
                }
                if (bestFactor > 20) {
                    bestFactor = 20;
                }
                N *= bestFactor;
            }
            long Tn = System.currentTimeMillis();
            if (upload) {
                this.performUntimedUpload(sb, in, out, K, N, r);
            } else {
                this.performUntimedDownload(sb, in, out, K, N, r);
            }
            T = System.currentTimeMillis() - Tn;
        }
        double tmp = T;
        tmp /= 1000.0;
        tmp = (double)(K * N) / tmp;
        DecimalFormat df0 = new DecimalFormat("###,###,###,##0");
        DecimalFormat df2 = new DecimalFormat("###,###,###,##0.00");
        String speed = tmp > 10.0 ? df0.format(tmp) : df2.format(tmp);
        sb.append(new Date() + ": --- transfer OK (" + T + "ms n=" + K * N + "k rate=" + speed + "kb/sec " + (upload ? "upload" : "download") + ")\n");
        return tmp;
    }

    private void performUntimedDownload(StringBuffer sb, InputStream in, OutputStream out, int K, int N, Random r) throws Exception {
        StreamUtils.writeInt(out, 95000);
        StreamUtils.writeInt(out, K);
        StreamUtils.writeInt(out, N);
        out.flush();
        this.untimedReceive(in, K, N);
        StreamUtils.writeInt(out, 1);
        out.flush();
        if (1 != StreamUtils.readInt(in)) {
            throw new Exception("Unexpected response after untimed download\n");
        }
    }

    private void performUntimedUpload(StringBuffer sb, InputStream in, OutputStream out, int K, int N, Random r) throws Exception {
        StreamUtils.writeInt(out, 94000);
        StreamUtils.writeInt(out, K);
        StreamUtils.writeInt(out, N);
        out.flush();
        this.untimedSend(out, K, N, r);
        if (1 != StreamUtils.readInt(in)) {
            throw new Exception("Unexpected response after untimed upload\n");
        }
    }

    private void performTimedUpload(StringBuffer sb, InputStream in, OutputStream out, int K, int N, Random r) throws Exception {
        sb.append(new Date() + ": --- transferring " + K * N + "kb up at " + K + "kb/sec\n");
        long T = System.currentTimeMillis();
        StreamUtils.writeInt(out, 91000);
        StreamUtils.writeInt(out, K);
        StreamUtils.writeInt(out, N);
        out.flush();
        this.timedSend(out, K, N, r);
        if (1 != StreamUtils.readInt(in)) {
            throw new Exception("Unexpected response after timed upload\n");
        }
        T = System.currentTimeMillis() - T;
        sb.append(new Date() + ": --- transfer OK (" + T + "ms)\n");
    }

    private void performTimedDownload(StringBuffer sb, InputStream in, OutputStream out, int K, int N, Random r) throws Exception {
        sb.append(new Date() + ": --- transferring " + K * N + "kb down at " + K + "kb/sec\n");
        long T = System.currentTimeMillis();
        StreamUtils.writeInt(out, 92000);
        StreamUtils.writeInt(out, K);
        StreamUtils.writeInt(out, N);
        out.flush();
        this.untimedReceive(in, K, N);
        StreamUtils.writeInt(out, 1);
        out.flush();
        if (1 != StreamUtils.readInt(in)) {
            throw new Exception("Unexpected response after timed download\n");
        }
        T = System.currentTimeMillis() - T;
        sb.append(new Date() + ": --- transfer OK (" + T + "ms)\n");
    }

    private void untimedSend(OutputStream out, int K, int N, Random r) throws Exception {
        if (VERBOSE_PROGRESS) {
            System.out.println("[ConnectionDiagnosis] New Untimed Send in 3... " + K + "k\n");
            Thread.sleep(3000L);
        }
        byte[] dat = new byte[1024 * K];
        r.nextBytes(dat);
        for (int i = 0; i < N; ++i) {
            if (VERBOSE_PROGRESS) {
                System.out.println("[ConnectionDiagnosis] Sending " + K + "k\n");
            }
            out.write(dat, 0, dat.length);
            if (VERBOSE_PROGRESS) {
                System.out.println("[ConnectionDiagnosis] Sent " + K + "k\n");
            }
            out.flush();
        }
        if (VERBOSE_PROGRESS) {
            System.out.println("[ConnectionDiagnosis] Data send complete " + N + "*" + K + "k\n");
        }
    }

    private void timedSend(OutputStream out, int K, int N, Random r) throws Exception {
        byte[] dat = new byte[1024 * K];
        for (int i = 0; i < N; ++i) {
            r.nextBytes(dat);
            out.write(dat, 0, dat.length);
            Thread.sleep(1000L);
            out.flush();
        }
    }

    private void untimedReceive(InputStream in, int K, int N) throws Exception {
        int len = K * 1024 * N;
        int tot = 0;
        byte[] buf = new byte[512];
        int n = 0;
        while (tot < len) {
            if (VERBOSE_PROGRESS) {
                System.out.println("[ConnectionDiagnosis] Reading 0.5k\n");
            }
            if ((n = in.read(buf)) > 0) {
                tot += n;
            }
            if (n == 0) {
                throw new Exception("ZERO data length?");
            }
            if (n != -1) continue;
            throw new Exception("Unexpected end of stream");
        }
    }

    public void serveDiagnosis(NodeLink nl) {
        Random r = new Random();
        InputStream in = nl.getInputStream();
        OutputStream out = nl.getOutputStream();
        try {
            int command = 0;
            while (command != 93000) {
                int N;
                int K;
                command = StreamUtils.readInt(in);
                if (command == 91000) {
                    K = StreamUtils.readInt(in);
                    N = StreamUtils.readInt(in);
                    this.untimedReceive(in, K, N);
                    StreamUtils.writeInt(out, 1);
                    out.flush();
                    continue;
                }
                if (command == 92000) {
                    K = StreamUtils.readInt(in);
                    N = StreamUtils.readInt(in);
                    this.timedSend(out, K, N, r);
                    StreamUtils.readInt(in);
                    StreamUtils.writeInt(out, 1);
                    out.flush();
                    continue;
                }
                if (command == 94000) {
                    K = StreamUtils.readInt(in);
                    N = StreamUtils.readInt(in);
                    this.untimedReceive(in, K, N);
                    StreamUtils.writeInt(out, 1);
                    out.flush();
                    continue;
                }
                if (command == 95000) {
                    K = StreamUtils.readInt(in);
                    N = StreamUtils.readInt(in);
                    this.untimedSend(out, K, N, r);
                    StreamUtils.readInt(in);
                    StreamUtils.writeInt(out, 1);
                    out.flush();
                    continue;
                }
                if (command != 96000) continue;
                StreamUtils.writeInt(out, 1);
                out.flush();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.out.println("Connection diagnosis failed unexpectedly: " + x);
        }
        System.out.println("Connection diagnosis complete");
        nl.stop("end diagnosis, closing test connection");
    }

    @Override
    public void layerFailed(int layerIndex) {
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        ++this.failures;
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    static {
        VERBOSE_PROGRESS = false;
        PERFORM_PARALLEL_CONNECTIONS_IN_DIAGNOSE = false;
        STOPMEIN = 180000L;
        DIAGNOSIS_MIN_MS = 4000L;
    }

    private class ConcurrentSpeedTest
    extends Thread {
        double uploadKbPerSec;
        double downloadKbPerSec;
        boolean success = true;
        UnqueuedSemaphore sem;
        UnqueuedSemaphore sig;
        NodelinkAttempt nla;

        public ConcurrentSpeedTest(NodelinkAttempt nla, UnqueuedSemaphore sem, UnqueuedSemaphore sig) {
            this.sem = sem;
            this.sig = sig;
            this.nla = nla;
        }

        @Override
        public void run() {
            Random r = new Random();
            this.nla = this.nla.cloneNew();
            try {
                this.nla.attemptNow();
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            NodeLink sockB = this.nla.getNodeLink();
            InputStream inB = sockB.getInputStream();
            OutputStream outB = sockB.getOutputStream();
            NodelinkStopper stopper = new NodelinkStopper(sockB);
            stopper.stopMeIn(STOPMEIN);
            try {
                StreamUtils.writeLong(outB, 944162751881113601L);
                outB.flush();
                if (1 != StreamUtils.readInt(inB)) {
                    throw new Exception("Server does not allow connection diagnosis (too old?)");
                }
                stopper.dontStopMe();
                this.sig.release(1);
                this.sem.acquire(1);
                stopper.stopMeIn(STOPMEIN);
                System.out.println("Beginning parallel speed upload...");
                this.uploadKbPerSec = ConnectionDiagnosis.this.performIncrementalSpeedUpload(new StringBuffer(), inB, outB, r);
                System.out.println("Completed parallel speed upload...");
                stopper.dontStopMe();
                this.sig.release(1);
                this.sem.acquire(1);
                stopper.stopMeIn(STOPMEIN);
                System.out.println("Beginning parallel speed download...");
                this.downloadKbPerSec = ConnectionDiagnosis.this.performIncrementalSpeedDownload(new StringBuffer(), inB, outB, r);
                System.out.println("Completed parallel speed download...");
                this.sig.release(1);
                stopper.dontStopMe();
            }
            catch (Exception x) {
                x.printStackTrace();
                this.success = false;
                this.sig.release(100);
                this.sem.release(100);
            }
            try {
                sockB.stop("end of parallel speed diagnosis, closing test connection");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            stopper.dontStopMe();
        }
    }
}

