/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.vnc;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import java.awt.Window;
import java.io.IOException;
import javax.swing.RootPaneContainer;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.validators.RequiredValidator;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class VNCCredentialsGlassDialog
extends OKCancelDialogPanel
implements AbstractField.ChangeListener {
    private TextField usernameField;
    private TextField passwordField;
    private String username = null;
    private String password = null;
    private boolean passwordOnly;
    private FixedWidthCUIPanel cuiPanel;

    public VNCCredentialsGlassDialog(boolean passwordOnly) {
        super(Language.get("LOGIN"), Language.get("CANCEL"));
        this.passwordOnly = passwordOnly;
        this.setIcon(ImageLoader.getImageIcon("images/svg/general/lock.svg,48"));
    }

    public void showDialog(RootPaneContainer rpc) {
        this.cuiPanel = new FixedWidthCUIPanel();
        this.addFields();
        this.setContent(this.cuiPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, 450, (AbstractDialogPanel)this);
        dialog.setTitle(Language.get("VNC_CREDENTIALS_TITLE"));
        dialog.showDialog();
        ResultPair[] filledOutResults = this.cuiPanel.getResults(Language.DEFLANG);
        if (!this.passwordOnly) {
            this.username = filledOutResults[0].getValue();
            this.password = filledOutResults[1].getValue();
        } else {
            this.password = filledOutResults[0].getValue();
        }
    }

    protected void addFields() {
        if (!this.passwordOnly) {
            this.usernameField = new TextField(Language.get("USERNAME"), this);
            this.usernameField.addValidator(RequiredValidator.REQUIRED_INSTANCE);
        }
        this.passwordField = new TextField(Language.get("PASSWORD"), this, 7);
        this.passwordField.addValidator(RequiredValidator.REQUIRED_INSTANCE);
        if (this.passwordOnly) {
            this.cuiPanel.setFields(new CUIField[]{this.passwordField});
        } else {
            this.cuiPanel.setFields(new CUIField[]{this.usernameField, this.passwordField});
        }
    }

    public String getVNCUsername() {
        return this.username;
    }

    public String getVNCPassword() {
        return this.password;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        SafeResourceBundle.loadTestBundle();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        ((Window)frame).setSize(500, 500);
        frame.setVisible(true);
        VNCCredentialsGlassDialog dialog = new VNCCredentialsGlassDialog(false);
        dialog.showDialog(frame);
        System.out.println("FINAL: " + dialog.getVNCUsername() + " - " + dialog.getVNCPassword());
    }

    @Override
    public void changed(AbstractField source) {
        this.setOkEnabled(this.cuiPanel.isValid());
    }
}

