/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.CentralDebugging;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.tech.video.IFrame;
import com.aem.shelp.tech.video.RecordingTimer;
import com.aem.shelp.tech.video.TechVideoRepository;
import com.aem.shelp.tech.video.VideoMetadata;
import com.aem.utils.CursorInfo;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.local.datalist.split.SplitByteArrayList;
import utils.files.FileLockUtil;
import utils.message.Message;
import utils.message.MessageUtils;

public class VideoRecorder
extends Thread {
    public static final int MESSAGE_TYPE_METADATA = 0;
    public static final int MESSAGE_TYPE_CACHED = 1;
    public static final int MESSAGE_TYPE_ENDBATCH = 2;
    public static final int MESSAGE_TYPE_CURSORIMAGE = 3;
    public static final int MESSAGE_TYPE_CURSORPOS = 4;
    public static final int MESSAGE_TYPE_REQUEST_RECT = 5;
    public static final int MESSAGE_TYPE_SCREEN_SIZE = 6;
    public static final int MESSAGE_TYPE_TRANSLATION = 7;
    public static final int MESSAGE_TYPE_REFORMED_TRANSLATION = 8;
    public static final int MESSAGE_TYPE_IFRAME = 9;
    public static final int MESSAGE_TYPE_RECORDING_STATE = 10;
    private LinkedList<TimestampedMessage> messageQueue = new LinkedList();
    private boolean die = false;
    private boolean isPaused = true;
    private SplitByteArrayList outputList = null;
    private Object LIST_LOCK = new Object();
    private RecordingTimer timer = new RecordingTimer();
    private static VideoRecorder INSTANCE;
    private static Object INSTANCE_LOCK;
    private Message lastRequestedRectangle = null;
    private Message lastCursorImage = null;
    private Message lastCursorPosition = null;
    private Message lastScreenSize = null;
    private Dimension lastScreenDimension = null;
    private IFrame iFrame = null;
    private VideoMetadata metadata;
    private ChunkHeader header;
    private boolean recordingInitialised = false;
    private FileLockUtil.LockResult lockFile;
    private Timer saveMetadataTimer;
    private static final long SAVE_PERIOD = 5000L;
    private static final long MAX_QUEUE_SIZE = 1000L;
    public static final long MAX_VIDEO_SIZE = 0x2800000L;
    TimerTask saveMetadaTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (VideoRecorder.this.metadata != null && VideoRecorder.this.metadata.isChanged()) {
                try {
                    VideoRecorder.this.saveMetadata();
                    VideoRecorder.this.metadata.setIsSaved();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private boolean skipNextFrame = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VideoRecorder getInstance() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new VideoRecorder();
            }
            return INSTANCE;
        }
    }

    public VideoRecorder() {
        super("VideoRecorder");
        INSTANCE = this;
        this.saveMetadataTimer = new Timer("MetadataSaver");
    }

    private void startSaveTimer() {
        this.saveMetadataTimer.schedule(this.saveMetadaTimerTask, 5000L, 5000L);
    }

    private void stopSaveTimer() {
        this.saveMetadaTimerTask.cancel();
    }

    private void initList() throws IOException {
        AbstractSession session = ConnectedTarget.TARGET;
        File targetFile = TechVideoRepository.getSaveFileFor(session, ".svf");
        File fileToLock = TechVideoRepository.getLockFileFor(targetFile);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        this.metadata = new VideoMetadata(session);
        this.header = new ChunkHeader(this.metadata.serialise());
        this.outputList = new SplitByteArrayList(targetFile, this.header, 0x2800000L);
        this.lockFile = FileLockUtil.lockFileOrBlock(fileToLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMetadata() throws IOException {
        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
            System.out.println("[VideoRecorder] Saving metadata");
        }
        if (!this.recordingInitialised) {
            if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                System.out.println("[VideoRecorder] Recording not initialised so cannot save metadata.");
            }
            return;
        }
        this.metadata.setDuration(this.timer.getTotalRecordedTime());
        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
            System.out.println("[VideoRecorder] Metadata is " + this.metadata);
        }
        this.header.setHeaderData(this.metadata.serialise());
        Object object = this.LIST_LOCK;
        synchronized (object) {
            this.outputList.writeHeader();
        }
    }

    public void setPaused(boolean isPaused) {
        System.out.println("[VideoRecorder] Setting paused to " + isPaused);
        Message start = new Message(10);
        start.append(!isPaused);
        this.addScreenMessageToQueue(start);
        this.isPaused = isPaused;
        if (!isPaused) {
            if (!this.recordingInitialised) {
                this.recordingInitialised = true;
                try {
                    this.initList();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.metadata.setStartTime(System.currentTimeMillis());
                try {
                    this.saveMetadata();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.start();
            }
            this.startSaveTimer();
            if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                System.out.println("[VideoRecorder] Starting timer");
            }
            this.timer.start();
            this.addChunksCachedDuringPause();
        } else {
            this.stopSaveTimer();
            if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                System.out.println("[VideoRecorder] Stopping timer");
            }
            this.timer.end();
            try {
                this.saveMetadata();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void addChunksCachedDuringPause() {
        if (this.metadata != null && this.lastScreenDimension != null) {
            if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                System.out.println("[VideoRecorder] Setting remembered screen size to " + this.lastScreenDimension);
            }
            this.metadata.setScreenSize(this.lastScreenDimension.width, this.lastScreenDimension.height);
        }
        this.addScreenMessageToQueue(this.lastScreenSize);
        this.addScreenMessageToQueue(this.lastRequestedRectangle);
        this.addScreenMessageToQueue(this.lastCursorImage);
        this.addScreenMessageToQueue(this.lastCursorPosition);
    }

    public void setRequestRectangle(Rectangle rect) {
        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
            System.out.println("[VideoRecorder] Setting request rectangle " + rect);
        }
        Message message = new Message(5);
        message.append(rect.x);
        message.append(rect.y);
        message.append(rect.width);
        message.append(rect.height);
        this.lastRequestedRectangle = message;
        if (!this.isPaused) {
            this.addScreenMessageToQueue(message);
        }
    }

    public void setCursorImage(CursorInfo cInfo) {
        if (cInfo == null) {
            return;
        }
        Message message = cInfo.toMessage();
        message.setType(3);
        this.lastCursorImage = message;
        if (!this.isPaused) {
            this.addScreenMessageToQueue(message);
        }
    }

    public void addEndBatchMessage() {
        if (!this.isPaused) {
            Message message = new Message(2);
            this.addScreenMessageToQueue(message);
        }
    }

    public void setCursorPosition(int x, int y) {
        Message message = new Message(4);
        message.append(x);
        message.append(y);
        this.lastCursorPosition = message;
        if (!this.isPaused) {
            this.addScreenMessageToQueue(message);
        }
    }

    public void addCachedDataToQueue(byte[] rgbData, int x, int y, int w, int h) {
        if (!this.isPaused) {
            this.reconstructScreenMessage(1, rgbData, x, y, w, h);
        }
    }

    public void reconstructScreenMessage(int type, byte[] rgbData, int x, int y, int w, int h) {
        Message message = new Message(type);
        int tmp = x << 16 | y;
        message.append(tmp);
        tmp = w << 16 | h;
        message.append(tmp);
        int enc = 3;
        int fil = 51;
        boolean blackIsEmpty = false;
        int comp = 100;
        tmp = enc << 2 | fil - 50;
        tmp = blackIsEmpty ? tmp << 1 | 1 : tmp << 1 | 0;
        tmp = tmp << 3 | comp - 100;
        message.append(tmp);
        message.append(rgbData);
        this.addScreenMessageToQueue(x, y, w, h, message);
    }

    private void addScreenMessageToQueue(Message message) {
        this.addScreenMessageToQueue(0, 0, 0, 0, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScreenMessageToQueue(int x, int y, int w, int h, Message message) {
        if (this.isPaused) {
            return;
        }
        if (message == null) {
            return;
        }
        TimestampedMessage timestampedMessage = new TimestampedMessage();
        timestampedMessage.message = message;
        timestampedMessage.timeStamp = System.currentTimeMillis();
        timestampedMessage.x = x;
        timestampedMessage.y = y;
        timestampedMessage.w = w;
        timestampedMessage.h = h;
        LinkedList<TimestampedMessage> linkedList = this.messageQueue;
        synchronized (linkedList) {
            this.messageQueue.add(timestampedMessage);
            if (CentralDebugging.VIDEO_QUEUE_SIZE) {
                System.out.println("[VideoRecorder] Adding message (" + message.getType() + ") to queue. New size is " + this.messageQueue.size());
            }
            if ((long)this.messageQueue.size() > 1000L) {
                System.out.println("[VideoRecorder] Message queue for video recording is full. Dropping frame.");
                this.skipNextFrame = true;
            }
            this.messageQueue.notify();
        }
    }

    public void die() {
        this.finish();
        this.die = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.die) {
            TimestampedMessage messageToProcess = null;
            Object object = this.messageQueue;
            synchronized (object) {
                boolean isMessageEndBatch;
                messageToProcess = this.getNextMessage();
                if (messageToProcess == null) {
                    continue;
                }
                if (CentralDebugging.VIDEO_QUEUE_SIZE) {
                    long roughSize = MessageUtils.roughSize(messageToProcess.message);
                    System.out.println("[VideoRecorder] Removed message (" + messageToProcess.message.getType() + ") from queue. New size is " + this.messageQueue.size() + ". Rough size is " + roughSize + ".");
                }
                boolean bl = isMessageEndBatch = messageToProcess.message.getType() == 2;
                if (this.skipNextFrame && isMessageEndBatch) {
                    System.out.println("[VideoRecorder] Unable to process video messages. Dropping a frame.");
                    TimestampedMessage messageToDrop = this.getNextMessage();
                    boolean bl2 = isMessageEndBatch = messageToDrop.message.getType() == 2;
                    while (!isMessageEndBatch) {
                        messageToDrop = this.getNextMessage();
                        isMessageEndBatch = messageToDrop.message.getType() == 2;
                    }
                    this.skipNextFrame = false;
                }
            }
            object = this.LIST_LOCK;
            synchronized (object) {
                if (!this.recordingInitialised) {
                    return;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    long size = this.outputList.size();
                    if (size > 0L && size % 200L == 0L) {
                        long start = System.currentTimeMillis();
                        this.outputList.addBytes(messageToProcess.timeStamp, MessageUtils.messageToBytes(this.iFrame.toMessage()));
                        ++size;
                        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                            System.out.println("[VideoRecorder] Wrote iFrame and took " + (System.currentTimeMillis() - start) + "ms");
                        }
                    }
                    if (messageToProcess.w != 0 && this.iFrame != null) {
                        this.iFrame.setIndexFor(messageToProcess.x, messageToProcess.y, messageToProcess.w, messageToProcess.h, (int)size);
                    }
                    if (messageToProcess.message.getType() == 5 && this.iFrame != null) {
                        this.iFrame.setViewedSection(messageToProcess.message.getAsInt(0), messageToProcess.message.getAsInt(1), messageToProcess.message.getAsInt(2), messageToProcess.message.getAsInt(3));
                    }
                    byte[] messageToBytes = MessageUtils.messageToBytes(messageToProcess.message);
                    this.outputList.addBytes(messageToProcess.timeStamp, messageToBytes);
                    long endTime = System.currentTimeMillis();
                    if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
                        System.out.println("[VideoRecorder] Time to process message (" + messageToProcess.message.getType() + ") was " + (endTime - startTime));
                    }
                }
                catch (Throwable t) {
                    System.out.println("Error processing video message " + messageToProcess.message);
                    t.printStackTrace();
                }
            }
        }
    }

    private TimestampedMessage getNextMessage() {
        while (this.messageQueue.size() == 0) {
            try {
                this.messageQueue.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.messageQueue.removeFirst();
    }

    public void setScreenSize(int w, int h) {
        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
            System.out.println("[VideoRecorder] Setting screen size to " + w + "," + h);
        }
        if (this.metadata != null) {
            System.out.println("[VideoRecorder] Saving metadata screen size " + w + "," + h);
            this.metadata.setScreenSize(w, h);
        } else {
            this.lastScreenDimension = new Dimension(w, h);
        }
        Message m = new Message(6);
        m.append(w);
        m.append(h);
        if (this.iFrame == null) {
            this.iFrame = new IFrame(w, h, 64);
        } else {
            this.iFrame.setScreenSize(w, h);
        }
        if (this.isPaused) {
            this.lastScreenSize = m;
        } else {
            this.addScreenMessageToQueue(m);
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (CentralDebugging.VIDEO_RECORD_VERBOSE) {
            System.out.println("[VideoRecorder] Finishing...");
        }
        if (!this.recordingInitialised) {
            return;
        }
        System.out.println("[VideoRecorder] Finishing session recording.");
        try {
            this.saveMetadata();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Object object = this.LIST_LOCK;
        synchronized (object) {
            try {
                this.outputList.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.outputList.close();
                this.outputList = null;
                this.recordingInitialised = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileLockUtil.releaseLock(this.lockFile);
        this.lockFile.lockFile.delete();
    }

    public void addScreenMessage(int x, int y, int w, int h, Message m) {
        this.addScreenMessageToQueue(x, y, w, h, m);
    }

    public void captureEntireScreen(BufferedImage image, int screenWidth, int screenHeight) {
        if (image == null) {
            return;
        }
        System.out.println("[VideoRecorder] Video recording started. Clearing and adding screen image");
        byte[] clearImage = new byte[]{1, 0, 0, 1};
        VideoRecorder.getInstance().reconstructScreenMessage(196611, clearImage, 0, 0, screenWidth, screenHeight);
        Rectangle updatedRect = new Rectangle(0, 0, screenWidth, screenHeight);
        int chunkSize = 64;
        int xStart = chunkSize * (updatedRect.x / chunkSize);
        int yStart = chunkSize * (updatedRect.y / chunkSize);
        int chunksAcross = (updatedRect.x + updatedRect.width - xStart) / chunkSize;
        int chunksDown = (updatedRect.y + updatedRect.height - yStart) / chunkSize;
        if (xStart + chunkSize * chunksAcross < updatedRect.x + updatedRect.width) {
            ++chunksAcross;
        }
        if (yStart + chunkSize * chunksDown < updatedRect.y + updatedRect.height) {
            ++chunksDown;
        }
        int[] rgbadat = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int yChunk = 0; yChunk < chunksDown; ++yChunk) {
            for (int xChunk = 0; xChunk < chunksAcross; ++xChunk) {
                int x = xStart + chunkSize * xChunk;
                int y = yStart + chunkSize * yChunk;
                int w = chunkSize;
                int h = chunkSize;
                if (x + w > screenWidth) {
                    w = screenWidth - x;
                }
                if (y + h > screenHeight) {
                    h = screenHeight - y;
                }
                if (w <= 0 || h <= 0) continue;
                Message videoMessage = new Message(8);
                videoMessage.append(x);
                videoMessage.append(y);
                videoMessage.append(w);
                videoMessage.append(h);
                for (int yOffset = 0; yOffset < h; ++yOffset) {
                    videoMessage.append(rgbadat, (y + yOffset) * image.getWidth() + x, w);
                }
                VideoRecorder.getInstance().addScreenMessageToQueue(x, y, w, h, videoMessage);
            }
        }
        VideoRecorder.getInstance().addEndBatchMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartRecording() {
        this.isPaused = true;
        Object object = this.messageQueue;
        synchronized (object) {
            this.messageQueue.clear();
        }
        object = this.LIST_LOCK;
        synchronized (object) {
            try {
                this.outputList.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.initList();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.addChunksCachedDuringPause();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        AccessSession s = AccessSession.createTestSession();
        ConnectedTarget.TARGET = s;
        VideoRecorder.getInstance().setPaused(false);
        Random r = new Random();
        byte[] data = new byte[1024];
        VideoRecorder.getInstance().setScreenSize(1000, 1000);
        for (int i = 0; i < 1000000; ++i) {
            System.out.println(i);
            Message m = new Message();
            r.nextBytes(data);
            m.append(data);
            VideoRecorder.getInstance().addScreenMessageToQueue(m);
            Thread.sleep(10L);
            System.out.println(Arrays.toString(VideoRecorder.getInstance().outputList.getTimedListFiles()));
        }
    }

    static {
        INSTANCE_LOCK = new Object();
    }

    class TimestampedMessage {
        int x;
        int y;
        int w;
        int h;
        long timeStamp;
        Message message;

        TimestampedMessage() {
        }
    }
}

