/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import com.aem.nodelink.tcp.Base64;
import com.aem.utils.CursorInfo;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import utils.swing.png.PngEncoder;

public class PngExtractor {
    private PngEncoder encoder = new PngEncoder();
    private int count = 0;
    private int frameCount = 0;
    private BufferedOutputStream fout = null;
    long previousTotal = 0L;
    byte[] previousPNG = null;

    public PngExtractor(File targetFile) throws FileNotFoundException {
        this.fout = new BufferedOutputStream(new FileOutputStream(targetFile));
    }

    public void incrementFrame(long timeSinceStart) {
        StringBuffer result = new StringBuffer();
        result.append("frames[").append(this.frameCount++).append("] = new Array(").append(this.count).append(",").append(timeSinceStart).append(");\n");
        this.write(result);
    }

    private void write(StringBuffer result) {
        try {
            this.fout.write(result.toString().getBytes("ASCII"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void extractFromBufferedImage(BufferedImage image, Rectangle area) {
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        byte[] newData = new byte[area.width * area.height * 3];
        int newCount = 0;
        long total = 0L;
        for (int yy = area.y; yy < area.y + area.height; ++yy) {
            for (int xx = area.x; xx < area.x + area.width; ++xx) {
                int rgb = imageData[yy * image.getWidth() + xx];
                total += (long)rgb;
                newData[newCount++] = (byte)(rgb >>> 16);
                newData[newCount++] = (byte)(rgb >>> 8);
                newData[newCount++] = (byte)rgb;
            }
        }
        StringBuffer result = new StringBuffer();
        byte[] imagePNG = this.encoder.encode(area.width, area.height, newData);
        boolean sameAsPrevious = false;
        if (this.previousPNG != null && total == this.previousTotal && Arrays.equals(imagePNG, this.previousPNG)) {
            sameAsPrevious = true;
        }
        this.previousTotal = total;
        this.previousPNG = imagePNG;
        if (!sameAsPrevious) {
            result.append("chunks[").append(this.count++).append("] = new Array(0, \"data:image/png;base64,").append(Base64.byteArrayToBase64(imagePNG)).append("\",").append(area.x).append(",").append(area.y).append(");\n");
        } else {
            result.append("chunks[").append(this.count++).append("] = new Array(0, \"\",").append(area.x).append(",").append(area.y).append(");\n");
        }
        this.write(result);
    }

    public void setCursorPosition(int cursorX, int cursorY) {
        StringBuffer result = new StringBuffer();
        result.append("chunks[").append(this.count++).append("] = new Array(1, \"\",").append(cursorX).append(",").append(cursorY).append(");\n");
        this.write(result);
    }

    public void setCursorImage(CursorInfo currentCursor) {
        BufferedImage image = currentCursor.getImage();
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        byte[] newData = new byte[imageData.length * 4];
        int newCount = 0;
        for (int yy = 0; yy < image.getHeight(); ++yy) {
            for (int xx = 0; xx < image.getWidth(); ++xx) {
                int rgb = imageData[yy * image.getWidth() + xx];
                newData[newCount++] = (byte)(rgb >>> 16);
                newData[newCount++] = (byte)(rgb >>> 8);
                newData[newCount++] = (byte)rgb;
                newData[newCount++] = (byte)(rgb >>> 24);
            }
        }
        StringBuffer result = new StringBuffer();
        byte[] imagePNG = this.encoder.encode(image.getWidth(), image.getHeight(), newData, true);
        result.append("chunks[").append(this.count++).append("] = new Array(2, \"data:image/png;base64,").append(Base64.byteArrayToBase64(imagePNG)).append("\");\n");
        this.write(result);
    }
}

