/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.utils.SummaryBlobLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;
import utils.swing.layout.WrapLayout;

public class TechGroupSummaryLabel {
    private JPanel rootComponent = new JPanel();
    private String[] groupNames;
    private String[] techNames;
    private boolean oneLine;
    private Color tagColor = SHStyle.PANEL_BACKGROUND_BLUE;
    private Border labelBorder = SHBorderFactory.createEmptyBorder(5, 0, 0, 5);

    public TechGroupSummaryLabel(boolean oneLine) {
        this.oneLine = oneLine;
    }

    public void setPickedNotifyAll() {
        String[] groupNames = new String[]{Language.get("ALL_TECHNICIANS")};
        this.setPickedTechsAndGroups(groupNames, this.techNames);
    }

    public void setPickedTechsAndGroups(String[] groupNames, String[] techNames) {
        this.groupNames = groupNames;
        this.techNames = techNames;
        if (this.oneLine) {
            this.rootComponent.setLayout(new FlowLayout(0, 0, 0));
        } else {
            this.rootComponent.setLayout(new WrapLayout(0, 0, 0));
        }
        this.initUI();
    }

    public void setTagColor(Color c) {
        this.tagColor = c;
    }

    public void initUI() {
        SummaryBlobLabel label;
        this.rootComponent.removeAll();
        if (this.groupNames != null && this.groupNames.length > 0) {
            for (String group : this.groupNames) {
                label = new SummaryBlobLabel(group, ImageLoader.getImageIcon("images/svg/users/queue.svg,16"), this.tagColor);
                label.setBackground(this.rootComponent.getBackground());
                label.setBorder(this.labelBorder);
                this.rootComponent.add(label);
            }
        }
        if (this.techNames != null && this.techNames.length > 0) {
            for (String tech : this.techNames) {
                label = new SummaryBlobLabel(tech, ImageLoader.getImageIcon("images/svg/users/technician.svg,16"), this.tagColor);
                label.setBackground(this.rootComponent.getBackground());
                label.setBorder(this.labelBorder);
                this.rootComponent.add(label);
            }
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        JPanel test = new JPanel(new BorderLayout());
        test.setBackground(Color.white);
        TechGroupSummaryLabel techGroupSummaryLabel = new TechGroupSummaryLabel(true);
        techGroupSummaryLabel.setPickedTechsAndGroups(new String[]{"Group One", "Administrators", "Winners"}, new String[]{"Tech", "George", "Antony", "Test Tech"});
        test.add((Component)techGroupSummaryLabel.rootComponent, "North");
        frame.getContentPane().add(test);
        frame.setVisible(true);
    }

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public void setEnabled(boolean enabled) {
        this.rootComponent.setEnabled(enabled);
    }

    public void setVisible(boolean b) {
        this.rootComponent.setVisible(b);
    }

    public void setBackground(Color innerBorderColor) {
        this.rootComponent.setBackground(innerBorderColor);
    }
}

