/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class SummaryBlobLabel
extends JPanel {
    private Color color;
    private Icon icon;
    private String text;
    private int bufferx = SimpleHelpLookAndFeel.scale(3);
    private int buffery = SimpleHelpLookAndFeel.scale(3);
    private boolean first = true;

    public SummaryBlobLabel(String text, Icon icon, Color color) {
        this.text = text;
        this.icon = icon;
        this.color = color;
    }

    public void setBuffer(int x, int y) {
        this.bufferx = x;
        this.buffery = y;
    }

    public void setText(String text) {
        this.text = text;
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        this.setPanelSize(fm, fm.stringWidth(text));
    }

    private void setPanelSize(Graphics2D g2d) {
        this.setPanelSize(g2d.getFont(), g2d.getFontRenderContext(), g2d.getFontMetrics());
    }

    private void setPanelSize(Font font, FontRenderContext frc, FontMetrics fm) {
        Rectangle2D textBounds = font.getStringBounds(this.text, frc);
        this.setPanelSize(fm, textBounds.getWidth());
    }

    private void setPanelSize(FontMetrics fm, double w) {
        Insets insets = this.getInsets();
        int fontHeight = fm.getHeight();
        fontHeight += 2 * this.buffery;
        int width = insets.left + insets.right + (int)((double)(2 * this.bufferx) + Math.ceil(w));
        if (this.icon != null) {
            width += this.bufferx + this.icon.getIconWidth();
            fontHeight = Math.max(fontHeight, this.icon.getIconHeight() + 2 * this.buffery);
        }
        Dimension d = new Dimension(width, fontHeight + insets.top + insets.bottom);
        this.setSize(d);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.first) {
            this.first = false;
            this.setPanelSize(g2d);
            this.revalidate();
            return;
        }
        super.paintComponent(g);
        int lineWidth = 1;
        g2d.setColor(this.color);
        g2d.fillRoundRect(insets.left + lineWidth, insets.top + lineWidth, this.getWidth() - 2 * lineWidth - insets.left - insets.right, this.getHeight() - 2 * lineWidth - insets.top - insets.bottom, 4, 4);
        g2d.setColor(this.color);
        g2d.drawRoundRect(insets.left + lineWidth, insets.top + lineWidth, this.getWidth() - 2 * lineWidth - insets.left - insets.right, this.getHeight() - 2 * lineWidth - insets.top - insets.bottom, 4, 4);
        int x = this.bufferx + insets.left;
        if (this.icon != null) {
            this.icon.paintIcon(this, g2d, this.bufferx, (insets.top + this.getHeight()) / 2 - this.icon.getIconHeight() / 2);
            x += this.icon.getIconWidth() + this.bufferx;
        }
        g2d.setColor(Color.BLACK);
        g2d.drawString(this.text, x, insets.top + this.buffery + g.getFontMetrics().getAscent());
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

