/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import utils.swing.components.switches.image.Switch;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public class MonitoringSwitch
extends Switch {
    public MonitoringSwitch() {
        super(ImageLoader.getImageIcon("images/svg/general/switch-on-green.svg,26"), ImageLoader.getImageIcon("images/svg/general/switch-off-green.svg,26"), ImageLoader.getImageIcon("images/svg/general/switch-undefined.svg,26"));
        this.setPreferredSize(new Dimension(SimpleHelpLookAndFeel.scale(26), SimpleHelpLookAndFeel.scale(14)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform old = g2d.getTransform();
        try {
            int x = this.getWidth() / 2 - this.getPreferredSize().width / 2;
            int y = this.getHeight() / 2 - this.getPreferredSize().height / 2;
            g.translate(x, y - SimpleHelpLookAndFeel.scale(6));
            super.paintComponent(g);
        }
        finally {
            ((Graphics2D)g).setTransform(old);
        }
    }

    public static void main(String[] args) {
        Switch[] boxes;
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        testFrame.setSize(500, 500);
        JPanel test = new JPanel(new GridLayout(0, 2));
        for (Switch box : boxes = new Switch[]{new MonitoringSwitch()}) {
            test.add(box);
        }
        testFrame.getContentPane().add(test);
        testFrame.setVisible(true);
    }
}

