/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.osstats.types.BasicInfo;
import utils.swing.MiniStatGraph;
import utils.swing.MiniStatGraphPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.formatters.DataSizeFormatter;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.layout.GbPanel;

public class MetricsRow {
    private final boolean large;
    private GbPanel rootComponent = new GbPanel();
    private final MiniStatGraphPanel cpuGraph;
    private final MiniStatGraphPanel memGraph;
    private CircularProgressIcon cpuLoadAverage;
    private CircularProgressIcon memLoadAverage;
    private ProgressRef[] memProgress;
    private ProgressRef[] cpuProgress;
    private JLabel cpuLoadLabel;
    private JLabel memLoadLabel;
    private JLabel memLabel;
    private JLabel memTitle;
    private JLabel cpuLabel;
    private JLabel cpuTitle;
    private BasicInfo info;
    private final NumberFormat percentFormat = NumberFormat.getPercentInstance();

    public MetricsRow(boolean large) {
        this.large = large;
        Color bg = AccessStyle.MINISTAT_BG;
        if (large) {
            bg = AccessStyle.MINISTAT_BG_LIGHT;
        }
        this.cpuGraph = new MiniStatGraphPanel(new MiniStatGraph(bg, MiniStatGraph.GREEN, 100.0));
        this.memGraph = new MiniStatGraphPanel(new MiniStatGraph(bg, MiniStatGraph.BLUE, 100.0));
        this.initUI(large);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public void initUI(boolean large) {
        final Color background = new Color(242, 242, 242);
        ColorProvider greenProvider = new ColorProvider(){

            @Override
            public Color nextColor(double d) {
                if (d < 0.8) {
                    return AccessStyle.MINISTAT_GREEN;
                }
                if (d < 0.9) {
                    return AccessStyle.MINISTAT_ORANGE;
                }
                return AccessStyle.MINISTAT_RED;
            }

            @Override
            public Color nextBackgroundColor(double value) {
                return background;
            }
        };
        ColorProvider blueProvider = new ColorProvider(){

            @Override
            public Color nextColor(double d) {
                if (d < 0.8) {
                    return AccessStyle.MINISTAT_BLUE;
                }
                if (d < 0.9) {
                    return AccessStyle.MINISTAT_ORANGE;
                }
                return AccessStyle.MINISTAT_RED;
            }

            @Override
            public Color nextBackgroundColor(double value) {
                return background;
            }
        };
        int progressIconSize = large ? SimpleHelpLookAndFeel.scale(72) : SimpleHelpLookAndFeel.scale(48);
        int arcSize = large ? SimpleHelpLookAndFeel.scale(18) : SimpleHelpLookAndFeel.scale(12);
        this.cpuProgress = new ProgressRef[]{new ProgressRef(), new ProgressRef(), new ProgressRef()};
        this.memProgress = new ProgressRef[]{new ProgressRef(), new ProgressRef(), new ProgressRef()};
        this.cpuLoadAverage = new CircularProgressIcon(progressIconSize, progressIconSize, greenProvider);
        this.memLoadAverage = new CircularProgressIcon(progressIconSize, progressIconSize, blueProvider);
        this.cpuLoadAverage.setRemoveWhenDone(false);
        this.memLoadAverage.setRemoveWhenDone(false);
        this.cpuLoadAverage.setArcDimensions(arcSize, SimpleHelpLookAndFeel.scale(2));
        this.memLoadAverage.setArcDimensions(arcSize, SimpleHelpLookAndFeel.scale(2));
        this.cpuLoadAverage.setBaseColorOnValue(true);
        this.memLoadAverage.setBaseColorOnValue(true);
        this.cpuLoadLabel = new JLabel(this.cpuLoadAverage);
        this.memLoadLabel = new JLabel(this.memLoadAverage);
        this.memLoadAverage.setUpdateComponent(this.memLoadLabel);
        this.cpuLoadAverage.setUpdateComponent(this.cpuLoadLabel);
        Dimension size = new Dimension(this.cpuLoadAverage.getIconWidth(), this.cpuLoadAverage.getIconHeight());
        this.cpuLoadLabel.setMinimumSize(size);
        this.memLoadLabel.setMinimumSize(size);
        this.cpuLoadLabel.setPreferredSize(size);
        this.memLoadLabel.setPreferredSize(size);
        for (ProgressRef ref : this.cpuProgress) {
            this.cpuLoadAverage.addProgressRef(ref);
        }
        for (ProgressRef ref : this.memProgress) {
            this.memLoadAverage.addProgressRef(ref);
        }
        if (large) {
            SwingUtil.setHeight(this.cpuGraph, SimpleHelpLookAndFeel.scale(90));
            SwingUtil.setHeight(this.memGraph, SimpleHelpLookAndFeel.scale(90));
        } else {
            size = new Dimension(SimpleHelpLookAndFeel.scale(150), SimpleHelpLookAndFeel.scale(60));
            this.cpuGraph.setSize(size);
            this.memGraph.setSize(size);
            this.cpuGraph.setPreferredSize(size);
            this.memGraph.setPreferredSize(size);
            this.cpuGraph.setMinimumSize(size);
            this.memGraph.setMinimumSize(size);
        }
        this.cpuLabel = new JLabel();
        this.memLabel = new JLabel();
        this.setLatestCPUandMem(-1.0, -1.0);
        this.cpuLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.memLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.cpuLabel.setHorizontalAlignment(0);
        this.memLabel.setHorizontalAlignment(0);
        int X = 0;
        int Y = 0;
        if (large) {
            this.cpuTitle = new JLabel(Language.get("CPU_USAGE_TITLE"));
            this.memTitle = new JLabel(Language.get("MEMORY_USAGE_TITLE"));
            SwingUtil.setSizesToWidest(this.cpuTitle, this.memTitle);
            this.cpuTitle.setFont(SHStyle.largeFont);
            this.memTitle.setFont(SHStyle.largeFont);
            this.cpuTitle.setHorizontalAlignment(0);
            this.memTitle.setHorizontalAlignment(0);
            this.rootComponent.add(this.cpuTitle, 1, Y, 1, 1, 0, 0, 17, 1, new ScaledInsets(0, 5, 10, 5));
            this.rootComponent.add(this.memTitle, 4, Y, 1, 1, 0, 0, 17, 1, new ScaledInsets(0, 5, 10, 5));
            this.cpuLabel.setText("<html><p align=center><font size=" + SimpleHelpLookAndFeel.scale(6) + ">" + this.percentFormat.format(100L) + "</font><br>");
            SwingUtil.setSizesToWidest(this.cpuLabel, this.memLabel);
            this.cpuLabel.setText("");
            X = 0;
            ++Y;
        }
        this.rootComponent.add(this.cpuLabel, X++, Y, 1, 1, 0, 1, 13, 1, new ScaledInsets(0, 5, 0, 5));
        this.rootComponent.add(this.cpuGraph, X++, Y, 1, 1, 1, 1, 13, 1, new ScaledInsets(0, 5, 0, 5));
        this.rootComponent.add(this.cpuLoadLabel, X++, Y, 1, 1, 0, 1, 17, 3, new ScaledInsets(0, 5, 0, 15));
        this.rootComponent.add(this.memLoadLabel, X++, Y, 1, 1, 0, 1, 13, 3, new ScaledInsets(0, 15, 0, 5));
        this.rootComponent.add(this.memGraph, X++, Y, 1, 1, 1, 1, 17, 1, new ScaledInsets(0, 5, 0, 5));
        this.rootComponent.add(this.memLabel, X++, Y, 1, 1, 0, 1, 17, 1, new ScaledInsets(0, 5, 0, 5));
        this.setLatestCPUandMem(-1.0, -1.0);
    }

    public void setBasicMachineInfo(BasicInfo info) {
        this.info = info;
    }

    private void setLatestCPUandMem(double cpu, double mem) {
        long total;
        String cpuTitle = this.large ? (this.info != null && this.info.getProcessorCount() > 0 ? (this.info.getProcessorCount() == 1 ? this.info.getProcessorCount() + " " + Language.get("HARDWARE_PROCESSOR") : this.info.getProcessorCount() + " " + Language.get("HARDWARE_PROCESSORS")) : "") : Language.get("CPU_USAGE_TITLE");
        if (cpu < 0.0) {
            cpuTitle = cpuTitle.replace(" ", "<br>");
            cpuTitle = "<html><p align=center>" + cpuTitle;
        } else {
            double roundedCpu = Math.round(cpu);
            cpuTitle = "<html><p align=center><font size=" + SimpleHelpLookAndFeel.scale(6) + ">" + this.percentFormat.format(roundedCpu /= 100.0) + "</font><br>" + cpuTitle;
        }
        this.cpuLabel.setText(cpuTitle);
        String memTitle = this.large ? (this.info != null ? ((total = this.info.getTotalMemory()) > 0L ? DataSizeFormatter.INSTANCE.getFormattedSize(total) : "") : "") : Language.get("MEMORY_USAGE_TITLE");
        if (mem < 0.0) {
            memTitle = memTitle.replace(" ", "<br>");
            memTitle = "<html><p align=center>" + memTitle;
        } else {
            double roundedMem = Math.round(mem);
            memTitle = "<html><p align=center><font size=" + SimpleHelpLookAndFeel.scale(6) + ">" + this.percentFormat.format(roundedMem /= 100.0) + "</font><br>" + memTitle;
        }
        this.memLabel.setText(memTitle);
    }

    public void setData(double[] cpu, double[] mem, byte[] loadAverages) {
        this.cpuGraph.setData(cpu);
        this.memGraph.setData(mem);
        this.setLatestCPUandMem(cpu[cpu.length - 1], mem[mem.length - 1]);
        if (loadAverages != null && loadAverages.length >= 6) {
            long decimals;
            double value;
            int i;
            this.cpuLoadLabel.setVisible(true);
            this.memLoadLabel.setVisible(true);
            StringBuilder tooltip = new StringBuilder();
            for (i = 0; i < 3; ++i) {
                value = (double)loadAverages[i] / 100.0;
                this.cpuProgress[i].setProgress(value);
                if (i == 0) {
                    tooltip.append("1m: ");
                } else if (i == 1) {
                    tooltip.append("  5m: ");
                } else {
                    tooltip.append("  15m: ");
                }
                decimals = (long)(value * 100.0);
                tooltip.append(decimals).append("%");
            }
            this.cpuLoadLabel.setToolTipText(tooltip.toString());
            tooltip = new StringBuilder();
            for (i = 0; i < 3; ++i) {
                value = (double)loadAverages[i + 3] / 100.0;
                this.memProgress[i].setProgress(value);
                if (i == 0) {
                    tooltip.append("1m: ");
                } else if (i == 1) {
                    tooltip.append("  5m: ");
                } else {
                    tooltip.append("  15m: ");
                }
                decimals = (long)(value * 100.0);
                tooltip.append(decimals).append("%");
            }
            this.memLoadLabel.setToolTipText(tooltip.toString());
        } else {
            this.cpuLoadLabel.setVisible(false);
            this.memLoadLabel.setVisible(false);
        }
    }
}

