/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.model.machine.MachineGroup;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.util.filter.FilterTreeModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.SHJTree;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHCheckBoxIcon;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;

public class MachinePickerTree
implements MessageFieldHandler.FilterListener,
MouseListener {
    private MachineTreeModel model;
    private FilterTreeModel filterModel;
    private HashSet<Object> isCheckedBox = new HashSet();
    private JPanel rootComponent;
    private JSearchTextField filterField;
    private SHJTree tree;
    private PickerRenderer renderer;
    private String[] filter;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public MachinePickerTree(Object[] selectedItems) {
        if (selectedItems != null) {
            Collections.addAll(this.isCheckedBox, selectedItems);
        }
        this.initUI();
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.model = model;
        this.filterModel = new FilterTreeModel(new PrunedTreeModel(model, (MachineGroup)model.getAvailableMachinesGroup()));
        this.tree.setModel(this.filterModel);
    }

    private void initUI() {
        this.renderer = new PickerRenderer();
        this.tree = new SHJTree(SHStyle.SELECTION_BACKGROUND);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(this.renderer);
        this.tree.addMouseListener(this);
        this.filterField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.filterField.setFilterListener(this);
        JPanel filterPanel = new JPanel(new GridLayout(1, 1));
        filterPanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, SHStyle.BORDER_COLOR_LIGHT), SHBorderFactory.createEmptyBorder(5, 0, 5, 0)));
        filterPanel.add(this.filterField);
        SwingUtil.setHeight(this.filterField, SimpleHelpLookAndFeel.scale(25));
        JScrollPane pane = new JScrollPane(this.tree);
        this.rootComponent = new JPanel(new BorderLayout());
        this.rootComponent.add((Component)filterPanel, "North");
        this.rootComponent.add((Component)pane, "Center");
    }

    @Override
    public void setFilter(String filter, boolean immediately) {
        this.filter = filter == null ? null : filter.split("\\s");
        this.filterModel.setFilters(this.filter);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int row = this.tree.getRowForLocation(e.getX(), e.getY());
        if (row == -1) {
            return;
        }
        TreePath path = this.tree.getPathForRow(row);
        Rectangle bounds = this.tree.getRowBounds(row);
        if (e.getX() > bounds.x && e.getX() < bounds.x + this.renderer.checkBoxIcon.getIconWidth()) {
            Object clickedObject = path.getLastPathComponent();
            if (!this.isCheckedBox.remove(clickedObject)) {
                this.isCheckedBox.add(clickedObject);
            }
            this.tree.repaint();
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public int getSelectedElementCount() {
        return this.isCheckedBox.size();
    }

    public void showInDialog(RootPaneContainer rootPaneContainer) {
        new MachinePickerDialog().showDialog(rootPaneContainer);
    }

    public Iterable<? extends Object> getSelectedElements() {
        return this.isCheckedBox;
    }

    public static void createTestDialog(RootPaneContainer rpc) throws IOException {
        MachineTreeModel model = new MachineTreeModel();
        ArrayList<Machine> machines = new ArrayList<Machine>();
        for (int i = 0; i < 10000; ++i) {
            machines.add(Machine.createTestMachine());
        }
        model.addElements(machines.toArray(new Machine[0]));
        MachinePickerTree tree = new MachinePickerTree(null);
        tree.setMachineTreeModel(model);
        MachinePickerDialog mpd = tree.new MachinePickerDialog();
        mpd.showDialog(rpc);
    }

    class MachinePickerDialog
    extends OKCancelDialogPanel {
        public MachinePickerDialog() {
            super(Language.get("CLOSE"));
            JPanel contentPanel = this.getContentPanel();
            contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale(new Dimension(500, 400)));
            FixedWidthPanel panel = new FixedWidthPanel(contentPanel);
            this.setContent(panel);
        }

        protected JPanel getContentPanel() {
            JPanel userPanel = new JPanel(new GridLayout(1, 1));
            userPanel.add(MachinePickerTree.this.rootComponent);
            return userPanel;
        }

        public void showDialog(RootPaneContainer rpc) {
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("ACP_PICK_MACHINES"));
            abstractGlassDialog.showDialog();
        }
    }

    class PickerRenderer
    extends DefaultTreeCellRenderer {
        private Icon groupIcon = ImageLoader.getImageIcon("images/svg/general/machine-group.svg,16");
        private Icon machineIcon = ImageLoader.getImageIcon("images/svg/technology/screen.svg,16");
        private JCheckBox dummyBox = new JCheckBox();
        private SHCheckBoxIcon checkBoxIcon = new SHCheckBoxIcon();
        private int buffer = SimpleHelpLookAndFeel.scale(25);
        private boolean selected = false;

        public PickerRenderer() {
            this.setBackgroundSelectionColor(null);
            this.setBorderSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof MachineGroup) {
                component.setIcon(this.groupIcon);
            } else {
                component.setText(((Machine)value).getMachineName().getName());
                component.setIcon(this.machineIcon);
            }
            this.selected = sel;
            this.dummyBox.setSelected(MachinePickerTree.this.isCheckedBox.contains(value));
            return component;
        }

        @Override
        public void paintComponent(Graphics g) {
            int y = (this.getHeight() - this.checkBoxIcon.getIconHeight()) / 2;
            g.translate(this.buffer, 0);
            super.paintComponent(g);
            g.translate(-this.buffer, 0);
            this.checkBoxIcon.paintIcon(this.dummyBox, g, 0, y);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.selected) {
                g2d.setColor(Color.WHITE);
            } else {
                g2d.setColor(AccessStyle.TREE_SELECTION_COLOR);
            }
        }
    }

    class PrunedTreeModel
    implements TreeModel {
        private final MachineGroup prunedRoot;
        private MachineTreeModel delegate;

        public PrunedTreeModel(MachineTreeModel model, MachineGroup prunedRoot) {
            this.delegate = model;
            this.prunedRoot = prunedRoot;
        }

        @Override
        public Object getRoot() {
            return this.prunedRoot;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                MachineGroup[] childGroups = (MachineGroup[])this.delegate.getGroupsIn(machineGroup);
                if (index < childGroups.length) {
                    return childGroups[index];
                }
                return machineGroup.getElements().get(index -= childGroups.length);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                MachineGroup[] childGroups = (MachineGroup[])this.delegate.getGroupsIn(machineGroup);
                return childGroups.length + machineGroup.getElementCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof MachineGroup) {
                MachineGroup machineGroup = (MachineGroup)parent;
                if (child instanceof MachineGroup) {
                    MachineGroup childGroup = (MachineGroup)child;
                    return this.delegate.getIndexOf(childGroup);
                }
                return this.delegate.getChildGroupCount(machineGroup) + machineGroup.getElements().indexOf(child);
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

