/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JLabel;
import utils.osstats.linux.LinuxBasicInfo;
import utils.osstats.osx.OSXBasicInfo;
import utils.osstats.types.BasicInfo;
import utils.osstats.types.DiskConfig;
import utils.osstats.types.MemoryConfig;
import utils.osstats.types.ProcessorConfig;
import utils.osstats.windows.WindowsBasicInfo;
import utils.progtools.DataUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JWrapTextPaneLabel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.layout.GbPanel;

public class BasicInfoUI {
    private GbPanel rootComponent = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
    private JWrapTextPaneLabel modelLabel = new JWrapTextPaneLabel(true);
    private JWrapTextPaneLabel processorLabel = new JWrapTextPaneLabel(true);
    private JWrapTextPaneLabel memoryLabel = new JWrapTextPaneLabel(true);
    private JWrapTextPaneLabel serialLabel = new JWrapTextPaneLabel(true);
    private GbPanel disksPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private JWrapTextPaneLabel biosLabel1 = new JWrapTextPaneLabel(true);
    private JWrapTextPaneLabel biosLabel2 = new JWrapTextPaneLabel(true);
    private JLabel biosTitle1;
    private JLabel biosTitle2;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public BasicInfoUI() {
        this.initUI();
    }

    public void initUI() {
        JLabel modelTitle = new JLabel(Language.get("HARDWARE_MODEL"));
        JLabel serialTitle = new JLabel(Language.get("HARDWARE_SERIAL"));
        JLabel processorsTitle = new JLabel(Language.get("HARDWARE_PROCESSORS"));
        JLabel memoryTitle = new JLabel(Language.get("HARDWARE_MEMORY"));
        JLabel disksTitle = new JLabel(Language.get("HARDWARE_DISKS"));
        this.biosTitle1 = new JLabel();
        this.biosTitle2 = new JLabel();
        modelTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        modelTitle.setHorizontalAlignment(4);
        serialTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        serialTitle.setHorizontalAlignment(4);
        processorsTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        processorsTitle.setHorizontalAlignment(4);
        memoryTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        memoryTitle.setHorizontalAlignment(4);
        disksTitle.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        disksTitle.setHorizontalAlignment(4);
        this.biosTitle1.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.biosTitle1.setHorizontalAlignment(4);
        this.biosTitle2.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.biosTitle2.setHorizontalAlignment(4);
        int Y = 0;
        this.rootComponent.add(modelTitle, 1, Y, 1, 1, 0, 0, 13, 2);
        this.rootComponent.add(this.modelLabel, 2, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add(serialTitle, 1, Y, 1, 1, 0, 0, 13, 2);
        this.rootComponent.add(this.serialLabel, 2, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add(processorsTitle, 1, Y, 1, 1, 0, 0, 13, 2, new Insets(20, 3, 3, 3));
        this.rootComponent.add(this.processorLabel, 2, Y++, 1, 1, 1, 0, 17, 2, new Insets(20, 3, 3, 3));
        this.rootComponent.add(memoryTitle, 1, Y, 1, 1, 0, 0, 13, 2);
        this.rootComponent.add(this.memoryLabel, 2, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add(disksTitle, 1, Y, 1, 1, 0, 0, 13, 2);
        this.rootComponent.add(this.disksPanel, 2, Y++, 1, 1, 1, 0, 17, 2, new Insets(0, 0, 0, 0));
        this.rootComponent.add(this.biosTitle1, 1, Y, 1, 1, 0, 0, 13, 2, new Insets(20, 3, 3, 3));
        this.rootComponent.add(this.biosLabel1, 2, Y++, 1, 1, 1, 0, 17, 2, new Insets(20, 3, 3, 3));
        this.rootComponent.add(this.biosTitle2, 1, Y, 1, 1, 0, 0, 13, 2);
        this.rootComponent.add(this.biosLabel2, 2, Y++, 1, 1, 1, 0, 17, 2);
    }

    public void initFor(BasicInfo basicInfo) {
        if (basicInfo == null) {
            return;
        }
        StringBuilder modelTextBuffer = new StringBuilder();
        if (basicInfo.computerModelName != null) {
            modelTextBuffer.append(basicInfo.computerModelName.trim());
        }
        if (basicInfo.computerModelManufacturer != null || basicInfo.computerModelIdentifier != null) {
            modelTextBuffer.append(" (");
            if (basicInfo.computerModelManufacturer != null) {
                modelTextBuffer.append(basicInfo.computerModelManufacturer.trim());
            }
            if (basicInfo.computerModelIdentifier != null) {
                if (basicInfo.computerModelManufacturer != null) {
                    modelTextBuffer.append(", ");
                }
                modelTextBuffer.append(basicInfo.computerModelIdentifier.trim());
            }
            modelTextBuffer.append(")");
        }
        String modelText = modelTextBuffer.toString();
        if (basicInfo.serial != null) {
            modelText = modelText.replace(basicInfo.serial, "");
        }
        modelText = modelText.replace("(,", "(");
        modelText = modelText.replace(", )", ")");
        modelText = modelText.replace("()", "");
        this.modelLabel.setText(modelText);
        if (basicInfo.getProcessorCount() > 0) {
            ProcessorConfig config = basicInfo.processorConfig[0];
            StringBuilder result = new StringBuilder();
            String speed = this.getProcessorSpeed(config);
            if (speed != null) {
                result.append(speed).append(" ");
            }
            result.append(config.processorName);
            result.append(" (");
            result.append(basicInfo.getProcessorCount());
            if (config.coreCount > 0) {
                result.append(", ").append(config.coreCount);
                if (config.coreCount == 1) {
                    result.append(" core");
                } else {
                    result.append(" cores");
                }
            }
            if (config.is64bit) {
                result.append(", 64bit");
            } else {
                result.append(", 32bit");
            }
            result.append(")");
            this.processorLabel.setText(result.toString());
        } else {
            this.processorLabel.setText("");
        }
        this.serialLabel.setText(basicInfo.serial);
        this.memoryLabel.setText(this.getMemorySummary(basicInfo.memoryConfig));
        this.disksPanel.removeAll();
        int Y = 0;
        for (DiskConfig config : basicInfo.diskConfig) {
            StringBuilder label = new StringBuilder();
            label.append(DataUtil.getSensibleSize(config.capacityBytes));
            if (config.type != null) {
                label.append(" ").append(config.type);
            }
            if (config.deviceName != null) {
                label.append(", ").append(config.deviceName);
            }
            if (config.disk != null || config.mediaName != null) {
                label.append(" (");
                if (config.deviceName != null && config.disk != null && config.deviceName.equals(config.disk)) {
                    label.append(config.mediaName);
                } else if (config.disk == null) {
                    label.append(config.mediaName);
                } else if (config.mediaName == null) {
                    label.append(config.disk);
                } else {
                    label.append(config.disk).append(", ").append(config.mediaName);
                }
                label.append(")");
            }
            JWrapTextPaneLabel diskLabel = new JWrapTextPaneLabel(true);
            diskLabel.setText(label.toString());
            this.disksPanel.add(diskLabel, 0, Y++, 1, 1, 1, 0, 17, 2);
        }
        this.disksPanel.revalidate();
        this.biosLabel1.setText(basicInfo.getBiosNameAndVendor());
        this.biosLabel2.setText(basicInfo.getBiosVersion());
        if (basicInfo instanceof WindowsBasicInfo || basicInfo instanceof LinuxBasicInfo) {
            this.biosTitle1.setText(Language.get("HARDWARE_BIOS"));
            this.biosTitle2.setText(Language.get("HARDWARE_RELEASE_DATE"));
        } else if (basicInfo instanceof OSXBasicInfo) {
            this.biosTitle1.setText(Language.get("HARDWARE_BOOT_ROM"));
            this.biosTitle2.setText(Language.get("HARDWARE_SMV_VERSION"));
        }
        this.rootComponent.repaint();
    }

    public String getProcessorSpeed(ProcessorConfig processorConfig) {
        double speedHz = processorConfig.processorSpeedHz;
        if (speedHz == 0.0) {
            return null;
        }
        return DataUtil.getSensibleSpeed(speedHz);
    }

    public String getMemorySummary(MemoryConfig[] allMemory) {
        ArrayList<MemoryConfig> configs = new ArrayList<MemoryConfig>();
        for (MemoryConfig config : allMemory) {
            configs.add(config);
        }
        Collections.reverse(configs);
        StringBuilder summary = new StringBuilder();
        while (configs.size() > 0) {
            String key = null;
            MemoryConfig config = (MemoryConfig)configs.remove(configs.size() - 1);
            long size = config.capacityBytes;
            key = config.type;
            if (config.speedHz > 0L) {
                key = key + " " + DataUtil.getSensibleSpeed(config.speedHz);
            }
            for (int i = configs.size() - 1; i >= 0; --i) {
                MemoryConfig newConfig = (MemoryConfig)configs.get(i);
                String newKey = config.speedHz > 0L ? config.type + " " + DataUtil.getSensibleSpeed(config.speedHz) : config.type;
                if (!newKey.equals(key)) continue;
                size += newConfig.capacityBytes;
                configs.remove(i);
            }
            if (summary.length() > 0) {
                summary.append(", ");
            }
            summary.append(DataUtil.getSensibleSize(size)).append(" ").append(key);
        }
        return summary.toString();
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        BasicInfoUI infoUI = new BasicInfoUI();
        frame.getContentPane().add(infoUI.getRootComponent());
        frame.setVisible(true);
        BasicInfo info = BasicInfo.getBasicInfo();
        infoUI.initFor(info);
    }
}

