/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.InterpretterOption;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.common.toolbox.ToolBoxGroup;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxUIInterface;
import com.aem.shelp.tech.access.model.machine.filters.RunToolMachineFilter;
import com.aem.shelp.tech.properties.ToolBoxPropertiesPanel;
import com.aem.shelp.tech.toolbox.ToolBoxImportRenderer;
import com.aem.shelp.tech.toolbox.ToolBoxItemUI;
import com.aem.shelp.tech.toolbox.ToolBoxResultUI;
import com.aem.shelp.tech.toolbox.ToolBoxRunnerSlider;
import com.aem.shelp.tech.utils.SavingLabel;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.shelp.util.PleaseWaitDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import utils.files.FileUtil;
import utils.progtools.SaverUtil;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.JEditableLabel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JWrapLabel;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.RadialProgressBar;
import utils.swing.components.SHJTable;
import utils.swing.components.animated.arrow.ArrowedProgressBar;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.components.messagefields.MessageTextArea;
import utils.swing.components.reorderablepanel.ReorderablePanel;
import utils.swing.components.reorderablepanel.ReorderablePanelDropTargetListener;
import utils.swing.components.reorderablepanel.ReorderablePanelList;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public abstract class ToolBoxUI
implements ToolBoxUIInterface,
ActionListener,
SaverUtil.SaveListener,
KeyListener,
MessageFieldHandler.FilterListener {
    private static final Color OUTER_COLOUR = SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER;
    private static final Color INNER_COLOUR = SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER;
    private final JPanel rootPanel = new JPanel();
    private final GbPanel toolBoxPanel = new GbPanel();
    private JScrollPane toolBoxPanelScroller = new JScrollPane(this.toolBoxPanel);
    private GbPanel toolBoxHeaderPanel = new GbPanel();
    private final JPanel editPanel = new JPanel(new BorderLayout());
    private EditUIHeaderPanel editUIHeaderPanel = new EditUIHeaderPanel();
    private final ToolBoxItemUI editUI = new ToolBoxItemUI(this);
    private final JPanel resultPanel = new JPanel(new BorderLayout());
    private HeaderPanel resultUIHeaderPanel = new HeaderPanel();
    private final ToolBoxResultUI resultUI = new ToolBoxResultUI(null);
    private JScrollPane resultScroller;
    private final JPanel sharePanel;
    private HeaderPanel shareUIHeaderPanel;
    private GbPanel sharingPanel;
    private JButton exportNow;
    private final JPanel scriptPanel;
    private ScriptHeaderPanel scriptHeaderPanel;
    private GbPanel scriptContentsPanel;
    private RSyntaxTextArea scriptArea;
    private final JPanel importPanel;
    private NoContentsInfoPanel noSharedToolboxPanel;
    private ImportHeaderPanel importUIHeaderPanel;
    private GbPanel importToolboxPanel;
    private SimpleList<SelectedToolBoxGroup> importedToolBoxesList;
    private FilterWrapper<SelectedToolBoxGroup> filteredWrapper;
    private SimpleTableModel tableModel;
    private SHJTable toolBoxImportTable;
    private ToolBoxImportRenderer toolBoxImportRenderer;
    private GbPanel importFromFilePanel;
    private JButton importNow;
    private JButton addGroupButton;
    private JButton importButton;
    private ToolBox toolBox;
    private JPanel filler;
    private SLPanel containerSliding;
    private SLConfig mainConfig;
    private SLConfig itemEditConfig;
    private SLConfig resultConfig;
    private SLConfig shareConfig;
    private SLConfig importConfig;
    private SLConfig scriptConfig;
    private int addToolButtonWidth;
    private ToolBoxItem itemBeingEdited;
    private ArrayList<ToolBoxGroupUI> allGroupUIs;
    private SaverUtil saverUtil;
    private boolean showEditUI;
    private HashMap<ToolBoxItem, ToolBoxRowItem> itemToUIMap;
    private int[] targetOSes;
    private boolean showBatchSlider;
    private ToolBoxRunnerSlider slider;
    private int machineCount;
    private MessageTextArea shareDescriptionArea;
    private JComboBox shareField;
    protected SavingLabel savingLabel;
    private String[] filterText;
    private String serverHost;
    private int serverPort;
    static int buttonWidth = -1;
    static final String[] shareOptions = new String[]{Language.get("TOOLBOX_SHARE_NONE"), Language.get("TOOLBOX_SHARE_GROUP"), Language.get("TOOLBOX_SHARE_ALL_TECHNICIANS")};
    final int mode_MAIN = 0;
    final int mode_EDIT = 1;
    final int mode_RESULT = 2;
    final int mode_SHARE = 3;
    final int mode_IMPORT = 4;
    final int mode_SCRIPT = 5;
    float modeTime;
    int modeCurrent;
    private ToolBoxGroup groupBeingShared;
    private ToolBoxGroupUI groupBeingSharedUI;

    public abstract RunToolMachineFilter.ToolBoxResultWrapper runItem(ToolBoxItem var1);

    public abstract void synchroniseResources(ToolBoxUI var1, ToolBoxItem var2, ToolBoxPropertiesPanel.SyncCancelledListener var3);

    public abstract void synchroniseResourcesAndBlock(ToolBox var1, ToolBoxItem var2, ToolBoxPropertiesPanel.SyncCancelledListener var3);

    public abstract ToolBoxGroup[] getSharedToolboxGroups() throws Exception;

    public JComponent getRootComponent() {
        return this.rootPanel;
    }

    public ToolBoxUI(boolean showEditUI, int[] targetOSes) {
        this(showEditUI, targetOSes, 0);
    }

    public ToolBoxUI(boolean showEditUI, int[] targetOSes, int machineCount) {
        this.resultScroller = new JScrollPane(this.resultUI.rootComponent);
        this.sharePanel = new JPanel(new BorderLayout());
        this.shareUIHeaderPanel = new HeaderPanel();
        this.sharingPanel = new GbPanel();
        this.exportNow = new JButton();
        this.scriptPanel = new JPanel(new BorderLayout());
        this.scriptHeaderPanel = new ScriptHeaderPanel();
        this.scriptContentsPanel = new GbPanel();
        this.scriptArea = new RSyntaxTextArea(20, 60);
        this.importPanel = new JPanel(new BorderLayout());
        this.noSharedToolboxPanel = new NoContentsInfoPanel(Language.get("TOOLBOX_NO_SHARED"), null, false);
        this.importUIHeaderPanel = new ImportHeaderPanel();
        this.importToolboxPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.importedToolBoxesList = new SimpleList();
        this.filteredWrapper = new FilterWrapper<SelectedToolBoxGroup>(this.importedToolBoxesList);
        this.tableModel = null;
        this.addGroupButton = new JButton(Language.get("TOOLBOX_CREATE_NEW"));
        this.importButton = new JButton(Language.get("TOOLBOX_IMPORT"));
        this.filler = new JPanel();
        this.containerSliding = new SLPanel();
        this.addToolButtonWidth = -1;
        this.allGroupUIs = new ArrayList();
        this.itemToUIMap = new HashMap();
        this.filterText = null;
        this.mode_MAIN = 0;
        this.mode_EDIT = 1;
        this.mode_RESULT = 2;
        this.mode_SHARE = 3;
        this.mode_IMPORT = 4;
        this.mode_SCRIPT = 5;
        this.modeTime = 0.5f;
        this.modeCurrent = 0;
        this.showEditUI = showEditUI;
        this.targetOSes = targetOSes;
        this.showBatchSlider = !showEditUI;
        this.machineCount = machineCount;
        this.saverUtil = new SaverUtil("ToolBox", 3000, this, true);
        this.initUI();
        this.load(new ToolBox());
    }

    private static int getButtonWidth() {
        if (buttonWidth != -1) {
            return buttonWidth;
        }
        JButton[] buttons = new JButton[]{new JButton(Language.get("TOOLBOX_IMPORT")), new JButton(Language.get("TOOLBOX_SHARE")), new JButton(Language.get("TOOLBOX_SHARE_FORGET")), new JButton(Language.get("REMOVE")), new JButton(Language.get("EDIT"))};
        for (int i = 0; i < buttons.length; ++i) {
            buttonWidth = Math.max(buttonWidth, buttons[i].getPreferredSize().width);
        }
        return buttonWidth;
    }

    public int getSessionsToUse() {
        return this.slider.getSessionsToUse();
    }

    public ToolBox getToolBox() {
        return this.toolBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.shareField) {
            this.groupBeingShared.setSharingMode((byte)this.shareField.getSelectedIndex());
            this.groupBeingSharedUI.updateGroupLabel();
        } else if (e.getSource() == this.importButton) {
            this.switchToImportView();
        } else if (e.getSource() == this.addGroupButton) {
            ToolBoxGroup group = new ToolBoxGroup(this.toolBox.getUniqueNewGroupID());
            group.setName(Language.get("TOOLBOX_NEW_GROUP_NAME"));
            this.addNewToolBoxGroup(group);
        } else {
            if (e.getSource() == this.exportNow) {
                this.exportToolbox();
                return;
            }
            if (e.getSource() == this.importNow) {
                this.importToolbox();
                return;
            }
        }
        this.saverUtil.queueSave();
    }

    protected void addNewToolBoxGroup(ToolBoxGroup group) {
        this.toolBox.addToolBoxGroup(group);
        ToolBoxGroupUI groupUI = new ToolBoxGroupUI(group);
        this.addToolBoxGroupUI(groupUI);
        this.toolBoxPanel.revalidate();
        this.toolBoxPanel.repaint();
    }

    private void exportToolbox() {
        String name = this.groupBeingShared.getName();
        File saveFile = SafeJFileChooser.saveFile(this.getRootComponent(), null, FileUtil.toFilenameTrimmed(name));
        if (saveFile != null) {
            new ExportToolboxThread(saveFile);
        }
    }

    private void importToolbox() {
        File importFile = SafeJFileChooser.pickFile(this.getRootComponent(), null);
        if (importFile != null) {
            new ImportToolboxThread(importFile);
        }
    }

    @Override
    public void startSynchronisation(ToolBoxItem item) {
        ToolBoxRowItem toolBoxRowItem = this.itemToUIMap.get(item);
        toolBoxRowItem.startSynchronisation();
    }

    public void synchronisationProgress(ToolBoxItem item, double percentage) {
        ToolBoxRowItem toolBoxRowItem = this.itemToUIMap.get(item);
        toolBoxRowItem.synchronisationProgress(percentage);
    }

    @Override
    public void endSynchronisation(ToolBoxItem item) {
        ToolBoxRowItem toolBoxRowItem = this.itemToUIMap.get(item);
        toolBoxRowItem.endSynchronisation();
    }

    public void setServerAddress(String host, int port) {
        this.serverHost = host;
        this.serverPort = port;
    }

    private void initUI() {
        this.toolBoxPanelScroller.setBorder(SHBorderFactory.createEmptyBorder());
        this.resultScroller.setBorder(SHBorderFactory.createEmptyBorder());
        SwingUtil.setHeight(this.toolBoxHeaderPanel, SimpleHelpLookAndFeel.scale(30));
        this.savingLabel = new SavingLabel();
        JPanel leftBuffer = new JPanel(new GridLayout(1, 1));
        JPanel rightBuffer = new JPanel(new GridLayout(1, 1));
        rightBuffer.setBorder(SHBorderFactory.createEmptyBorder(0, 0, 0, 3));
        rightBuffer.add(this.importButton);
        SwingUtil.setWidth(this.importButton, ToolBoxUI.getButtonWidth());
        int maxWidthForBuffers = Math.max(rightBuffer.getPreferredSize().width, leftBuffer.getPreferredSize().width);
        SwingUtil.setWidth(leftBuffer, maxWidthForBuffers);
        SwingUtil.setWidth(rightBuffer, maxWidthForBuffers);
        this.toolBoxHeaderPanel.add(leftBuffer, 0, 1, 1, 1, 0, 1, 10, 0);
        this.toolBoxHeaderPanel.add(this.addGroupButton, 1, 1, 1, 1, 1, 1, 10, 0);
        this.toolBoxHeaderPanel.add(rightBuffer, 2, 1, 1, 1, 0, 1, 10, 0);
        this.addGroupButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.rootPanel.setLayout(new GridLayout());
        this.rootPanel.add(this.containerSliding);
        this.editPanel.add((Component)this.editUIHeaderPanel, "North");
        this.editPanel.add((Component)this.editUI.getRootComponent(), "Center");
        this.resultPanel.add((Component)this.resultUIHeaderPanel, "North");
        this.resultPanel.add((Component)this.resultScroller, "Center");
        this.initSharePanel();
        this.sharePanel.add((Component)this.shareUIHeaderPanel, "North");
        this.sharePanel.add((Component)this.sharingPanel, "Center");
        this.initImportPanel();
        this.noSharedToolboxPanel.setContentsPanel(this.importToolboxPanel);
        this.noSharedToolboxPanel.setFont(SHStyle.normalFont, SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
        this.importPanel.add((Component)this.importUIHeaderPanel, "North");
        this.importPanel.add((Component)this.noSharedToolboxPanel, "Center");
        this.importPanel.add((Component)this.importFromFilePanel, "South");
        this.initScriptPanel();
        this.scriptPanel.add((Component)this.scriptHeaderPanel, "North");
        this.scriptPanel.add((Component)this.scriptContentsPanel, "Center");
        this.initSlidingConfigs();
        this.filler.setBackground(Color.white);
        SwingUtil.setSize(this.filler, 1, 1);
    }

    private void initScriptPanel() {
        try {
            InputStream xmlStream = ToolBoxUI.class.getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/eclipse.xml");
            if (xmlStream != null) {
                Theme theme = Theme.load(xmlStream);
                theme.apply(this.scriptArea);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.scriptArea.setCodeFoldingEnabled(true);
        RTextScrollPane scrollPane = new RTextScrollPane(this.scriptArea);
        scrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.scriptContentsPanel.add(scrollPane, 0, 0, 1, 1, 1, 1, 10, 1);
    }

    private void initImportPanel() {
        TableStructure ts = TableStructure.createTableStructure(ToolBoxGroup.class, new String[]{"", "", "", ""}, new String[]{"", Language.get("TOOLBOX_NAME"), Language.get("DESCRIPTION"), Language.get("OWNER")});
        this.tableModel = new SimpleTableModel(this.filteredWrapper, ts);
        this.toolBoxImportTable = new SHJTable(this.tableModel);
        this.toolBoxImportTable.addMouseListener(new ImportTableMouseListener());
        this.toolBoxImportTable.setRowHeight(SimpleHelpLookAndFeel.scale(26));
        this.toolBoxImportRenderer = new ToolBoxImportRenderer();
        this.toolBoxImportTable.setDefaultRenderer(Object.class, this.toolBoxImportRenderer);
        ts.setMinWidths(new int[]{SimpleHelpLookAndFeel.scale(30), SimpleHelpLookAndFeel.scale(100), -1, SimpleHelpLookAndFeel.scale(150)});
        ts.setMaxWidths(new int[]{SimpleHelpLookAndFeel.scale(30), -1, -1, 150});
        ts.initTableDimensions(this.toolBoxImportTable);
        JScrollPane tableScroller = new JScrollPane(this.toolBoxImportTable);
        this.importToolboxPanel.add(tableScroller, 0, 0, 1, 1, 1, 1, 10, 1);
        this.importFromFilePanel = new GbPanel();
        this.importFromFilePanel.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(1, 0, 0, 0, SHStyle.BORDER_COLOR), SHBorderFactory.createEmptyBorder(5, 5, 5, 5)));
        StrippedContentPanel contentPanel = new StrippedContentPanel(this.importFromFilePanel);
        GbPanel importFromFileContent = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        importFromFileContent.setBorder(SHBorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel label = new JLabel(Language.get("TOOLBOX_IMPORT_DESC"));
        this.importNow = new JButton(Language.get("TOOLBOX_IMPORT_FILE"));
        importFromFileContent.add(label, 0, 0, 1, 1, 1, 1, 10, 1);
        importFromFileContent.add(this.importNow, 0, 1, 1, 1, 1, 1, 17, 0, new ScaledInsets(10, 5, 0, 0));
        this.importNow.addActionListener(this);
        contentPanel.addContent(importFromFileContent, Language.get("TOOLBOX_IMPORT_FILE"));
    }

    private void loadSharePanel(ToolBoxGroup group) {
        this.shareField.setSelectedIndex(group.getSharingMode());
        if (group.getSharingDescription() != null) {
            this.shareDescriptionArea.setText(group.getSharingDescription());
        }
    }

    private void initSharePanel() {
        GbPanel shareConfigurationPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        JWrapLabel descLabel = new JWrapLabel("<html>" + Language.get("TOOLBOX_SHARE_DESC"));
        JLabel shareLabel = new JLabel(Language.get("TOOLBOX_SHARE_WITH"));
        JLabel summaryLabel = new JLabel(Language.get("TOOLBOX_SHARE_SUMMARY"));
        this.shareField = new JComboBox<String>(shareOptions);
        this.shareField.setSelectedIndex(0);
        this.shareDescriptionArea = new MessageTextArea(Language.get("TOOLBOX_SHARE_DESCRIPTION"), null);
        JScrollPane scroller = new JScrollPane(this.shareDescriptionArea);
        SwingUtil.setHeight(scroller, SimpleHelpLookAndFeel.scale(100));
        this.shareField.addActionListener(this);
        this.shareDescriptionArea.addKeyListener(this);
        int Y = 0;
        shareConfigurationPanel.add(descLabel, 0, Y++, 2, 1, 1, 0, 13, 2);
        shareConfigurationPanel.add(shareLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        shareConfigurationPanel.add(this.shareField, 1, Y++, 1, 1, 0, 0, 17, 2);
        shareConfigurationPanel.add(summaryLabel, 0, Y, 1, 1, 0, 0, 12, 0);
        shareConfigurationPanel.add(scroller, 1, Y++, 1, 1, 0, 0, 17, 2);
        GbPanel exportPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        JWrapLabel descLabel2 = new JWrapLabel("<html>" + Language.get("TOOLBOX_EXPORT_DESC"));
        this.exportNow = new JButton(Language.get("TOOLBOX_EXPORT_NOW"));
        this.exportNow.addActionListener(this);
        int Y2 = 0;
        exportPanel.add(descLabel2, 0, Y2++, 2, 1, 1, 0, 17, 2);
        exportPanel.add(this.exportNow, 0, Y2++, 1, 1, 1, 0, 17, 0, new ScaledInsets(10, 5, 0, 0));
        StrippedContentPanel scp = new StrippedContentPanel(this.sharingPanel);
        scp.addContent(shareConfigurationPanel, Language.get("TOOLBOX_SHARING_TITLE"));
        scp.addContent(exportPanel, Language.get("TOOLBOX_EXPORT_TITLE"));
        scp.addVerticalFiller();
        scp.setBackgroundColours(true);
    }

    public void load(ToolBox toolBox) {
        this.toolBox = toolBox;
        this.toolBoxPanel.removeAll();
        if (this.showEditUI) {
            this.toolBoxPanel.add(this.toolBoxHeaderPanel, 0, 0, 1, 1, 1, 0, 10, 1);
        }
        if (toolBox != null) {
            Iterator<ToolBoxGroup> iterator = toolBox.getGroupIterator(this.filterText);
            while (iterator.hasNext()) {
                ToolBoxGroup group = iterator.next();
                if (!this.showEditUI && !group.containsAnItemForThisOS(this.targetOSes)) continue;
                ToolBoxGroupUI groupUI = new ToolBoxGroupUI(group);
                this.addToolBoxGroupUI(groupUI);
            }
        }
        this.toolBoxPanel.add(this.filler, 0, this.toolBoxPanel.getComponentCount(), 1, 1, 1, 1, 10, 1);
        if (this.showBatchSlider) {
            this.slider = new ToolBoxRunnerSlider(this.machineCount);
            this.toolBoxPanel.add(this.slider.getRootComponent(), 0, this.toolBoxPanel.getComponentCount(), 1, 1, 1, 0, 10, 1);
        }
    }

    private void removeToolBoxGroupUI(ToolBoxGroupUI groupUI) {
        this.allGroupUIs.remove(groupUI);
        for (Component c : this.toolBoxPanel.getComponents()) {
            if (c != groupUI.rootComponent) continue;
            this.toolBoxPanel.remove(c);
            this.toolBoxPanel.revalidate();
            this.toolBoxPanel.repaint();
            return;
        }
    }

    private void addToolBoxGroupUI(ToolBoxGroupUI groupUI) {
        boolean lastComponentIsFiller;
        this.allGroupUIs.add(groupUI);
        boolean bl = lastComponentIsFiller = this.toolBoxPanel.getComponentCount() > 0 && this.toolBoxPanel.getComponent(this.toolBoxPanel.getComponentCount() - 1) == this.filler;
        if (lastComponentIsFiller) {
            this.toolBoxPanel.remove(this.filler);
        }
        this.toolBoxPanel.add(groupUI.rootComponent, 0, this.toolBoxPanel.getComponentCount(), 1, 1, 1, 0, 10, 2);
        if (lastComponentIsFiller) {
            this.toolBoxPanel.add(this.filler, 0, this.toolBoxPanel.getComponentCount(), 1, 1, 1, 1, 10, 1);
        }
    }

    private void switchToEdit(ToolBoxItem item, boolean isImported) {
        this.itemBeingEdited = item;
        this.editUI.load(item, isImported);
        this.switchToEditView();
    }

    private void reloadAllItemNames() {
        for (ToolBoxGroupUI groupUI : this.allGroupUIs) {
            groupUI.reloadAllItemNames();
        }
    }

    private void removeItem(ToolBoxItem item) {
        for (int i = this.allGroupUIs.size() - 1; i >= 0; --i) {
            ToolBoxGroupUI groupUI = this.allGroupUIs.get(i);
            boolean success = groupUI.removeItem(item);
            if (success) {
                boolean isEmpty;
                boolean bl = isEmpty = !groupUI.group.getToolBoxItems().hasNext();
                if (isEmpty) {
                    this.removeToolBoxGroupUI(groupUI);
                    this.toolBox.removeToolBoxGroup(groupUI.group);
                }
            }
            this.saverUtil.queueSave();
        }
    }

    private void initSlidingConfigs() {
        this.mainConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.toolBoxPanelScroller);
        this.itemEditConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.editPanel);
        this.resultConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.resultPanel);
        this.shareConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.sharePanel);
        this.importConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.importPanel);
        this.scriptConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.scriptPanel);
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.mainConfig);
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    public void switchToEditView() {
        if (this.modeCurrent == 5) {
            this.editUI.setScriptContents(this.scriptArea.getText());
        }
        this.switchToNewView(this.itemEditConfig, 1, this.editPanel);
    }

    public void switchToToolBoxView() {
        if (this.groupBeingShared != null) {
            this.groupBeingShared = null;
        }
        this.switchToNewView(this.mainConfig, 0, this.toolBoxPanelScroller);
    }

    public void switchToResultsView() {
        this.switchToNewView(this.resultConfig, 2, this.resultPanel);
    }

    public void switchToScriptView(String scriptContents, InterpretterOption interpretter) {
        this.scriptArea.setSyntaxEditingStyle(interpretter.getBestGuessSyntax());
        this.scriptArea.setText(scriptContents);
        this.switchToNewView(this.scriptConfig, 5, this.scriptPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolBoxUI.this.scriptArea.requestFocusInWindow();
            }
        });
    }

    public void switchToShareView(ToolBoxGroupUI toolBoxGroupUI, ToolBoxGroup group) {
        this.groupBeingShared = group;
        this.groupBeingSharedUI = toolBoxGroupUI;
        this.loadSharePanel(group);
        this.switchToNewView(this.shareConfig, 3, this.sharePanel);
    }

    public void switchToImportView() {
        this.switchToNewView(this.importConfig, 4, this.importPanel);
        new QueryServerForToolboxes();
    }

    public void setEnabled(boolean enabled) {
        this.rootPanel.setEnabled(enabled);
        this.toolBoxPanel.setEnabled(enabled);
        this.editPanel.setEnabled(enabled);
    }

    public void setRemoteOperatingSystems(int[] targetOSes) {
        this.targetOSes = targetOSes;
        if (this.toolBox != null) {
            this.load(this.toolBox);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.shareDescriptionArea) {
            this.groupBeingShared.setSharingDescription(this.shareDescriptionArea.getText());
        }
    }

    @Override
    public void setFilter(String filter, boolean immediately) {
        if (filter == null) {
            this.filterText = null;
        } else {
            this.filterText = filter.split(" ");
            for (int i = 0; i < this.filterText.length; ++i) {
                this.filterText[i] = this.filterText[i].toLowerCase();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolBoxUI.this.load(ToolBoxUI.this.toolBox);
                ToolBoxUI.this.toolBoxPanel.revalidate();
                ToolBoxUI.this.toolBoxPanel.repaint();
            }
        });
    }

    class SelectedToolBoxGroup {
        ToolBoxGroup group;
        boolean imported;

        SelectedToolBoxGroup() {
        }

        public String toString() {
            return this.group.toString();
        }
    }

    class ImportTableMouseListener
    extends MouseAdapter {
        ImportTableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int row = ToolBoxUI.this.toolBoxImportTable.rowAtPoint(e.getPoint());
            int column = ToolBoxUI.this.toolBoxImportTable.columnAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            SelectedToolBoxGroup toolBoxGroup = (SelectedToolBoxGroup)ToolBoxUI.this.filteredWrapper.get(row);
            if (toolBoxGroup != null && column == 0) {
                toolBoxGroup.imported = !toolBoxGroup.imported;
                ToolBoxUI.this.tableModel.fireCellChanged(row, column);
            }
        }
    }

    class QueryServerForToolboxes
    extends Thread {
        public QueryServerForToolboxes() {
            this.start();
        }

        @Override
        public void run() {
            ToolBoxGroup[] sharedGroups = null;
            try {
                sharedGroups = ToolBoxUI.this.getSharedToolboxGroups();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            final ToolBoxGroup[] sharedGroupsTmp = sharedGroups;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ToolBoxUI.this.importedToolBoxesList.clear();
                    ToolBoxUI.this.importedToolBoxesList.startBatch();
                    try {
                        if (sharedGroupsTmp != null) {
                            for (ToolBoxGroup g : sharedGroupsTmp) {
                                SelectedToolBoxGroup newWrapper = new SelectedToolBoxGroup();
                                newWrapper.group = g;
                                newWrapper.imported = ToolBoxUI.this.toolBox.containsGroup(g);
                                ToolBoxUI.this.importedToolBoxesList.add(newWrapper);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        ToolBoxUI.this.noSharedToolboxPanel.setHasContents(ToolBoxUI.this.importedToolBoxesList.size() > 0);
                        ToolBoxUI.this.importUIHeaderPanel.filterField.setEnabled(ToolBoxUI.this.importedToolBoxesList.size() > 0);
                        ToolBoxUI.this.importedToolBoxesList.endBatch();
                        throw throwable;
                    }
                    ToolBoxUI.this.noSharedToolboxPanel.setHasContents(ToolBoxUI.this.importedToolBoxesList.size() > 0);
                    ToolBoxUI.this.importUIHeaderPanel.filterField.setEnabled(ToolBoxUI.this.importedToolBoxesList.size() > 0);
                    ToolBoxUI.this.importedToolBoxesList.endBatch();
                }
            });
        }
    }

    class ToolBoxGroupUI
    extends MouseAdapter
    implements JEditableLabel.EditListener,
    ActionListener,
    ReorderablePanelDropTargetListener.ReorderNotifier {
        private JPanel rootComponent = new JPanel(new BorderLayout());
        private JEditableLabel groupEditableLabel = new JEditableLabel(false){

            @Override
            protected String removeHTML(String labelText) {
                String s = labelText.substring(6);
                int index = s.indexOf("<font");
                if (index > -1) {
                    s = s.substring(0, index);
                }
                if ((index = s.indexOf("&nbsp;")) > -1) {
                    s = s.substring(0, index);
                }
                return s;
            }

            @Override
            protected String addBackHTML(String labelText) {
                return ToolBoxGroupUI.this.getSharedLabel(labelText, ToolBoxGroupUI.this.group.getSharingMode() != 0);
            }
        };
        private JButton addToolButton = new JButton();
        private JButton shareButton = new JButton(Language.get("TOOLBOX_SHARE"));
        private JButton removeGroupButton = new JButton(Language.get("REMOVE"));
        private JButton forgetButton = new JButton(Language.get("TOOLBOX_SHARE_FORGET"));
        JLabel emptyLabel;
        private ReorderablePanelList itemList = new ReorderablePanelList(){

            @Override
            public void relayout() {
                super.relayout();
                ToolBoxGroupUI.this.updateItemListBackgrounds();
            }
        };
        private ToolBoxGroup group;
        private JPanel topPanel;
        private JLabel iconLabel;

        public ToolBoxGroupUI(ToolBoxGroup group) {
            this.itemList.setReorderNotifier(this);
            this.group = group;
            this.initUI();
            this.load(group);
        }

        @Override
        public void reorderHappened() {
            List<ReorderablePanel> panels = this.itemList.getReorderablePanels();
            for (int i = 0; i < panels.size(); ++i) {
                ToolBoxRowItem item = (ToolBoxRowItem)panels.get(i);
                this.group.setToolBoxItemIndex(item.item, i);
            }
            ToolBoxUI.this.saverUtil.saveNow();
        }

        protected String getSharedLabel(String labelText, boolean shared) {
            if (shared) {
                return "<html>" + labelText + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=#DDDDDD> " + Language.get("SHARED");
            }
            return "<html>" + labelText;
        }

        protected String getImportedLabel(String groupName, String ownerName) {
            return "<html>" + groupName + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=#DDDDDD> " + Language.get("SHARED_BY") + " " + ownerName;
        }

        public void updateGroupLabel() {
            if (this.group.isImported()) {
                this.groupEditableLabel.setText(this.getImportedLabel(this.group.getName(), this.group.getSharedOwnerName()));
            } else {
                this.groupEditableLabel.setText(this.getSharedLabel(this.group.getName(), this.group.getSharingMode() != 0));
            }
        }

        public boolean removeItem(ToolBoxItem item) {
            List<ReorderablePanel> reorderablePanels = this.itemList.getReorderablePanels();
            ReorderablePanel removeItem = null;
            for (ReorderablePanel panel : reorderablePanels) {
                ToolBoxRowItem itemUI = (ToolBoxRowItem)panel;
                if (itemUI.item != item) continue;
                removeItem = panel;
                break;
            }
            if (removeItem != null) {
                this.group.removeToolBoxItem(item);
                reorderablePanels.remove(removeItem);
                this.itemList.relayout();
                this.rootComponent.revalidate();
                this.rootComponent.repaint();
                return true;
            }
            return false;
        }

        public void reloadAllItemNames() {
            for (ReorderablePanel panel : this.itemList.getReorderablePanels()) {
                ToolBoxRowItem itemUI = (ToolBoxRowItem)panel;
                itemUI.reload();
            }
        }

        private void load(ToolBoxGroup group) {
            SwingUtil.setWidth(this.forgetButton, ToolBoxUI.getButtonWidth());
            SwingUtil.setWidth(this.shareButton, ToolBoxUI.getButtonWidth());
            SwingUtil.setWidth(this.removeGroupButton, ToolBoxUI.getButtonWidth());
            this.forgetButton.setVisible(group.isImported());
            this.shareButton.setVisible(!group.isImported() && group.getItemCount() > 0);
            this.removeGroupButton.setVisible(!group.isImported() && group.getItemCount() == 0);
            this.addToolButton.setVisible(!group.isImported());
            if (group.isImported()) {
                this.iconLabel.setIcon(ImageLoader.getImageIcon("O[images/svg/general/box.svg,24 | images/svg/arrows/right-blue.svg,12]"));
            }
            this.updateGroupLabel();
            this.itemList.removeAll();
            Iterator<ToolBoxItem> items = group.getToolBoxItems();
            int count = 0;
            while (items.hasNext()) {
                ToolBoxItem item = items.next();
                if (!item.isIncludedByFilter(ToolBoxUI.this.filterText) || !ToolBoxUI.this.showEditUI && !item.showOnThisOS(ToolBoxUI.this.targetOSes)) continue;
                ToolBoxRowItem itemUI = new ToolBoxRowItem(group, item);
                itemUI.setDragDropListener(this.itemList.demoPanelDropTargetListener);
                this.itemList.getReorderablePanels().add(itemUI);
                ++count;
            }
            this.itemList.setVisible(count > 0);
            this.emptyLabel.setVisible(count == 0);
            this.itemList.relayout();
        }

        private void updateItemListBackgrounds() {
            boolean isWhite = true;
            List<ReorderablePanel> reorderablePanels = this.itemList.getReorderablePanels();
            for (ReorderablePanel panel : reorderablePanels) {
                ToolBoxRowItem itemUI = (ToolBoxRowItem)panel;
                if (!isWhite) {
                    itemUI.setBackground(SHStyle.TABLE_ROW_BAND_COLOR);
                } else {
                    itemUI.setBackground(Color.WHITE);
                }
                isWhite = !isWhite;
            }
            this.rootComponent.repaint();
        }

        public void initUI() {
            this.rootComponent.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createEmptyBorder(3, 3, 10, 3), SHBorderFactory.createMatteBorder(1, 1, 1, 1, OUTER_COLOUR)));
            this.forgetButton.addActionListener(this);
            this.forgetButton.setFont(SHStyle.smallerFont);
            this.shareButton.addActionListener(this);
            this.shareButton.setFont(SHStyle.smallerFont);
            this.removeGroupButton.addActionListener(this);
            this.removeGroupButton.setFont(SHStyle.smallerFont);
            this.addToolButton.setFont(SHStyle.smallerFont);
            this.addToolButton.setText(Language.get("TOOLBOX_ADD_TOOL"));
            this.addToolButton.addActionListener(this);
            SwingUtil.setHeight(this.groupEditableLabel, SimpleHelpLookAndFeel.scale(30));
            if (ToolBoxUI.this.addToolButtonWidth == -1) {
                ToolBoxUI.this.addToolButtonWidth = this.addToolButton.getPreferredSize().width;
            }
            this.topPanel = new ColorPropagatingPanel(new BorderLayout());
            JPanel iconAndEditLabel = new JPanel(new BorderLayout());
            this.iconLabel = new JLabel(ImageLoader.getImageIcon("images/svg/general/box.svg,24"));
            this.iconLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 5, 0, 0));
            iconAndEditLabel.add((Component)this.iconLabel, "West");
            iconAndEditLabel.add((Component)this.groupEditableLabel, "Center");
            this.topPanel.add((Component)iconAndEditLabel, "Center");
            if (ToolBoxUI.this.showEditUI) {
                GbPanel rightPanel = new GbPanel();
                rightPanel.add(this.addToolButton, 0, 0, 1, 1, 0, 1, 10, 2, new Insets(3, 3, 3, 3));
                rightPanel.add(this.shareButton, 1, 0, 1, 1, 0, 1, 10, 2, new Insets(3, 3, 3, 3));
                rightPanel.add(this.removeGroupButton, 2, 0, 1, 1, 0, 1, 10, 2, new Insets(3, 3, 3, 3));
                rightPanel.add(this.forgetButton, 3, 0, 1, 1, 0, 1, 10, 2, new Insets(3, 3, 3, 3));
                this.topPanel.add((Component)rightPanel, "East");
            }
            this.emptyLabel = new JLabel(Language.get("TOOLBOX_EMPTY"));
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setBorder(SHStyle.PANEL_EMPTY_BORDER);
            this.emptyLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            this.rootComponent.add((Component)this.topPanel, "North");
            this.rootComponent.add((Component)this.itemList, "Center");
            this.rootComponent.add((Component)this.emptyLabel, "South");
            this.rootComponent.setBackground(Color.white);
            this.topPanel.setBackground(INNER_COLOUR);
            this.groupEditableLabel.setBackground(INNER_COLOUR);
            this.groupEditableLabel.setForeground(Color.white);
            this.groupEditableLabel.setIsEditable(ToolBoxUI.this.showEditUI);
            this.groupEditableLabel.addListener(this);
        }

        @Override
        public void editableLabelValueSet(String newValue) {
            this.group.setName(newValue);
            ToolBoxUI.this.saverUtil.queueSave();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.addToolButton) {
                this.removeGroupButton.setVisible(false);
                this.shareButton.setVisible(true);
                ToolBoxItem item = new ToolBoxItem();
                item.setName(Language.get("TOOLBOX_NEW_TOOL"));
                this.group.addToolBoxItem(item);
                ToolBoxRowItem itemUI = new ToolBoxRowItem(this.group, item);
                itemUI.setDragDropListener(this.itemList.demoPanelDropTargetListener);
                this.itemList.getReorderablePanels().add(itemUI);
                this.itemList.relayout();
                this.itemList.setVisible(true);
                this.emptyLabel.setVisible(false);
                ToolBoxUI.this.toolBoxPanel.revalidate();
                ToolBoxUI.this.toolBoxPanel.repaint();
                ToolBoxUI.this.switchToEdit(item, this.group.isImported());
                ToolBoxUI.this.saverUtil.queueSave();
            } else if (e.getSource() == this.forgetButton) {
                ToolBoxUI.this.toolBox.removeToolBoxGroup(this.group);
                ToolBoxUI.this.removeToolBoxGroupUI(this);
                ToolBoxUI.this.saverUtil.saveNow();
            } else if (e.getSource() == this.shareButton) {
                ToolBoxUI.this.switchToShareView(this, this.group);
            } else if (e.getSource() == this.removeGroupButton) {
                ToolBoxUI.this.removeToolBoxGroupUI(this);
                ToolBoxUI.this.toolBox.removeToolBoxGroup(this.group);
                ToolBoxUI.this.saverUtil.queueSave();
            }
        }

        @Override
        public void editableLabelStartEdit() {
        }
    }

    class ToolBoxRowItem
    extends ReorderablePanel
    implements MouseListener,
    ActionListener {
        private ToolBoxItem item;
        private JLabel toolBoxLabel;
        private RadialProgressBar progressPanel;
        private ArrowedProgressBar bar;
        private boolean running;
        private JButton resultButton;
        private RunToolMachineFilter.ToolBoxResultWrapper result;
        private JButton removeButton;
        private JButton editButton;
        private ToolBoxGroup group;
        Color previousBackgroundColor;

        public ToolBoxRowItem(ToolBoxGroup group, ToolBoxItem item) {
            super(ToolBoxUI.this.showEditUI);
            this.toolBoxLabel = new JLabel();
            this.progressPanel = new RadialProgressBar();
            this.bar = new ArrowedProgressBar();
            this.removeButton = new JButton();
            this.editButton = new JButton();
            this.previousBackgroundColor = null;
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.initUI();
            this.load(group, item);
            ToolBoxUI.this.itemToUIMap.put(item, this);
        }

        public void endSynchronisation() {
            this.progressPanel.setVisible(false);
            this.repaint();
        }

        public void startSynchronisation() {
            this.progressPanel.setPercentageComplete(0.0);
            this.progressPanel.setVisible(true);
            this.repaint();
        }

        public void synchronisationProgress(double progress) {
            this.progressPanel.setPercentageComplete(progress);
        }

        private void initUI() {
            this.toolBoxLabel.setBorder(SHBorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.toolBoxLabel.setIconTextGap(SimpleHelpLookAndFeel.scale(10));
            this.toolBoxLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/spanner-dark.svg,16"));
            this.progressPanel.setVisible(false);
            this.progressPanel.setToolTipText(Language.get("TOOLBOX_SYNCHING"));
            GbPanelWrapper gbWrapper = new GbPanelWrapper(this, new Insets(3, 3, 3, 3));
            int X = 0;
            this.resultButton = new JButton(Language.get("TOOLBOX_RESULTS_VIEW"));
            this.resultButton.setVisible(false);
            this.resultButton.setEnabled(false);
            this.resultButton.addMouseListener(this);
            this.resultButton.setFont(SHStyle.smallerFont);
            gbWrapper.add(this.toolBoxLabel, X++, 0, 1, 1, 1, 1, 17, 1);
            gbWrapper.add(this.progressPanel, X++, 0, 1, 1, 0, 0, 10, 0);
            gbWrapper.add(this.bar.getRootComponent(), X++, 0, 1, 1, 0, 0, 10, 0);
            gbWrapper.add(this.resultButton, X++, 0, 1, 1, 0, 0, 10, 0);
            if (ToolBoxUI.this.showEditUI) {
                this.removeButton.setText(Language.get("REMOVE"));
                this.removeButton.setFont(SHStyle.smallerFont);
                this.removeButton.addMouseListener(this);
                this.removeButton.setEnabled(false);
                this.removeButton.addMouseListener(this);
                SwingUtil.setHeight(this.removeButton, SHStyle.SMALL_BUTTON_HEIGHT);
                SwingUtil.setWidth(this.removeButton, ToolBoxUI.getButtonWidth());
                SHButtonUI.makeButtonRed(this.removeButton);
                this.editButton.setText(Language.get("EDIT"));
                this.editButton.setFont(SHStyle.smallerFont);
                this.editButton.addMouseListener(this);
                this.editButton.setEnabled(false);
                this.editButton.addMouseListener(this);
                SwingUtil.setHeight(this.editButton, SHStyle.SMALL_BUTTON_HEIGHT);
                SwingUtil.setWidth(this.editButton, ToolBoxUI.getButtonWidth());
                gbWrapper.add(this.editButton, X++, 0, 1, 0, 0, 1, 17, 2);
                gbWrapper.add(this.removeButton, X++, 0, 1, 0, 0, 1, 17, 2);
            }
            this.resultButton.addActionListener(this);
            this.setBackground(Color.WHITE);
            SwingUtil.setHeight(this, SimpleHelpLookAndFeel.scale(30));
            SwingUtil.setSize(this.progressPanel, SimpleHelpLookAndFeel.scale(24), SimpleHelpLookAndFeel.scale(24));
            SwingUtil.setSize(this.bar.getRootComponent(), SimpleHelpLookAndFeel.scale(16), SimpleHelpLookAndFeel.scale(16));
            this.bar.setVisible(false);
        }

        public void reload() {
            this.toolBoxLabel.setText(this.item.getName());
        }

        public void load(ToolBoxGroup group, ToolBoxItem item) {
            this.item = item;
            this.group = group;
            this.toolBoxLabel.setText(item.getName());
            this.removeButton.setVisible(!group.isImported());
            if (group.isImported()) {
                this.editButton.setText(Language.get("VIEW"));
            }
            if (item.isScriptAction()) {
                this.toolBoxLabel.setIcon(ImageLoader.getImageIcon("images/svg/files-folders/code.svg,16"));
            } else {
                this.toolBoxLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/spanner-dark.svg,16"));
            }
        }

        private void toolStart() {
            this.resultButton.setEnabled(false);
            this.resultButton.setVisible(false);
            this.running = true;
            this.bar.setVisible(true);
            this.bar.on();
        }

        private void toolFinished(RunToolMachineFilter.ToolBoxResultWrapper result) {
            this.result = result;
            if (result != null && this.item.isReturnCodeSuccess(result.returnCode)) {
                this.toolBoxLabel.setIcon(ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
            } else {
                this.toolBoxLabel.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
            }
            this.resultButton.setVisible(true);
            this.running = false;
            this.bar.setVisible(false);
            this.bar.off();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == this.removeButton) {
                ToolBoxUI.this.removeItem(this.item);
            } else if (e.getSource() == this.editButton) {
                ToolBoxUI.this.switchToEdit(this.item, this.group.isImported());
            } else if (!(e.getSource() instanceof JButton)) {
                if (ToolBoxUI.this.showEditUI) {
                    ToolBoxUI.this.switchToEdit(this.item, this.group.isImported());
                } else {
                    if (this.running) {
                        return;
                    }
                    System.out.println("[ToolBoxUI] Asked to run toolbox item " + this.item.getName());
                    new Thread(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ToolBoxRowItem.this.toolStart();
                                }
                            });
                            final RunToolMachineFilter.ToolBoxResultWrapper runItem = ToolBoxUI.this.runItem(ToolBoxRowItem.this.item);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ToolBoxRowItem.this.toolFinished(runItem);
                                }
                            });
                        }
                    }.start();
                }
            }
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.progressPanel != null) {
                this.progressPanel.setBackground(c);
            }
            if (this.bar != null) {
                this.bar.setBackground(c);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!ToolBoxUI.this.showEditUI) {
                this.resultButton.setEnabled(true);
                this.editButton.setEnabled(true);
                if (this.previousBackgroundColor == null) {
                    this.previousBackgroundColor = this.getBackground();
                }
                this.setBackground(SHStyle.SELECTION_BACKGROUND);
                this.toolBoxLabel.setForeground(Color.WHITE);
                this.repaint();
            } else {
                this.removeButton.setEnabled(true);
                this.removeButton.repaint();
                this.editButton.setEnabled(true);
                this.editButton.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!ToolBoxUI.this.showEditUI) {
                this.resultButton.setEnabled(false);
                this.editButton.setEnabled(false);
                if (this.previousBackgroundColor != null) {
                    this.setBackground(this.previousBackgroundColor);
                } else {
                    this.setBackground(Color.WHITE);
                }
                this.toolBoxLabel.setForeground(UIManager.getColor("Label.foreground"));
                this.repaint();
            } else {
                this.removeButton.setEnabled(false);
                this.removeButton.repaint();
                this.editButton.setEnabled(false);
                this.editButton.repaint();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.resultButton) {
                ToolBoxUI.this.resultUI.load(this.result);
                ToolBoxUI.this.switchToResultsView();
            }
        }
    }

    private class ScriptHeaderPanel
    extends JPanel
    implements ActionListener {
        JButton backButton = new JButton(Language.get("TOOLBOX_BACK_SCRIPT"));

        public ScriptHeaderPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.setBackground(Color.WHITE);
            this.add((Component)this.backButton, "West");
            this.backButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolBoxUI.this.switchToEditView();
        }
    }

    private class HeaderPanel
    extends JPanel
    implements ActionListener {
        JButton backButton = new JButton(Language.get("TOOLBOX_BACK"));

        public HeaderPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(SHBorderFactory.createCompoundBorder(SHBorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), SHBorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.setBackground(Color.WHITE);
            this.add((Component)this.backButton, "West");
            this.backButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.saveSettings();
            ToolBoxUI.this.switchToToolBoxView();
        }

        protected void saveSettings() {
            ToolBoxUI.this.saverUtil.saveNow();
        }
    }

    private class ImportHeaderPanel
    extends HeaderPanel
    implements MessageFieldHandler.FilterListener {
        private JSearchTextField filterField = new JSearchTextField(Language.get("FILTER_TOOLBOX_IMPORTS"));

        public ImportHeaderPanel() {
            this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"), true, true, "CLEAR");
            this.filterField.addIcon(ImageLoader.getImageIcon("images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
            this.filterField.setFilterListener(this);
            this.filterField.setSize(SimpleHelpLookAndFeel.scale(250), SimpleHelpLookAndFeel.scale(24));
            this.filterField.setPreferredSize(this.filterField.getSize());
            SwingUtil.setWidth(this.filterField, this.filterField.getSize().width);
            this.add((Component)this.filterField, "East");
        }

        @Override
        public void setFilter(String filter, boolean immediately) {
            ToolBoxUI.this.filteredWrapper.setCaseSensitive(false);
            ToolBoxUI.this.filteredWrapper.setFilterText(filter);
        }

        @Override
        protected void saveSettings() {
            ArrayList<ToolBoxGroup> newImportedGroups = new ArrayList<ToolBoxGroup>();
            ArrayList<ToolBoxGroup> existingImportedGroups = new ArrayList<ToolBoxGroup>();
            for (SelectedToolBoxGroup g : ToolBoxUI.this.importedToolBoxesList) {
                if (!g.imported) continue;
                existingImportedGroups.add(g.group);
                g.group.setImported(true);
                if (ToolBoxUI.this.toolBox.containsGroup(g.group)) continue;
                newImportedGroups.add(g.group);
            }
            ArrayList<ToolBoxGroup> removedGroups = new ArrayList<ToolBoxGroup>();
            Iterator<ToolBoxGroup> groups = ToolBoxUI.this.toolBox.getGroupIterator();
            while (groups.hasNext()) {
                ToolBoxGroup group = groups.next();
                if (!group.isImported() || existingImportedGroups.contains(group)) continue;
                removedGroups.add(group);
            }
            boolean changed = false;
            for (ToolBoxGroup g : removedGroups) {
                changed = true;
                ToolBoxUI.this.toolBox.removeToolBoxGroup(g);
            }
            for (ToolBoxGroup g : newImportedGroups) {
                changed = true;
                ToolBoxUI.this.toolBox.addToolBoxGroup(g);
            }
            super.saveSettings();
            if (changed) {
                ToolBoxUI.this.load(ToolBoxUI.this.toolBox);
            }
        }
    }

    private class EditUIHeaderPanel
    extends HeaderPanel {
        private EditUIHeaderPanel() {
        }

        @Override
        protected void saveSettings() {
            super.saveSettings();
            ToolBoxUI.this.editUI.save(ToolBoxUI.this.itemBeingEdited);
            ToolBoxUI.this.synchroniseResources(ToolBoxUI.this, ToolBoxUI.this.itemBeingEdited, null);
            ToolBoxUI.this.itemBeingEdited = null;
            ToolBoxUI.this.reloadAllItemNames();
        }
    }

    public class ImportToolboxThread
    extends Thread
    implements PleaseWaitDialog.PleaseWaitCancelListener,
    ToolBoxPropertiesPanel.SyncCancelledListener {
        public final Object LOCK;
        private final File importFile;
        private boolean isCancelled;

        public ImportToolboxThread(File importFile) {
            super("ImportToolboxThread");
            this.LOCK = new Object();
            this.importFile = importFile;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PleaseWaitDialog dialog = null;
            try {
                ToolBoxGroup group = new ToolBoxGroup(ToolBoxUI.this.toolBox.getUniqueNewGroupID());
                group.loadFrom(this.importFile);
                ToolBoxUI.this.addNewToolBoxGroup(group);
                dialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer(ToolBoxUI.this.getRootComponent()), Language.get("TB_IMPORT_PROGRESS_TITLE"), Language.get("TB_IMPORT_PROGRESS_MSG"), this);
                for (ToolBoxItem item : group) {
                    ToolBoxUI.this.synchroniseResourcesAndBlock(ToolBoxUI.this.toolBox, item, this);
                }
                if (dialog.wasCancelled()) {
                    ToolBoxUI.this.toolBox.removeToolBoxGroup(group);
                }
                ToolBoxUI.this.switchToToolBoxView();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (dialog != null) {
                    dialog.hideDialog();
                }
            }
        }

        @Override
        public void cancelled() {
            this.isCancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    private class ExportToolboxThread
    extends Thread
    implements PleaseWaitDialog.PleaseWaitCancelListener,
    ToolBoxPropertiesPanel.SyncCancelledListener {
        private final File saveFile;
        private boolean isCancelled = false;

        public ExportToolboxThread(File saveFile) {
            this.saveFile = saveFile;
        }

        @Override
        public void run() {
            PleaseWaitDialog dialog = null;
            try {
                dialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer(ToolBoxUI.this.getRootComponent()), Language.get("TB_EXPORT_PROGRESS_TITLE"), Language.get("TB_EXPORT_PROGRESS_MSG"), this);
                ToolBoxUI.this.groupBeingShared.saveTo(this.saveFile, ToolBoxUI.this.serverHost, ToolBoxUI.this.serverPort, this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (dialog != null) {
                    dialog.hideDialog();
                }
            }
        }

        @Override
        public void cancelled() {
            this.isCancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

