/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.reporting;

import com.aem.shelp.tech.reporting.ReportRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.stream.StreamPiper;

public class ReportResult {
    private ReportRequest reportRequest;
    private String reportFile;
    private long creationTime;
    private byte[] reportCompressed;

    public ReportResult(ReportRequest reportRequest, byte[] reportData, File reportFile, long creationTime) throws IOException {
        this.reportRequest = reportRequest;
        this.reportCompressed = reportData;
        this.reportFile = reportFile.getName();
        this.creationTime = creationTime;
    }

    private ReportResult() {
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getFilename() {
        return this.reportFile;
    }

    public static ReportResult fromMessage(Message m) {
        ReportResult result = new ReportResult();
        result.reportRequest = ReportRequest.fromMessage(m.getNextMessage());
        result.reportCompressed = m.getNextByteArray();
        result.creationTime = m.getNextLong();
        result.reportFile = m.getNextString();
        return result;
    }

    public void toMessage(Message m) {
        m.append(this.reportRequest.toMessage());
        m.append(this.reportCompressed);
        m.append(this.creationTime);
        m.append(this.reportFile);
    }

    public ReportRequest getReportRequest() {
        return this.reportRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportResult loadFrom(File file) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
        try {
            Message m = MessageUtils.readMessage(bin);
            ReportResult reportResult = ReportResult.fromMessage(m);
            return reportResult;
        }
        finally {
            FileUtil.robustClose(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(File file) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(this.reportCompressed)));
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
        try {
            StreamPiper.pipe(bin, bout, true, false, true);
        }
        finally {
            FileUtil.robustClose(bout);
            FileUtil.robustClose(bin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) throws IOException {
        Message m = new Message();
        this.toMessage(m);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
        try {
            MessageUtils.writeMessage(bout, m);
        }
        finally {
            FileUtil.robustClose(bout);
        }
    }
}

