/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.notifiers;

import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.tech.notifiers.AudioNotification;
import com.aem.shelp.tech.notifiers.FrameNotification;
import com.aem.shelp.tech.notifiers.TrayNotification;
import com.aem.utils.Debugger;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class NotifierController {
    public static NotifierController INSTANCE;
    private Object LOCK = new Object();
    private NotificationExecutor executor = new NotificationExecutor();
    private TreeSet previousNames = null;
    private TreeSet joined = null;
    private TreeSet left = null;
    private int customerCount = 0;
    public AudioNotification audio;
    public TrayNotification tray;
    public FrameNotification frame;

    public NotifierController(ResourceBundle lang) {
        if (INSTANCE != null) {
            return;
        }
        this.audio = new AudioNotification(lang);
        this.tray = new TrayNotification(lang);
        this.frame = new FrameNotification(lang);
        this.executor.start();
        INSTANCE = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomerList(Customer[] customers) {
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < customers.length; ++i) {
            Customer customer = customers[i];
            if (!customer.isSH()) continue;
            set.add(customer.getCustomerID());
        }
        if (this.previousNames == null) {
            this.previousNames = set;
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.joined = (TreeSet)set.clone();
            this.joined.removeAll(this.previousNames);
            this.left = (TreeSet)this.previousNames.clone();
            this.left.removeAll(set);
            this.customerCount = customers.length;
            if (this.joined.size() > 0 || this.left.size() > 0) {
                this.LOCK.notifyAll();
            }
        }
        this.previousNames = set;
    }

    class NotificationExecutor
    extends Thread {
        private boolean die = false;

        NotificationExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.die) {
                Object object = NotifierController.this.LOCK;
                synchronized (object) {
                    try {
                        NotifierController.this.LOCK.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        NotifierController.this.audio.sendNotification(NotifierController.this.customerCount, NotifierController.this.joined, NotifierController.this.left);
                    }
                    catch (Throwable t) {
                        Debugger.error("Audio Notification Failed - " + t.getMessage());
                    }
                    try {
                        NotifierController.this.tray.sendNotification(NotifierController.this.customerCount, NotifierController.this.joined, NotifierController.this.left);
                    }
                    catch (Throwable t) {
                        Debugger.error("Tray Notification Failed - " + t.getMessage());
                    }
                    try {
                        NotifierController.this.frame.sendNotification(NotifierController.this.customerCount, NotifierController.this.joined, NotifierController.this.left);
                    }
                    catch (Throwable t) {
                        Debugger.error("Frame Notification Failed - " + t.getMessage());
                    }
                    NotifierController.this.joined.clear();
                    NotifierController.this.left.clear();
                }
            }
        }
    }
}

