/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.notifiers;

import com.aem.sdesktop.server.sounds.SHSounds;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.TechOptionsPanel;
import com.aem.shelp.tech.notifiers.NotifierController;
import com.aem.shelp.tech.utils.StrippedContentPanel;
import com.aem.utils.TrayNotifier;
import com.aem.utils.sound.SampledSound;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jwrapper.jwutils.JWGenericOS;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.pagedproperties.PropertiesPage;

public class NotificationOptionsPanel
extends PropertiesPage
implements ActionListener {
    public static final String SYSTRAY_ENABLE = "SYSTRAY_ENABLE";
    public static final String SYSTRAY_NOTIFICATION = "SYSTRAY_NOTIFICATION";
    public static final String AUDIO_ENABLE = "AUDIO_ENABLE";
    public static final String AUDIO_NOTIFICATION = "AUDIO_NOTIFICATION";
    public static final String AUDIO_SOUND = "AUDIO_SOUND";
    public static final String AUDIO_CHAT = "AUDIO_CHAT";
    public static final String FRAME_ENABLE = "FRAME_ENABLE";
    public static final String FRAME_NOTIFICATION = "FRAME_NOTIFICATION";
    private JCheckBox systemTrayEnable;
    private JLabel systemTrayLabel;
    private JComboBox systemTrayNotifications;
    private JComboBox audioNotificationsBox;
    private JCheckBox audioEnable;
    private JLabel audioLabel;
    private JLabel audioLabelChat;
    private JLabel chatNotificationsLabel;
    private JLabel soundLabel;
    private JLabel soundLabelChat;
    private JComboBox soundBox;
    private JComboBox soundBoxChat;
    private JButton playButton;
    private JButton playButtonChat;
    private JCheckBox frameEnable;
    private JLabel frameLabel;
    private JComboBox frameNotification;
    private String[] notificationOptions;
    private TechOptionsPanel techOptionsPanel;
    private static final String[] soundOptions = new String[]{"Beep", "Bell", "Clang", "Ding", "Notify", "Pong", "Pop", "Ptwing"};
    private static final SampledSound[] sounds = new SampledSound[]{SHSounds.beep, SHSounds.bell, SHSounds.clang, SHSounds.ding, SHSounds.notify, SHSounds.pong, SHSounds.pop, SHSounds.ptwiiing};
    ActionListener changeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            NotificationOptionsPanel.this.setEnabled();
            NotificationOptionsPanel.this.contentChanged(true);
        }
    };

    public static SampledSound getChatNotificationSound(Properties props) {
        boolean audioEnabled = (props.getProperty(AUDIO_ENABLE, "false") + "").equalsIgnoreCase("true");
        if (!audioEnabled) {
            return null;
        }
        String sound = props.getProperty(AUDIO_CHAT, soundOptions[0]);
        int index = Arrays.binarySearch(soundOptions, sound);
        if (index == -1) {
            return null;
        }
        return sounds[index];
    }

    public NotificationOptionsPanel(TechOptionsPanel listener) {
        super(listener);
        this.techOptionsPanel = listener;
        this.notificationOptions = new String[]{Language.get("CUSTOMER_JOINS"), Language.get("CUSTOMER_LEAVES"), Language.get("CUSTOMER_JOINS_OR_LEAVES")};
        boolean traySupported = TrayNotifier.isSupported();
        GbPanel panel = new GbPanel();
        StrippedContentPanel contentsPanel = new StrippedContentPanel(panel);
        GbPanel mainWrapper = new GbPanel();
        mainWrapper.add(panel, 0, 0, 1, 1, 1, 1, 11, 1);
        JScrollPane pane = new JScrollPane(mainWrapper);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        ColorPropagatingPanel systemTray = new ColorPropagatingPanel();
        GridBagLayout gbl = new GridBagLayout();
        systemTray.setLayout(gbl);
        JPanel temp = new JPanel();
        temp.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        temp.setLayout(new BoxLayout(temp, 1));
        if (!traySupported) {
            JLabel label = new JLabel();
            label.setIcon(ImageLoader.getImageIcon("images/svg/dialogs/warning.svg,16"));
            String os = JWGenericOS.getInstance().getOSName();
            label.setText(Language.get("TRAY_ICON_NOT_SUPPORTED") + " " + os);
            temp.add(label);
            temp.add(Box.createVerticalStrut(10));
        }
        this.systemTrayEnable = new JCheckBox();
        this.systemTrayEnable.addActionListener(this.changeListener);
        this.systemTrayEnable.setText(Language.get(SYSTRAY_ENABLE));
        this.systemTrayEnable.setMaximumSize(this.systemTrayEnable.getPreferredSize());
        if (!traySupported) {
            this.systemTrayEnable.setEnabled(false);
        }
        temp.add(this.systemTrayEnable);
        temp.add(Box.createVerticalStrut(4));
        JPanel systemTrayChoice = new JPanel();
        systemTrayChoice.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        systemTrayChoice.setLayout(new BoxLayout(systemTrayChoice, 0));
        this.systemTrayLabel = new JLabel(Language.get("SYSTRAY_WHEN") + " ");
        this.systemTrayNotifications = new JComboBox<String>(this.notificationOptions);
        this.fixHeight(this.systemTrayNotifications);
        this.systemTrayNotifications.addActionListener(this.changeListener);
        systemTrayChoice.add(this.systemTrayLabel);
        systemTrayChoice.add(Box.createHorizontalStrut(5));
        systemTrayChoice.add(this.systemTrayNotifications);
        systemTrayChoice.add(Box.createHorizontalGlue());
        systemTray.add(temp);
        gbl.setConstraints(temp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        systemTray.add(systemTrayChoice);
        gbl.setConstraints(systemTrayChoice, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 4, 0), 0, 0));
        contentsPanel.addContent(systemTray, Language.get("SYSTRAY_TITLE"));
        this.audioEnable = new JCheckBox();
        this.audioEnable.addActionListener(this.changeListener);
        this.audioEnable.setText(Language.get(AUDIO_ENABLE));
        this.audioLabel = new JLabel(Language.get("AUDIO_WHEN"));
        this.audioLabelChat = new JLabel(Language.get("AUDIO_WHEN"));
        this.audioNotificationsBox = new JComboBox<String>(this.notificationOptions);
        this.fixHeight(this.audioNotificationsBox);
        this.audioNotificationsBox.addActionListener(this.changeListener);
        this.chatNotificationsLabel = new JLabel(Language.get("NEW_CHAT_MESSAGE"));
        this.soundLabel = new JLabel(Language.get("AUDIO_FILE"));
        this.soundLabelChat = new JLabel(Language.get("AUDIO_FILE"));
        this.soundBox = new JComboBox<String>(soundOptions);
        this.fixHeight(this.soundBox);
        this.soundBox.addActionListener(this.changeListener);
        this.soundBoxChat = new JComboBox<String>(soundOptions);
        this.fixHeight(this.soundBoxChat);
        this.soundBoxChat.addActionListener(this.changeListener);
        this.playButton = new JButton(Language.get("AUDIO_PLAY"), ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
        this.playButton.addActionListener(new AudioPlayerListener(this.soundBox));
        this.playButtonChat = new JButton(Language.get("AUDIO_PLAY"), ImageLoader.getImageIcon("images/svg/av/play.svg,16"));
        this.playButtonChat.addActionListener(new AudioPlayerListener(this.soundBoxChat));
        ColorPropagatingGBPanel soundTray = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        int X = 0;
        soundTray.add(this.audioLabel, X++, 1, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.audioNotificationsBox, X++, 1, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.soundLabel, X++, 1, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.soundBox, X++, 1, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.playButton, X++, 1, 1, 1, 0, 1, 17, 0, new Insets(3, 20, 3, 3));
        soundTray.add(this.audioEnable, 0, 0, X, 1, 1, 1, 17, 2);
        X = 0;
        soundTray.add(this.audioLabelChat, X++, 2, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.chatNotificationsLabel, X++, 2, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.soundLabelChat, X++, 2, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.soundBoxChat, X++, 2, 1, 1, 0, 1, 17, 0);
        soundTray.add(this.playButtonChat, X++, 2, 1, 1, 0, 1, 17, 0, new Insets(3, 20, 3, 3));
        contentsPanel.addContent(soundTray, Language.get("AUDIO_TITLE"));
        ColorPropagatingPanel framePanel = new ColorPropagatingPanel();
        gbl = new GridBagLayout();
        framePanel.setLayout(gbl);
        temp = new JPanel();
        temp.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        temp.setLayout(new BoxLayout(temp, 1));
        this.frameEnable = new JCheckBox();
        this.frameEnable.addActionListener(this.changeListener);
        this.frameEnable.setText(Language.get(FRAME_ENABLE));
        temp.add(this.frameEnable);
        JPanel frameChoice = new JPanel();
        frameChoice.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        frameChoice.setLayout(new BoxLayout(frameChoice, 0));
        this.frameLabel = new JLabel(Language.get("FRAME_WHEN") + " ");
        this.frameNotification = new JComboBox<String>(this.notificationOptions);
        this.fixHeight(this.frameNotification);
        this.frameNotification.addActionListener(this.changeListener);
        frameChoice.add(this.frameLabel);
        frameChoice.add(Box.createHorizontalStrut(5));
        frameChoice.add(this.frameNotification);
        frameChoice.add(Box.createHorizontalGlue());
        framePanel.add(temp);
        gbl.setConstraints(temp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        framePanel.add(frameChoice);
        gbl.setConstraints(frameChoice, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(4, 0, 4, 0), 0, 0));
        contentsPanel.addContent(framePanel, Language.get("FRAME_TITLE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
        this.systemTrayEnable.addActionListener(this);
        this.systemTrayNotifications.addActionListener(this);
        this.audioEnable.addActionListener(this);
        this.audioNotificationsBox.addActionListener(this);
        this.soundBox.addActionListener(this);
        this.soundBoxChat.addActionListener(this);
        this.frameEnable.addActionListener(this);
        this.frameNotification.addActionListener(this);
        this.setEnabled();
    }

    private void fixHeight(JComboBox box) {
        Dimension dim = box.getPreferredSize();
        dim.height = SimpleHelpLookAndFeel.scale(24);
        box.setPreferredSize(dim);
        box.setMaximumSize(dim);
        box.setMinimumSize(dim);
    }

    public void setEnabled() {
        boolean enabled = this.systemTrayEnable.isSelected();
        this.systemTrayLabel.setEnabled(enabled);
        this.systemTrayNotifications.setEnabled(enabled);
        enabled = this.audioEnable.isSelected();
        this.audioLabel.setEnabled(enabled);
        this.audioNotificationsBox.setEnabled(enabled);
        this.soundLabel.setEnabled(enabled);
        this.soundBox.setEnabled(enabled);
        this.playButton.setEnabled(enabled);
        this.audioLabelChat.setEnabled(enabled);
        this.chatNotificationsLabel.setEnabled(enabled);
        this.soundLabelChat.setEnabled(enabled);
        this.soundBoxChat.setEnabled(enabled);
        this.playButtonChat.setEnabled(enabled);
        enabled = this.frameEnable.isSelected();
        this.frameLabel.setEnabled(enabled);
        this.frameNotification.setEnabled(enabled);
    }

    @Override
    public void load(Object objectProps) {
        Properties props = (Properties)objectProps;
        boolean enabled = (props.getProperty(SYSTRAY_ENABLE, "false") + "").equalsIgnoreCase("true");
        this.systemTrayEnable.setSelected(enabled);
        String notification = props.getProperty(SYSTRAY_NOTIFICATION, this.notificationOptions[0]);
        this.systemTrayNotifications.setSelectedItem(notification);
        if (this.systemTrayNotifications.getSelectedIndex() == -1) {
            this.systemTrayNotifications.setSelectedIndex(0);
        }
        enabled = (props.getProperty(AUDIO_ENABLE, "false") + "").equalsIgnoreCase("true");
        this.audioEnable.setSelected(enabled);
        notification = props.getProperty(AUDIO_NOTIFICATION, this.notificationOptions[0]);
        this.audioNotificationsBox.setSelectedItem(notification);
        if (this.audioNotificationsBox.getSelectedIndex() == -1) {
            this.audioNotificationsBox.setSelectedIndex(0);
        }
        String sound = props.getProperty(AUDIO_SOUND, soundOptions[0]);
        this.soundBox.setSelectedItem(sound);
        if (this.soundBox.getSelectedIndex() == -1) {
            this.soundBox.setSelectedIndex(0);
        }
        sound = props.getProperty(AUDIO_CHAT, soundOptions[0]);
        this.soundBoxChat.setSelectedItem(sound);
        if (this.soundBoxChat.getSelectedIndex() == -1) {
            this.soundBoxChat.setSelectedIndex(0);
        }
        enabled = (props.getProperty(FRAME_ENABLE, "false") + "").equalsIgnoreCase("true");
        this.frameEnable.setSelected(enabled);
        notification = props.getProperty(FRAME_NOTIFICATION, this.notificationOptions[0]);
        this.frameNotification.setSelectedItem(notification);
        if (this.frameNotification.getSelectedIndex() == -1) {
            this.frameNotification.setSelectedIndex(0);
        }
        this.updateNotifiers();
    }

    @Override
    public void save(Object saveObject) {
        Properties props = (Properties)saveObject;
        props.setProperty(SYSTRAY_ENABLE, Boolean.toString(this.systemTrayEnable.isSelected()));
        props.setProperty(SYSTRAY_NOTIFICATION, this.systemTrayNotifications.getSelectedItem().toString());
        props.setProperty(AUDIO_ENABLE, Boolean.toString(this.audioEnable.isSelected()));
        props.setProperty(AUDIO_NOTIFICATION, this.audioNotificationsBox.getSelectedItem().toString());
        props.setProperty(AUDIO_SOUND, this.soundBox.getSelectedItem().toString());
        props.setProperty(AUDIO_CHAT, this.soundBoxChat.getSelectedItem().toString());
        props.setProperty(FRAME_ENABLE, Boolean.toString(this.frameEnable.isSelected()));
        props.setProperty(FRAME_NOTIFICATION, this.frameNotification.getSelectedItem().toString());
        this.updateNotifiers();
    }

    private void updateNotifiers() {
        boolean leave;
        boolean enable = this.systemTrayEnable.isSelected();
        int index = this.systemTrayNotifications.getSelectedIndex();
        boolean join = index == 0 || index == 2;
        boolean bl = leave = index == 1 || index == 2;
        if (NotifierController.INSTANCE != null && NotifierController.INSTANCE.tray != null) {
            NotifierController.INSTANCE.tray.setSettings(enable, join, leave);
        }
        enable = this.audioEnable.isSelected();
        index = this.audioNotificationsBox.getSelectedIndex();
        join = index == 0 || index == 2;
        leave = index == 1 || index == 2;
        int sound = this.soundBox.getSelectedIndex();
        if (NotifierController.INSTANCE != null && NotifierController.INSTANCE.audio != null) {
            NotifierController.INSTANCE.audio.setSettings(enable, join, leave, sounds[sound]);
        }
        enable = this.frameEnable.isSelected();
        index = this.frameNotification.getSelectedIndex();
        join = index == 0 || index == 2;
        boolean bl2 = leave = index == 1 || index == 2;
        if (NotifierController.INSTANCE != null && NotifierController.INSTANCE.frame != null) {
            NotifierController.INSTANCE.frame.setSettings(enable, join, leave);
        }
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.techOptionsPanel.requestSave();
    }

    class AudioPlayerListener
    implements ActionListener {
        private JComboBox soundsBox;

        public AudioPlayerListener(JComboBox soundsBox) {
            this.soundsBox = soundsBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sound = this.soundsBox.getSelectedIndex();
            if (sound >= 0 && sound < sounds.length) {
                SHSounds.play(sounds[sound]);
            }
        }
    }
}

