/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.invitations;

import com.aem.shelp.common.Invitation;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.SHComboBox;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIFieldRepository;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextAreaField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class InvitationRequestPanel
extends JPanel
implements ActionListener,
AbstractField.ChangeListener {
    private JButton bok;
    private JButton bcancel;
    private String detailsXML;
    private String[] CONNECT_OPTIONS_ORIG;
    private SHComboBox connectToCombo;
    private String[] EXPIRY_OPTIONS;
    private String[] EXPIRY_OPTIONS_ORIG;
    private SHComboBox expiresCombo;
    private String[] SHARE_OPTIONS;
    private String[] SHARE_OPTIONS_GROUP;
    private SHComboBox shareCombo;
    private Invitation invitation;
    private InvitationDialogListener listener;
    private Invitation editingInvitation;
    private TransientTechUser techUser;
    private CUIField[] detailFields;
    private CUIHorizontalPanel panel;

    public InvitationRequestPanel(String detailsXML, InvitationDialogListener listener, TransientTechUser techUser) {
        this.listener = listener;
        this.techUser = techUser;
        this.detailsXML = detailsXML;
        if (this.detailsXML == null) {
            this.detailsXML = "";
        } else {
            this.detailFields = CUIFieldRepository.fieldsFromXML(detailsXML);
        }
        for (CUIField field : this.detailFields) {
            field.setDisplayLabel(Language.get(field.getLabel()));
            System.out.println("[InvitationRequestPanel] Setting displaylabel for " + field.getLabel() + " to " + field.getDisplayLabel());
        }
        this.initUI();
    }

    public void initForNew() {
        this.editingInvitation = null;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(this.EXPIRY_OPTIONS_ORIG);
        this.expiresCombo.setModel(model);
        this.expiresCombo.setSelectedIndex(0);
        model = new DefaultComboBoxModel<String>(this.CONNECT_OPTIONS_ORIG);
        this.connectToCombo.setModel(model);
        this.connectToCombo.setSelectedIndex(0);
        model = this.techUser != null && this.techUser.isAnonymousLogin ? new DefaultComboBoxModel<String>(this.SHARE_OPTIONS_GROUP) : new DefaultComboBoxModel<String>(this.SHARE_OPTIONS);
        this.shareCombo.setModel(model);
        this.shareCombo.setSelectedIndex(0);
        for (int i = 0; i < this.detailFields.length; ++i) {
            this.detailFields[i].clearContents();
        }
        this.bok.setText(Language.get("CREATE_INVITATION"));
        this.updateEnabled();
    }

    public void initForEdit(Invitation selectedInvitation) {
        DefaultComboBoxModel<String> model;
        this.editingInvitation = selectedInvitation;
        if (selectedInvitation.hasLimit()) {
            this.EXPIRY_OPTIONS[0] = selectedInvitation.getTextualExpiry();
            model = new DefaultComboBoxModel<String>(this.EXPIRY_OPTIONS);
            this.expiresCombo.setModel(model);
            this.expiresCombo.setSelectedIndex(0);
        } else {
            model = new DefaultComboBoxModel<String>(this.EXPIRY_OPTIONS_ORIG);
            this.expiresCombo.setModel(model);
            this.expiresCombo.setSelectedIndex(0);
        }
        String option = selectedInvitation.getShareOption();
        if (option != null) {
            if (option.equals("None")) {
                this.shareCombo.setSelectedIndex(2);
            } else if (option.equals("All")) {
                this.shareCombo.setSelectedIndex(0);
            } else if (option.equals("Group")) {
                this.shareCombo.setSelectedIndex(1);
            }
        }
        if (selectedInvitation.hasTechnicianFilter()) {
            this.connectToCombo.setSelectedIndex(1);
        } else if (selectedInvitation.hasTechnicianGroupFilter()) {
            this.connectToCombo.setSelectedIndex(2);
        } else {
            this.connectToCombo.setSelectedIndex(0);
        }
        for (int i = 0; i < this.detailFields.length; ++i) {
            String label = this.detailFields[i].getLabel();
            String value = selectedInvitation.getDetailFor(label);
            ResultPair pair = new ResultPair(label, value);
            this.detailFields[i].setStorableFilledOutData(pair);
        }
        this.bok.setText(Language.get("UPDATE_INVITATION"));
        this.updateEnabled();
    }

    public void initFocus() {
        for (int i = 0; i < this.detailFields.length; ++i) {
            CUIField field = this.detailFields[i];
            if (field instanceof TextField) {
                ((JTextField)((TextField)field).getComponent()).requestFocusInWindow();
                ((JTextField)((TextField)field).getComponent()).selectAll();
                return;
            }
            if (!(field instanceof TextAreaField)) continue;
            ((JTextArea)((TextAreaField)field).getComponent()).requestFocusInWindow();
            ((JTextArea)((TextAreaField)field).getComponent()).selectAll();
            return;
        }
    }

    private static int getDialogHeight(String details) {
        int numberOfDetails = 0;
        if (details != null) {
            numberOfDetails = details.split("\n").length;
        }
        if (numberOfDetails == 0) {
            numberOfDetails = 0;
        }
        if (numberOfDetails == 0) {
            return 280;
        }
        if (numberOfDetails == 1) {
            return 310;
        }
        if (numberOfDetails == 2) {
            return 350;
        }
        return 350;
    }

    public Invitation getResult() {
        return this.invitation;
    }

    private void processInvitation() {
        this.invitation = new Invitation();
        if (this.editingInvitation != null) {
            boolean containsCurrent;
            this.invitation.setInvitationID(this.editingInvitation.getInvitationID());
            boolean bl = containsCurrent = this.expiresCombo.getModel().getSize() > this.EXPIRY_OPTIONS_ORIG.length;
            if (containsCurrent && this.expiresCombo.getSelectedIndex() == 0) {
                this.invitation.setSessionLimit(this.editingInvitation.getSessionLimit());
                this.invitation.setDurationLimit(this.editingInvitation.getDurationLimit());
            } else {
                this.getDurationFor(this.expiresCombo.getSelectedIndex());
            }
        } else {
            this.getDurationFor(this.expiresCombo.getSelectedIndex());
        }
        this.invitation.setTechnicianFilter(null);
        this.invitation.setTechnicianGroupFilter(null);
        if (this.connectToCombo.getSelectedIndex() == 1) {
            this.invitation.setTechnicianFilter(this.techUser.username);
        } else if (this.connectToCombo.getSelectedIndex() == 2) {
            this.invitation.setTechnicianGroupFilter(this.techUser.groupList);
        }
        if (this.shareCombo.getSelectedIndex() == 2) {
            this.invitation.setShareOption("None");
        } else if (this.shareCombo.getSelectedIndex() == 0) {
            this.invitation.setShareOption("All");
        } else if (this.shareCombo.getSelectedIndex() == 1) {
            this.invitation.setShareOption("Group");
        }
        for (int i = 0; i < this.detailFields.length; ++i) {
            ResultPair storableFilledOutData = this.detailFields[i].getReadableFilledOutData(Language.DEFLANG);
            if (storableFilledOutData == null) continue;
            this.invitation.addCustomerDetail(storableFilledOutData.getKey(), storableFilledOutData.getValue());
        }
    }

    private void getDurationFor(int selectedIndex) {
        boolean containsCurrent;
        boolean bl = containsCurrent = this.expiresCombo.getModel().getSize() > this.EXPIRY_OPTIONS_ORIG.length;
        if (containsCurrent) {
            switch (selectedIndex) {
                case 0: {
                    return;
                }
                case 1: {
                    this.invitation.setSessionLimit(-1);
                    this.invitation.setDurationLimit(-1L);
                    return;
                }
                case 2: {
                    this.invitation.setSessionLimit(1);
                    return;
                }
                case 3: {
                    this.invitation.setSessionLimit(5);
                    return;
                }
                case 4: {
                    this.invitation.setDurationLimit(3600000L);
                    return;
                }
                case 5: {
                    this.invitation.setDurationLimit(86400000L);
                    return;
                }
                case 6: {
                    this.invitation.setDurationLimit(604800000L);
                    return;
                }
            }
        } else {
            switch (selectedIndex) {
                case 0: {
                    this.invitation.setSessionLimit(-1);
                    this.invitation.setDurationLimit(-1L);
                    return;
                }
                case 1: {
                    this.invitation.setSessionLimit(1);
                    return;
                }
                case 2: {
                    this.invitation.setSessionLimit(5);
                    return;
                }
                case 3: {
                    this.invitation.setDurationLimit(3600000L);
                    return;
                }
                case 4: {
                    this.invitation.setDurationLimit(86400000L);
                    return;
                }
                case 5: {
                    this.invitation.setDurationLimit(604800000L);
                    return;
                }
            }
        }
    }

    private int getComboBoxIndexFor(Invitation invitation) {
        if (invitation.getDurationLimit() != -1L) {
            if (invitation.getDurationLimit() == 3600000L) {
                return 3;
            }
            if (invitation.getDurationLimit() == 86400000L) {
                return 4;
            }
            return 5;
        }
        if (invitation.getSessionLimit() != -1) {
            if (invitation.getSessionLimit() == 1) {
                return 1;
            }
            if (invitation.getSessionLimit() == 5) {
                return 2;
            }
        }
        return 0;
    }

    private void initUI() {
        this.EXPIRY_OPTIONS_ORIG = new String[]{Language.get("INVITATION_EXPIRY_NEVER"), Language.get("INVITATION_EXPIRY_ONE_SESSION"), Language.get("INVITATION_EXPIRY_5_SESSIONS"), Language.get("INVITATION_EXPIRY_ONE_HOUR"), Language.get("INVITATION_EXPIRY_ONE_DAY"), Language.get("INVITATION_EXPIRY_ONE_WEEK")};
        this.EXPIRY_OPTIONS = new String[]{"", Language.get("INVITATION_EXPIRY_NEVER"), Language.get("INVITATION_EXPIRY_ONE_SESSION"), Language.get("INVITATION_EXPIRY_5_SESSIONS"), Language.get("INVITATION_EXPIRY_ONE_HOUR"), Language.get("INVITATION_EXPIRY_ONE_DAY"), Language.get("INVITATION_EXPIRY_ONE_WEEK")};
        this.SHARE_OPTIONS_GROUP = new String[]{Language.get("INVITATION_SHARE_ANYONE"), Language.get("INVITATION_SHARE_GROUP")};
        this.SHARE_OPTIONS = new String[]{Language.get("INVITATION_SHARE_ANYONE"), Language.get("INVITATION_SHARE_GROUP"), Language.get("INVITATION_SHARE_NOONE")};
        this.CONNECT_OPTIONS_ORIG = new String[]{Language.get("INVITATION_CONNECT_ANYONE"), Language.get("INVITATION_CONNECT_ME"), Language.get("INVITATION_CONNECT_MY_GROUP")};
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.initNewInvitationPanel());
        this.add("South", this.initButtonsPanel());
        this.updateEnabled();
    }

    private Component initButtonsPanel() {
        this.bok = new JButton(Language.get("CREATE_INVITATION"), ImageLoader.getImageIcon("images/svg/general/invite.svg,16"));
        this.bcancel = new JButton(Language.get("CANCEL"), ImageLoader.getImageIcon("images/svg/general/cancel.svg,16"));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 30, 2, 10));
        buttonsPanel.add(this.bcancel, 0, 0, 1, 1, 1, 1, 13, 0);
        buttonsPanel.add(this.bok, 1, 0, 1, 1, 0, 1, 13, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.bok.addActionListener(this);
        this.bcancel.addActionListener(this);
        this.bok.setEnabled(false);
        return buttonsPanel;
    }

    private void updateEnabled() {
        this.bok.setEnabled(this.panel.isValid());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.bok) {
            this.processInvitation();
            this.listener.createNewInvitation(this.invitation);
        } else if (o == this.bcancel) {
            this.invitation = null;
            this.listener.cancelNewInvitation();
        }
    }

    public JPanel initNewInvitationPanel() {
        JComponent createDetailsPanel = this.createDetailsPanel();
        JComponent optionsPanel = this.createInvitationOptionsPanel();
        RoundBorderPanel customerDetails = new RoundBorderPanel(Language.get("INVITATION_CUSTOMER_DETAILS"));
        customerDetails.setLayout(new GridLayout(1, 1));
        customerDetails.add(createDetailsPanel);
        RoundBorderPanel invitationOptions = new RoundBorderPanel(Language.get("INVITATION_OPTIONS"));
        invitationOptions.setLayout(new GridLayout(1, 1));
        invitationOptions.add(optionsPanel);
        GbPanel panel = new GbPanel();
        int Y = 0;
        panel.add(invitationOptions, 0, Y++, 1, 1, 1, 0, 10, 1);
        panel.add(customerDetails, 0, Y++, 1, 1, 1, 1, 10, 1);
        panel.setBorder(SHBorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private JComponent createInvitationOptionsPanel() {
        JLabel connectToLabel = new JLabel(Language.get("INVITATION_CONNECT_TO") + " ");
        this.connectToCombo = new SHComboBox(this.CONNECT_OPTIONS_ORIG);
        JLabel expiresLabel = new JLabel(Language.get("INVITATION_EXPIRE_LABEL") + " ");
        this.expiresCombo = new SHComboBox(this.EXPIRY_OPTIONS);
        JLabel shareLabel = new JLabel(Language.get("INVITATION_SHARE_LABEL") + " ");
        this.shareCombo = new SHComboBox(this.SHARE_OPTIONS);
        GbPanel cp = new GbPanel(new ScaledInsets(2, 0, 0, 0));
        cp.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        cp.add(connectToLabel, 0, 0, 1, 1, 1, 0, 13, 0);
        cp.add(this.connectToCombo, 1, 0, 1, 1, 1, 0, 17, 0, new Insets(2, 4, 0, 0));
        cp.add(expiresLabel, 0, 1, 1, 1, 1, 0, 13, 0);
        cp.add(this.expiresCombo, 1, 1, 1, 1, 1, 0, 17, 0, new Insets(2, 4, 0, 0));
        cp.add(shareLabel, 0, 2, 1, 1, 1, 0, 13, 0);
        cp.add(this.shareCombo, 1, 2, 1, 1, 1, 0, 17, 0, new Insets(2, 4, 0, 0));
        return cp;
    }

    private JComponent createDetailsPanel() {
        this.panel = new CUIHorizontalPanel(new Insets(3, 10, 3, 3), true);
        this.panel.addAll(this.detailFields);
        this.panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.panel.setChangeListener(this);
        GbPanel cp = new GbPanel();
        cp.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        int Y = 0;
        cp.add(this.panel.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 1);
        JPanel paddy = new JPanel();
        paddy.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        cp.add(paddy, 0, Y++, 2, 1, 1, 10000, 10, 1);
        JScrollPane sp = new JScrollPane(cp);
        sp.setBorder(SHBorderFactory.createEmptyBorder());
        return sp;
    }

    public void keyReleased(KeyEvent arg0) {
        this.updateEnabled();
    }

    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void changed(AbstractField source) {
        this.updateEnabled();
    }

    static interface InvitationDialogListener {
        public void cancelNewInvitation();

        public void createNewInvitation(Invitation var1);
    }
}

