/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.invitations;

import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.shelp.common.Invitation;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.invitations.InvitationConfiguration;
import com.aem.shelp.tech.invitations.InvitationRequestPanel;
import com.aem.shelp.tech.invitations.InvitationURLPanel;
import com.aem.utils.blowfish.Blowfish;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import jwrapper.jwutils.JWSystem;
import utils.files.FileUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;

public class InvitationRepositoryGlassDialog
extends ScaledGlassDialog
implements ActionListener,
KeyListener,
ListSelectionListener,
InvitationRequestPanel.InvitationDialogListener {
    private JButton bclose;
    private JButton bdelete;
    private JButton bedit;
    private JButton bnew;
    private JButton bsend;
    private JButton bdone;
    private SimpleList invitationList;
    private SortWrapper sortedInvitationList;
    private JTable invitationTable;
    private String REPOSITORY_PANEL_KEY = "REPOSITORY_PANEL_KEY";
    private String NEW_INVITATION_KEY = "NEW_INVITATION_KEY";
    private String SEND_KEY = "SEND_KEY";
    private CardLayout cl = new CardLayout();
    private JPanel cardPanel;
    private TechClient client;
    private InvitationRequestPanel requestPanel;
    private InvitationURLPanel urlPanel;
    private JButton copyCodeToClipboard;
    private JButton sendEmailInvitationLinkButton;
    private JLabel invitaionCodeLabel;
    private JLabel emailStatusLabel;
    private JTextField emailAddressField;
    private InvitationConfiguration configuration;
    private JButton copyCustomerLink;
    private String customerLink;

    public InvitationRepositoryGlassDialog(RootPaneContainer frame, TechClient.EditableInvitationWrapper[] invitations, InvitationConfiguration configuration, TechClient client) {
        super(frame, 630, 430, true, true, false);
        this.client = client;
        this.configuration = configuration;
        this.setModal(true);
        this.initUI();
        this.initFocus();
        for (int i = 0; i < invitations.length; ++i) {
            this.invitationList.add(invitations[i]);
        }
        this.setVisible(true);
    }

    private void initFocus() {
    }

    private String loadEmailAddressFor(String code) {
        try {
            if (code == null || code.length() == 0) {
                return null;
            }
            File invitationsFolder = new File(JWSystem.getAllAppVersionsSharedFolder(), "invitations");
            File targetFile = new File(invitationsFolder, code);
            byte[] encryptedData = FileUtil.readFile(targetFile);
            Blowfish bfish = new Blowfish();
            bfish.init("ljis$5$GSEFsdjkkjasdjh khjhkjhkjh34kjh33819js02jkdufgy64ofAH$hakfEJHRgisergSV5ItW$%0vwt'4&$^&%AdaF@l2i2@EFSwKJKUIWNRIb44");
            byte[] decrypted = bfish.decryptSecure(encryptedData, 0, false);
            return new String(decrypted, "UTF-8");
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void saveEmailAddressFor(String code, String address) {
        try {
            if (code == null || code.length() == 0) {
                return;
            }
            File invitationsFolder = new File(JWSystem.getAllAppVersionsSharedFolder(), "invitations");
            File targetFile = new File(invitationsFolder, code);
            byte[] decryptedData = address.getBytes("UTF-8");
            Blowfish bfish = new Blowfish();
            bfish.init("ljis$5$GSEFsdjkkjasdjh khjhkjhkjh34kjh33819js02jkdufgy64ofAH$hakfEJHRgisergSV5ItW$%0vwt'4&$^&%AdaF@l2i2@EFSwKJKUIWNRIb44");
            byte[] encrypted = bfish.encryptSecure(decryptedData, 0, false);
            FileUtil.writeFile(targetFile, encrypted);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initUI() {
        this.setTitle(Language.get("INVITE_REPOSITORY_TITLE"));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.cl);
        this.requestPanel = this.client != null ? new InvitationRequestPanel(this.configuration.detailsXML, this, this.client.getTechUser()) : new InvitationRequestPanel(this.configuration.detailsXML, this, null);
        JPanel repositoryPanel = new JPanel();
        repositoryPanel.setLayout(new BorderLayout());
        repositoryPanel.add("Center", this.newRepositoryPanel());
        repositoryPanel.add("South", this.initButtonsPanel());
        JPanel sendPanel = this.createSendPanel();
        this.cardPanel.add((Component)repositoryPanel, this.REPOSITORY_PANEL_KEY);
        this.cardPanel.add((Component)this.requestPanel, this.NEW_INVITATION_KEY);
        this.cardPanel.add((Component)sendPanel, this.SEND_KEY);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this.cardPanel);
    }

    private JPanel createSendPanel() {
        GbPanel panel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        RoundBorderPanel invitationCodePanel = new RoundBorderPanel(Language.get("STANDALONE_CONNECTIONS"));
        JLabel label = new JLabel(Language.get(Language.get("INVITATION_SEND_CODE_LABEL") + ""));
        this.invitaionCodeLabel = new JLabel("");
        this.invitaionCodeLabel.setFont(this.invitaionCodeLabel.getFont().deriveFont(SimpleHelpLookAndFeel.scale(20.0f)));
        this.copyCodeToClipboard = new JButton(Language.get("COPY"));
        this.copyCodeToClipboard.addActionListener(this);
        GbPanelWrapper invitationCodeWrapper = new GbPanelWrapper(invitationCodePanel);
        invitationCodeWrapper.add(label, 0, 0, 1, 1, 1, 0, 17, 0);
        invitationCodeWrapper.add(this.invitaionCodeLabel, 1, 0, 1, 1, 100, 0, 17, 2, new Insets(0, 20, 0, 10));
        invitationCodeWrapper.add(this.copyCodeToClipboard, 1, 0, 1, 1, 1, 0, 13, 0);
        RoundBorderPanel urlConnectPanel = new RoundBorderPanel(Language.get("DIRECT_CONNECTIONS"));
        this.urlPanel = this.client != null ? new InvitationURLPanel(this.client.getVirtualServerHostname(), false) : new InvitationURLPanel("test", false);
        GbPanelWrapper urlConnectWrapper = new GbPanelWrapper(urlConnectPanel);
        urlConnectWrapper.add(this.urlPanel.getRootComponent(), 0, 0, 1, 1, 1, 0, 17, 2);
        RoundBorderPanel sendEmailPanel = new RoundBorderPanel(Language.get("SEND_EMAIL_TITLE"));
        GbPanelWrapper sendEmailWrapper = new GbPanelWrapper(sendEmailPanel, new Insets(2, 2, 2, 2));
        this.sendEmailInvitationLinkButton = new JButton(Language.get("SEND_INVITATION_LINK"));
        this.emailAddressField = new JTextField();
        JLabel emailAddressLabel = new JLabel(Language.get("EMAIL_ADDRESS") + "");
        this.emailStatusLabel = new JLabel();
        GbPanel emailStatusPanel = new GbPanel();
        emailStatusPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        emailStatusPanel.add(this.sendEmailInvitationLinkButton, 0, 0, 1, 1, 1, 0, 17, 0);
        emailStatusPanel.add(this.emailStatusLabel, 1, 0, 1, 1, 100, 0, 17, 2, new Insets(0, 10, 0, 0));
        int X = 0;
        sendEmailWrapper.add(emailAddressLabel, X++, 0, 1, 1, 0, 0, 10, 2);
        sendEmailWrapper.add(this.emailAddressField, X++, 0, 1, 1, 100, 0, 10, 2);
        sendEmailWrapper.add(emailStatusPanel, 1, 1, 2, 1, 1, 0, 17, 2);
        this.bdone = new JButton(Language.get("CLOSE"), ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
        this.bdone.addActionListener(this);
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 30, 0, 10));
        buttonsPanel.add(this.bdone, 0, 0, 1, 1, 1, 1, 10, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add(invitationCodePanel, 0, 0, 1, 1, 1, 0, 10, 2);
        panel.add(urlConnectPanel, 0, 1, 1, 1, 1, 0, 10, 2);
        panel.add(sendEmailPanel, 0, 2, 1, 1, 1, 0, 10, 2);
        panel.add(buttonsPanel, 0, 3, 1, 1, 1, 100, 15, 2);
        this.sendEmailInvitationLinkButton.addActionListener(this);
        this.emailAddressField.addKeyListener(this);
        return panel;
    }

    private void initSendPanel(Invitation selectedInvitation) {
        String cachedEmailAddress = this.loadEmailAddressFor(selectedInvitation.invitationID);
        this.invitaionCodeLabel.setText(selectedInvitation.getInvitationIDAsCode());
        this.urlPanel.updateInviteURL(selectedInvitation.getInvitationID());
        this.customerLink = SHJWUtil.getUpdateURLProtocol() + "://" + this.client.getVirtualServerHostname() + "/customer?invite=" + selectedInvitation.getInvitationID();
        if (cachedEmailAddress == null) {
            String emailAddress = selectedInvitation.guessEmailAddress();
            if (emailAddress != null) {
                this.emailAddressField.setText(emailAddress);
            } else {
                this.emailAddressField.setText("");
            }
        } else {
            this.emailAddressField.setText(cachedEmailAddress);
        }
        this.emailStatusLabel.setText("");
        this.updateEnabled();
    }

    private GbPanel newRepositoryPanel() {
        this.bnew = new JButton(Language.get("CREATE_A_NEW_INVITATION"), ImageLoader.getImageIcon("images/svg/general/add.svg,16"));
        this.bdelete = new JButton(Language.get("DELETE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,16"));
        this.bedit = new JButton(Language.get("INVITE_EDIT"), ImageLoader.getImageIcon("images/svg/general/pencil.svg,16"));
        this.bsend = new JButton(Language.get("INVITE_SEND"), ImageLoader.getImageIcon("images/svg/computing/email.svg,16"));
        this.bsend.setHorizontalAlignment(2);
        this.bedit.setHorizontalAlignment(2);
        this.bdelete.setHorizontalAlignment(2);
        TableStructure ts = TableStructure.createTableStructure(TechClient.EditableInvitationWrapper.class, new String[]{"getName", "getFormattedCreationTime", "getCreatedByDisplayName"}, new String[]{" " + Language.get("INVITE_CUSTOMER_NAME"), " " + Language.get("INVITE_CREATION"), " " + Language.get("INVITE_CREATED_BY")});
        ts.setWidths(new int[]{200, 0, 0});
        this.invitationList = new SimpleList();
        this.sortedInvitationList = new SortWrapper(this.invitationList, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
        SimpleTableModel slm = new SimpleTableModel(this.sortedInvitationList, ts);
        this.invitationTable = new SHJTable(0, ts.getColumnCount());
        if (this.invitationTable.getRowHeight() < SimpleHelpLookAndFeel.scale(18)) {
            this.invitationTable.setRowHeight(SimpleHelpLookAndFeel.scale(22));
        }
        slm.assignToTable(this.invitationTable);
        this.invitationTable.setSelectionMode(2);
        ts.initTableDimensions(this.invitationTable);
        ((DefaultTableCellRenderer)this.invitationTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        this.invitationTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane regpane = new JScrollPane(this.invitationTable);
        regpane.getViewport().setBackground(Color.white);
        regpane.setBorder(SHBorderFactory.createLineBorder(SHStyle.BORDER_COLOR));
        ts.initTableDimensions(this.invitationTable);
        JWrapLabel invitationDescription = new JWrapLabel("<HTML>" + Language.get("INVITATION_DESCRIPTION") + "</HTML>");
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        buttonsPanel.add(this.bsend, 0, 0, 1, 1, 0, 0, 11, 2);
        buttonsPanel.add(this.bedit, 0, 1, 1, 1, 0, 0, 11, 2);
        buttonsPanel.add(this.bdelete, 0, 2, 1, 1, 0, 0, 11, 2, new Insets(20, 2, 2, 2));
        GbPanel panel = new GbPanel();
        panel.add(invitationDescription, 0, 0, 2, 1, 1, 0, 17, 2, new Insets(5, 5, 5, 5));
        panel.add(this.bnew, 0, 1, 2, 1, 1, 0, 10, 0, new Insets(5, 5, 0, 5));
        panel.add(regpane, 0, 3, 1, 1, 1, 1, 10, 1, new Insets(5, 0, 0, 0));
        panel.add(buttonsPanel, 1, 3, 1, 1, 0, 1, 11, 0, new Insets(22, 2, 2, 2));
        this.bdelete.setEnabled(false);
        this.bedit.setEnabled(false);
        this.bsend.setEnabled(false);
        this.bnew.addActionListener(this);
        this.bdelete.addActionListener(this);
        this.bedit.addActionListener(this);
        this.bsend.addActionListener(this);
        return panel;
    }

    private Component initButtonsPanel() {
        this.bclose = new JButton(Language.get("CLOSE"), ImageLoader.getImageIcon("images/svg/general/ok.svg,16"));
        GbPanel buttonsPanel = new GbPanel(new ScaledInsets(2, 30, 2, 10));
        buttonsPanel.add(this.bclose, 0, 0, 1, 1, 1, 1, 10, 0);
        buttonsPanel.setBorder(SHBorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.bclose.addActionListener(this);
        return buttonsPanel;
    }

    private void updateEnabled() {
        if (this.invitationTable.getSelectedRowCount() > 0) {
            int[] indices = this.invitationTable.getSelectedRows();
            boolean isCreatedByMe = true;
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0 && isCreatedByMe; --i) {
                TechClient.EditableInvitationWrapper invitation = (TechClient.EditableInvitationWrapper)this.sortedInvitationList.get(indices[i]);
                isCreatedByMe = invitation.canBeEdited;
            }
            this.bdelete.setEnabled(isCreatedByMe);
            if (this.invitationTable.getSelectedRowCount() == 1) {
                this.bedit.setEnabled(isCreatedByMe);
                this.bsend.setEnabled(true);
            } else {
                this.bedit.setEnabled(false);
                this.bsend.setEnabled(false);
            }
        } else {
            this.bdelete.setEnabled(false);
            this.bedit.setEnabled(false);
            this.bsend.setEnabled(false);
        }
        if (this.emailAddressField.getText().length() > 0) {
            this.sendEmailInvitationLinkButton.setEnabled(true);
        } else {
            this.sendEmailInvitationLinkButton.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        this.actionPerformed(o);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.actionPerformed(this.sendEmailInvitationLinkButton);
        } else if (e.getKeyCode() == 27) {
            this.actionPerformed(this.bclose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionPerformed(Object o) {
        if (o == this.bclose) {
            this.setVisible(false);
        } else if (o == this.sendEmailInvitationLinkButton) {
            this.sendEmailInvitationLinkButton.setEnabled(false);
            this.emailStatusLabel.setText(Language.get("SEND_EMAIL_STATUS1") + "...");
            int selectedIndex = this.invitationTable.getSelectedRows()[0];
            TechClient.EditableInvitationWrapper selectedInvitation = (TechClient.EditableInvitationWrapper)this.sortedInvitationList.get(selectedIndex);
            new SendInvitationEmailThread(selectedInvitation.invitation, this.emailAddressField.getText(), this.sendEmailInvitationLinkButton, false).start();
            this.saveEmailAddressFor(selectedInvitation.invitation.invitationID, this.emailAddressField.getText());
        } else if (o == this.copyCodeToClipboard) {
            String url = this.invitaionCodeLabel.getText();
            ClipboardUtil.setClipboardAsText(url);
        } else if (o == this.bnew) {
            this.requestPanel.initForNew();
            this.cl.show(this.cardPanel, this.NEW_INVITATION_KEY);
            this.requestPanel.initFocus();
        } else if (o == this.bedit) {
            int selectedIndex = this.invitationTable.getSelectedRows()[0];
            TechClient.EditableInvitationWrapper selectedInvitation = (TechClient.EditableInvitationWrapper)this.sortedInvitationList.get(selectedIndex);
            this.requestPanel.initForEdit(selectedInvitation.invitation);
            this.cl.show(this.cardPanel, this.NEW_INVITATION_KEY);
            this.requestPanel.initFocus();
        } else if (o == this.bsend) {
            int selectedIndex = this.invitationTable.getSelectedRows()[0];
            TechClient.EditableInvitationWrapper selectedInvitation = (TechClient.EditableInvitationWrapper)this.sortedInvitationList.get(selectedIndex);
            this.initSendPanel(selectedInvitation.invitation);
            this.cl.show(this.cardPanel, this.SEND_KEY);
        } else if (o == this.bdone) {
            this.cl.show(this.cardPanel, this.REPOSITORY_PANEL_KEY);
        } else if (o == this.copyCustomerLink) {
            ClipboardUtil.setClipboardAsText(this.customerLink);
        } else if (o == this.bdelete) {
            ArrayList<Invitation> removedInvitations = new ArrayList<Invitation>();
            this.invitationList.startBatch();
            try {
                int[] indices = this.invitationTable.getSelectedRows();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; --i) {
                    Object objectToDelete = this.sortedInvitationList.get(indices[i]);
                    removedInvitations.add(((TechClient.EditableInvitationWrapper)objectToDelete).invitation);
                    this.invitationList.remove(objectToDelete);
                }
            }
            finally {
                this.invitationList.endBatch();
            }
            new DeleteInvitationThread(removedInvitations).start();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.updateEnabled();
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    @Override
    public void cancelNewInvitation() {
        this.cl.show(this.cardPanel, this.REPOSITORY_PANEL_KEY);
    }

    @Override
    public void createNewInvitation(Invitation invitation) {
        new CreateNewInvitationThread(invitation).start();
    }

    class SendInvitationEmailThread
    extends Thread {
        private Invitation selectedInvitation;
        private String address;
        private JButton invoker;
        private boolean standalone;

        public SendInvitationEmailThread(Invitation selectedInvitation, String address, JButton invoker, boolean standalone) {
            super("SendInvitationEmailThread");
            this.selectedInvitation = selectedInvitation;
            this.address = address;
            this.invoker = invoker;
            this.standalone = standalone;
        }

        @Override
        public void run() {
            try {
                String url = InvitationURLPanel.getURL(InvitationRepositoryGlassDialog.this.client.getVirtualServerHostname(), this.selectedInvitation.getInvitationID());
                InvitationRepositoryGlassDialog.this.client.sendInvitationEmail(this.selectedInvitation, this.address, url, this.standalone);
                InvitationRepositoryGlassDialog.this.emailStatusLabel.setText(Language.get("SEND_EMAIL_STATUS2") + ".");
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message != null) {
                    InvitationRepositoryGlassDialog.this.emailStatusLabel.setText(Language.get("SEND_EMAIL_STATUS3") + ": " + message);
                } else {
                    InvitationRepositoryGlassDialog.this.emailStatusLabel.setText(Language.get("SEND_EMAIL_STATUS3") + ".");
                }
            }
            finally {
                this.invoker.setEnabled(true);
            }
        }
    }

    class CreateNewInvitationThread
    extends Thread {
        private Invitation invitation;

        public CreateNewInvitationThread(Invitation invitation) {
            this.invitation = invitation;
        }

        @Override
        public void run() {
            Invitation requestNewInvitation = null;
            try {
                requestNewInvitation = InvitationRepositoryGlassDialog.this.client.requestNewInvitation(this.invitation);
                for (int i = 0; i < InvitationRepositoryGlassDialog.this.invitationList.size(); ++i) {
                    TechClient.EditableInvitationWrapper oldInvitation = (TechClient.EditableInvitationWrapper)InvitationRepositoryGlassDialog.this.invitationList.get(i);
                    if (!oldInvitation.invitation.getInvitationID().equals(requestNewInvitation.getInvitationID())) continue;
                    InvitationRepositoryGlassDialog.this.invitationList.remove(i);
                    break;
                }
                TechClient.EditableInvitationWrapper wrapper = new TechClient.EditableInvitationWrapper(requestNewInvitation, true);
                InvitationRepositoryGlassDialog.this.invitationList.add(wrapper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            InvitationRepositoryGlassDialog.this.cl.show(InvitationRepositoryGlassDialog.this.cardPanel, InvitationRepositoryGlassDialog.this.REPOSITORY_PANEL_KEY);
            if (requestNewInvitation != null) {
                int index = InvitationRepositoryGlassDialog.this.sortedInvitationList.indexOf(requestNewInvitation);
                InvitationRepositoryGlassDialog.this.invitationTable.getSelectionModel().setSelectionInterval(index, index);
            }
        }
    }

    class DeleteInvitationThread
    extends Thread {
        private ArrayList removedInvitations;

        public DeleteInvitationThread(ArrayList removedInvitations) {
            this.removedInvitations = removedInvitations;
        }

        @Override
        public void run() {
            try {
                InvitationRepositoryGlassDialog.this.client.deleteInvitations(this.removedInvitations);
            }
            catch (Throwable t) {
                String message = t.getMessage();
                if (message == null) {
                    message = "";
                }
                SHGlassOptionPane.showErrorDialog(InvitationRepositoryGlassDialog.this.src_rootPane, Language.get("INVITE_DELETE_ERROR") + "\n" + message, Language.get("INVITE_ERROR_TITLE"), ImageLoader.getImageIcon("images/svg/dialogs/error.svg,48"), Language.get("CLOSE"));
                t.printStackTrace();
            }
        }
    }
}

