/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history.summarypanels;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.DemoSession;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class DemoSummaryPanel {
    private GbPanel rootComponent = new GbPanel(new ScaledInsets(2, 2, 2, 2));
    private JLabel attendeeCount;
    private JLabel demoName;

    public DemoSummaryPanel() {
        this.initUI();
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    public void setBackground(Color backgroundColor) {
        this.rootComponent.setBackground(backgroundColor);
    }

    public void initWith(DemoSession session) {
        this.demoName.setText(session.getName());
        this.attendeeCount.setText(Integer.toString(session.getAttendeeCount()));
    }

    private void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.demoName = new JLabel();
        this.attendeeCount = new JLabel();
        JLabel demoNameLabel = new JLabel(Language.get("NAME") + ": ");
        JLabel attendeeLabel = new JLabel(Language.get("PRESENTATION_COUNT") + ": ");
        demoNameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        attendeeLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        int Y = 0;
        this.rootComponent.add(demoNameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        this.rootComponent.add(this.demoName, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add(attendeeLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        this.rootComponent.add(this.attendeeCount, 1, Y++, 1, 1, 1, 0, 17, 2);
    }
}

